/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import org.apache.lucene.util.ArrayUtil;

public class NeighborArray {
    private int size;
    float[] score;
    int[] node;

    NeighborArray(int maxSize) {
        this.node = new int[maxSize];
        this.score = new float[maxSize];
    }

    public void add(int newNode, float newScore) {
        if (this.size == this.node.length - 1) {
            this.node = ArrayUtil.grow(this.node, (this.size + 1) * 3 / 2);
            this.score = ArrayUtil.growExact(this.score, this.node.length);
        }
        this.node[this.size] = newNode;
        this.score[this.size] = newScore;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public int[] node() {
        return this.node;
    }

    public void clear() {
        this.size = 0;
    }

    void removeLast() {
        --this.size;
    }

    public String toString() {
        return "NeighborArray[" + this.size + "]";
    }
}

