/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.nio;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.function.IntFunction;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.nio.FlushOperation;
import org.elasticsearch.nio.Page;

public class SSLOutboundBuffer
implements AutoCloseable {
    private final ArrayDeque<Page> pages = new ArrayDeque();
    private final IntFunction<Page> pageSupplier;
    private Page currentPage;

    SSLOutboundBuffer(IntFunction<Page> pageSupplier) {
        this.pageSupplier = pageSupplier;
    }

    void incrementEncryptedBytes(int encryptedBytesProduced) {
        if (encryptedBytesProduced != 0) {
            this.currentPage.byteBuffer().limit(encryptedBytesProduced);
            this.pages.addLast(this.currentPage);
        } else if (this.currentPage != null) {
            this.currentPage.close();
        }
        this.currentPage = null;
    }

    ByteBuffer nextWriteBuffer(int networkBufferSize) {
        Page newPage;
        if (this.currentPage != null) {
            this.currentPage.close();
        }
        this.currentPage = newPage = this.pageSupplier.apply(networkBufferSize);
        return newPage.byteBuffer().duplicate();
    }

    FlushOperation buildNetworkFlushOperation() {
        int pageCount = this.pages.size();
        ByteBuffer[] byteBuffers = new ByteBuffer[pageCount];
        Page[] pagesToClose = new Page[pageCount];
        for (int i = 0; i < pageCount; ++i) {
            Page page;
            pagesToClose[i] = page = this.pages.removeFirst();
            byteBuffers[i] = page.byteBuffer();
        }
        return new FlushOperation(byteBuffers, (r, e) -> {
            try {
                IOUtils.close((Closeable[])pagesToClose);
            }
            catch (Exception ex) {
                if (e != null) {
                    ex.addSuppressed((Throwable)e);
                }
                assert (false) : ex;
                throw new ElasticsearchException((Throwable)ex);
            }
        });
    }

    boolean hasEncryptedBytesToFlush() {
        return !this.pages.isEmpty();
    }

    @Override
    public void close() {
        Page p;
        Exception closeException = null;
        try {
            IOUtils.close((Closeable)this.currentPage);
        }
        catch (Exception e) {
            closeException = e;
        }
        this.currentPage = null;
        while ((p = this.pages.pollFirst()) != null) {
            try {
                p.close();
            }
            catch (Exception ex) {
                closeException = (Exception)ExceptionsHelper.useOrSuppress((Throwable)closeException, (Throwable)ex);
            }
        }
        if (closeException != null) {
            assert (false) : closeException;
            throw new ElasticsearchException((Throwable)closeException);
        }
    }
}

