/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty4.SharedGroupFactory;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.transport.SecurityHttpExceptionHandler;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty4.IpFilterRemoteAddressFilter;

public class SecurityNetty4HttpServerTransport
extends Netty4HttpServerTransport {
    private static final Logger logger = LogManager.getLogger(SecurityNetty4HttpServerTransport.class);
    private final SecurityHttpExceptionHandler securityExceptionHandler;
    private final IPFilter ipFilter;
    private final SSLService sslService;
    private final SslConfiguration sslConfiguration;

    public SecurityNetty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, IPFilter ipFilter, SSLService sslService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory) {
        super(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, sharedGroupFactory);
        this.securityExceptionHandler = new SecurityHttpExceptionHandler(logger, this.lifecycle, (c, e) -> super.onException(c, e));
        this.ipFilter = ipFilter;
        boolean ssl = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings);
        this.sslService = sslService;
        if (ssl) {
            this.sslConfiguration = sslService.getHttpTransportSSLConfiguration();
            if (!sslService.isConfigurationValidForServerUsage(this.sslConfiguration)) {
                throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [xpack.security.http.ssl.key] or [xpack.security.http.ssl.keystore.path] setting");
            }
        } else {
            this.sslConfiguration = null;
        }
    }

    public void onException(HttpChannel channel, Exception e) {
        this.securityExceptionHandler.accept(channel, e);
    }

    protected void doStart() {
        super.doStart();
        this.ipFilter.setBoundHttpTransportAddress(this.boundAddress());
    }

    public ChannelHandler configureServerChannelHandler() {
        return new HttpSslChannelHandler();
    }

    private final class HttpSslChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        HttpSslChannelHandler() {
            super((Netty4HttpServerTransport)SecurityNetty4HttpServerTransport.this, SecurityNetty4HttpServerTransport.this.handlingSettings);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (SecurityNetty4HttpServerTransport.this.sslConfiguration != null) {
                SSLEngine sslEngine = SecurityNetty4HttpServerTransport.this.sslService.createSSLEngine(SecurityNetty4HttpServerTransport.this.sslConfiguration, null, -1);
                sslEngine.setUseClientMode(false);
                ch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(sslEngine));
            }
            ch.pipeline().addFirst("ip_filter", (ChannelHandler)new IpFilterRemoteAddressFilter(SecurityNetty4HttpServerTransport.this.ipFilter, ".http"));
        }
    }
}

