/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;

public abstract class SamlMessageBuilder {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final Clock clock;
    protected final SpConfiguration serviceProvider;
    protected final EntityDescriptor identityProvider;

    public SamlMessageBuilder(EntityDescriptor identityProvider, SpConfiguration serviceProvider, Clock clock) {
        this.identityProvider = identityProvider;
        this.serviceProvider = serviceProvider;
        this.clock = clock;
    }

    protected String getIdentityProviderEndpoint(String binding, Function<IDPSSODescriptor, ? extends Collection<? extends Endpoint>> selector) {
        List locations = this.identityProvider.getRoleDescriptors(IDPSSODescriptor.DEFAULT_ELEMENT_NAME).stream().map(rd -> (IDPSSODescriptor)rd).flatMap(idp -> ((Collection)selector.apply((IDPSSODescriptor)idp)).stream()).filter(endp -> binding.equals(endp.getBinding())).map(sso -> sso.getLocation()).collect(Collectors.toList());
        if (locations.isEmpty()) {
            return null;
        }
        if (locations.size() > 1) {
            throw new ElasticsearchException("Found multiple locations for binding [{}] in descriptor [{}] - [{}]", new Object[]{binding, this.identityProvider.getID(), locations});
        }
        return (String)locations.get(0);
    }

    protected Issuer buildIssuer() {
        Issuer issuer = SamlUtils.buildObject(Issuer.class, Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(this.serviceProvider.getEntityId());
        return issuer;
    }

    protected String buildId() {
        return SamlUtils.generateSecureNCName(20);
    }
}

