/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.enrollment.InternalEnrollmentTokenGenerator;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;
import org.elasticsearch.xpack.security.tool.CommandUtils;

public class InitialNodeSecurityAutoConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(InitialNodeSecurityAutoConfiguration.class);
    private static final BackoffPolicy BACKOFF_POLICY = BackoffPolicy.exponentialBackoff();

    private InitialNodeSecurityAutoConfiguration() {
        throw new IllegalStateException("Class should not be instantiated");
    }

    public static void maybeGenerateEnrollmentTokensAndElasticCredentialsOnNodeStartup(NativeUsersStore nativeUsersStore, SecurityIndexManager securityIndexManager, SSLService sslService, Client client, Environment environment) {
        if (!((Boolean)XPackSettings.ENROLLMENT_ENABLED.get(environment.settings())).booleanValue()) {
            return;
        }
        InternalEnrollmentTokenGenerator enrollmentTokenGenerator = new InternalEnrollmentTokenGenerator(environment, sslService, client);
        PrintStream out = InitialNodeSecurityAutoConfiguration.getConsoleOutput();
        if (out == null) {
            LOGGER.info((Object)"Auto-configuration will not generate a password for the elastic built-in superuser, as we cannot  determine if there is a terminal attached to the elasticsearch process. You can use the `bin/elasticsearch-reset-password` tool to set the password for the elastic user.");
            return;
        }
        securityIndexManager.onStateRecovered(securityIndexState -> {
            if (!securityIndexState.indexExists()) {
                String fingerprint;
                try {
                    fingerprint = enrollmentTokenGenerator.getHttpsCaFingerprint();
                    LOGGER.info((Object)("HTTPS has been configured with automatically generated certificates, and the CA's hex-encoded SHA-256 fingerprint is [" + fingerprint + "]"));
                }
                catch (Exception e2) {
                    fingerprint = null;
                    LOGGER.error((Object)"Failed to compute the HTTPS CA fingerprint, probably the certs are not auto-generated", (Throwable)e2);
                }
                String httpsCaFingerprint = fingerprint;
                GroupedActionListener groupedActionListener = new GroupedActionListener(ActionListener.wrap(results -> {
                    HashMap allResultsMap = new HashMap();
                    for (Map result : results) {
                        allResultsMap.putAll(result);
                    }
                    String elasticPassword = (String)allResultsMap.get("generated_elastic_user_password");
                    String kibanaEnrollmentToken = (String)allResultsMap.get("kibana_enrollment_token");
                    String nodeEnrollmentToken = (String)allResultsMap.get("node_enrollment_token");
                    InitialNodeSecurityAutoConfiguration.outputInformationToConsole(elasticPassword, kibanaEnrollmentToken, nodeEnrollmentToken, httpsCaFingerprint, out);
                }, e -> LOGGER.error((Object)"Unexpected exception during security auto-configuration", (Throwable)e)), 3);
                if (!ReservedRealm.BOOTSTRAP_ELASTIC_PASSWORD.exists(environment.settings()) && !ReservedRealm.AUTOCONFIG_ELASTIC_PASSWORD_HASH.exists(environment.settings())) {
                    char[] elasticPassword = CommandUtils.generatePassword(20);
                    nativeUsersStore.createElasticUser(elasticPassword, (ActionListener<Void>)ActionListener.wrap(aVoid -> {
                        LOGGER.debug((Object)"elastic credentials generated successfully");
                        groupedActionListener.onResponse(Map.of("generated_elastic_user_password", new String(elasticPassword)));
                    }, e -> {
                        LOGGER.error((Object)"Failed to generate credentials for the elastic built-in superuser", (Throwable)e);
                        groupedActionListener.onResponse(Map.of());
                    }));
                } else {
                    if (!ReservedRealm.BOOTSTRAP_ELASTIC_PASSWORD.exists(environment.settings())) {
                        LOGGER.info((Object)("Auto-configuration will not generate a password for the elastic built-in superuser, you should use the password specified in the node's secure setting [" + ReservedRealm.BOOTSTRAP_ELASTIC_PASSWORD.getKey() + "] in order to authenticate as elastic"));
                    }
                    groupedActionListener.onResponse(Map.of("generated_elastic_user_password", ""));
                }
                Iterator backoff = BACKOFF_POLICY.iterator();
                enrollmentTokenGenerator.createKibanaEnrollmentToken(kibanaToken -> {
                    if (kibanaToken != null) {
                        try {
                            LOGGER.debug((Object)"Successfully generated the kibana enrollment token");
                            groupedActionListener.onResponse(Map.of("kibana_enrollment_token", kibanaToken.getEncoded()));
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)"Failed to encode kibana enrollment token", (Throwable)e);
                            groupedActionListener.onResponse(Map.of());
                        }
                    } else {
                        groupedActionListener.onResponse(Map.of());
                    }
                }, backoff);
                enrollmentTokenGenerator.maybeCreateNodeEnrollmentToken(encodedNodeToken -> {
                    if (encodedNodeToken != null) {
                        groupedActionListener.onResponse(Map.of("node_enrollment_token", encodedNodeToken));
                    } else {
                        groupedActionListener.onResponse(Map.of());
                    }
                }, backoff);
            }
        });
    }

    private static PrintStream getConsoleOutput() {
        PrintStream output = BootstrapInfo.getConsoleOutput();
        if (output == null) {
            return null;
        }
        output.println();
        if (output.checkError()) {
            return null;
        }
        return output;
    }

    private static void outputInformationToConsole(String elasticPassword, String kibanaEnrollmentToken, String nodeEnrollmentToken, String caCertFingerprint, PrintStream out) {
        StringBuilder builder = new StringBuilder();
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("--------------------------------------------------------------------------------------------------------------");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        if (elasticPassword == null) {
            builder.append("Unable to auto-generate the password for the elastic built-in superuser.");
        } else if (Strings.isEmpty((CharSequence)elasticPassword)) {
            builder.append("The generated password for the elastic built-in superuser has not been changed.");
        } else {
            builder.append("The generated password for the elastic built-in superuser is:");
            builder.append(System.lineSeparator());
            builder.append(elasticPassword);
        }
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        if (null != kibanaEnrollmentToken) {
            builder.append("The enrollment token for Kibana instances, valid for the next ");
            builder.append(30L);
            builder.append(" minutes:");
            builder.append(System.lineSeparator());
            builder.append(kibanaEnrollmentToken);
        } else {
            builder.append("Unable to generate an enrollment token for Kibana instances.");
        }
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        if (nodeEnrollmentToken == null) {
            builder.append("Unable to generate an enrollment token for Elasticsearch nodes.");
            builder.append(System.lineSeparator());
            builder.append(System.lineSeparator());
        } else if (!Strings.isEmpty((CharSequence)nodeEnrollmentToken)) {
            builder.append("The enrollment token for Elasticsearch instances, valid for the next ");
            builder.append(30L);
            builder.append(" minutes:");
            builder.append(System.lineSeparator());
            builder.append(nodeEnrollmentToken);
            builder.append(System.lineSeparator());
            builder.append(System.lineSeparator());
        }
        if (null != caCertFingerprint) {
            builder.append("The hex-encoded SHA-256 fingerprint of the generated HTTPS CA DER-encoded certificate:");
            builder.append(System.lineSeparator());
            builder.append(caCertFingerprint);
            builder.append(System.lineSeparator());
        }
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("You can complete the following actions at any time:");
        builder.append(System.lineSeparator());
        builder.append("Reset the password of the elastic built-in superuser with 'bin/elasticsearch-reset-password -u elastic'.");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("Generate an enrollment token for Kibana instances with 'bin/elasticsearch-create-enrollment-token -s kibana'.");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("Generate an enrollment token for Elasticsearch nodes with 'bin/elasticsearch-create-enrollment-token -s node'.");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("--------------------------------------------------------------------------------------------------------------");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        out.println(builder);
    }
}

