/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.upgrades;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.upgrades.SingleFeatureMigrationResult;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class FeatureMigrationResults
implements Metadata.Custom {
    public static final String TYPE = "system_index_migration";
    public static final Version MIGRATION_ADDED_VERSION = Version.V_8_0_0;
    private static final ParseField RESULTS_FIELD = new ParseField("results", new String[0]);
    public static final ConstructingObjectParser<FeatureMigrationResults, Void> PARSER = new ConstructingObjectParser("system_index_migration", a -> {
        Map<String, SingleFeatureMigrationResult> statuses = ((List)a[0]).stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2));
        return new FeatureMigrationResults(statuses);
    });
    private final Map<String, SingleFeatureMigrationResult> featureStatuses;

    public FeatureMigrationResults(Map<String, SingleFeatureMigrationResult> featureStatuses) {
        this.featureStatuses = Objects.requireNonNullElse(featureStatuses, new HashMap());
    }

    public FeatureMigrationResults(StreamInput in) throws IOException {
        this.featureStatuses = in.readMap(StreamInput::readString, SingleFeatureMigrationResult::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.featureStatuses, (outStream, featureName) -> outStream.writeString((String)featureName), (outStream, featureStatus) -> featureStatus.writeTo(outStream));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RESULTS_FIELD.getPreferredName(), this.featureStatuses);
        return builder;
    }

    public static FeatureMigrationResults fromXContent(XContentParser parser) {
        return (FeatureMigrationResults)PARSER.apply(parser, null);
    }

    public Map<String, SingleFeatureMigrationResult> getFeatureStatuses() {
        return Collections.unmodifiableMap(this.featureStatuses);
    }

    public FeatureMigrationResults withResult(String featureName, SingleFeatureMigrationResult status) {
        HashMap<String, SingleFeatureMigrationResult> newMap = new HashMap<String, SingleFeatureMigrationResult>(this.featureStatuses);
        newMap.put(featureName, status);
        return new FeatureMigrationResults(newMap);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return MIGRATION_ADDED_VERSION;
    }

    public String toString() {
        return "SystemIndexMigrationResult{featureStatuses=" + this.featureStatuses + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FeatureMigrationResults)) {
            return false;
        }
        FeatureMigrationResults that = (FeatureMigrationResults)o;
        return this.featureStatuses.equals(that.featureStatuses);
    }

    public int hashCode() {
        return Objects.hash(this.featureStatuses);
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new ResultsDiff((FeatureMigrationResults)previousState, this);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new ResultsDiff(in);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> new Tuple((Object)n, (Object)SingleFeatureMigrationResult.fromXContent(p)), v -> {
            throw new IllegalArgumentException("ordered " + RESULTS_FIELD.getPreferredName() + " are not supported");
        }, RESULTS_FIELD);
    }

    public static class ResultsDiff
    implements NamedDiff<Metadata.Custom> {
        private final Diff<Map<String, SingleFeatureMigrationResult>> resultsDiff;

        public ResultsDiff(FeatureMigrationResults before, FeatureMigrationResults after) {
            this.resultsDiff = DiffableUtils.diff(before.featureStatuses, after.featureStatuses, DiffableUtils.getStringKeySerializer());
        }

        public ResultsDiff(StreamInput in) throws IOException {
            this.resultsDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), SingleFeatureMigrationResult::new, ResultsDiff::readDiffFrom);
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            TreeMap<String, SingleFeatureMigrationResult> newResults = new TreeMap<String, SingleFeatureMigrationResult>(this.resultsDiff.apply(((FeatureMigrationResults)part).featureStatuses));
            return new FeatureMigrationResults(newResults);
        }

        @Override
        public String getWriteableName() {
            return FeatureMigrationResults.TYPE;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.resultsDiff.writeTo(out);
        }

        static Diff<SingleFeatureMigrationResult> readDiffFrom(StreamInput in) throws IOException {
            return AbstractDiffable.readDiffFrom(SingleFeatureMigrationResult::new, in);
        }

        @Override
        public Version getMinimalSupportedVersion() {
            return MIGRATION_ADDED_VERSION;
        }
    }
}

