/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class TransportInfo
implements ReportingService.Info {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TransportInfo.class);
    private static final boolean CNAME_IN_PUBLISH_ADDRESS = Booleans.parseBoolean((String)System.getProperty("es.transport.cname_in_publish_address"), (boolean)false);
    private final BoundTransportAddress address;
    private Map<String, BoundTransportAddress> profileAddresses;
    private final boolean cnameInPublishAddressProperty;

    public TransportInfo(BoundTransportAddress address, @Nullable Map<String, BoundTransportAddress> profileAddresses) {
        this(address, profileAddresses, CNAME_IN_PUBLISH_ADDRESS);
    }

    public TransportInfo(BoundTransportAddress address, @Nullable Map<String, BoundTransportAddress> profileAddresses, boolean cnameInPublishAddressProperty) {
        this.address = address;
        this.profileAddresses = profileAddresses;
        this.cnameInPublishAddressProperty = cnameInPublishAddressProperty;
    }

    public TransportInfo(StreamInput in) throws IOException {
        this.address = new BoundTransportAddress(in);
        int size = in.readVInt();
        if (size > 0) {
            this.profileAddresses = new HashMap<String, BoundTransportAddress>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readString();
                BoundTransportAddress value = new BoundTransportAddress(in);
                this.profileAddresses.put(key, value);
            }
        }
        this.cnameInPublishAddressProperty = CNAME_IN_PUBLISH_ADDRESS;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.address.writeTo(out);
        if (this.profileAddresses != null) {
            out.writeVInt(this.profileAddresses.size());
        } else {
            out.writeVInt(0);
        }
        if (this.profileAddresses != null && this.profileAddresses.size() > 0) {
            for (Map.Entry<String, BoundTransportAddress> entry : this.profileAddresses.entrySet()) {
                out.writeString(entry.getKey());
                entry.getValue().writeTo(out);
            }
        }
    }

    private String formatPublishAddressString(String propertyName, TransportAddress publishAddress) {
        Object publishAddressString = publishAddress.toString();
        String hostString = publishAddress.address().getHostString();
        if (!InetAddresses.isInetAddress(hostString)) {
            publishAddressString = hostString + "/" + publishAddress.toString();
            if (this.cnameInPublishAddressProperty) {
                deprecationLogger.warn(DeprecationCategory.SETTINGS, "cname_in_publish_address", "es.transport.cname_in_publish_address system property is deprecated and no longer affects " + propertyName + " formatting. Remove this property to get rid of this deprecation warning.", new Object[0]);
            }
        }
        return publishAddressString;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("transport");
        builder.xContentList("bound_address", (ToXContent[])this.address.boundAddresses());
        builder.field("publish_address", this.formatPublishAddressString("transport.publish_address", this.address.publishAddress()));
        builder.startObject("profiles");
        if (this.profileAddresses != null && this.profileAddresses.size() > 0) {
            for (Map.Entry<String, BoundTransportAddress> entry : this.profileAddresses.entrySet()) {
                builder.startObject(entry.getKey());
                builder.array("bound_address", (Object[])entry.getValue().boundAddresses());
                String propertyName = "transport." + entry.getKey() + ".publish_address";
                builder.field("publish_address", this.formatPublishAddressString(propertyName, entry.getValue().publishAddress()));
                builder.endObject();
            }
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public BoundTransportAddress address() {
        return this.address;
    }

    public BoundTransportAddress getAddress() {
        return this.address();
    }

    public Map<String, BoundTransportAddress> getProfileAddresses() {
        return this.profileAddresses();
    }

    public Map<String, BoundTransportAddress> profileAddresses() {
        return this.profileAddresses;
    }

    static final class Fields {
        static final String TRANSPORT = "transport";
        static final String BOUND_ADDRESS = "bound_address";
        static final String PUBLISH_ADDRESS = "publish_address";
        static final String PROFILES = "profiles";

        Fields() {
        }
    }
}

