/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.TransportDecompressor;

public class DeflateTransportDecompressor
implements TransportDecompressor {
    private final Inflater inflater;
    private final Recycler<BytesRef> recycler;
    private final ArrayDeque<Recycler.V<BytesRef>> pages;
    private int pageOffset = 0;
    private int pageLength = 0;
    private boolean hasSkippedHeader = false;

    public DeflateTransportDecompressor(Recycler<BytesRef> recycler) {
        this.recycler = recycler;
        this.inflater = new Inflater(true);
        this.pages = new ArrayDeque(4);
    }

    @Override
    public int decompress(BytesReference bytesReference) throws IOException {
        BytesRef ref;
        int bytesConsumed = 0;
        if (!this.hasSkippedHeader) {
            this.hasSkippedHeader = true;
            int headerLength = 4;
            bytesReference = bytesReference.slice(headerLength, bytesReference.length() - headerLength);
            bytesConsumed += headerLength;
        }
        BytesRefIterator refIterator = bytesReference.iterator();
        while ((ref = refIterator.next()) != null) {
            this.inflater.setInput(ref.bytes, ref.offset, ref.length);
            bytesConsumed += ref.length;
            boolean continueInflating = true;
            while (continueInflating) {
                boolean isNewPage;
                boolean bl = isNewPage = this.pageOffset == this.pageLength;
                if (isNewPage) {
                    Recycler.V<BytesRef> newPage = this.recycler.obtain();
                    this.pageOffset = 0;
                    this.pageLength = newPage.v().length;
                    assert (newPage.v().length > 0);
                    this.pages.add(newPage);
                }
                Recycler.V<BytesRef> page = this.pages.getLast();
                BytesRef output = page.v();
                try {
                    int bytesInflated = this.inflater.inflate(output.bytes, output.offset + this.pageOffset, this.pageLength - this.pageOffset);
                    this.pageOffset += bytesInflated;
                    if (isNewPage && bytesInflated == 0) {
                        Recycler.V<BytesRef> removed = this.pages.pollLast();
                        assert (removed == page);
                        removed.close();
                        this.pageOffset = 16384;
                    }
                }
                catch (DataFormatException e) {
                    throw new IOException("Exception while inflating bytes", e);
                }
                if (this.inflater.needsInput()) {
                    continueInflating = false;
                }
                if (this.inflater.finished()) {
                    bytesConsumed -= this.inflater.getRemaining();
                    continueInflating = false;
                }
                assert (!this.inflater.needsDictionary());
            }
        }
        return bytesConsumed;
    }

    public boolean isEOS() {
        return this.inflater.finished();
    }

    @Override
    public ReleasableBytesReference pollDecompressedPage(boolean isEOS) {
        if (this.pages.isEmpty()) {
            return null;
        }
        if (this.pages.size() == 1) {
            if (isEOS) {
                assert (this.isEOS());
                Recycler.V<BytesRef> page = this.pages.pollFirst();
                BytesArray delegate = new BytesArray(page.v().bytes, page.v().offset, this.pageOffset);
                ReleasableBytesReference reference = new ReleasableBytesReference((BytesReference)delegate, page);
                this.pageLength = 0;
                this.pageOffset = 0;
                return reference;
            }
            return null;
        }
        Recycler.V<BytesRef> page = this.pages.pollFirst();
        return new ReleasableBytesReference((BytesReference)new BytesArray(page.v()), page);
    }

    @Override
    public Compression.Scheme getScheme() {
        return Compression.Scheme.DEFLATE;
    }

    @Override
    public void close() {
        this.inflater.end();
        for (Recycler.V<BytesRef> page : this.pages) {
            page.close();
        }
    }
}

