/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.timeseries.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.timeseries.support.TimeSeriesMetrics;

public class TimeSeriesMetricsService {
    private final Client client;
    private final int bucketBatchSize;
    private final int docBatchSize;

    public TimeSeriesMetricsService(Client client, int bucketBatchSize, int docBatchSize) {
        this.client = client;
        this.bucketBatchSize = bucketBatchSize;
        this.docBatchSize = docBatchSize;
    }

    public void newMetrics(String[] indices, ActionListener<TimeSeriesMetrics> listener) {
        FieldCapabilitiesRequest request = new FieldCapabilitiesRequest();
        request.indices(indices);
        request.fields("*");
        this.client.fieldCaps(request, listener.map(this::newMetrics));
    }

    private TimeSeriesMetrics newMetrics(FieldCapabilitiesResponse response) {
        if (!response.getFailures().isEmpty()) {
            ElasticsearchException e = new ElasticsearchException("Failed to fetch field caps for " + Arrays.toString(response.getFailedIndices()), new Object[0]);
            for (FieldCapabilitiesFailure f : response.getFailures()) {
                e.addSuppressed(new ElasticsearchException("Failed to fetch field caps for " + Arrays.toString(f.getIndices()), (Throwable)f.getException(), new Object[0]));
            }
            throw e;
        }
        ArrayList<String> dimensionFieldNames = new ArrayList<String>();
        for (Map.Entry<String, Map<String, FieldCapabilities>> e : response.get().entrySet()) {
            for (Map.Entry<String, FieldCapabilities> e2 : e.getValue().entrySet()) {
                this.collectField(dimensionFieldNames, e.getKey(), e2.getKey(), e2.getValue());
            }
        }
        return new TimeSeriesMetrics(this.bucketBatchSize, this.docBatchSize, this.client, response.getIndices(), List.copyOf(dimensionFieldNames));
    }

    private void collectField(List<String> dimensions, String fieldName, String fieldType, FieldCapabilities capabilities) {
        if (capabilities.isDimension()) {
            dimensions.add(fieldName);
        }
    }
}

