/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.search.fetch.FetchProfiler;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.profile.SearchProfileQueryPhaseResult;
import org.elasticsearch.search.profile.aggregation.AggregationProfileShardResult;
import org.elasticsearch.search.profile.aggregation.AggregationProfiler;
import org.elasticsearch.search.profile.query.QueryProfileShardResult;
import org.elasticsearch.search.profile.query.QueryProfiler;

public final class Profilers {
    private final ContextIndexSearcher searcher;
    private final List<QueryProfiler> queryProfilers = new ArrayList<QueryProfiler>();
    private final AggregationProfiler aggProfiler = new AggregationProfiler();

    public Profilers(ContextIndexSearcher searcher) {
        this.searcher = searcher;
        this.addQueryProfiler();
    }

    public QueryProfiler addQueryProfiler() {
        QueryProfiler profiler = new QueryProfiler();
        this.searcher.setProfiler(profiler);
        this.queryProfilers.add(profiler);
        return profiler;
    }

    public QueryProfiler getCurrentQueryProfiler() {
        return this.queryProfilers.get(this.queryProfilers.size() - 1);
    }

    public List<QueryProfiler> getQueryProfilers() {
        return Collections.unmodifiableList(this.queryProfilers);
    }

    public AggregationProfiler getAggregationProfiler() {
        return this.aggProfiler;
    }

    public FetchProfiler startProfilingFetchPhase() {
        return new FetchProfiler();
    }

    public SearchProfileQueryPhaseResult buildQueryPhaseResults() {
        ArrayList<QueryProfileShardResult> queryResults = new ArrayList<QueryProfileShardResult>(this.queryProfilers.size());
        for (QueryProfiler queryProfiler : this.queryProfilers) {
            QueryProfileShardResult result = new QueryProfileShardResult(queryProfiler.getTree(), queryProfiler.getRewriteTime(), queryProfiler.getCollector());
            queryResults.add(result);
        }
        AggregationProfileShardResult aggResults = new AggregationProfileShardResult(this.aggProfiler.getTree());
        return new SearchProfileQueryPhaseResult(queryResults, aggResults);
    }
}

