/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;

public final class AliasFilter
implements Writeable,
Rewriteable<AliasFilter> {
    private final String[] aliases;
    private final QueryBuilder filter;
    public static final AliasFilter EMPTY = new AliasFilter(null, Strings.EMPTY_ARRAY);

    public AliasFilter(QueryBuilder filter, String ... aliases) {
        this.aliases = aliases == null ? Strings.EMPTY_ARRAY : aliases;
        this.filter = filter;
    }

    public AliasFilter(StreamInput input) throws IOException {
        this.aliases = input.readStringArray();
        this.filter = input.readOptionalNamedWriteable(QueryBuilder.class);
    }

    @Override
    public AliasFilter rewrite(QueryRewriteContext context) throws IOException {
        QueryBuilder rewrite;
        QueryBuilder queryBuilder = this.filter;
        if (queryBuilder != null && (rewrite = Rewriteable.rewrite(queryBuilder, context)) != queryBuilder) {
            return new AliasFilter(rewrite, this.aliases);
        }
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.aliases);
        out.writeOptionalNamedWriteable(this.filter);
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public QueryBuilder getQueryBuilder() {
        return this.filter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasFilter that = (AliasFilter)o;
        return Arrays.equals(this.aliases, that.aliases) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.aliases), this.filter);
    }

    public String toString() {
        return "AliasFilter{aliases=" + Arrays.toString(this.aliases) + ", filter=" + this.filter + "}";
    }
}

