/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import org.elasticsearch.monitor.jvm.JvmStats;
import org.elasticsearch.threadpool.ThreadPool;

public final class SearchUtils {
    public static final int DEFAULT_MAX_CLAUSE_COUNT = 1024;

    public static int calculateMaxClauseValue(ThreadPool threadPool) {
        int searchThreadPoolSize = threadPool.info("search").getMax();
        long heapSize = JvmStats.jvmStats().getMem().getHeapMax().getGb();
        return SearchUtils.calculateMaxClauseValue(searchThreadPoolSize, heapSize);
    }

    static int calculateMaxClauseValue(long threadPoolSize, double heapInGb) {
        if (threadPoolSize <= 0L || heapInGb <= 0.0) {
            return 1024;
        }
        int maxClauseCount = (int)(heapInGb * 65536.0 / (double)threadPoolSize);
        return Math.max(1024, maxClauseCount);
    }

    private SearchUtils() {
    }
}

