/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ResultDeduplicator;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.ListenableActionFuture;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.RepositoryCleanupInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetadata;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import org.elasticsearch.index.snapshots.blobstore.RateLimitingInputStream;
import org.elasticsearch.index.snapshots.blobstore.SlicedInputStream;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.GetSnapshotInfoContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.IndexMetaDataGenerations;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryCleanupResult;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.RepositoryStats;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.elasticsearch.repositories.blobstore.FileRestoreContext;
import org.elasticsearch.snapshots.AbortedSnapshotException;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public abstract class BlobStoreRepository
extends AbstractLifecycleComponent
implements Repository {
    private static final Logger logger = LogManager.getLogger(BlobStoreRepository.class);
    protected volatile RepositoryMetadata metadata;
    protected final ThreadPool threadPool;
    public static final String SNAPSHOT_PREFIX = "snap-";
    public static final String INDEX_FILE_PREFIX = "index-";
    public static final String INDEX_LATEST_BLOB = "index.latest";
    private static final String TESTS_FILE = "tests-";
    public static final String METADATA_PREFIX = "meta-";
    public static final String METADATA_NAME_FORMAT = "meta-%s.dat";
    public static final String SNAPSHOT_NAME_FORMAT = "snap-%s.dat";
    private static final String SNAPSHOT_INDEX_PREFIX = "index-";
    private static final String SNAPSHOT_INDEX_NAME_FORMAT = "index-%s";
    public static final String UPLOADED_DATA_BLOB_PREFIX = "__";
    public static final String URL_REPOSITORY_TYPE = "url";
    public static final String READONLY_SETTING_KEY = "readonly";
    private static final String VIRTUAL_DATA_BLOB_PREFIX = "v__";
    public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting("compress", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> CACHE_REPOSITORY_DATA = Setting.boolSetting("cache_repository_data", true, Setting.Property.DeprecatedWarning);
    public static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting("io_buffer_size", ByteSizeValue.parseBytesSizeValue("128kb", "io_buffer_size"), ByteSizeValue.parseBytesSizeValue("8kb", "buffer_size"), ByteSizeValue.parseBytesSizeValue("16mb", "io_buffer_size"), Setting.Property.NodeScope);
    public static final Setting<Boolean> SUPPORT_URL_REPO = Setting.boolSetting("support_url_repo", true, Setting.Property.NodeScope);
    public static final Setting<Integer> MAX_SNAPSHOTS_SETTING = Setting.intSetting("max_number_of_snapshots", Integer.MAX_VALUE, 1, Setting.Property.NodeScope);
    public static final Setting<Boolean> USE_FOR_PEER_RECOVERY_SETTING = Setting.boolSetting("use_for_peer_recovery", false, new Setting.Property[0]);
    protected final boolean supportURLRepo;
    private final boolean compress;
    private final boolean cacheRepositoryData;
    private volatile RateLimiter snapshotRateLimiter;
    private volatile RateLimiter restoreRateLimiter;
    private final CounterMetric snapshotRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric restoreRateLimitingTimeInNanos = new CounterMetric();
    public static final ChecksumBlobStoreFormat<Metadata> GLOBAL_METADATA_FORMAT = new ChecksumBlobStoreFormat<Metadata>("metadata", "meta-%s.dat", (repoName, parser) -> Metadata.fromXContent(parser));
    public static final ChecksumBlobStoreFormat<IndexMetadata> INDEX_METADATA_FORMAT = new ChecksumBlobStoreFormat<IndexMetadata>("index-metadata", "meta-%s.dat", (repoName, parser) -> IndexMetadata.Builder.legacyFromXContent(parser), (repoName, parser) -> IndexMetadata.fromXContent(parser));
    private static final String SNAPSHOT_CODEC = "snapshot";
    public static final ChecksumBlobStoreFormat<SnapshotInfo> SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat<SnapshotInfo>("snapshot", "snap-%s.dat", SnapshotInfo::fromXContentInternal);
    public static final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot> INDEX_SHARD_SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot>("snapshot", "snap-%s.dat", (repoName, parser) -> BlobStoreIndexShardSnapshot.fromXContent(parser));
    public static final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots> INDEX_SHARD_SNAPSHOTS_FORMAT = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots>("snapshots", "index-%s", (repoName, parser) -> BlobStoreIndexShardSnapshots.fromXContent(parser));
    public static final Setting<ByteSizeValue> MAX_SNAPSHOT_BYTES_PER_SEC = Setting.byteSizeSetting("max_snapshot_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> MAX_RESTORE_BYTES_PER_SEC = Setting.byteSizeSetting("max_restore_bytes_per_sec", ByteSizeValue.ZERO, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final Set<String> DYNAMIC_SETTING_NAMES = Set.of(MAX_SNAPSHOT_BYTES_PER_SEC.getKey(), MAX_RESTORE_BYTES_PER_SEC.getKey());
    private final boolean readOnly;
    private final Object lock = new Object();
    private final SetOnce<BlobContainer> blobContainer = new SetOnce();
    private final SetOnce<BlobStore> blobStore = new SetOnce();
    private final BlobPath basePath;
    private final ClusterService clusterService;
    private final RecoverySettings recoverySettings;
    private final NamedXContentRegistry namedXContentRegistry;
    protected final BigArrays bigArrays;
    private boolean uncleanStart;
    private volatile boolean bestEffortConsistency;
    protected final int bufferSize;
    private final int maxSnapshotCount;
    @Nullable
    private List<ActionListener<Void>> emptyListeners;
    private final Set<ShardId> ongoingRestores = new HashSet<ShardId>();
    private final AtomicLong latestKnownRepoGen = new AtomicLong(-2L);
    private final AtomicReference<RepositoryData> latestKnownRepositoryData = new AtomicReference<RepositoryData>(RepositoryData.EMPTY);
    private ListenableActionFuture<RepositoryData> repoDataInitialized;
    private final ResultDeduplicator<RepositoryMetadata, RepositoryData> repoDataDeduplicator = new ResultDeduplicator();

    protected BlobStoreRepository(RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, BlobPath basePath) {
        this.metadata = metadata;
        this.threadPool = clusterService.getClusterApplierService().threadPool();
        this.clusterService = clusterService;
        this.bigArrays = bigArrays;
        this.recoverySettings = recoverySettings;
        this.compress = COMPRESS_SETTING.get(metadata.settings());
        this.supportURLRepo = SUPPORT_URL_REPO.get(metadata.settings());
        this.snapshotRateLimiter = BlobStoreRepository.getRateLimiter(metadata.settings(), MAX_SNAPSHOT_BYTES_PER_SEC);
        this.restoreRateLimiter = BlobStoreRepository.getRateLimiter(metadata.settings(), MAX_RESTORE_BYTES_PER_SEC);
        this.readOnly = metadata.settings().getAsBoolean(READONLY_SETTING_KEY, false);
        this.cacheRepositoryData = CACHE_REPOSITORY_DATA.get(metadata.settings());
        this.bufferSize = Math.toIntExact(BUFFER_SIZE_SETTING.get(metadata.settings()).getBytes());
        this.namedXContentRegistry = namedXContentRegistry;
        this.basePath = basePath;
        this.maxSnapshotCount = MAX_SNAPSHOTS_SETTING.get(metadata.settings());
    }

    @Override
    protected void doStart() {
        this.uncleanStart = this.metadata.pendingGeneration() > -1L && this.metadata.generation() != this.metadata.pendingGeneration();
        ByteSizeValue chunkSize = this.chunkSize();
        if (chunkSize != null && chunkSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("the chunk size cannot be negative: [" + chunkSize + "]");
        }
    }

    @Override
    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        BlobStore store;
        Object object = this.lock;
        synchronized (object) {
            store = (BlobStore)this.blobStore.get();
        }
        if (store != null) {
            try {
                store.close();
            }
            catch (Exception t) {
                logger.warn("cannot close blob store", (Throwable)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitIdle() {
        PlainActionFuture future;
        assert (this.lifecycle.stoppedOrClosed());
        Set<ShardId> set = this.ongoingRestores;
        synchronized (set) {
            if (this.ongoingRestores.isEmpty()) {
                return;
            }
            future = new PlainActionFuture();
            if (this.emptyListeners == null) {
                this.emptyListeners = new ArrayList<ActionListener<Void>>();
            }
            this.emptyListeners.add(future);
        }
        FutureUtils.get(future);
    }

    @Override
    public void executeConsistentStateUpdate(final Function<RepositoryData, ClusterStateUpdateTask> createUpdateTask, String source, final Consumer<Exception> onFailure) {
        final RepositoryMetadata repositoryMetadataStart = this.metadata;
        this.getRepositoryData(ActionListener.wrap(repositoryData -> {
            final ClusterStateUpdateTask updateTask = (ClusterStateUpdateTask)createUpdateTask.apply((RepositoryData)repositoryData);
            this.clusterService.submitStateUpdateTask(source, new ClusterStateUpdateTask(updateTask.priority(), updateTask.timeout()){
                private boolean executedTask;
                {
                    super(priority, timeout);
                    this.executedTask = false;
                }

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    if (repositoryMetadataStart.equals(BlobStoreRepository.this.getRepoMetadata(currentState))) {
                        this.executedTask = true;
                        return updateTask.execute(currentState);
                    }
                    return currentState;
                }

                @Override
                public void onFailure(String source, Exception e) {
                    if (this.executedTask) {
                        updateTask.onFailure(source, e);
                    } else {
                        onFailure.accept(e);
                    }
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    if (this.executedTask) {
                        updateTask.clusterStateProcessed(source, oldState, newState);
                    } else {
                        BlobStoreRepository.this.executeConsistentStateUpdate(createUpdateTask, source, onFailure);
                    }
                }
            });
        }, onFailure));
    }

    @Override
    public void cloneShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, @Nullable ShardGeneration shardGeneration, ActionListener<ShardSnapshotResult> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "cannot clone shard snapshot on a readonly repository"));
            return;
        }
        IndexId index = shardId.index();
        int shardNum = shardId.shardId();
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        executor.execute(ActionRunnable.supply(listener, () -> {
            BlobStoreIndexShardSnapshots existingSnapshots;
            ShardGeneration newGen;
            ShardGeneration existingShardGen;
            long startTime = this.threadPool.absoluteTimeInMillis();
            BlobContainer shardContainer = this.shardContainer(index, shardNum);
            if (shardGeneration == null) {
                Tuple<BlobStoreIndexShardSnapshots, Long> tuple = this.buildBlobStoreIndexShardSnapshots(shardContainer.listBlobsByPrefix("index-").keySet(), shardContainer);
                existingShardGen = new ShardGeneration((Long)tuple.v2());
                newGen = new ShardGeneration((Long)tuple.v2() + 1L);
                existingSnapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
            } else {
                newGen = ShardGeneration.newGeneration();
                existingSnapshots = (BlobStoreIndexShardSnapshots)this.buildBlobStoreIndexShardSnapshots(Collections.emptySet(), shardContainer, shardGeneration).v1();
                existingShardGen = shardGeneration;
            }
            SnapshotFiles existingTargetFiles = null;
            SnapshotFiles sourceFiles = null;
            for (SnapshotFiles existingSnapshot : existingSnapshots) {
                String snapshotName = existingSnapshot.snapshot();
                if (snapshotName.equals(target.getName())) {
                    existingTargetFiles = existingSnapshot;
                } else if (snapshotName.equals(source.getName())) {
                    sourceFiles = existingSnapshot;
                }
                if (sourceFiles == null || existingTargetFiles == null) continue;
                break;
            }
            if (sourceFiles == null) {
                throw new RepositoryException(this.metadata.name(), "Can't create clone of [" + shardId + "] for snapshot [" + target + "]. The source snapshot [" + source + "] was not found in the shard metadata.");
            }
            if (existingTargetFiles != null) {
                if (existingTargetFiles.isSame(sourceFiles)) {
                    return new ShardSnapshotResult(existingShardGen, ByteSizeValue.ofBytes(existingTargetFiles.totalSize()), BlobStoreRepository.getSegmentInfoFileCount(existingTargetFiles.indexFiles()));
                }
                throw new RepositoryException(this.metadata.name(), "Can't create clone of [" + shardId + "] for snapshot [" + target + "]. A snapshot by that name already exists for this shard.");
            }
            BlobStoreIndexShardSnapshot sourceMeta = this.loadShardSnapshot(shardContainer, source);
            logger.trace("[{}] [{}] writing shard snapshot file for clone", (Object)shardId, (Object)target);
            INDEX_SHARD_SNAPSHOT_FORMAT.write(sourceMeta.asClone(target.getName(), startTime, this.threadPool.absoluteTimeInMillis() - startTime), shardContainer, target.getUUID(), this.compress);
            INDEX_SHARD_SNAPSHOTS_FORMAT.write(existingSnapshots.withClone(source.getName(), target.getName()), shardContainer, newGen.toBlobNamePart(), this.compress);
            return new ShardSnapshotResult(newGen, ByteSizeValue.ofBytes(sourceMeta.totalSize()), BlobStoreRepository.getSegmentInfoFileCount(sourceMeta.indexFiles()));
        }));
    }

    private static int getSegmentInfoFileCount(List<BlobStoreIndexShardSnapshot.FileInfo> indexFiles) {
        return Math.toIntExact(Math.min(Integer.MAX_VALUE, indexFiles.stream().filter(fi -> fi.physicalName().endsWith(".si")).count()));
    }

    @Override
    public boolean canUpdateInPlace(Settings updatedSettings, Set<String> ignoredSettings) {
        Settings current = this.metadata.settings();
        if (current.equals(updatedSettings)) {
            return true;
        }
        HashSet<String> changedSettingNames = new HashSet<String>(current.keySet());
        changedSettingNames.addAll(updatedSettings.keySet());
        changedSettingNames.removeAll(ignoredSettings);
        changedSettingNames.removeIf(setting -> Objects.equals(current.get((String)setting), updatedSettings.get((String)setting)));
        changedSettingNames.removeAll(DYNAMIC_SETTING_NAMES);
        return changedSettingNames.isEmpty();
    }

    @Override
    public void updateState(ClusterState state) {
        Settings previousSettings = this.metadata.settings();
        this.metadata = this.getRepoMetadata(state);
        Settings updatedSettings = this.metadata.settings();
        if (!updatedSettings.equals(previousSettings)) {
            this.snapshotRateLimiter = BlobStoreRepository.getRateLimiter(this.metadata.settings(), MAX_SNAPSHOT_BYTES_PER_SEC);
            this.restoreRateLimiter = BlobStoreRepository.getRateLimiter(this.metadata.settings(), MAX_RESTORE_BYTES_PER_SEC);
        }
        this.uncleanStart = this.uncleanStart && this.metadata.generation() != this.metadata.pendingGeneration();
        boolean wasBestEffortConsistency = this.bestEffortConsistency;
        boolean bl = this.bestEffortConsistency = this.uncleanStart || this.isReadOnly() || this.metadata.generation() == -2L;
        if (this.isReadOnly()) {
            return;
        }
        if (this.bestEffortConsistency) {
            SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
            long bestGenerationFromCS = this.bestGeneration(snapshotsInProgress.forRepo(this.metadata.name()));
            if (bestGenerationFromCS == -1L) {
                bestGenerationFromCS = this.bestGeneration(state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries());
            }
            if (bestGenerationFromCS == -1L) {
                bestGenerationFromCS = this.bestGeneration(state.custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY).entries());
            }
            long finalBestGen = Math.max(bestGenerationFromCS, this.metadata.generation());
            this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, finalBestGen));
        } else {
            long previousBest = this.latestKnownRepoGen.getAndSet(this.metadata.generation());
            if (previousBest != this.metadata.generation()) {
                assert (wasBestEffortConsistency || this.metadata.generation() == -3L || previousBest < this.metadata.generation()) : "Illegal move from repository generation [" + previousBest + "] to generation [" + this.metadata.generation() + "]";
                logger.debug("Updated repository generation from [{}] to [{}]", (Object)previousBest, (Object)this.metadata.generation());
            }
        }
    }

    private long bestGeneration(Collection<? extends RepositoryOperation> operations) {
        String repoName = this.metadata.name();
        return operations.stream().filter(e -> e.repository().equals(repoName)).mapToLong(RepositoryOperation::repositoryStateId).max().orElse(-1L);
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    BlobContainer getBlobContainer() {
        return (BlobContainer)this.blobContainer.get();
    }

    protected BlobStore getBlobStore() {
        return (BlobStore)this.blobStore.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobContainer blobContainer() {
        this.assertSnapshotOrGenericThread();
        if (!this.lifecycle.started()) {
            throw this.notStartedException();
        }
        BlobContainer blobContainer = (BlobContainer)this.blobContainer.get();
        if (blobContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                blobContainer = (BlobContainer)this.blobContainer.get();
                if (blobContainer == null) {
                    blobContainer = this.blobStore().blobContainer(this.basePath());
                    this.blobContainer.set((Object)blobContainer);
                }
            }
        }
        return blobContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobStore blobStore() {
        this.assertSnapshotOrGenericThread();
        BlobStore store = (BlobStore)this.blobStore.get();
        if (store == null) {
            Object object = this.lock;
            synchronized (object) {
                store = (BlobStore)this.blobStore.get();
                if (store == null) {
                    if (!this.lifecycle.started()) {
                        throw this.notStartedException();
                    }
                    try {
                        store = this.createBlobStore();
                    }
                    catch (RepositoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RepositoryException(this.metadata.name(), "cannot create blob store", e);
                    }
                    this.blobStore.set((Object)store);
                }
            }
        }
        return store;
    }

    protected abstract BlobStore createBlobStore() throws Exception;

    public BlobPath basePath() {
        return this.basePath;
    }

    protected final boolean isCompress() {
        return this.compress;
    }

    protected ByteSizeValue chunkSize() {
        return null;
    }

    @Override
    public RepositoryMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RepositoryStats stats() {
        BlobStore store = (BlobStore)this.blobStore.get();
        if (store == null) {
            return RepositoryStats.EMPTY_STATS;
        }
        return new RepositoryStats(store.stats());
    }

    @Override
    public void deleteSnapshots(final Collection<SnapshotId> snapshotIds, final long repositoryStateId, final Version repositoryMetaVersion, final ActionListener<RepositoryData> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "cannot delete snapshot from a readonly repository"));
        } else {
            this.threadPool.executor(SNAPSHOT_CODEC).execute(new AbstractRunnable(){

                @Override
                protected void doRun() throws Exception {
                    Map<String, BlobMetadata> rootBlobs = BlobStoreRepository.this.blobContainer().listBlobs();
                    RepositoryData repositoryData = BlobStoreRepository.this.safeRepositoryData(repositoryStateId, rootBlobs);
                    Map<String, BlobContainer> foundIndices = BlobStoreRepository.this.blobStore().blobContainer(BlobStoreRepository.this.indicesPath()).children();
                    BlobStoreRepository.this.doDeleteShardSnapshots(snapshotIds, repositoryStateId, foundIndices, rootBlobs, repositoryData, repositoryMetaVersion, listener);
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(new RepositoryException(BlobStoreRepository.this.metadata.name(), "failed to delete snapshots " + snapshotIds, e));
                }
            });
        }
    }

    private RepositoryData safeRepositoryData(long repositoryStateId, Map<String, BlobMetadata> rootBlobs) {
        RepositoryData cached;
        long genToLoad;
        long generation = this.latestGeneration(rootBlobs.keySet());
        if (this.bestEffortConsistency) {
            genToLoad = this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, repositoryStateId));
            cached = null;
        } else {
            genToLoad = this.latestKnownRepoGen.get();
            cached = this.latestKnownRepositoryData.get();
        }
        if (genToLoad > generation) {
            logger.debug("Determined repository's generation from its contents to [" + generation + "] but current generation is at least [" + genToLoad + "]");
        }
        if (genToLoad != repositoryStateId) {
            throw new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + repositoryStateId + "], actual current generation [" + genToLoad + "]");
        }
        if (cached != null && cached.getGenId() == genToLoad) {
            return cached;
        }
        return this.getRepositoryData(genToLoad);
    }

    private void doDeleteShardSnapshots(Collection<SnapshotId> snapshotIds, long repositoryStateId, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData repositoryData, Version repoMetaVersion, ActionListener<RepositoryData> listener) {
        if (SnapshotsService.useShardGenerations(repoMetaVersion)) {
            StepListener<Collection<ShardSnapshotMetaDeleteResult>> writeShardMetaDataAndComputeDeletesStep = new StepListener<Collection<ShardSnapshotMetaDeleteResult>>();
            this.writeUpdatedShardMetaDataAndComputeDeletes(snapshotIds, repositoryData, true, writeShardMetaDataAndComputeDeletesStep);
            StepListener writeUpdatedRepoDataStep = new StepListener();
            writeShardMetaDataAndComputeDeletesStep.whenComplete((CheckedConsumer<Collection<ShardSnapshotMetaDeleteResult>, Exception>)((CheckedConsumer)deleteResults -> {
                ShardGenerations.Builder builder = ShardGenerations.builder();
                for (ShardSnapshotMetaDeleteResult newGen : deleteResults) {
                    builder.put(newGen.indexId, newGen.shardId, newGen.newGeneration);
                }
                RepositoryData updatedRepoData = repositoryData.removeSnapshots(snapshotIds, builder.build());
                this.writeIndexGen(updatedRepoData, repositoryStateId, repoMetaVersion, Function.identity(), ActionListener.wrap(writeUpdatedRepoDataStep::onResponse, listener::onFailure));
            }), listener::onFailure);
            writeUpdatedRepoDataStep.whenComplete(updatedRepoData -> {
                GroupedActionListener<Void> afterCleanupsListener = new GroupedActionListener<Void>(ActionListener.wrap(() -> listener.onResponse((RepositoryData)updatedRepoData)), 2);
                this.cleanupUnlinkedRootAndIndicesBlobs(snapshotIds, foundIndices, rootBlobs, (RepositoryData)updatedRepoData, (ActionListener<Void>)afterCleanupsListener);
                this.asyncCleanupUnlinkedShardLevelBlobs(repositoryData, snapshotIds, (Collection)writeShardMetaDataAndComputeDeletesStep.result(), afterCleanupsListener);
            }, listener::onFailure);
        } else {
            RepositoryData updatedRepoData2 = repositoryData.removeSnapshots(snapshotIds, ShardGenerations.EMPTY);
            this.writeIndexGen(updatedRepoData2, repositoryStateId, repoMetaVersion, Function.identity(), ActionListener.wrap(newRepoData -> {
                GroupedActionListener<Void> afterCleanupsListener = new GroupedActionListener<Void>(ActionListener.wrap(() -> listener.onResponse((RepositoryData)newRepoData)), 2);
                this.cleanupUnlinkedRootAndIndicesBlobs(snapshotIds, foundIndices, rootBlobs, (RepositoryData)newRepoData, (ActionListener<Void>)afterCleanupsListener);
                StepListener<Collection<ShardSnapshotMetaDeleteResult>> writeMetaAndComputeDeletesStep = new StepListener<Collection<ShardSnapshotMetaDeleteResult>>();
                this.writeUpdatedShardMetaDataAndComputeDeletes(snapshotIds, repositoryData, false, writeMetaAndComputeDeletesStep);
                writeMetaAndComputeDeletesStep.whenComplete((CheckedConsumer<Collection<ShardSnapshotMetaDeleteResult>, Exception>)((CheckedConsumer)deleteResults -> this.asyncCleanupUnlinkedShardLevelBlobs(repositoryData, snapshotIds, (Collection<ShardSnapshotMetaDeleteResult>)deleteResults, (ActionListener<Void>)afterCleanupsListener)), afterCleanupsListener::onFailure);
            }, listener::onFailure));
        }
    }

    private void cleanupUnlinkedRootAndIndicesBlobs(Collection<SnapshotId> deletedSnapshots, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData updatedRepoData, ActionListener<Void> listener) {
        this.cleanupStaleBlobs(deletedSnapshots, foundIndices, rootBlobs, updatedRepoData, listener.map(ignored -> null));
    }

    private void asyncCleanupUnlinkedShardLevelBlobs(RepositoryData oldRepositoryData, Collection<SnapshotId> snapshotIds, Collection<ShardSnapshotMetaDeleteResult> deleteResults, ActionListener<Void> listener) {
        Iterator<String> filesToDelete = this.resolveFilesToDelete(oldRepositoryData, snapshotIds, deleteResults);
        if (!filesToDelete.hasNext()) {
            listener.onResponse(null);
            return;
        }
        this.threadPool.executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(listener, l -> {
            try {
                this.deleteFromContainer(this.blobContainer(), filesToDelete);
                l.onResponse(null);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("{} Failed to delete some blobs during snapshot delete", (Object)snapshotIds), (Throwable)e);
                throw e;
            }
        }));
    }

    private void writeUpdatedShardMetaDataAndComputeDeletes(final Collection<SnapshotId> snapshotIds, final RepositoryData oldRepositoryData, final boolean useUUIDs, ActionListener<Collection<ShardSnapshotMetaDeleteResult>> onAllShardsCompleted) {
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        List<IndexId> indices = oldRepositoryData.indicesToUpdateAfterRemovingSnapshot(snapshotIds);
        if (indices.isEmpty()) {
            onAllShardsCompleted.onResponse(Collections.emptyList());
            return;
        }
        GroupedActionListener deleteIndexMetadataListener = new GroupedActionListener(onAllShardsCompleted.map(res -> res.stream().flatMap(Collection::stream).collect(Collectors.toList())), indices.size());
        for (final IndexId indexId : indices) {
            Set<SnapshotId> snapshotsWithIndex = Set.copyOf(oldRepositoryData.getSnapshots(indexId));
            final Set survivingSnapshots = snapshotsWithIndex.stream().filter(id -> !snapshotIds.contains(id)).collect(Collectors.toSet());
            StepListener shardCountListener = new StepListener();
            Collection indexMetaGenerations = snapshotIds.stream().filter(snapshotsWithIndex::contains).map(id -> oldRepositoryData.indexMetaDataGenerations().indexMetaBlobId((SnapshotId)id, indexId)).collect(Collectors.toSet());
            GroupedActionListener allShardCountsListener = new GroupedActionListener(shardCountListener, indexMetaGenerations.size());
            BlobContainer indexContainer = this.indexContainer(indexId);
            for (String indexMetaGeneration : indexMetaGenerations) {
                executor.execute(ActionRunnable.supply(allShardCountsListener, () -> {
                    try {
                        return INDEX_METADATA_FORMAT.read(this.metadata.name(), indexContainer, indexMetaGeneration, this.namedXContentRegistry).getNumberOfShards();
                    }
                    catch (Exception ex) {
                        logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to read metadata for index", (Object)indexMetaGeneration, (Object)indexId.getName()), (Throwable)ex);
                        return null;
                    }
                }));
            }
            shardCountListener.whenComplete(counts -> {
                int shardCount = counts.stream().mapToInt(i -> i).max().orElse(0);
                if (shardCount == 0) {
                    deleteIndexMetadataListener.onResponse(null);
                    return;
                }
                final GroupedActionListener allShardsListener = new GroupedActionListener(deleteIndexMetadataListener, shardCount);
                int shardId = 0;
                while (shardId < shardCount) {
                    final int finalShardId = shardId++;
                    executor.execute(new AbstractRunnable(){

                        @Override
                        protected void doRun() throws Exception {
                            BlobStoreIndexShardSnapshots blobStoreIndexShardSnapshots;
                            long newGen;
                            BlobContainer shardContainer = BlobStoreRepository.this.shardContainer(indexId, finalShardId);
                            Set<String> blobs = shardContainer.listBlobs().keySet();
                            if (useUUIDs) {
                                newGen = -1L;
                                blobStoreIndexShardSnapshots = (BlobStoreIndexShardSnapshots)BlobStoreRepository.this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, oldRepositoryData.shardGenerations().getShardGen(indexId, finalShardId)).v1();
                            } else {
                                Tuple<BlobStoreIndexShardSnapshots, Long> tuple = BlobStoreRepository.this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
                                newGen = (Long)tuple.v2() + 1L;
                                blobStoreIndexShardSnapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
                            }
                            allShardsListener.onResponse(BlobStoreRepository.this.deleteFromShardSnapshotMeta(survivingSnapshots, indexId, finalShardId, snapshotIds, shardContainer, blobs, blobStoreIndexShardSnapshots, newGen));
                        }

                        @Override
                        public void onFailure(Exception ex) {
                            logger.warn(() -> new ParameterizedMessage("{} failed to delete shard data for shard [{}][{}]", new Object[]{snapshotIds, indexId.getName(), finalShardId}), (Throwable)ex);
                            allShardsListener.onResponse(null);
                        }
                    });
                }
            }, deleteIndexMetadataListener::onFailure);
        }
    }

    private Iterator<String> resolveFilesToDelete(RepositoryData oldRepositoryData, Collection<SnapshotId> snapshotIds, Collection<ShardSnapshotMetaDeleteResult> deleteResults) {
        String basePath = this.basePath().buildAsString();
        int basePathLen = basePath.length();
        Map<IndexId, Collection<String>> indexMetaGenerations = oldRepositoryData.indexMetaDataToRemoveAfterRemovingSnapshots(snapshotIds);
        return Stream.concat(deleteResults.stream().flatMap(shardResult -> {
            String shardPath = this.shardContainer(shardResult.indexId, shardResult.shardId).path().buildAsString();
            return shardResult.blobsToDelete.stream().map(blob -> shardPath + blob);
        }), indexMetaGenerations.entrySet().stream().flatMap(entry -> {
            String indexContainerPath = this.indexContainer((IndexId)entry.getKey()).path().buildAsString();
            return ((Collection)entry.getValue()).stream().map(id -> indexContainerPath + INDEX_METADATA_FORMAT.blobName((String)id));
        })).map(absolutePath -> {
            assert (absolutePath.startsWith(basePath));
            return absolutePath.substring(basePathLen);
        }).iterator();
    }

    private void cleanupStaleBlobs(Collection<SnapshotId> deletedSnapshots, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData newRepoData, ActionListener<DeleteResult> listener) {
        GroupedActionListener<DeleteResult> groupedListener = new GroupedActionListener<DeleteResult>(ActionListener.wrap(deleteResults -> {
            DeleteResult deleteResult = DeleteResult.ZERO;
            for (DeleteResult result : deleteResults) {
                deleteResult = deleteResult.add(result);
            }
            listener.onResponse(deleteResult);
        }, listener::onFailure), 2);
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        List<String> staleRootBlobs = BlobStoreRepository.staleRootBlobs(newRepoData, rootBlobs.keySet());
        if (staleRootBlobs.isEmpty()) {
            groupedListener.onResponse(DeleteResult.ZERO);
        } else {
            executor.execute(ActionRunnable.supply(groupedListener, () -> {
                List<String> deletedBlobs = this.cleanupStaleRootFiles(newRepoData.getGenId() - 1L, deletedSnapshots, staleRootBlobs);
                return new DeleteResult(deletedBlobs.size(), deletedBlobs.stream().mapToLong(name -> ((BlobMetadata)rootBlobs.get(name)).length()).sum());
            }));
        }
        Set survivingIndexIds = newRepoData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
        if (foundIndices.keySet().equals(survivingIndexIds)) {
            groupedListener.onResponse(DeleteResult.ZERO);
        } else {
            executor.execute(ActionRunnable.supply(groupedListener, () -> this.cleanupStaleIndices(foundIndices, survivingIndexIds)));
        }
    }

    public void cleanup(long repositoryStateId, Version repositoryMetaVersion, ActionListener<RepositoryCleanupResult> listener) {
        try {
            if (this.isReadOnly()) {
                throw new RepositoryException(this.metadata.name(), "cannot run cleanup on readonly repository");
            }
            Map<String, BlobMetadata> rootBlobs = this.blobContainer().listBlobs();
            RepositoryData repositoryData = this.safeRepositoryData(repositoryStateId, rootBlobs);
            Map<String, BlobContainer> foundIndices = this.blobStore().blobContainer(this.indicesPath()).children();
            Set survivingIndexIds = repositoryData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
            List<String> staleRootBlobs = BlobStoreRepository.staleRootBlobs(repositoryData, rootBlobs.keySet());
            if (survivingIndexIds.equals(foundIndices.keySet()) && staleRootBlobs.isEmpty()) {
                listener.onResponse(new RepositoryCleanupResult(DeleteResult.ZERO));
            } else {
                this.writeIndexGen(repositoryData, repositoryStateId, repositoryMetaVersion, Function.identity(), ActionListener.wrap(v -> this.cleanupStaleBlobs(Collections.emptyList(), foundIndices, rootBlobs, repositoryData, listener.map(RepositoryCleanupResult::new)), listener::onFailure));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static List<String> staleRootBlobs(RepositoryData repositoryData, Set<String> rootBlobNames) {
        Set allSnapshotIds = repositoryData.getSnapshotIds().stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
        return rootBlobNames.stream().filter(blob -> {
            if (FsBlobContainer.isTempBlobName(blob)) {
                return true;
            }
            if (blob.endsWith(".dat")) {
                String foundUUID;
                if (blob.startsWith(SNAPSHOT_PREFIX)) {
                    foundUUID = blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length());
                    assert (SNAPSHOT_FORMAT.blobName(foundUUID).equals(blob));
                } else if (blob.startsWith(METADATA_PREFIX)) {
                    foundUUID = blob.substring(METADATA_PREFIX.length(), blob.length() - ".dat".length());
                    assert (GLOBAL_METADATA_FORMAT.blobName(foundUUID).equals(blob));
                } else {
                    return false;
                }
                return !allSnapshotIds.contains(foundUUID);
            }
            if (blob.startsWith("index-")) {
                return repositoryData.getGenId() > Long.parseLong(blob.substring("index-".length()));
            }
            return false;
        }).collect(Collectors.toList());
    }

    private List<String> cleanupStaleRootFiles(long previousGeneration, Collection<SnapshotId> deletedSnapshots, List<String> blobsToDelete) {
        if (blobsToDelete.isEmpty()) {
            return blobsToDelete;
        }
        try {
            if (logger.isInfoEnabled()) {
                Set blobNamesToIgnore = deletedSnapshots.stream().flatMap(snapshotId -> Stream.of(GLOBAL_METADATA_FORMAT.blobName(snapshotId.getUUID()), SNAPSHOT_FORMAT.blobName(snapshotId.getUUID()), "index-" + previousGeneration)).collect(Collectors.toSet());
                List blobsToLog = blobsToDelete.stream().filter(b -> !blobNamesToIgnore.contains(b)).collect(Collectors.toList());
                if (!blobsToLog.isEmpty()) {
                    logger.info("[{}] Found stale root level blobs {}. Cleaning them up", (Object)this.metadata.name(), blobsToLog);
                }
            }
            this.deleteFromContainer(this.blobContainer(), blobsToDelete.iterator());
            return blobsToDelete;
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] The following blobs are no longer part of any snapshot [{}] but failed to remove them", (Object)this.metadata.name(), (Object)blobsToDelete), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private DeleteResult cleanupStaleIndices(Map<String, BlobContainer> foundIndices, Set<String> survivingIndexIds) {
        DeleteResult deleteResult = DeleteResult.ZERO;
        for (Map.Entry<String, BlobContainer> indexEntry : foundIndices.entrySet()) {
            String indexSnId = indexEntry.getKey();
            try {
                if (survivingIndexIds.contains(indexSnId)) continue;
                logger.debug("[{}] Found stale index [{}]. Cleaning it up", (Object)this.metadata.name(), (Object)indexSnId);
                deleteResult = deleteResult.add(indexEntry.getValue().delete());
                logger.debug("[{}] Cleaned up stale index [{}]", (Object)this.metadata.name(), (Object)indexSnId);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] index {} is no longer part of any snapshot in the repository, but failed to clean up its index folder", (Object)this.metadata.name(), (Object)indexSnId), (Throwable)e);
            }
        }
        return deleteResult;
    }

    @Override
    public void finalizeSnapshot(FinalizeSnapshotContext finalizeSnapshotContext) {
        long repositoryStateId = finalizeSnapshotContext.repositoryStateId();
        ShardGenerations shardGenerations = finalizeSnapshotContext.updatedShardGenerations();
        SnapshotInfo snapshotInfo = finalizeSnapshotContext.snapshotInfo();
        assert (repositoryStateId > -2L) : "Must finalize based on a valid repository generation but received [" + repositoryStateId + "]";
        Collection<IndexId> indices = shardGenerations.indices();
        SnapshotId snapshotId = snapshotInfo.snapshotId();
        Version repositoryMetaVersion = finalizeSnapshotContext.repositoryMetaVersion();
        boolean writeShardGens = SnapshotsService.useShardGenerations(repositoryMetaVersion);
        Consumer<Exception> onUpdateFailure = e -> finalizeSnapshotContext.onFailure(new SnapshotException(this.metadata.name(), snapshotId, "failed to update snapshot in repository", (Throwable)e));
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        boolean writeIndexGens = SnapshotsService.useIndexGenerations(repositoryMetaVersion);
        StepListener<RepositoryData> repoDataListener = new StepListener<RepositoryData>();
        this.getRepositoryData(repoDataListener);
        repoDataListener.whenComplete((CheckedConsumer<RepositoryData, Exception>)((CheckedConsumer)existingRepositoryData -> {
            ConcurrentMap indexMetas;
            ConcurrentMap indexMetaIdentifiers;
            int existingSnapshotCount = existingRepositoryData.getSnapshotIds().size();
            if (existingSnapshotCount >= this.maxSnapshotCount) {
                finalizeSnapshotContext.onFailure(new RepositoryException(this.metadata.name(), "Cannot add another snapshot to this repository as it already contains [" + existingSnapshotCount + "] snapshots and is configured to hold up to [" + this.maxSnapshotCount + "] snapshots only."));
                return;
            }
            if (writeIndexGens) {
                indexMetaIdentifiers = ConcurrentCollections.newConcurrentMap();
                indexMetas = ConcurrentCollections.newConcurrentMap();
            } else {
                indexMetas = null;
                indexMetaIdentifiers = null;
            }
            GroupedActionListener allMetaListener = new GroupedActionListener(ActionListener.wrap(v -> {
                String slmPolicy = BlobStoreRepository.slmPolicy(snapshotInfo);
                RepositoryData.SnapshotDetails snapshotDetails = new RepositoryData.SnapshotDetails(snapshotInfo.state(), Version.CURRENT, snapshotInfo.startTime(), snapshotInfo.endTime(), slmPolicy);
                this.writeIndexGen(existingRepositoryData.addSnapshot(snapshotId, snapshotDetails, shardGenerations, indexMetas, indexMetaIdentifiers), repositoryStateId, repositoryMetaVersion, finalizeSnapshotContext::updatedClusterState, ActionListener.wrap(newRepoData -> {
                    if (writeShardGens) {
                        this.cleanupOldShardGens((RepositoryData)existingRepositoryData, (RepositoryData)newRepoData, finalizeSnapshotContext);
                    }
                    finalizeSnapshotContext.onResponse((Tuple<RepositoryData, SnapshotInfo>)Tuple.tuple((Object)newRepoData, (Object)snapshotInfo));
                }, onUpdateFailure));
            }, onUpdateFailure), 2 + indices.size());
            Metadata clusterMetadata = finalizeSnapshotContext.clusterMetadata();
            executor.execute(ActionRunnable.run(allMetaListener, (CheckedRunnable<Exception>)((CheckedRunnable)() -> GLOBAL_METADATA_FORMAT.write(clusterMetadata, this.blobContainer(), snapshotId.getUUID(), this.compress))));
            for (IndexId index : indices) {
                executor.execute(ActionRunnable.run(allMetaListener, (CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                    IndexMetadata indexMetaData = clusterMetadata.index(index.getName());
                    if (writeIndexGens) {
                        String identifiers = IndexMetaDataGenerations.buildUniqueIdentifier(indexMetaData);
                        String metaUUID = existingRepositoryData.indexMetaDataGenerations().getIndexMetaBlobId(identifiers);
                        if (metaUUID == null) {
                            metaUUID = UUIDs.base64UUID();
                            INDEX_METADATA_FORMAT.write(indexMetaData, this.indexContainer(index), metaUUID, this.compress);
                            indexMetaIdentifiers.put(identifiers, metaUUID);
                        }
                        indexMetas.put(index, identifiers);
                    } else {
                        INDEX_METADATA_FORMAT.write(clusterMetadata.index(index.getName()), this.indexContainer(index), snapshotId.getUUID(), this.compress);
                    }
                })));
            }
            executor.execute(ActionRunnable.run(allMetaListener, (CheckedRunnable<Exception>)((CheckedRunnable)() -> SNAPSHOT_FORMAT.write(snapshotInfo, this.blobContainer(), snapshotId.getUUID(), this.compress))));
        }), onUpdateFailure);
    }

    private void cleanupOldShardGens(RepositoryData existingRepositoryData, RepositoryData updatedRepositoryData, FinalizeSnapshotContext finalizeSnapshotContext) {
        HashSet<CallSite> toDelete = new HashSet<CallSite>();
        int prefixPathLen = this.basePath().buildAsString().length();
        updatedRepositoryData.shardGenerations().obsoleteShardGenerations(existingRepositoryData.shardGenerations()).forEach((indexId, gens) -> gens.forEach((shardId, oldGen) -> toDelete.add((CallSite)((Object)(this.shardContainer((IndexId)indexId, (int)shardId).path().buildAsString().substring(prefixPathLen) + "index-" + oldGen)))));
        for (Map.Entry<RepositoryShardId, Set<ShardGeneration>> obsoleteEntry : finalizeSnapshotContext.obsoleteShardGenerations().entrySet()) {
            String containerPath = this.shardContainer(obsoleteEntry.getKey().index(), obsoleteEntry.getKey().shardId()).path().buildAsString().substring(prefixPathLen) + "index-";
            for (ShardGeneration shardGeneration : obsoleteEntry.getValue()) {
                toDelete.add((CallSite)((Object)(containerPath + shardGeneration)));
            }
        }
        try {
            this.deleteFromContainer(this.blobContainer(), toDelete.iterator());
        }
        catch (Exception e) {
            logger.warn("Failed to clean up old shard generation blobs", (Throwable)e);
        }
    }

    @Override
    public void getSnapshotInfo(GetSnapshotInfoContext context) {
        int workers = Math.min(this.threadPool.info("snapshot_meta").getMax(), context.snapshotIds().size());
        LinkedBlockingQueue<SnapshotId> queue = new LinkedBlockingQueue<SnapshotId>(context.snapshotIds());
        for (int i = 0; i < workers; ++i) {
            this.getOneSnapshotInfo(queue, context);
        }
    }

    private void getOneSnapshotInfo(BlockingQueue<SnapshotId> queue, GetSnapshotInfoContext context) {
        SnapshotId snapshotId = (SnapshotId)queue.poll();
        if (snapshotId == null) {
            return;
        }
        this.threadPool.executor("snapshot_meta").execute(() -> {
            if (context.done()) {
                return;
            }
            if (context.isCancelled()) {
                queue.clear();
                context.onFailure(new TaskCancelledException("task cancelled"));
                return;
            }
            Exception failure = null;
            SnapshotInfo snapshotInfo = null;
            try {
                snapshotInfo = SNAPSHOT_FORMAT.read(this.metadata.name(), this.blobContainer(), snapshotId.getUUID(), this.namedXContentRegistry);
            }
            catch (NoSuchFileException ex) {
                failure = new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
            }
            catch (IOException | NotXContentException ex) {
                failure = new SnapshotException(this.metadata.name(), snapshotId, "failed to get snapshot info" + snapshotId, ex);
            }
            catch (Exception e) {
                Exception exception = failure = e instanceof SnapshotException ? e : new SnapshotException(this.metadata.name(), snapshotId, "Snapshot could not be read", e);
            }
            if (failure != null) {
                if (context.abortOnFailure()) {
                    queue.clear();
                }
                context.onFailure(failure);
            } else {
                assert (snapshotInfo != null);
                context.onResponse(snapshotInfo);
            }
            this.getOneSnapshotInfo(queue, context);
        });
    }

    @Override
    public Metadata getSnapshotGlobalMetadata(SnapshotId snapshotId) {
        try {
            return GLOBAL_METADATA_FORMAT.read(this.metadata.name(), this.blobContainer(), snapshotId.getUUID(), this.namedXContentRegistry);
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read global metadata", ex);
        }
    }

    @Override
    public IndexMetadata getSnapshotIndexMetaData(RepositoryData repositoryData, SnapshotId snapshotId, IndexId index) throws IOException {
        try {
            return INDEX_METADATA_FORMAT.read(this.metadata.name(), this.indexContainer(index), repositoryData.indexMetaDataGenerations().indexMetaBlobId(snapshotId, index), this.namedXContentRegistry);
        }
        catch (NoSuchFileException e) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)e);
        }
    }

    private void deleteFromContainer(final BlobContainer container, final Iterator<String> blobs) throws IOException {
        Iterator<String> wrappedIterator = logger.isTraceEnabled() ? new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return blobs.hasNext();
            }

            @Override
            public String next() {
                String blobName = (String)blobs.next();
                logger.trace("[{}] Deleting [{}] from [{}]", (Object)BlobStoreRepository.this.metadata.name(), (Object)blobName, (Object)container.path());
                return blobName;
            }
        } : blobs;
        container.deleteBlobsIgnoringIfNotExists(wrappedIterator);
    }

    private BlobPath indicesPath() {
        return this.basePath().add("indices");
    }

    private BlobContainer indexContainer(IndexId indexId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()));
    }

    private BlobContainer shardContainer(IndexId indexId, ShardId shardId) {
        return this.shardContainer(indexId, shardId.getId());
    }

    public BlobContainer shardContainer(IndexId indexId, int shardId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()).add(Integer.toString(shardId)));
    }

    private static RateLimiter getRateLimiter(Settings repositorySettings, Setting<ByteSizeValue> setting) {
        ByteSizeValue maxSnapshotBytesPerSec = setting.get(repositorySettings);
        if (maxSnapshotBytesPerSec.getBytes() <= 0L) {
            return null;
        }
        return new RateLimiter.SimpleRateLimiter(maxSnapshotBytesPerSec.getMbFrac());
    }

    @Override
    public long getSnapshotThrottleTimeInNanos() {
        return this.snapshotRateLimitingTimeInNanos.count();
    }

    @Override
    public long getRestoreThrottleTimeInNanos() {
        return this.restoreRateLimitingTimeInNanos.count();
    }

    protected void assertSnapshotOrGenericThread() {
        assert (Thread.currentThread().getName().contains("[snapshot]") || Thread.currentThread().getName().contains("[snapshot_meta]") || Thread.currentThread().getName().contains("[generic]")) : "Expected current thread [" + Thread.currentThread() + "] to be the snapshot or generic thread.";
    }

    @Override
    public String startVerification() {
        try {
            if (this.isReadOnly()) {
                this.latestIndexBlobId();
                return "read-only";
            }
            String seed = UUIDs.randomBase64UUID();
            byte[] testBytes = Strings.toUTF8Bytes(seed);
            BlobContainer testContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
            testContainer.writeBlobAtomic("master.dat", new BytesArray(testBytes), true);
            return seed;
        }
        catch (Exception exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "path " + this.basePath() + " is not accessible on master node", exp);
        }
    }

    @Override
    public void endVerification(String seed) {
        if (!this.isReadOnly()) {
            try {
                String testPrefix = BlobStoreRepository.testBlobPrefix(seed);
                this.blobStore().blobContainer(this.basePath().add(testPrefix)).delete();
            }
            catch (Exception exp) {
                throw new RepositoryVerificationException(this.metadata.name(), "cannot delete test data at " + this.basePath(), exp);
            }
        }
    }

    @Override
    public void getRepositoryData(ActionListener<RepositoryData> listener) {
        assert (this.clusterService.localNode().isMasterNode()) : "should only load repository data on master nodes";
        if (!this.lifecycle.started()) {
            listener.onFailure(this.notStartedException());
            return;
        }
        if (this.latestKnownRepoGen.get() == -3L) {
            listener.onFailure(this.corruptedStateException(null, null));
            return;
        }
        RepositoryData cached = this.latestKnownRepositoryData.get();
        if (!this.bestEffortConsistency && cached.getGenId() == this.latestKnownRepoGen.get()) {
            this.repoDataDeduplicator.executeOnce(this.metadata, listener, (metadata, l) -> l.onResponse(cached));
            return;
        }
        if (this.metadata.generation() == -2L && !this.isReadOnly()) {
            logger.debug("[{}] loading repository metadata for the first time, trying to determine correct generation and to store it in the cluster state", (Object)this.metadata.name());
            this.initializeRepoGenerationTracking(listener);
        } else {
            logger.trace("[{}] loading un-cached repository data with best known repository generation [{}]", (Object)this.metadata.name(), (Object)this.latestKnownRepoGen);
            ExecutorService executor = this.threadPool.executor("snapshot_meta");
            if (this.bestEffortConsistency || !this.cacheRepositoryData) {
                executor.execute(ActionRunnable.wrap(listener, this::doGetRepositoryData));
            } else {
                this.repoDataDeduplicator.executeOnce(this.metadata, listener, (metadata, l) -> executor.execute(ActionRunnable.wrap(l, this::doGetRepositoryData)));
            }
        }
    }

    private RepositoryException notStartedException() {
        return new RepositoryException(this.metadata.name(), "repository is not in started state");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRepoGenerationTracking(ActionListener<RepositoryData> listener) {
        BlobStoreRepository blobStoreRepository = this;
        synchronized (blobStoreRepository) {
            if (this.repoDataInitialized == null) {
                if (this.metadata.generation() != -2L) {
                    this.getRepositoryData(listener);
                    return;
                }
                logger.trace("[{}] initializing repository generation in cluster state", (Object)this.metadata.name());
                this.repoDataInitialized = new ListenableActionFuture();
                this.repoDataInitialized.addListener(listener);
                Consumer<Exception> onFailure = e -> {
                    ListenableActionFuture<RepositoryData> existingListener;
                    logger.warn((Message)new ParameterizedMessage("[{}] Exception when initializing repository generation in cluster state", (Object)this.metadata.name()), (Throwable)e);
                    BlobStoreRepository blobStoreRepository = this;
                    synchronized (blobStoreRepository) {
                        existingListener = this.repoDataInitialized;
                        this.repoDataInitialized = null;
                    }
                    existingListener.onFailure((Exception)e);
                };
                this.threadPool.generic().execute(ActionRunnable.wrap(ActionListener.wrap(repoData -> this.clusterService.submitStateUpdateTask("set initial safe repository generation [" + this.metadata.name() + "][" + repoData.getGenId() + "]", new ClusterStateUpdateTask((RepositoryData)repoData, onFailure){
                    final /* synthetic */ RepositoryData val$repoData;
                    final /* synthetic */ Consumer val$onFailure;
                    {
                        this.val$repoData = repositoryData;
                        this.val$onFailure = consumer;
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        RepositoryMetadata metadata = BlobStoreRepository.this.getRepoMetadata(currentState);
                        if (metadata.generation() != -2L) {
                            throw new RepositoryException(metadata.name(), "Found unexpected initialized repo metadata [" + metadata + "]");
                        }
                        return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.getMetadata()).putCustom("repositories", ((RepositoriesMetadata)currentState.metadata().custom("repositories")).withUpdatedGeneration(metadata.name(), this.val$repoData.getGenId(), this.val$repoData.getGenId()))).build();
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        this.val$onFailure.accept(e);
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        logger.trace("[{}] initialized repository generation in cluster state to [{}]", (Object)BlobStoreRepository.this.metadata.name(), (Object)this.val$repoData.getGenId());
                        BlobStoreRepository.this.threadPool.generic().execute(() -> {
                            ListenableActionFuture<RepositoryData> existingListener;
                            BlobStoreRepository blobStoreRepository = BlobStoreRepository.this;
                            synchronized (blobStoreRepository) {
                                existingListener = BlobStoreRepository.this.repoDataInitialized;
                                BlobStoreRepository.this.repoDataInitialized = null;
                            }
                            existingListener.onResponse(this.val$repoData);
                            logger.trace("[{}] called listeners after initializing repository to generation [{}]", (Object)BlobStoreRepository.this.metadata.name(), (Object)this.val$repoData.getGenId());
                        });
                    }
                }), onFailure), this::doGetRepositoryData));
            } else {
                logger.trace("[{}] waiting for existing initialization of repository metadata generation in cluster state", (Object)this.metadata.name());
                this.repoDataInitialized.addListener(listener);
            }
        }
    }

    private void doGetRepositoryData(ActionListener<RepositoryData> listener) {
        long lastFailedGeneration = -2L;
        while (true) {
            long genToLoad;
            if (this.bestEffortConsistency) {
                long generation;
                try {
                    generation = this.latestIndexBlobId();
                }
                catch (Exception e) {
                    listener.onFailure(new RepositoryException(this.metadata.name(), "Could not determine repository generation from root blobs", e));
                    return;
                }
                genToLoad = this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, generation));
                if (genToLoad > generation) {
                    logger.info("Determined repository generation [{}] from repository contents but correct generation must be at least [{}]", (Object)generation, (Object)genToLoad);
                }
            } else {
                genToLoad = this.latestKnownRepoGen.get();
            }
            try {
                RepositoryData cached = this.latestKnownRepositoryData.get();
                if (!this.bestEffortConsistency && cached.getGenId() == genToLoad) {
                    listener.onResponse(cached);
                } else {
                    RepositoryData loaded = this.getRepositoryData(genToLoad);
                    if (cached == null || cached.getGenId() < genToLoad) {
                        this.cacheRepositoryData(loaded, Version.CURRENT);
                    }
                    if (loaded.getUuid().equals(this.metadata.uuid())) {
                        listener.onResponse(loaded);
                    } else {
                        RepositoriesService.updateRepositoryUuidInMetadata(this.clusterService, this.metadata.name(), loaded, new ThreadedActionListener<Void>(logger, this.threadPool, "generic", listener.map(v -> loaded), false));
                    }
                }
                return;
            }
            catch (RepositoryException e) {
                if (genToLoad != this.latestKnownRepoGen.get() && genToLoad != lastFailedGeneration) {
                    lastFailedGeneration = genToLoad;
                    logger.warn("Failed to load repository data generation [" + genToLoad + "] because a concurrent operation moved the current generation to [" + this.latestKnownRepoGen.get() + "]", (Throwable)e);
                    continue;
                }
                if (!this.bestEffortConsistency && ExceptionsHelper.unwrap(e, NoSuchFileException.class) != null) {
                    Tuple<Long, String> previousWriterInformation = null;
                    try {
                        previousWriterInformation = this.readLastWriterInfo();
                    }
                    catch (Exception ex) {
                        e.addSuppressed(ex);
                    }
                    Tuple<Long, String> finalLastInfo = previousWriterInformation;
                    this.markRepoCorrupted(genToLoad, e, ActionListener.wrap(v -> listener.onFailure(this.corruptedStateException(e, finalLastInfo)), listener::onFailure));
                } else {
                    listener.onFailure(e);
                }
                return;
            }
            catch (Exception e) {
                listener.onFailure(new RepositoryException(this.metadata.name(), "Unexpected exception when loading repository data", e));
                return;
            }
            break;
        }
    }

    private void cacheRepositoryData(RepositoryData repositoryData, Version version) {
        RepositoryData toCache;
        if (!this.cacheRepositoryData) {
            return;
        }
        if (SnapshotsService.useShardGenerations(version)) {
            toCache = repositoryData;
        } else {
            toCache = repositoryData.withoutShardGenerations();
            assert (repositoryData.indexMetaDataGenerations().equals(IndexMetaDataGenerations.EMPTY)) : "repository data should not contain index generations at version [" + version + "] but saw [" + repositoryData.indexMetaDataGenerations() + "]";
        }
        assert (toCache.getGenId() >= 0L) : "No need to cache abstract generations but attempted to cache [" + toCache.getGenId() + "]";
        this.latestKnownRepositoryData.updateAndGet(known -> {
            if (known.getGenId() > toCache.getGenId()) {
                return known;
            }
            return toCache;
        });
    }

    private RepositoryException corruptedStateException(@Nullable Exception cause, @Nullable Tuple<Long, String> previousWriterInfo) {
        return new RepositoryException(this.metadata.name(), "Could not read repository data because the contents of the repository do not match its expected state. This is likely the result of either concurrently modifying the contents of the repository by a process other than this cluster or an issue with the repository's underlying storage. The repository has been disabled to prevent corrupting its contents. To re-enable it and continue using it please remove the repository from the cluster and add it again to make the cluster recover the known state of the repository from its physical contents." + this.previousWriterMessage(previousWriterInfo), cause);
    }

    private String previousWriterMessage(@Nullable Tuple<Long, String> previousWriterInfo) {
        return previousWriterInfo == null ? "" : " The last cluster to write to this repository was [" + (String)previousWriterInfo.v2() + "] at generation [" + previousWriterInfo.v1() + "].";
    }

    private void markRepoCorrupted(final long corruptedGeneration, final Exception originalException, final ActionListener<Void> listener) {
        assert (corruptedGeneration != -2L);
        assert (!this.bestEffortConsistency);
        this.clusterService.submitStateUpdateTask("mark repository corrupted [" + this.metadata.name() + "][" + corruptedGeneration + "]", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RepositoriesMetadata state = (RepositoriesMetadata)currentState.metadata().custom("repositories");
                RepositoryMetadata repoState = state.repository(BlobStoreRepository.this.metadata.name());
                if (repoState.generation() != corruptedGeneration) {
                    throw new IllegalStateException("Tried to mark repo generation [" + corruptedGeneration + "] as corrupted but its state concurrently changed to [" + repoState + "]");
                }
                return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("repositories", state.withUpdatedGeneration(BlobStoreRepository.this.metadata.name(), -3L, repoState.pendingGeneration())).build()).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed marking repository state as corrupted", ExceptionsHelper.useOrSuppress(e, originalException)));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(null);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private RepositoryData getRepositoryData(long indexGen) {
        if (indexGen == -1L) {
            return RepositoryData.EMPTY;
        }
        try {
            String snapshotsIndexBlobName = "index-" + Long.toString(indexGen);
            try (InputStream blob = this.blobContainer().readBlob(snapshotsIndexBlobName);){
                RepositoryData repositoryData;
                block16: {
                    XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, blob);
                    try {
                        repositoryData = RepositoryData.snapshotsFromXContent(parser, indexGen, true);
                        if (parser == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return repositoryData;
            }
        }
        catch (IOException ioe) {
            if (this.bestEffortConsistency && this.latestKnownRepoGen.compareAndSet(indexGen, -1L)) {
                logger.warn("Resetting repository generation tracker because we failed to read generation [" + indexGen + "]", (Throwable)ioe);
            }
            throw new RepositoryException(this.metadata.name(), "could not read repository data from index blob", ioe);
        }
    }

    private static String testBlobPrefix(String seed) {
        return TESTS_FILE + seed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void writeIndexGen(RepositoryData repositoryData, final long expectedGen, final Version version, final Function<ClusterState, ClusterState> stateFilter, final ActionListener<RepositoryData> listener) {
        logger.trace("[{}] writing repository data on top of expected generation [{}]", (Object)this.metadata.name(), (Object)expectedGen);
        assert (!this.isReadOnly());
        long currentGen = repositoryData.getGenId();
        if (currentGen != expectedGen) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + expectedGen + "], actual current generation [" + currentGen + "]"));
            return;
        }
        final StepListener setPendingStep = new StepListener();
        this.clusterService.submitStateUpdateTask("set pending repository generation [" + this.metadata.name() + "][" + expectedGen + "]", new ClusterStateUpdateTask(){
            private long newGen;

            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean uninitializedMeta;
                RepositoryMetadata meta = BlobStoreRepository.this.getRepoMetadata(currentState);
                String repoName = BlobStoreRepository.this.metadata.name();
                long genInState = meta.generation();
                boolean bl = uninitializedMeta = meta.generation() == -2L || BlobStoreRepository.this.bestEffortConsistency;
                if (!uninitializedMeta && meta.pendingGeneration() != genInState) {
                    logger.info("Trying to write new repository data over unfinished write, repo [{}] is at safe generation [{}] and pending generation [{}]", (Object)meta.name(), (Object)genInState, (Object)meta.pendingGeneration());
                }
                assert (expectedGen == -1L || uninitializedMeta || expectedGen == meta.generation()) : "Expected non-empty generation [" + expectedGen + "] does not match generation tracked in [" + meta + "]";
                long safeGeneration = expectedGen == -1L ? -1L : (uninitializedMeta ? expectedGen : genInState);
                long nextPendingGen = BlobStoreRepository.this.metadata.pendingGeneration() + 1L;
                long l = this.newGen = uninitializedMeta ? Math.max(expectedGen + 1L, nextPendingGen) : nextPendingGen;
                assert (this.newGen > BlobStoreRepository.this.latestKnownRepoGen.get()) : "Attempted new generation [" + this.newGen + "] must be larger than latest known generation [" + BlobStoreRepository.this.latestKnownRepoGen.get() + "]";
                return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.getMetadata()).putCustom("repositories", ((RepositoriesMetadata)currentState.metadata().custom("repositories")).withUpdatedGeneration(repoName, safeGeneration, this.newGen)).build()).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed to execute cluster state update [" + source + "]", e));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                logger.trace("[{}] successfully set pending repository generation to [{}]", (Object)BlobStoreRepository.this.metadata.name(), (Object)this.newGen);
                setPendingStep.onResponse(this.newGen);
            }
        });
        StepListener filterRepositoryDataStep = new StepListener();
        setPendingStep.whenComplete(newGen -> this.threadPool().executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(listener, l -> {
            final List<SnapshotId> snapshotIdsWithMissingDetails = repositoryData.getSnapshotIds().stream().filter(repositoryData::hasMissingDetails).collect(Collectors.toList());
            if (!snapshotIdsWithMissingDetails.isEmpty()) {
                ConcurrentHashMap extraDetailsMap = new ConcurrentHashMap();
                this.getSnapshotInfo(new GetSnapshotInfoContext(snapshotIdsWithMissingDetails, false, () -> false, (context, snapshotInfo) -> {
                    String slmPolicy = BlobStoreRepository.slmPolicy(snapshotInfo);
                    extraDetailsMap.put(snapshotInfo.snapshotId(), new RepositoryData.SnapshotDetails(snapshotInfo.state(), snapshotInfo.version(), snapshotInfo.startTime(), snapshotInfo.endTime(), slmPolicy));
                }, ActionListener.runAfter(new ActionListener<Void>(){

                    @Override
                    public void onResponse(Void aVoid) {
                        logger.info("Successfully loaded all snapshots' detailed information for {} from snapshot metadata", (Object)AllocationService.firstListElementsToCommaDelimitedString(snapshotIdsWithMissingDetails, SnapshotId::toString, logger.isDebugEnabled()));
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn("Failure when trying to load missing details from snapshot metadata", (Throwable)e);
                    }
                }, () -> filterRepositoryDataStep.onResponse(repositoryData.withExtraDetails(extraDetailsMap)))));
            } else {
                filterRepositoryDataStep.onResponse(repositoryData);
            }
        })), listener::onFailure);
        filterRepositoryDataStep.whenComplete(filteredRepositoryData -> {
            final long newGen = (Long)setPendingStep.result();
            final RepositoryData newRepositoryData = this.updateRepositoryData((RepositoryData)filteredRepositoryData, version, newGen);
            if (this.latestKnownRepoGen.get() >= newGen) {
                throw new IllegalArgumentException("Tried writing generation [" + newGen + "] but repository is at least at generation [" + this.latestKnownRepoGen.get() + "] already");
            }
            if (!this.ensureSafeGenerationExists(expectedGen, listener::onFailure)) {
                return;
            }
            String indexBlob = "index-" + Long.toString(newGen);
            logger.debug("Repository [{}] writing new index generational blob [{}]", (Object)this.metadata.name(), (Object)indexBlob);
            this.writeAtomic(this.blobContainer(), indexBlob, (CheckedConsumer<OutputStream, IOException>)((CheckedConsumer)out -> {
                try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder((OutputStream)Streams.noCloseStream(out));){
                    newRepositoryData.snapshotsToXContent(xContentBuilder, version);
                }
            }), true);
            this.maybeWriteIndexLatest(newGen);
            this.clusterService.submitStateUpdateTask("set safe repository generation [" + this.metadata.name() + "][" + newGen + "]", new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RepositoryMetadata meta = BlobStoreRepository.this.getRepoMetadata(currentState);
                    if (meta.generation() != expectedGen) {
                        throw new IllegalStateException("Tried to update repo generation to [" + newGen + "] but saw unexpected generation in state [" + meta + "]");
                    }
                    if (meta.pendingGeneration() != newGen) {
                        throw new IllegalStateException("Tried to update from unexpected pending repo generation [" + meta.pendingGeneration() + "] after write to generation [" + newGen + "]");
                    }
                    RepositoriesMetadata currentMetadata = (RepositoriesMetadata)currentState.metadata().custom("repositories");
                    RepositoriesMetadata withGenerations = currentMetadata.withUpdatedGeneration(BlobStoreRepository.this.metadata.name(), newGen, newGen);
                    RepositoriesMetadata withUuid = meta.uuid().equals(newRepositoryData.getUuid()) ? withGenerations : withGenerations.withUuid(BlobStoreRepository.this.metadata.name(), newRepositoryData.getUuid());
                    ClusterState newClusterState = (ClusterState)stateFilter.apply(ClusterState.builder(currentState).metadata(Metadata.builder(currentState.getMetadata()).putCustom("repositories", withUuid)).build());
                    return BlobStoreRepository.this.updateRepositoryGenerationsIfNecessary(newClusterState, expectedGen, newGen);
                }

                @Override
                public void onFailure(String source, Exception e) {
                    listener.onFailure(new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed to execute cluster state update [" + source + "]", e));
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    logger.trace("[{}] successfully set safe repository generation to [{}]", (Object)BlobStoreRepository.this.metadata.name(), (Object)newGen);
                    BlobStoreRepository.this.cacheRepositoryData(newRepositoryData, version);
                    BlobStoreRepository.this.threadPool.executor(BlobStoreRepository.SNAPSHOT_CODEC).execute(ActionRunnable.supply(listener, () -> {
                        try {
                            BlobStoreRepository.this.deleteFromContainer(BlobStoreRepository.this.blobContainer(), LongStream.range(Math.max(Math.max(expectedGen - 1L, 0L), newGen - 1000L), newGen).mapToObj(gen -> "index-" + gen).iterator());
                        }
                        catch (IOException e) {
                            logger.warn(() -> new ParameterizedMessage("Failed to clean up old index blobs from before [{}]", (Object)newGen), (Throwable)e);
                        }
                        return newRepositoryData;
                    }));
                }
            });
        }, listener::onFailure);
    }

    private static String slmPolicy(SnapshotInfo snapshotInfo) {
        Object policyFound;
        String slmPolicy = snapshotInfo.userMetadata() == null ? "" : ((policyFound = snapshotInfo.userMetadata().get("policy")) instanceof String ? (String)policyFound : "");
        return slmPolicy;
    }

    private RepositoryData updateRepositoryData(RepositoryData repositoryData, Version repositoryMetaversion, long newGen) {
        if (SnapshotsService.includesUUIDs(repositoryMetaversion)) {
            String clusterUUID = this.clusterService.state().metadata().clusterUUID();
            if (!repositoryData.getClusterUUID().equals(clusterUUID)) {
                repositoryData = repositoryData.withClusterUuid(clusterUUID);
            }
        }
        return repositoryData.withGenId(newGen);
    }

    private void maybeWriteIndexLatest(long newGen) {
        if (this.supportURLRepo) {
            logger.debug("Repository [{}] updating index.latest with generation [{}]", (Object)this.metadata.name(), (Object)newGen);
            try {
                this.writeAtomic(this.blobContainer(), INDEX_LATEST_BLOB, (CheckedConsumer<OutputStream, IOException>)((CheckedConsumer)out -> out.write(Numbers.longToBytes(newGen))), false);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("Failed to write index.latest blob. If you do not intend to use this repository as the basis for a URL repository you may turn off attempting to write the index.latest blob by setting repository setting [{}] to [false]", (Object)SUPPORT_URL_REPO.getKey()), (Throwable)e);
            }
        }
    }

    private boolean ensureSafeGenerationExists(long safeGeneration, final Consumer<Exception> onFailure) throws IOException {
        logger.debug("Ensure generation [{}] that is the basis for this write exists in [{}]", (Object)safeGeneration, (Object)this.metadata.name());
        if (safeGeneration != -1L && !this.blobContainer().blobExists("index-" + safeGeneration)) {
            Tuple<Long, String> previousWriterInfo = null;
            Exception readRepoDataEx = null;
            try {
                previousWriterInfo = this.readLastWriterInfo();
            }
            catch (Exception ex) {
                readRepoDataEx = ex;
            }
            final RepositoryException exception = new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + safeGeneration + "] but it was not found in the repository." + this.previousWriterMessage(previousWriterInfo));
            if (readRepoDataEx != null) {
                exception.addSuppressed(readRepoDataEx);
            }
            this.markRepoCorrupted(safeGeneration, exception, new ActionListener<Void>(){

                @Override
                public void onResponse(Void aVoid) {
                    onFailure.accept(exception);
                }

                @Override
                public void onFailure(Exception e) {
                    onFailure.accept(e);
                }
            });
            return false;
        }
        return true;
    }

    private Tuple<Long, String> readLastWriterInfo() throws IOException {
        assert (!this.bestEffortConsistency) : "This should only be used for adding information to errors in consistent mode";
        long latestGeneration = this.latestIndexBlobId();
        RepositoryData actualRepositoryData = this.getRepositoryData(latestGeneration);
        return Tuple.tuple((Object)latestGeneration, (Object)actualRepositoryData.getClusterUUID());
    }

    private ClusterState updateRepositoryGenerationsIfNecessary(ClusterState state, long oldGen, long newGen) {
        String repoName = this.metadata.name();
        boolean changedSnapshots = false;
        ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
        SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        for (SnapshotsInProgress.Entry entry : state.custom("snapshots", SnapshotsInProgress.EMPTY).forRepo(repoName)) {
            if (entry.repositoryStateId() == oldGen) {
                snapshotEntries.add(entry.withRepoGen(newGen));
                changedSnapshots = true;
                continue;
            }
            snapshotEntries.add(entry);
        }
        SnapshotsInProgress updatedSnapshotsInProgress = changedSnapshots ? snapshotsInProgress.withUpdatedEntriesForRepo(repoName, snapshotEntries) : null;
        boolean changedDeletions = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> deletionEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        for (SnapshotDeletionsInProgress.Entry entry : state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries()) {
            if (entry.repository().equals(repoName) && entry.repositoryStateId() == oldGen) {
                deletionEntries.add(entry.withRepoGen(newGen));
                changedDeletions = true;
                continue;
            }
            deletionEntries.add(entry);
        }
        SnapshotDeletionsInProgress updatedDeletionsInProgress = changedDeletions ? SnapshotDeletionsInProgress.of(deletionEntries) : null;
        return SnapshotsService.updateWithSnapshots(state, updatedSnapshotsInProgress, updatedDeletionsInProgress);
    }

    private RepositoryMetadata getRepoMetadata(ClusterState state) {
        RepositoryMetadata repositoryMetadata = ((RepositoriesMetadata)state.getMetadata().custom("repositories")).repository(this.metadata.name());
        assert (repositoryMetadata != null || this.lifecycle.stoppedOrClosed()) : "did not find metadata for repo [" + this.metadata.name() + "] in state [" + this.lifecycleState() + "]";
        return repositoryMetadata;
    }

    long latestIndexBlobId() throws IOException {
        try {
            return this.listBlobsToGetLatestIndexId();
        }
        catch (UnsupportedOperationException e) {
            try {
                return this.readSnapshotIndexLatestBlob();
            }
            catch (NoSuchFileException nsfe) {
                return -1L;
            }
        }
    }

    long readSnapshotIndexLatestBlob() throws IOException {
        BytesReference content = Streams.readFully(Streams.limitStream(this.blobContainer().readBlob(INDEX_LATEST_BLOB), 9L));
        if (content.length() != 8) {
            throw new RepositoryException(this.metadata.name(), "exception reading blob [index.latest]: expected 8 bytes but blob was " + (String)(content.length() < 8 ? content.length() + " bytes" : "longer"));
        }
        return Numbers.bytesToLong(content.toBytesRef());
    }

    private long listBlobsToGetLatestIndexId() throws IOException {
        return this.latestGeneration(this.blobContainer().listBlobsByPrefix("index-").keySet());
    }

    private long latestGeneration(Collection<String> rootBlobs) {
        long latest = -1L;
        for (String blobName : rootBlobs) {
            if (!blobName.startsWith("index-")) continue;
            try {
                long curr = Long.parseLong(blobName.substring("index-".length()));
                latest = Math.max(latest, curr);
            }
            catch (NumberFormatException nfe) {
                logger.warn("[{}] Unknown blob in the repository: {}", (Object)this.metadata.name(), (Object)blobName);
            }
        }
        return latest;
    }

    private void writeAtomic(BlobContainer container, String blobName, CheckedConsumer<OutputStream, IOException> writer, boolean failIfAlreadyExists) throws IOException {
        logger.trace(() -> new ParameterizedMessage("[{}] Writing [{}] to {} atomically", new Object[]{this.metadata.name(), blobName, container.path()}));
        container.writeBlob(blobName, failIfAlreadyExists, true, writer);
    }

    @Override
    public void snapshotShard(SnapshotShardContext context) {
        if (this.isReadOnly()) {
            context.onFailure(new RepositoryException(this.metadata.name(), "cannot snapshot shard on a readonly repository"));
            return;
        }
        Store store = context.store();
        IndexCommit snapshotIndexCommit = context.indexCommit();
        ShardId shardId = store.shardId();
        SnapshotId snapshotId = context.snapshotId();
        IndexShardSnapshotStatus snapshotStatus = context.status();
        long startTime = this.threadPool.absoluteTimeInMillis();
        try {
            Runnable afterWriteSnapBlob;
            ShardGeneration indexGeneration;
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> indexCommitPointFiles;
            Set<Object> blobs;
            ShardGeneration generation = snapshotStatus.generation();
            logger.debug("[{}] [{}] snapshot to [{}] [{}] ...", (Object)shardId, (Object)snapshotId, (Object)this.metadata.name(), (Object)generation);
            BlobContainer shardContainer = this.shardContainer(context.indexId(), shardId);
            if (generation == null) {
                try {
                    blobs = shardContainer.listBlobsByPrefix("index-").keySet();
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "failed to list blobs", e);
                }
            } else {
                blobs = Collections.singleton("index-" + generation);
            }
            Tuple<BlobStoreIndexShardSnapshots, ShardGeneration> tuple = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, generation);
            BlobStoreIndexShardSnapshots snapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
            ShardGeneration fileListGeneration = (ShardGeneration)tuple.v2();
            if (snapshots.snapshots().stream().anyMatch(sf -> sf.snapshot().equals(snapshotId.getName()))) {
                throw new IndexShardSnapshotFailedException(shardId, "Duplicate snapshot name [" + snapshotId.getName() + "] detected, aborting");
            }
            List filesFromSegmentInfos = Optional.ofNullable(context.stateIdentifier()).map(id -> {
                for (SnapshotFiles snapshotFileSet : snapshots.snapshots()) {
                    if (!id.equals(snapshotFileSet.shardStateIdentifier())) continue;
                    return snapshotFileSet.indexFiles();
                }
                return null;
            }).orElse(null);
            int indexIncrementalFileCount = 0;
            int indexTotalNumberOfFiles = 0;
            long indexIncrementalSize = 0L;
            long indexTotalFileSize = 0L;
            LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>();
            if (filesFromSegmentInfos == null) {
                Collection fileNames;
                Store.MetadataSnapshot metadataFromStore;
                indexCommitPointFiles = new ArrayList();
                try (Object ignored = BlobStoreRepository.incrementStoreRef(store, snapshotStatus, shardId);){
                    try {
                        logger.trace("[{}] [{}] Loading store metadata using index commit [{}]", (Object)shardId, (Object)snapshotId, (Object)snapshotIndexCommit);
                        metadataFromStore = store.getMetadata(snapshotIndexCommit);
                        fileNames = snapshotIndexCommit.getFileNames();
                    }
                    catch (IOException e) {
                        throw new IndexShardSnapshotFailedException(shardId, "Failed to get store file metadata", e);
                    }
                }
                ignored = fileNames.iterator();
                while (ignored.hasNext()) {
                    String fileName = (String)ignored.next();
                    if (snapshotStatus.isAborted()) {
                        logger.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileName);
                        throw new AbortedSnapshotException();
                    }
                    logger.trace("[{}] [{}] Processing [{}]", (Object)shardId, (Object)snapshotId, (Object)fileName);
                    StoreFileMetadata md = metadataFromStore.get(fileName);
                    BlobStoreIndexShardSnapshot.FileInfo existingFileInfo = null;
                    List<BlobStoreIndexShardSnapshot.FileInfo> filesInfo = snapshots.findPhysicalIndexFiles(fileName);
                    if (filesInfo != null) {
                        for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesInfo) {
                            if (!fileInfo.isSame(md)) continue;
                            existingFileInfo = fileInfo;
                            break;
                        }
                    }
                    boolean needsWrite = !md.hashEqualsContents();
                    indexTotalFileSize += md.length();
                    ++indexTotalNumberOfFiles;
                    if (existingFileInfo == null) {
                        ++indexIncrementalFileCount;
                        indexIncrementalSize += md.length();
                        BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = new BlobStoreIndexShardSnapshot.FileInfo((needsWrite ? UPLOADED_DATA_BLOB_PREFIX : VIRTUAL_DATA_BLOB_PREFIX) + UUIDs.randomBase64UUID(), md, this.chunkSize());
                        indexCommitPointFiles.add(snapshotFileInfo);
                        if (needsWrite) {
                            filesToSnapshot.add(snapshotFileInfo);
                        }
                        assert (needsWrite || BlobStoreRepository.assertFileContentsMatchHash(snapshotStatus, snapshotFileInfo, store));
                        continue;
                    }
                    indexCommitPointFiles.add(existingFileInfo);
                }
            } else {
                for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesFromSegmentInfos) {
                    ++indexTotalNumberOfFiles;
                    indexTotalFileSize += fileInfo.length();
                }
                indexCommitPointFiles = filesFromSegmentInfos;
            }
            snapshotStatus.moveToStarted(startTime, indexIncrementalFileCount, indexTotalNumberOfFiles, indexIncrementalSize, indexTotalFileSize);
            boolean writeShardGens = SnapshotsService.useShardGenerations(context.getRepositoryMetaVersion());
            boolean writeFileInfoWriterUUID = SnapshotsService.includeFileInfoWriterUUID(context.getRepositoryMetaVersion());
            ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
            newSnapshotsList.add(new SnapshotFiles(snapshotId.getName(), indexCommitPointFiles, context.stateIdentifier()));
            for (SnapshotFiles point : snapshots) {
                newSnapshotsList.add(point);
            }
            BlobStoreIndexShardSnapshots updatedBlobStoreIndexShardSnapshots = new BlobStoreIndexShardSnapshots(newSnapshotsList);
            if (writeShardGens) {
                indexGeneration = ShardGeneration.newGeneration();
                try {
                    Map<String, String> serializationParams = Collections.singletonMap("serialize_writer_uuid", Boolean.toString(writeFileInfoWriterUUID));
                    INDEX_SHARD_SNAPSHOTS_FORMAT.write(updatedBlobStoreIndexShardSnapshots, shardContainer, indexGeneration.toBlobNamePart(), this.compress, serializationParams);
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to write shard level snapshot metadata for [" + snapshotId + "] to [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(indexGeneration.toBlobNamePart()) + "]", e);
                }
                afterWriteSnapBlob = () -> {};
            } else {
                long newGen = Long.parseLong(fileListGeneration.toBlobNamePart()) + 1L;
                indexGeneration = new ShardGeneration(newGen);
                List blobsToDelete = blobs.stream().filter(blob -> blob.startsWith("index-")).collect(Collectors.toList());
                assert (blobsToDelete.stream().mapToLong(b -> Long.parseLong(b.replaceFirst("index-", ""))).max().orElse(-1L) < Long.parseLong(indexGeneration.toString())) : "Tried to delete an index-N blob newer than the current generation [" + indexGeneration + "] when deleting index-N blobs " + blobsToDelete;
                afterWriteSnapBlob = () -> {
                    try {
                        Map<String, String> serializationParams = Collections.singletonMap("serialize_writer_uuid", Boolean.toString(writeFileInfoWriterUUID));
                        this.writeShardIndexBlobAtomic(shardContainer, newGen, updatedBlobStoreIndexShardSnapshots, serializationParams);
                    }
                    catch (IOException e) {
                        throw new IndexShardSnapshotFailedException(shardId, "Failed to finalize snapshot creation [" + snapshotId + "] with shard index [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(indexGeneration.toBlobNamePart()) + "]", e);
                    }
                    try {
                        this.deleteFromContainer(shardContainer, blobsToDelete.iterator());
                    }
                    catch (IOException e) {
                        logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to delete old index-N blobs during finalization", (Object)snapshotId, (Object)shardId), (Throwable)e);
                    }
                };
            }
            StepListener<Collection<Void>> allFilesUploadedListener = new StepListener<Collection<Void>>();
            allFilesUploadedListener.whenComplete(v -> {
                IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.moveToFinalize(snapshotIndexCommit.getGeneration());
                logger.trace("[{}] [{}] writing shard snapshot file", (Object)shardId, (Object)snapshotId);
                BlobStoreIndexShardSnapshot blobStoreIndexShardSnapshot = new BlobStoreIndexShardSnapshot(snapshotId.getName(), lastSnapshotStatus.getIndexVersion(), indexCommitPointFiles, lastSnapshotStatus.getStartTime(), this.threadPool.absoluteTimeInMillis() - lastSnapshotStatus.getStartTime(), lastSnapshotStatus.getIncrementalFileCount(), lastSnapshotStatus.getIncrementalSize());
                try {
                    String snapshotUUID = snapshotId.getUUID();
                    Map<String, String> serializationParams = Collections.singletonMap("serialize_writer_uuid", Boolean.toString(writeFileInfoWriterUUID));
                    INDEX_SHARD_SNAPSHOT_FORMAT.write(blobStoreIndexShardSnapshot, shardContainer, snapshotUUID, this.compress, serializationParams);
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to write commit point", e);
                }
                afterWriteSnapBlob.run();
                ShardSnapshotResult shardSnapshotResult = new ShardSnapshotResult(indexGeneration, ByteSizeValue.ofBytes(blobStoreIndexShardSnapshot.totalSize()), BlobStoreRepository.getSegmentInfoFileCount(blobStoreIndexShardSnapshot.indexFiles()));
                snapshotStatus.moveToDone(this.threadPool.absoluteTimeInMillis(), shardSnapshotResult);
                context.onResponse(shardSnapshotResult);
            }, context::onFailure);
            if (indexIncrementalFileCount == 0) {
                allFilesUploadedListener.onResponse(Collections.emptyList());
                return;
            }
            ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
            int workers = Math.min(this.threadPool.info(SNAPSHOT_CODEC).getMax(), indexIncrementalFileCount);
            ActionListener<Void> filesListener = BlobStoreRepository.fileQueueListener(filesToSnapshot, workers, allFilesUploadedListener);
            for (int i = 0; i < workers; ++i) {
                this.executeOneFileSnapshot(store, snapshotId, context.indexId(), snapshotStatus, filesToSnapshot, executor, filesListener);
            }
        }
        catch (Exception e) {
            context.onFailure(e);
        }
    }

    private void executeOneFileSnapshot(Store store, SnapshotId snapshotId, IndexId indexId, IndexShardSnapshotStatus snapshotStatus, BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot, Executor executor, ActionListener<Void> listener) throws InterruptedException {
        ShardId shardId = store.shardId();
        BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = filesToSnapshot.poll(0L, TimeUnit.MILLISECONDS);
        if (snapshotFileInfo == null) {
            listener.onResponse(null);
        } else {
            executor.execute(ActionRunnable.wrap(listener, l -> {
                try (Releasable ignored = BlobStoreRepository.incrementStoreRef(store, snapshotStatus, shardId);){
                    this.snapshotFile(snapshotFileInfo, indexId, shardId, snapshotId, snapshotStatus, store);
                    this.executeOneFileSnapshot(store, snapshotId, indexId, snapshotStatus, filesToSnapshot, executor, (ActionListener<Void>)l);
                }
            }));
        }
    }

    private static Releasable incrementStoreRef(Store store, IndexShardSnapshotStatus snapshotStatus, ShardId shardId) {
        if (!store.tryIncRef()) {
            if (snapshotStatus.isAborted()) {
                throw new AbortedSnapshotException();
            }
            assert (false) : "Store should not be closed concurrently unless snapshot is aborted";
            throw new IndexShardSnapshotFailedException(shardId, "Store got closed concurrently");
        }
        return store::decRef;
    }

    private static boolean assertFileContentsMatchHash(IndexShardSnapshotStatus snapshotStatus, BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store store) {
        block14: {
            if (store.tryIncRef()) {
                try (IndexInput indexInput = store.openVerifyingInput(fileInfo.physicalName(), IOContext.READONCE, fileInfo.metadata());){
                    byte[] tmp = new byte[Math.toIntExact(fileInfo.metadata().length())];
                    indexInput.readBytes(tmp, 0, tmp.length);
                    assert (fileInfo.metadata().hash().bytesEquals(new BytesRef(tmp)));
                    break block14;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                finally {
                    store.decRef();
                }
            }
            assert (snapshotStatus.isAborted()) : "if the store is already closed we must have been aborted";
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreShard(final Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        ShardId shardId = store.shardId();
        ActionListener<Void> restoreListener = listener.delegateResponse((l, e) -> l.onFailure(new IndexShardRestoreFailedException(shardId, "failed to restore snapshot [" + snapshotId + "]", (Throwable)e)));
        final ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        final BlobContainer container = this.shardContainer(indexId, snapshotShardId);
        Set<ShardId> set = this.ongoingRestores;
        synchronized (set) {
            if (store.isClosing()) {
                restoreListener.onFailure((Exception)new AlreadyClosedException("store is closing"));
                return;
            }
            if (!this.lifecycle.started()) {
                restoreListener.onFailure((Exception)new AlreadyClosedException("repository [" + this.metadata.name() + "] closed"));
                return;
            }
            boolean added = this.ongoingRestores.add(shardId);
            assert (added) : "add restore for [" + shardId + "] that already has an existing restore";
        }
        executor.execute(ActionRunnable.wrap(ActionListener.runAfter(restoreListener, () -> {
            List onEmptyListeners;
            Set<ShardId> set = this.ongoingRestores;
            synchronized (set) {
                if (!this.ongoingRestores.remove(shardId) || !this.ongoingRestores.isEmpty() || this.emptyListeners == null) {
                    return;
                }
                onEmptyListeners = this.emptyListeners;
                this.emptyListeners = null;
            }
            ActionListener.onResponse(onEmptyListeners, null);
        }), l -> {
            BlobStoreIndexShardSnapshot snapshot = this.loadShardSnapshot(container, snapshotId);
            final SnapshotFiles snapshotFiles = new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles(), null);
            new FileRestoreContext(this.metadata.name(), shardId, snapshotId, recoveryState){

                @Override
                protected void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover, Store store2, ActionListener<Void> listener) {
                    if (filesToRecover.isEmpty()) {
                        listener.onResponse(null);
                    } else {
                        int workers = Math.min(BlobStoreRepository.this.threadPool.info(BlobStoreRepository.SNAPSHOT_CODEC).getMax(), snapshotFiles.indexFiles().size());
                        LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>(filesToRecover);
                        ActionListener<Void> allFilesListener = BlobStoreRepository.fileQueueListener(files, workers, listener.map(v -> null));
                        for (int i = 0; i < workers; ++i) {
                            try {
                                this.executeOneFileRestore(files, allFilesListener);
                                continue;
                            }
                            catch (Exception e) {
                                allFilesListener.onFailure(e);
                            }
                        }
                    }
                }

                private void executeOneFileRestore(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, ActionListener<Void> allFilesListener) throws InterruptedException {
                    BlobStoreIndexShardSnapshot.FileInfo fileToRecover = files.poll(0L, TimeUnit.MILLISECONDS);
                    if (fileToRecover == null) {
                        allFilesListener.onResponse(null);
                    } else {
                        executor.execute(ActionRunnable.wrap(allFilesListener, filesListener -> {
                            store.incRef();
                            try {
                                this.restoreFile(fileToRecover, store);
                            }
                            finally {
                                store.decRef();
                            }
                            this.executeOneFileRestore(files, (ActionListener<Void>)filesListener);
                        }));
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private void restoreFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, final Store store2) throws IOException {
                    this.ensureNotClosing(store2);
                    logger.trace(() -> new ParameterizedMessage("[{}] restoring [{}] to [{}]", new Object[]{BlobStoreRepository.this.metadata.name(), fileInfo, store2}));
                    boolean success = false;
                    try {
                        try (IndexOutput indexOutput = store2.createVerifyingOutput(fileInfo.physicalName(), fileInfo.metadata(), IOContext.DEFAULT);){
                            if (fileInfo.name().startsWith(BlobStoreRepository.VIRTUAL_DATA_BLOB_PREFIX)) {
                                BytesRef hash = fileInfo.metadata().hash();
                                indexOutput.writeBytes(hash.bytes, hash.offset, hash.length);
                                this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), hash.length);
                            } else {
                                try (InputStream stream = BlobStoreRepository.this.maybeRateLimitRestores(new SlicedInputStream(fileInfo.numberOfParts()){

                                    @Override
                                    protected InputStream openSlice(int slice) throws IOException {
                                        this.ensureNotClosing(store2);
                                        return container.readBlob(fileInfo.partName(slice));
                                    }
                                });){
                                    int length;
                                    byte[] buffer = new byte[Math.toIntExact(Math.min((long)BlobStoreRepository.this.bufferSize, fileInfo.length()))];
                                    while ((length = stream.read(buffer)) > 0) {
                                        this.ensureNotClosing(store2);
                                        indexOutput.writeBytes(buffer, 0, length);
                                        this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), length);
                                    }
                                }
                            }
                            Store.verify(indexOutput);
                            indexOutput.close();
                            store2.directory().sync(Collections.singleton(fileInfo.physicalName()));
                            success = true;
                        }
                        if (success) return;
                    }
                    catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                        try {
                            try {
                                store2.markStoreCorrupted((IOException)ex);
                                throw ex;
                            }
                            catch (IOException e) {
                                logger.warn("store cannot be marked as corrupted", (Throwable)e);
                            }
                            throw ex;
                        }
                        catch (Throwable throwable) {
                            if (success) throw throwable;
                            store2.deleteQuiet(fileInfo.physicalName());
                            throw throwable;
                        }
                    }
                    store2.deleteQuiet(fileInfo.physicalName());
                    return;
                }

                void ensureNotClosing(Store store2) throws AlreadyClosedException {
                    assert (store2.refCount() > 0);
                    if (store2.isClosing()) {
                        throw new AlreadyClosedException("store is closing");
                    }
                    if (!BlobStoreRepository.this.lifecycle.started()) {
                        throw new AlreadyClosedException("repository [" + BlobStoreRepository.this.metadata.name() + "] closed");
                    }
                }
            }.restore(snapshotFiles, store, (ActionListener<Void>)l);
        }));
    }

    private static ActionListener<Void> fileQueueListener(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, int workers, ActionListener<Collection<Void>> listener) {
        return new GroupedActionListener(listener, workers).delegateResponse((l, e) -> {
            files.clear();
            l.onFailure((Exception)e);
        });
    }

    private static InputStream maybeRateLimit(InputStream stream, Supplier<RateLimiter> rateLimiterSupplier, RateLimitingInputStream.Listener throttleListener) {
        return new RateLimitingInputStream(stream, rateLimiterSupplier, throttleListener);
    }

    public InputStream maybeRateLimitRestores(InputStream stream) {
        return this.maybeRateLimitRestores(stream, this.restoreRateLimitingTimeInNanos::inc);
    }

    public InputStream maybeRateLimitRestores(InputStream stream, RateLimitingInputStream.Listener throttleListener) {
        return BlobStoreRepository.maybeRateLimit(BlobStoreRepository.maybeRateLimit(stream, () -> this.restoreRateLimiter, throttleListener), this.recoverySettings::rateLimiter, throttleListener);
    }

    public InputStream maybeRateLimitSnapshots(InputStream stream) {
        return this.maybeRateLimitSnapshots(stream, this.snapshotRateLimitingTimeInNanos::inc);
    }

    public InputStream maybeRateLimitSnapshots(InputStream stream, RateLimitingInputStream.Listener throttleListener) {
        return BlobStoreRepository.maybeRateLimit(stream, () -> this.snapshotRateLimiter, throttleListener);
    }

    @Override
    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        BlobStoreIndexShardSnapshot snapshot = this.loadShardSnapshot(this.shardContainer(indexId, shardId), snapshotId);
        return IndexShardSnapshotStatus.newDone(snapshot.startTime(), snapshot.time(), snapshot.incrementalFileCount(), snapshot.totalFileCount(), snapshot.incrementalSize(), snapshot.totalSize(), null);
    }

    @Override
    public void verify(String seed, DiscoveryNode localNode) {
        this.assertSnapshotOrGenericThread();
        if (this.isReadOnly()) {
            try {
                this.latestIndexBlobId();
            }
            catch (Exception e) {
                throw new RepositoryVerificationException(this.metadata.name(), "path " + this.basePath() + " is not accessible on node " + localNode, e);
            }
        }
        BlobContainer testBlobContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
        try {
            testBlobContainer.writeBlob("data-" + localNode.getId() + ".dat", new BytesArray(seed), true);
        }
        catch (Exception exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "store location [" + this.blobStore() + "] is not accessible on the node [" + localNode + "]", exp);
        }
        try (InputStream masterDat = testBlobContainer.readBlob("master.dat");){
            String seedRead = Streams.readFully(masterDat).utf8ToString();
            if (!seedRead.equals(seed)) {
                throw new RepositoryVerificationException(this.metadata.name(), "Seed read from master.dat was [" + seedRead + "] but expected seed [" + seed + "]");
            }
        }
        catch (NoSuchFileException e) {
            throw new RepositoryVerificationException(this.metadata.name(), "a file written by master to the store [" + this.blobStore() + "] cannot be accessed on the node [" + localNode + "]. This might indicate that the store [" + this.blobStore() + "] is not shared between this node and the master node or that permissions on the store don't allow reading files written by the master node", e);
        }
        catch (Exception e) {
            throw new RepositoryVerificationException(this.metadata.name(), "Failed to verify repository", e);
        }
    }

    public String toString() {
        return "BlobStoreRepository[[" + this.metadata.name() + "], [" + this.blobStore.get() + "]]";
    }

    private ShardSnapshotMetaDeleteResult deleteFromShardSnapshotMeta(Set<SnapshotId> survivingSnapshots, IndexId indexId, int snapshotShardId, Collection<SnapshotId> snapshotIds, BlobContainer shardContainer, Set<String> blobs, BlobStoreIndexShardSnapshots snapshots, long indexGeneration) {
        ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
        Set survivingSnapshotNames = survivingSnapshots.stream().map(SnapshotId::getName).collect(Collectors.toSet());
        for (SnapshotFiles point : snapshots) {
            if (!survivingSnapshotNames.contains(point.snapshot())) continue;
            newSnapshotsList.add(point);
        }
        ShardGeneration writtenGeneration = null;
        try {
            if (newSnapshotsList.isEmpty()) {
                return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId, ShardGenerations.DELETED_SHARD_GEN, blobs);
            }
            BlobStoreIndexShardSnapshots updatedSnapshots = new BlobStoreIndexShardSnapshots(newSnapshotsList);
            if (indexGeneration < 0L) {
                writtenGeneration = ShardGeneration.newGeneration();
                INDEX_SHARD_SNAPSHOTS_FORMAT.write(updatedSnapshots, shardContainer, writtenGeneration.toBlobNamePart(), this.compress);
            } else {
                writtenGeneration = new ShardGeneration(indexGeneration);
                this.writeShardIndexBlobAtomic(shardContainer, indexGeneration, updatedSnapshots, Collections.emptyMap());
            }
            Set<String> survivingSnapshotUUIDs = survivingSnapshots.stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
            return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId, writtenGeneration, BlobStoreRepository.unusedBlobs(blobs, survivingSnapshotUUIDs, updatedSnapshots));
        }
        catch (IOException e) {
            throw new RepositoryException(this.metadata.name(), "Failed to finalize snapshot deletion " + snapshotIds + " with shard index [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(writtenGeneration.toBlobNamePart()) + "]", e);
        }
    }

    private void writeShardIndexBlobAtomic(BlobContainer shardContainer, long indexGeneration, BlobStoreIndexShardSnapshots updatedSnapshots, Map<String, String> serializationParams) throws IOException {
        assert (indexGeneration >= 0L) : "Shard generation must not be negative but saw [" + indexGeneration + "]";
        logger.trace(() -> new ParameterizedMessage("[{}] Writing shard index [{}] to [{}]", new Object[]{this.metadata.name(), indexGeneration, shardContainer.path()}));
        String blobName = INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(String.valueOf(indexGeneration));
        this.writeAtomic(shardContainer, blobName, (CheckedConsumer<OutputStream, IOException>)((CheckedConsumer)out -> INDEX_SHARD_SNAPSHOTS_FORMAT.serialize(updatedSnapshots, blobName, this.compress, serializationParams, (OutputStream)out)), true);
    }

    private static List<String> unusedBlobs(Set<String> blobs, Set<String> survivingSnapshotUUIDs, BlobStoreIndexShardSnapshots updatedSnapshots) {
        return blobs.stream().filter(blob -> blob.startsWith("index-") || blob.startsWith(SNAPSHOT_PREFIX) && blob.endsWith(".dat") && !survivingSnapshotUUIDs.contains(blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length())) || blob.startsWith(UPLOADED_DATA_BLOB_PREFIX) && updatedSnapshots.findNameFile(BlobStoreIndexShardSnapshot.FileInfo.canonicalName(blob)) == null || FsBlobContainer.isTempBlobName(blob)).collect(Collectors.toList());
    }

    public BlobStoreIndexShardSnapshot loadShardSnapshot(BlobContainer shardContainer, SnapshotId snapshotId) {
        try {
            return INDEX_SHARD_SNAPSHOT_FORMAT.read(this.metadata.name(), shardContainer, snapshotId.getUUID(), this.namedXContentRegistry);
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read shard snapshot file for [" + shardContainer.path() + "]", ex);
        }
    }

    public BlobStoreIndexShardSnapshots getBlobStoreIndexShardSnapshots(IndexId indexId, int shardId, @Nullable ShardGeneration shardGen) throws IOException {
        BlobContainer shardContainer = this.shardContainer(indexId, shardId);
        Set<String> blobs = Collections.emptySet();
        if (shardGen == null) {
            blobs = shardContainer.listBlobsByPrefix("index-").keySet();
        }
        return (BlobStoreIndexShardSnapshots)this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, shardGen).v1();
    }

    private Tuple<BlobStoreIndexShardSnapshots, ShardGeneration> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer, @Nullable ShardGeneration generation) throws IOException {
        if (generation != null) {
            if (generation.equals(ShardGenerations.NEW_SHARD_GEN)) {
                return new Tuple((Object)BlobStoreIndexShardSnapshots.EMPTY, (Object)ShardGenerations.NEW_SHARD_GEN);
            }
            return new Tuple((Object)INDEX_SHARD_SNAPSHOTS_FORMAT.read(this.metadata.name(), shardContainer, generation.toBlobNamePart(), this.namedXContentRegistry), (Object)generation);
        }
        Tuple<BlobStoreIndexShardSnapshots, Long> legacyIndex = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
        return new Tuple((Object)((BlobStoreIndexShardSnapshots)legacyIndex.v1()), (Object)new ShardGeneration((Long)legacyIndex.v2()));
    }

    private Tuple<BlobStoreIndexShardSnapshots, Long> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer) throws IOException {
        long latest = this.latestGeneration(blobs);
        if (latest >= 0L) {
            BlobStoreIndexShardSnapshots shardSnapshots = INDEX_SHARD_SNAPSHOTS_FORMAT.read(this.metadata.name(), shardContainer, Long.toString(latest), this.namedXContentRegistry);
            return new Tuple((Object)shardSnapshots, (Object)latest);
        }
        if (blobs.stream().anyMatch(b -> b.startsWith(SNAPSHOT_PREFIX) || b.startsWith("index-") || b.startsWith(UPLOADED_DATA_BLOB_PREFIX))) {
            logger.warn("Could not find a readable index-N file in a non-empty shard snapshot directory [" + shardContainer.path() + "]");
        }
        return new Tuple((Object)BlobStoreIndexShardSnapshots.EMPTY, (Object)latest);
    }

    private void snapshotFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, IndexId indexId, final ShardId shardId, final SnapshotId snapshotId, final IndexShardSnapshotStatus snapshotStatus, Store store) throws IOException {
        BlobContainer shardContainer = this.shardContainer(indexId, shardId);
        String file = fileInfo.physicalName();
        try (IndexInput indexInput = store.openVerifyingInput(file, IOContext.READONCE, fileInfo.metadata());){
            for (int i = 0; i < fileInfo.numberOfParts(); ++i) {
                long partBytes = fileInfo.partBytes(i);
                FilterInputStream inputStream = new FilterInputStream(this.maybeRateLimitSnapshots(new InputStreamIndexInput(indexInput, partBytes))){

                    @Override
                    public int read() throws IOException {
                        this.checkAborted();
                        return super.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        this.checkAborted();
                        return super.read(b, off, len);
                    }

                    private void checkAborted() {
                        if (snapshotStatus.isAborted()) {
                            logger.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileInfo.physicalName());
                            throw new AbortedSnapshotException();
                        }
                    }
                };
                String partName = fileInfo.partName(i);
                logger.trace(() -> new ParameterizedMessage("[{}] Writing [{}] to [{}]", new Object[]{this.metadata.name(), partName, shardContainer.path()}));
                shardContainer.writeBlob(partName, inputStream, partBytes, false);
            }
            Store.verify(indexInput);
            snapshotStatus.addProcessedFile(fileInfo.length());
        }
        catch (Exception t) {
            BlobStoreRepository.failStoreIfCorrupted(store, t);
            snapshotStatus.addProcessedFile(0L);
            throw t;
        }
    }

    private static void failStoreIfCorrupted(Store store, Exception e) {
        if (Lucene.isCorruptionException(e)) {
            try {
                store.markStoreCorrupted((IOException)e);
            }
            catch (IOException inner) {
                inner.addSuppressed(e);
                logger.warn("store cannot be marked as corrupted", (Throwable)inner);
            }
        }
    }

    public boolean supportURLRepo() {
        return this.supportURLRepo;
    }

    public boolean hasAtomicOverwrites() {
        return true;
    }

    public int getReadBufferSizeInBytes() {
        return this.bufferSize;
    }

    private static final class ShardSnapshotMetaDeleteResult {
        private final IndexId indexId;
        private final int shardId;
        private final ShardGeneration newGeneration;
        private final Collection<String> blobsToDelete;

        ShardSnapshotMetaDeleteResult(IndexId indexId, int shardId, ShardGeneration newGeneration, Collection<String> blobsToDelete) {
            this.indexId = indexId;
            this.shardId = shardId;
            this.newGeneration = newGeneration;
            this.blobsToDelete = blobsToDelete;
        }
    }
}

