/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.SnapshotId;

public final class IndexMetaDataGenerations {
    public static final IndexMetaDataGenerations EMPTY = new IndexMetaDataGenerations(Collections.emptyMap(), Collections.emptyMap());
    final Map<SnapshotId, Map<IndexId, String>> lookup;
    final Map<String, String> identifiers;

    IndexMetaDataGenerations(Map<SnapshotId, Map<IndexId, String>> lookup, Map<String, String> identifiers) {
        assert (identifiers.keySet().equals(lookup.values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet()))) : "identifier mappings " + identifiers + " don't track the same blob ids as the lookup map " + lookup;
        assert (lookup.values().stream().noneMatch(Map::isEmpty)) : "Lookup contained empty map [" + lookup + "]";
        this.lookup = Map.copyOf(lookup);
        this.identifiers = Map.copyOf(identifiers);
    }

    public boolean isEmpty() {
        return this.identifiers.isEmpty();
    }

    @Nullable
    public String getIndexMetaBlobId(String metaIdentifier) {
        return this.identifiers.get(metaIdentifier);
    }

    public String indexMetaBlobId(SnapshotId snapshotId, IndexId indexId) {
        String identifier = this.snapshotIndexMetadataIdentifier(snapshotId, indexId);
        if (identifier == null) {
            return snapshotId.getUUID();
        }
        return this.identifiers.get(identifier);
    }

    @Nullable
    public String snapshotIndexMetadataIdentifier(SnapshotId snapshotId, IndexId indexId) {
        return (String)this.lookup.getOrDefault(snapshotId, Collections.emptyMap()).get(indexId);
    }

    public IndexMetaDataGenerations withAddedSnapshot(SnapshotId snapshotId, Map<IndexId, String> newLookup, Map<String, String> newIdentifiers) {
        HashMap<SnapshotId, Map<IndexId, String>> updatedIndexMetaLookup = new HashMap<SnapshotId, Map<IndexId, String>>(this.lookup);
        HashMap<String, String> updatedIndexMetaIdentifiers = new HashMap<String, String>(this.identifiers);
        updatedIndexMetaIdentifiers.putAll(newIdentifiers);
        if (!newLookup.isEmpty()) {
            HashMap<String, String> identifierDeduplicator = new HashMap<String, String>(this.identifiers.size());
            for (String string : this.identifiers.keySet()) {
                identifierDeduplicator.put(string, string);
            }
            HashMap<IndexId, String> fixedLookup = new HashMap<IndexId, String>(newLookup.size());
            for (Map.Entry<IndexId, String> entry : newLookup.entrySet()) {
                String generation = entry.getValue();
                fixedLookup.put(entry.getKey(), identifierDeduplicator.getOrDefault(generation, generation));
            }
            Map map = updatedIndexMetaLookup.put(snapshotId, Map.copyOf(fixedLookup));
            assert (map == null) : "unexpected existing index generation mappings " + map;
        }
        return new IndexMetaDataGenerations(updatedIndexMetaLookup, updatedIndexMetaIdentifiers);
    }

    public IndexMetaDataGenerations withRemovedSnapshots(Collection<SnapshotId> snapshotIds) {
        HashMap<SnapshotId, Map<IndexId, String>> updatedIndexMetaLookup = new HashMap<SnapshotId, Map<IndexId, String>>(this.lookup);
        updatedIndexMetaLookup.keySet().removeAll(snapshotIds);
        HashMap<String, String> updatedIndexMetaIdentifiers = new HashMap<String, String>(this.identifiers);
        updatedIndexMetaIdentifiers.keySet().removeIf(k -> updatedIndexMetaLookup.values().stream().noneMatch(identifiers -> identifiers.containsValue(k)));
        return new IndexMetaDataGenerations(updatedIndexMetaLookup, updatedIndexMetaIdentifiers);
    }

    public int hashCode() {
        return Objects.hash(this.identifiers, this.lookup);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof IndexMetaDataGenerations)) {
            return false;
        }
        IndexMetaDataGenerations other = (IndexMetaDataGenerations)that;
        return this.lookup.equals(other.lookup) && this.identifiers.equals(other.identifiers);
    }

    public String toString() {
        return "IndexMetaDataGenerations{lookup:" + this.lookup + "}{identifier:" + this.identifiers + "}";
    }

    public static String buildUniqueIdentifier(IndexMetadata indexMetaData) {
        return indexMetaData.getIndexUUID() + "-" + indexMetaData.getSettings().get("index.history.uuid", "_na_") + "-" + indexMetaData.getSettingsVersion() + "-" + indexMetaData.getMappingVersion() + "-" + indexMetaData.getAliasesVersion();
    }
}

