/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.search.uhighlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.PriorityQueue;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.uhighlight.FieldHighlighter;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.PassageScorer;
import org.apache.lucene.util.BytesRef;

class CustomFieldHighlighter
extends FieldHighlighter {
    private static final Passage[] EMPTY_PASSAGE = new Passage[0];
    private final Locale breakIteratorLocale;
    private final int noMatchSize;
    private String fieldValue;

    CustomFieldHighlighter(String field, FieldOffsetStrategy fieldOffsetStrategy, Locale breakIteratorLocale, BreakIterator breakIterator, PassageScorer passageScorer, int maxPassages, int maxNoHighlightPassages, PassageFormatter passageFormatter, int noMatchSize) {
        super(field, fieldOffsetStrategy, breakIterator, passageScorer, maxPassages, maxNoHighlightPassages, passageFormatter);
        this.breakIteratorLocale = breakIteratorLocale;
        this.noMatchSize = noMatchSize;
    }

    FieldOffsetStrategy getFieldOffsetStrategy() {
        return this.fieldOffsetStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object highlightFieldForDoc(LeafReader reader, int docId, String content) throws IOException {
        this.fieldValue = content;
        try {
            Object object = super.highlightFieldForDoc(reader, docId, content);
            return object;
        }
        finally {
            this.fieldValue = null;
        }
    }

    protected Passage[] getSummaryPassagesNoHighlight(int maxPassages) {
        if (this.noMatchSize > 0) {
            int pos;
            for (pos = 0; pos < this.fieldValue.length() && this.fieldValue.charAt(pos) == '\u0000'; ++pos) {
            }
            if (pos < this.fieldValue.length()) {
                int end = this.fieldValue.indexOf(0, pos);
                if (end == -1) {
                    end = this.fieldValue.length();
                }
                if (this.noMatchSize + pos < end) {
                    BreakIterator bi = BreakIterator.getWordInstance(this.breakIteratorLocale);
                    bi.setText(this.fieldValue);
                    end = bi.following(this.noMatchSize + pos);
                    if (end == -1) {
                        end = this.fieldValue.length();
                    }
                }
                Passage passage = new Passage();
                passage.setScore(Float.NaN);
                passage.setStartOffset(pos);
                passage.setEndOffset(end);
                return new Passage[]{passage};
            }
        }
        return EMPTY_PASSAGE;
    }

    protected Passage[] highlightOffsetsEnums(OffsetsEnum off) throws IOException {
        int contentLength = this.breakIterator.getText().getEndIndex();
        if (!off.nextPosition()) {
            return new Passage[0];
        }
        PriorityQueue<Passage> passageQueue = new PriorityQueue<Passage>(Math.min(64, this.maxPassages + 1), (left, right) -> {
            if (left.getScore() < right.getScore()) {
                return -1;
            }
            if (left.getScore() > right.getScore()) {
                return 1;
            }
            return left.getStartOffset() - right.getStartOffset();
        });
        Passage passage = new Passage();
        do {
            int start;
            if ((start = off.startOffset()) == -1) {
                throw new IllegalArgumentException("field '" + this.field + "' was indexed without offsets, cannot highlight");
            }
            int end = off.endOffset();
            if (start < contentLength && end > contentLength) continue;
            if (start >= passage.getEndOffset()) {
                passage = this.maybeAddPassage(passageQueue, this.passageScorer, passage, contentLength);
                if (start >= contentLength) break;
                passage.setStartOffset(Math.max(this.breakIterator.preceding(start + 1), 0));
                passage.setEndOffset(Math.min(this.breakIterator.following(start), contentLength));
            }
            BytesRef term = off.getTerm();
            assert (term != null);
            passage.addMatch(start, end, term, off.freq());
        } while (off.nextPosition());
        this.maybeAddPassage(passageQueue, this.passageScorer, passage, contentLength);
        Passage[] passages = passageQueue.toArray(new Passage[passageQueue.size()]);
        Arrays.sort(passages, Comparator.comparingInt(Passage::getStartOffset));
        return passages;
    }

    private Passage maybeAddPassage(PriorityQueue<Passage> passageQueue, PassageScorer scorer, Passage passage, int contentLength) {
        if (passage.getStartOffset() == -1) {
            return passage;
        }
        passage.setScore(scorer.score(passage, contentLength));
        if (passageQueue.size() == this.maxPassages && passage.getScore() < passageQueue.peek().getScore()) {
            passage.reset();
        } else {
            passageQueue.offer(passage);
            if (passageQueue.size() > this.maxPassages) {
                passage = passageQueue.poll();
                passage.reset();
            } else {
                passage = new Passage();
            }
        }
        return passage;
    }
}

