/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.ConditionalProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.IngestInfo;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.IngestMetric;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.ingest.PipelineProcessor;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.ProcessorInfo;
import org.elasticsearch.ingest.WrappingProcessor;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class IngestService
implements ClusterStateApplier,
ReportingService<IngestInfo> {
    public static final String NOOP_PIPELINE_NAME = "_none";
    public static final String INGEST_ORIGIN = "ingest";
    private static final Logger logger = LogManager.getLogger(IngestService.class);
    private static final IndexNameExpressionResolver.DateMathExpressionResolver DATE_MATH_EXPRESSION_RESOLVER = new IndexNameExpressionResolver.DateMathExpressionResolver();
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final Map<String, Processor.Factory> processorFactories;
    private volatile Map<String, PipelineHolder> pipelines = Map.of();
    private final ThreadPool threadPool;
    private final IngestMetric totalMetrics = new IngestMetric();
    private final List<Consumer<ClusterState>> ingestClusterStateListeners = new CopyOnWriteArrayList<Consumer<ClusterState>>();
    private volatile ClusterState state;

    public IngestService(ClusterService clusterService, ThreadPool threadPool, Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, List<IngestPlugin> ingestPlugins, Client client) {
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.processorFactories = IngestService.processorFactories(ingestPlugins, new Processor.Parameters(env, scriptService, analysisRegistry, threadPool.getThreadContext(), threadPool::relativeTimeInMillis, (delay, command) -> threadPool.schedule((Runnable)command, TimeValue.timeValueMillis((long)delay), "generic"), this, client, threadPool.generic()::execute));
        this.threadPool = threadPool;
    }

    private static Map<String, Processor.Factory> processorFactories(List<IngestPlugin> ingestPlugins, Processor.Parameters parameters) {
        HashMap<String, Processor.Factory> processorFactories = new HashMap<String, Processor.Factory>();
        for (IngestPlugin ingestPlugin : ingestPlugins) {
            Map<String, Processor.Factory> newProcessors = ingestPlugin.getProcessors(parameters);
            for (Map.Entry<String, Processor.Factory> entry : newProcessors.entrySet()) {
                if (processorFactories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Ingest processor [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(processorFactories);
    }

    public static boolean resolvePipelines(DocWriteRequest<?> originalRequest, IndexRequest indexRequest, Metadata metadata) {
        return IngestService.resolvePipelines(originalRequest, indexRequest, metadata, System.currentTimeMillis());
    }

    public static boolean resolvePipelines(DocWriteRequest<?> originalRequest, IndexRequest indexRequest, Metadata metadata, long epochMillis) {
        if (!indexRequest.isPipelineResolved()) {
            IndexAbstraction indexAbstraction;
            String requestPipeline = indexRequest.getPipeline();
            indexRequest.setPipeline(NOOP_PIPELINE_NAME);
            indexRequest.setFinalPipeline(NOOP_PIPELINE_NAME);
            String defaultPipeline = null;
            String finalPipeline = null;
            IndexMetadata indexMetadata = null;
            if (originalRequest != null) {
                indexMetadata = metadata.indices().get(IngestService.resolveIndexName(originalRequest.index(), epochMillis));
            }
            if (indexMetadata == null && indexRequest.index() != null && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexRequest.index())) != null && indexAbstraction.getWriteIndex() != null) {
                indexMetadata = metadata.index(indexAbstraction.getWriteIndex());
            }
            if (indexMetadata == null && originalRequest != null && originalRequest.index() != null && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(originalRequest.index())) != null && indexAbstraction.getWriteIndex() != null) {
                indexMetadata = metadata.index(indexAbstraction.getWriteIndex());
            }
            if (indexMetadata != null) {
                Settings indexSettings = indexMetadata.getSettings();
                if (IndexSettings.DEFAULT_PIPELINE.exists(indexSettings)) {
                    defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(indexSettings);
                    indexRequest.setPipeline(defaultPipeline);
                }
                if (IndexSettings.FINAL_PIPELINE.exists(indexSettings)) {
                    finalPipeline = IndexSettings.FINAL_PIPELINE.get(indexSettings);
                    indexRequest.setFinalPipeline(finalPipeline);
                }
            } else if (indexRequest.index() != null) {
                String v2Template = MetadataIndexTemplateService.findV2Template(metadata, indexRequest.index(), false);
                if (v2Template != null) {
                    Settings settings = MetadataIndexTemplateService.resolveSettings(metadata, v2Template);
                    if (IndexSettings.DEFAULT_PIPELINE.exists(settings)) {
                        defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(settings);
                    }
                    if (IndexSettings.FINAL_PIPELINE.exists(settings)) {
                        finalPipeline = IndexSettings.FINAL_PIPELINE.get(settings);
                    }
                    indexRequest.setPipeline(Objects.requireNonNullElse(defaultPipeline, NOOP_PIPELINE_NAME));
                    indexRequest.setFinalPipeline(Objects.requireNonNullElse(finalPipeline, NOOP_PIPELINE_NAME));
                } else {
                    List<IndexTemplateMetadata> templates = MetadataIndexTemplateService.findV1Templates(metadata, indexRequest.index(), null);
                    for (IndexTemplateMetadata template : templates) {
                        Settings settings = template.settings();
                        if (defaultPipeline == null && IndexSettings.DEFAULT_PIPELINE.exists(settings)) {
                            defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(settings);
                        }
                        if (finalPipeline == null && IndexSettings.FINAL_PIPELINE.exists(settings)) {
                            finalPipeline = IndexSettings.FINAL_PIPELINE.get(settings);
                        }
                        if (defaultPipeline == null || finalPipeline == null) continue;
                        break;
                    }
                    indexRequest.setPipeline(Objects.requireNonNullElse(defaultPipeline, NOOP_PIPELINE_NAME));
                    indexRequest.setFinalPipeline(Objects.requireNonNullElse(finalPipeline, NOOP_PIPELINE_NAME));
                }
            }
            if (requestPipeline != null) {
                indexRequest.setPipeline(requestPipeline);
            }
            indexRequest.isPipelineResolved(true);
        }
        return !NOOP_PIPELINE_NAME.equals(indexRequest.getPipeline()) || !NOOP_PIPELINE_NAME.equals(indexRequest.getFinalPipeline());
    }

    private static String resolveIndexName(String unresolvedIndexName, long epochMillis) {
        List<String> resolvedNames = DATE_MATH_EXPRESSION_RESOLVER.resolve(new IndexNameExpressionResolver.ResolverContext(epochMillis), List.of(unresolvedIndexName));
        assert (resolvedNames.size() == 1);
        return resolvedNames.get(0);
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void delete(final DeletePipelineRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("delete-pipeline-" + request.getId(), new AckedClusterStateUpdateTask(request, listener){

            @Override
            public ClusterState execute(ClusterState currentState) {
                return IngestService.innerDelete(request, currentState);
            }
        });
    }

    static ClusterState innerDelete(DeletePipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metadata().custom(INGEST_ORIGIN);
        if (currentIngestMetadata == null) {
            return currentState;
        }
        Map<String, PipelineConfiguration> pipelines = currentIngestMetadata.getPipelines();
        HashSet<String> toRemove = new HashSet<String>();
        for (String pipelineKey : pipelines.keySet()) {
            if (!Regex.simpleMatch(request.getId(), pipelineKey)) continue;
            toRemove.add(pipelineKey);
        }
        if (toRemove.isEmpty() && !Regex.isMatchAllPattern(request.getId())) {
            throw new ResourceNotFoundException("pipeline [{}] is missing", request.getId());
        }
        if (toRemove.isEmpty()) {
            return currentState;
        }
        HashMap<String, PipelineConfiguration> pipelinesCopy = new HashMap<String, PipelineConfiguration>(pipelines);
        ImmutableOpenMap<String, IndexMetadata> indices = currentState.metadata().indices();
        for (String key : toRemove) {
            IngestService.validateNotInUse(key, indices);
            pipelinesCopy.remove(key);
        }
        ClusterState.Builder newState = ClusterState.builder(currentState);
        newState.metadata(Metadata.builder(currentState.getMetadata()).putCustom(INGEST_ORIGIN, new IngestMetadata(pipelinesCopy)).build());
        return newState.build();
    }

    static void validateNotInUse(String pipeline, ImmutableOpenMap<String, IndexMetadata> indices) {
        ArrayList<String> defaultPipelineIndices = new ArrayList<String>();
        ArrayList<String> finalPipelineIndices = new ArrayList<String>();
        for (IndexMetadata indexMetadata : indices.values()) {
            String defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(indexMetadata.getSettings());
            String finalPipeline = IndexSettings.FINAL_PIPELINE.get(indexMetadata.getSettings());
            if (pipeline.equals(defaultPipeline)) {
                defaultPipelineIndices.add(indexMetadata.getIndex().getName());
            }
            if (!pipeline.equals(finalPipeline)) continue;
            finalPipelineIndices.add(indexMetadata.getIndex().getName());
        }
        if (defaultPipelineIndices.size() > 0 || finalPipelineIndices.size() > 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "pipeline [%s] cannot be deleted because it is %s%s%s", pipeline, defaultPipelineIndices.size() > 0 ? String.format(Locale.ROOT, "the default pipeline for %s index(es) including [%s]", defaultPipelineIndices.size(), defaultPipelineIndices.stream().sorted().limit(3L).collect(Collectors.joining(","))) : "", defaultPipelineIndices.size() > 0 && finalPipelineIndices.size() > 0 ? " and " : "", finalPipelineIndices.size() > 0 ? String.format(Locale.ROOT, "the final pipeline for %s index(es) including [%s]", finalPipelineIndices.size(), finalPipelineIndices.stream().sorted().limit(3L).collect(Collectors.joining(","))) : ""));
        }
    }

    public static List<PipelineConfiguration> getPipelines(ClusterState clusterState, String ... ids) {
        IngestMetadata ingestMetadata = (IngestMetadata)clusterState.getMetadata().custom(INGEST_ORIGIN);
        return IngestService.innerGetPipelines(ingestMetadata, ids);
    }

    static List<PipelineConfiguration> innerGetPipelines(IngestMetadata ingestMetadata, String ... ids) {
        if (ingestMetadata == null) {
            return Collections.emptyList();
        }
        if (ids.length == 0) {
            return new ArrayList<PipelineConfiguration>(ingestMetadata.getPipelines().values());
        }
        ArrayList<PipelineConfiguration> result = new ArrayList<PipelineConfiguration>(ids.length);
        for (String id : ids) {
            if (Regex.isSimpleMatchPattern(id)) {
                for (Map.Entry<String, PipelineConfiguration> entry : ingestMetadata.getPipelines().entrySet()) {
                    if (!Regex.simpleMatch(id, entry.getKey())) continue;
                    result.add(entry.getValue());
                }
                continue;
            }
            PipelineConfiguration pipeline = ingestMetadata.getPipelines().get(id);
            if (pipeline == null) continue;
            result.add(pipeline);
        }
        return result;
    }

    public void putPipeline(final PutPipelineRequest request, ActionListener<AcknowledgedResponse> listener, Consumer<ActionListener<NodesInfoResponse>> nodeInfoListener) throws Exception {
        Map pipelineConfig = null;
        IngestMetadata currentIngestMetadata = (IngestMetadata)this.state.metadata().custom(INGEST_ORIGIN);
        if (request.getVersion() == null && currentIngestMetadata != null && currentIngestMetadata.getPipelines().containsKey(request.getId())) {
            pipelineConfig = (Map)XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2();
            PipelineConfiguration currentPipeline = currentIngestMetadata.getPipelines().get(request.getId());
            if (currentPipeline.getConfigAsMap().equals(pipelineConfig)) {
                listener.onResponse(AcknowledgedResponse.TRUE);
                return;
            }
        }
        Map config = pipelineConfig == null ? (Map)XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2() : pipelineConfig;
        nodeInfoListener.accept(ActionListener.wrap(nodeInfos -> {
            HashMap<DiscoveryNode, IngestInfo> ingestInfos = new HashMap<DiscoveryNode, IngestInfo>();
            for (NodeInfo nodeInfo : nodeInfos.getNodes()) {
                ingestInfos.put(nodeInfo.getNode(), nodeInfo.getInfo(IngestInfo.class));
            }
            this.validatePipeline(ingestInfos, request.getId(), config);
            this.clusterService.submitStateUpdateTask("put-pipeline-" + request.getId(), new AckedClusterStateUpdateTask(request, listener){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return IngestService.innerPut(request, currentState);
                }
            });
        }, listener::onFailure));
    }

    public Pipeline getPipeline(String id) {
        PipelineHolder holder = this.pipelines.get(id);
        if (holder != null) {
            return holder.pipeline;
        }
        return null;
    }

    public Map<String, Processor.Factory> getProcessorFactories() {
        return this.processorFactories;
    }

    @Override
    public IngestInfo info() {
        Map<String, Processor.Factory> processorFactories = this.getProcessorFactories();
        ArrayList<ProcessorInfo> processorInfoList = new ArrayList<ProcessorInfo>(processorFactories.size());
        for (Map.Entry<String, Processor.Factory> entry : processorFactories.entrySet()) {
            processorInfoList.add(new ProcessorInfo(entry.getKey()));
        }
        return new IngestInfo(processorInfoList);
    }

    Map<String, PipelineHolder> pipelines() {
        return this.pipelines;
    }

    private static List<Tuple<Processor, IngestMetric>> getProcessorMetrics(CompoundProcessor compoundProcessor, List<Tuple<Processor, IngestMetric>> processorMetrics) {
        for (Tuple<Processor, IngestMetric> processorWithMetric : compoundProcessor.getProcessorsWithMetrics()) {
            Processor processor = (Processor)processorWithMetric.v1();
            IngestMetric metric = (IngestMetric)processorWithMetric.v2();
            if (processor instanceof CompoundProcessor) {
                CompoundProcessor cp = (CompoundProcessor)processor;
                IngestService.getProcessorMetrics(cp, processorMetrics);
                continue;
            }
            if (processor instanceof ConditionalProcessor) {
                ConditionalProcessor cp = (ConditionalProcessor)processor;
                metric = cp.getMetric();
            }
            processorMetrics.add((Tuple<Processor, IngestMetric>)new Tuple((Object)processor, (Object)metric));
        }
        return processorMetrics;
    }

    static ClusterState innerPut(PutPipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metadata().custom(INGEST_ORIGIN);
        BytesReference pipelineSource = request.getSource();
        if (request.getVersion() != null) {
            PipelineConfiguration currentPipeline;
            PipelineConfiguration pipelineConfiguration = currentPipeline = currentIngestMetadata != null ? currentIngestMetadata.getPipelines().get(request.getId()) : null;
            if (currentPipeline == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "version conflict, required version [%s] for pipeline [%s] but no pipeline was found", request.getVersion(), request.getId()));
            }
            Integer currentVersion = currentPipeline.getVersion();
            if (!Objects.equals(request.getVersion(), currentVersion)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "version conflict, required version [%s] for pipeline [%s] but current version is [%s]", request.getVersion(), request.getId(), currentVersion));
            }
            Map pipelineConfig = (Map)XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2();
            Integer specifiedVersion = (Integer)pipelineConfig.get("version");
            if (pipelineConfig.containsKey("version") && Objects.equals(specifiedVersion, currentVersion)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot update pipeline [%s] with the same version [%s]", request.getId(), request.getVersion()));
            }
            if (specifiedVersion == null) {
                pipelineConfig.put("version", request.getVersion() == null ? 1 : request.getVersion() + 1);
                try {
                    XContentBuilder builder = XContentBuilder.builder((XContent)request.getXContentType().xContent()).map(pipelineConfig);
                    pipelineSource = BytesReference.bytes(builder);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        HashMap<String, PipelineConfiguration> pipelines = currentIngestMetadata != null ? new HashMap<String, PipelineConfiguration>(currentIngestMetadata.getPipelines()) : new HashMap<String, PipelineConfiguration>();
        pipelines.put(request.getId(), new PipelineConfiguration(request.getId(), pipelineSource, request.getXContentType()));
        ClusterState.Builder newState = ClusterState.builder(currentState);
        newState.metadata(Metadata.builder(currentState.getMetadata()).putCustom(INGEST_ORIGIN, new IngestMetadata(pipelines)).build());
        return newState.build();
    }

    void validatePipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, String pipelineId, Map<String, Object> pipelineConfig) throws Exception {
        if (ingestInfos.isEmpty()) {
            throw new IllegalStateException("Ingest info is empty");
        }
        Pipeline pipeline = Pipeline.create(pipelineId, pipelineConfig, this.processorFactories, this.scriptService);
        ArrayList<ElasticsearchException> exceptions = new ArrayList<ElasticsearchException>();
        for (Processor processor : pipeline.flattenAllProcessors()) {
            for (Map.Entry<DiscoveryNode, IngestInfo> entry : ingestInfos.entrySet()) {
                String type = processor.getType();
                if (entry.getValue().containsProcessor(type) || "conditional".equals(type)) continue;
                String message = "Processor type [" + processor.getType() + "] is not installed on node [" + entry.getKey() + "]";
                exceptions.add(ConfigurationUtils.newConfigurationException(processor.getType(), processor.getTag(), null, message));
            }
        }
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }

    public void executeBulkRequest(final int numberOfActionRequests, final Iterable<DocWriteRequest<?>> actionRequests, final BiConsumer<Integer, Exception> onFailure, final BiConsumer<Thread, Exception> onCompletion, final IntConsumer onDropped, String executorName) {
        this.threadPool.executor(executorName).execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                onCompletion.accept(null, e);
            }

            @Override
            protected void doRun() {
                Thread originalThread = Thread.currentThread();
                AtomicInteger counter = new AtomicInteger(numberOfActionRequests);
                int i = 0;
                for (DocWriteRequest actionRequest : actionRequests) {
                    List<String> pipelines;
                    IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(actionRequest);
                    if (indexRequest == null) {
                        if (counter.decrementAndGet() == 0) {
                            onCompletion.accept(originalThread, null);
                        }
                        assert (counter.get() >= 0);
                        ++i;
                        continue;
                    }
                    String pipelineId = indexRequest.getPipeline();
                    indexRequest.setPipeline(IngestService.NOOP_PIPELINE_NAME);
                    String finalPipelineId = indexRequest.getFinalPipeline();
                    indexRequest.setFinalPipeline(IngestService.NOOP_PIPELINE_NAME);
                    boolean hasFinalPipeline = true;
                    if (!IngestService.NOOP_PIPELINE_NAME.equals(pipelineId) && !IngestService.NOOP_PIPELINE_NAME.equals(finalPipelineId)) {
                        pipelines = List.of(pipelineId, finalPipelineId);
                    } else if (!IngestService.NOOP_PIPELINE_NAME.equals(pipelineId)) {
                        pipelines = List.of(pipelineId);
                        hasFinalPipeline = false;
                    } else if (!IngestService.NOOP_PIPELINE_NAME.equals(finalPipelineId)) {
                        pipelines = List.of(finalPipelineId);
                    } else {
                        if (counter.decrementAndGet() == 0) {
                            onCompletion.accept(originalThread, null);
                        }
                        assert (counter.get() >= 0);
                        ++i;
                        continue;
                    }
                    IngestService.this.executePipelines(i, pipelines.iterator(), hasFinalPipeline, indexRequest, onDropped, onFailure, counter, onCompletion, originalThread);
                    ++i;
                }
            }
        });
    }

    private void executePipelines(int slot, Iterator<String> it, boolean hasFinalPipeline, IndexRequest indexRequest, IntConsumer onDropped, BiConsumer<Integer, Exception> onFailure, AtomicInteger counter, BiConsumer<Thread, Exception> onCompletion, Thread originalThread) {
        block5: {
            assert (it.hasNext());
            String pipelineId = it.next();
            try {
                PipelineHolder holder = this.pipelines.get(pipelineId);
                if (holder == null) {
                    throw new IllegalArgumentException("pipeline with id [" + pipelineId + "] does not exist");
                }
                Pipeline pipeline = holder.pipeline;
                String originalIndex = indexRequest.indices()[0];
                this.innerExecute(slot, indexRequest, pipeline, onDropped, e -> {
                    if (e != null) {
                        logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}]", new Object[]{pipelineId, indexRequest.index(), indexRequest.id()}), (Throwable)e);
                        onFailure.accept(slot, (Exception)e);
                    }
                    Iterator<Object> newIt = it;
                    boolean newHasFinalPipeline = hasFinalPipeline;
                    String newIndex = indexRequest.indices()[0];
                    if (!Objects.equals(originalIndex, newIndex)) {
                        if (hasFinalPipeline && !it.hasNext()) {
                            this.totalMetrics.ingestFailed();
                            onFailure.accept(slot, new IllegalStateException("final pipeline [" + pipelineId + "] can't change the target index"));
                        } else {
                            indexRequest.isPipelineResolved(false);
                            IngestService.resolvePipelines(null, indexRequest, this.state.metadata());
                            if (!NOOP_PIPELINE_NAME.equals(indexRequest.getFinalPipeline())) {
                                newIt = Collections.singleton(indexRequest.getFinalPipeline()).iterator();
                                newHasFinalPipeline = true;
                            } else {
                                newIt = Collections.emptyIterator();
                            }
                        }
                    }
                    if (newIt.hasNext()) {
                        this.executePipelines(slot, (Iterator<String>)newIt, newHasFinalPipeline, indexRequest, onDropped, onFailure, counter, onCompletion, originalThread);
                    } else {
                        if (counter.decrementAndGet() == 0) {
                            onCompletion.accept(originalThread, null);
                        }
                        assert (counter.get() >= 0);
                    }
                });
            }
            catch (Exception e2) {
                logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}]", new Object[]{pipelineId, indexRequest.index(), indexRequest.id()}), (Throwable)e2);
                onFailure.accept(slot, e2);
                if (counter.decrementAndGet() == 0) {
                    onCompletion.accept(originalThread, null);
                }
                if ($assertionsDisabled || counter.get() >= 0) break block5;
                throw new AssertionError();
            }
        }
    }

    public IngestStats stats() {
        IngestStats.Builder statsBuilder = new IngestStats.Builder();
        statsBuilder.addTotalMetrics(this.totalMetrics);
        this.pipelines.forEach((id, holder) -> {
            Pipeline pipeline = holder.pipeline;
            CompoundProcessor rootProcessor = pipeline.getCompoundProcessor();
            statsBuilder.addPipelineMetrics((String)id, pipeline.getMetrics());
            ArrayList<Tuple<Processor, IngestMetric>> processorMetrics = new ArrayList<Tuple<Processor, IngestMetric>>();
            IngestService.getProcessorMetrics(rootProcessor, processorMetrics);
            processorMetrics.forEach(t -> {
                Processor processor = (Processor)t.v1();
                IngestMetric processorMetric = (IngestMetric)t.v2();
                statsBuilder.addProcessorMetrics((String)id, IngestService.getProcessorName(processor), processor.getType(), processorMetric);
            });
        });
        return statsBuilder.build();
    }

    public void addIngestClusterStateListener(Consumer<ClusterState> listener) {
        this.ingestClusterStateListeners.add(listener);
    }

    static String getProcessorName(Processor processor) {
        String tag;
        if (processor instanceof ConditionalProcessor) {
            ConditionalProcessor conditionalProcessor = (ConditionalProcessor)processor;
            processor = conditionalProcessor.getInnerProcessor();
        }
        StringBuilder sb = new StringBuilder(5);
        sb.append(processor.getType());
        if (processor instanceof PipelineProcessor) {
            PipelineProcessor pipelineProcessor = (PipelineProcessor)processor;
            String pipelineName = pipelineProcessor.getPipelineTemplate().newInstance(Map.of()).execute();
            sb.append(":");
            sb.append(pipelineName);
        }
        if ((tag = processor.getTag()) != null && !tag.isEmpty()) {
            sb.append(":");
            sb.append(tag);
        }
        return sb.toString();
    }

    private void innerExecute(int slot, IndexRequest indexRequest, Pipeline pipeline, IntConsumer itemDroppedHandler, Consumer<Exception> handler) {
        if (pipeline.getProcessors().isEmpty()) {
            handler.accept(null);
            return;
        }
        long startTimeInNanos = System.nanoTime();
        this.totalMetrics.preIngest();
        String index = indexRequest.index();
        String id = indexRequest.id();
        String routing = indexRequest.routing();
        Long version = indexRequest.version();
        VersionType versionType = indexRequest.versionType();
        Map<String, Object> sourceAsMap = indexRequest.sourceAsMap();
        IngestDocument ingestDocument = new IngestDocument(index, id, routing, version, versionType, sourceAsMap);
        ingestDocument.executePipeline(pipeline, (result, e) -> {
            long ingestTimeInNanos = System.nanoTime() - startTimeInNanos;
            this.totalMetrics.postIngest(ingestTimeInNanos);
            if (e != null) {
                this.totalMetrics.ingestFailed();
                handler.accept((Exception)e);
            } else if (result == null) {
                itemDroppedHandler.accept(slot);
                handler.accept(null);
            } else {
                Map<IngestDocument.Metadata, Object> metadataMap = ingestDocument.extractMetadata();
                String newIndex = (String)metadataMap.get((Object)IngestDocument.Metadata.INDEX);
                indexRequest.index(newIndex);
                indexRequest.id((String)metadataMap.get((Object)IngestDocument.Metadata.ID));
                indexRequest.routing((String)metadataMap.get((Object)IngestDocument.Metadata.ROUTING));
                indexRequest.version(((Number)metadataMap.get((Object)IngestDocument.Metadata.VERSION)).longValue());
                if (metadataMap.get((Object)IngestDocument.Metadata.VERSION_TYPE) != null) {
                    indexRequest.versionType(VersionType.fromString((String)metadataMap.get((Object)IngestDocument.Metadata.VERSION_TYPE)));
                }
                if (metadataMap.get((Object)IngestDocument.Metadata.IF_SEQ_NO) != null) {
                    indexRequest.setIfSeqNo(((Number)metadataMap.get((Object)IngestDocument.Metadata.IF_SEQ_NO)).longValue());
                }
                if (metadataMap.get((Object)IngestDocument.Metadata.IF_PRIMARY_TERM) != null) {
                    indexRequest.setIfPrimaryTerm(((Number)metadataMap.get((Object)IngestDocument.Metadata.IF_PRIMARY_TERM)).longValue());
                }
                indexRequest.source(ingestDocument.getSourceAndMetadata(), indexRequest.getContentType());
                if (metadataMap.get((Object)IngestDocument.Metadata.DYNAMIC_TEMPLATES) != null) {
                    HashMap<String, String> mergedDynamicTemplates = new HashMap<String, String>(indexRequest.getDynamicTemplates());
                    Map map = (Map)metadataMap.get((Object)IngestDocument.Metadata.DYNAMIC_TEMPLATES);
                    mergedDynamicTemplates.putAll(map);
                    indexRequest.setDynamicTemplates(mergedDynamicTemplates);
                }
                handler.accept(null);
            }
        });
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.state = event.state();
        if (this.state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        this.ingestClusterStateListeners.forEach(consumer -> consumer.accept(this.state));
        IngestMetadata newIngestMetadata = (IngestMetadata)this.state.getMetadata().custom(INGEST_ORIGIN);
        if (newIngestMetadata == null) {
            return;
        }
        try {
            this.innerUpdatePipelines(newIngestMetadata);
        }
        catch (ElasticsearchParseException e) {
            logger.warn("failed to update ingest pipelines", (Throwable)e);
        }
    }

    synchronized void innerUpdatePipelines(IngestMetadata newIngestMetadata) {
        Map<String, PipelineHolder> existingPipelines = this.pipelines;
        HashMap<String, PipelineHolder> newPipelines = null;
        ArrayList<ElasticsearchParseException> exceptions = null;
        for (PipelineConfiguration pipelineConfiguration : newIngestMetadata.getPipelines().values()) {
            PipelineHolder previous = existingPipelines.get(pipelineConfiguration.getId());
            if (previous != null && previous.configuration.equals(pipelineConfiguration)) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            try {
                Pipeline newPipeline = Pipeline.create(pipelineConfiguration.getId(), pipelineConfiguration.getConfigAsMap(), this.processorFactories, this.scriptService);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, newPipeline));
                if (previous == null) continue;
                Pipeline oldPipeline = previous.pipeline;
                newPipeline.getMetrics().add(oldPipeline.getMetrics());
                ArrayList<Tuple<Processor, IngestMetric>> oldPerProcessMetrics = new ArrayList<Tuple<Processor, IngestMetric>>();
                ArrayList<Tuple<Processor, IngestMetric>> newPerProcessMetrics = new ArrayList<Tuple<Processor, IngestMetric>>();
                IngestService.getProcessorMetrics(oldPipeline.getCompoundProcessor(), oldPerProcessMetrics);
                IngestService.getProcessorMetrics(newPipeline.getCompoundProcessor(), newPerProcessMetrics);
                if (newPerProcessMetrics.size() != oldPerProcessMetrics.size()) continue;
                Iterator oldMetricsIterator = oldPerProcessMetrics.iterator();
                for (Tuple tuple : newPerProcessMetrics) {
                    String type = ((Processor)tuple.v1()).getType();
                    IngestMetric metric = (IngestMetric)tuple.v2();
                    if (!oldMetricsIterator.hasNext()) continue;
                    Tuple oldCompositeMetric = (Tuple)oldMetricsIterator.next();
                    String oldType = ((Processor)oldCompositeMetric.v1()).getType();
                    IngestMetric oldMetric = (IngestMetric)oldCompositeMetric.v2();
                    if (!type.equals(oldType)) continue;
                    metric.add(oldMetric);
                }
            }
            catch (ElasticsearchParseException e) {
                Pipeline pipeline = IngestService.substitutePipeline(pipelineConfiguration.getId(), e);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, pipeline));
                if (exceptions == null) {
                    exceptions = new ArrayList<ElasticsearchParseException>();
                }
                exceptions.add(e);
            }
            catch (Exception e) {
                ElasticsearchParseException parseException = new ElasticsearchParseException("Error updating pipeline with id [" + pipelineConfiguration.getId() + "]", (Throwable)e, new Object[0]);
                Pipeline pipeline = IngestService.substitutePipeline(pipelineConfiguration.getId(), parseException);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, pipeline));
                if (exceptions == null) {
                    exceptions = new ArrayList();
                }
                exceptions.add(parseException);
            }
        }
        for (Map.Entry entry : existingPipelines.entrySet()) {
            if (newIngestMetadata.getPipelines().get(entry.getKey()) != null) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            newPipelines.remove(entry.getKey());
        }
        if (newPipelines != null) {
            this.pipelines = Map.copyOf(newPipelines);
            if (exceptions != null) {
                ExceptionsHelper.rethrowAndSuppress(exceptions);
            }
        }
    }

    public <P extends Processor> List<P> getProcessorsInPipeline(String pipelineId, Class<P> clazz) {
        Pipeline pipeline = this.getPipeline(pipelineId);
        if (pipeline == null) {
            throw new IllegalArgumentException("pipeline with id [" + pipelineId + "] does not exist");
        }
        ArrayList<Processor> processors = new ArrayList<Processor>();
        block0: for (Processor processor : pipeline.flattenAllProcessors()) {
            if (clazz.isAssignableFrom(processor.getClass())) {
                processors.add((Processor)clazz.cast(processor));
            }
            while (processor instanceof WrappingProcessor) {
                WrappingProcessor wrappingProcessor = (WrappingProcessor)processor;
                if (clazz.isAssignableFrom(wrappingProcessor.getInnerProcessor().getClass())) {
                    processors.add((Processor)clazz.cast(wrappingProcessor.getInnerProcessor()));
                }
                if (wrappingProcessor != (processor = wrappingProcessor.getInnerProcessor())) continue;
                continue block0;
            }
        }
        return processors;
    }

    public <P extends Processor> Collection<String> getPipelineWithProcessorType(Class<P> clazz, Predicate<P> predicate) {
        LinkedList<String> matchedPipelines = new LinkedList<String>();
        for (PipelineHolder holder : this.pipelines.values()) {
            String pipelineId = holder.pipeline.getId();
            List<P> processors = this.getProcessorsInPipeline(pipelineId, clazz);
            if (processors.isEmpty() || !processors.stream().anyMatch(predicate)) continue;
            matchedPipelines.add(pipelineId);
        }
        return matchedPipelines;
    }

    public synchronized void reloadPipeline(String id) throws Exception {
        PipelineHolder holder = this.pipelines.get(id);
        Pipeline updatedPipeline = Pipeline.create(id, holder.configuration.getConfigAsMap(), this.processorFactories, this.scriptService);
        HashMap<String, PipelineHolder> updatedPipelines = new HashMap<String, PipelineHolder>(this.pipelines);
        updatedPipelines.put(id, new PipelineHolder(holder.configuration, updatedPipeline));
        this.pipelines = Map.copyOf(updatedPipelines);
    }

    private static Pipeline substitutePipeline(String id, ElasticsearchParseException e) {
        String tag = e.getHeaderKeys().contains("processor_tag") ? e.getHeader("processor_tag").get(0) : null;
        final String type = e.getHeaderKeys().contains("processor_type") ? e.getHeader("processor_type").get(0) : "unknown";
        final String errorMessage = "pipeline with id [" + id + "] could not be loaded, caused by [" + e.getDetailedMessage() + "]";
        AbstractProcessor failureProcessor = new AbstractProcessor(tag, "this is a placeholder processor"){

            @Override
            public IngestDocument execute(IngestDocument ingestDocument) {
                throw new IllegalStateException(errorMessage);
            }

            @Override
            public String getType() {
                return type;
            }
        };
        String description = "this is a place holder pipeline, because pipeline with id [" + id + "] could not be loaded";
        return new Pipeline(id, description, null, null, new CompoundProcessor(failureProcessor));
    }

    static class PipelineHolder {
        final PipelineConfiguration configuration;
        final Pipeline pipeline;

        PipelineHolder(PipelineConfiguration configuration, Pipeline pipeline) {
            this.configuration = Objects.requireNonNull(configuration);
            this.pipeline = Objects.requireNonNull(pipeline);
        }
    }
}

