/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.indices.ExecutorNames;
import org.elasticsearch.indices.IndexPatternMatcher;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;

public class SystemIndexDescriptor
implements IndexPatternMatcher,
Comparable<SystemIndexDescriptor> {
    public static final Settings DEFAULT_SETTINGS = Settings.builder().put("index.hidden", true).build();
    private final String indexPattern;
    private final String primaryIndex;
    private final String description;
    private final CharacterRunAutomaton indexPatternAutomaton;
    private final String mappings;
    private final Settings settings;
    private final String aliasName;
    private final int indexFormat;
    private final String versionMetaKey;
    private final String origin;
    private final Version minimumNodeVersion;
    private final Version mappingVersion;
    private final boolean hasDynamicMappings;
    private final Type type;
    private final List<String> allowedElasticProductOrigins;
    private final List<SystemIndexDescriptor> priorSystemIndexDescriptors;
    private final boolean isNetNew;
    private final ExecutorNames executorNames;

    public SystemIndexDescriptor(String indexPattern, String description) {
        this(indexPattern, null, description, null, null, null, 0, null, null, Version.CURRENT.minimumCompatibilityVersion(), Type.INTERNAL_UNMANAGED, List.of(), List.of(), null, false);
    }

    public SystemIndexDescriptor(String indexPattern, String description, Type type, List<String> allowedElasticProductOrigins) {
        this(indexPattern, null, description, null, null, null, 0, null, null, Version.CURRENT.minimumCompatibilityVersion(), type, allowedElasticProductOrigins, List.of(), null, false);
    }

    SystemIndexDescriptor(String indexPattern, String primaryIndex, String description, String mappings, Settings settings, String aliasName, int indexFormat, String versionMetaKey, String origin, Version minimumNodeVersion, Type type, List<String> allowedElasticProductOrigins, List<SystemIndexDescriptor> priorSystemIndexDescriptors, ExecutorNames executorNames, boolean isNetNew) {
        List<SystemIndexDescriptor> sortedPriorSystemIndexDescriptors;
        Objects.requireNonNull(indexPattern, "system index pattern must not be null");
        if (indexPattern.length() < 2) {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must at least 2 characters in length");
        }
        if (indexPattern.charAt(0) != '.') {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must start with the character [.]");
        }
        if (indexPattern.charAt(1) == '*') {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must not start with the character sequence [.*] to prevent conflicts");
        }
        if (primaryIndex != null) {
            if (primaryIndex.charAt(0) != '.') {
                throw new IllegalArgumentException("system primary index provided as [" + primaryIndex + "] but must start with the character [.]");
            }
            if (!primaryIndex.matches("^\\.[\\w-]+$")) {
                throw new IllegalArgumentException("system primary index provided as [" + primaryIndex + "] but cannot contain special characters or patterns");
            }
        }
        if (indexFormat < 0) {
            throw new IllegalArgumentException("Index format cannot be negative");
        }
        Strings.requireNonEmpty(indexPattern, "indexPattern must be supplied");
        Objects.requireNonNull(type, "type must not be null");
        if (type.isManaged()) {
            Objects.requireNonNull(settings, "Must supply settings for a managed system index");
            Strings.requireNonEmpty(mappings, "Must supply mappings for a managed system index");
            Strings.requireNonEmpty(primaryIndex, "Must supply primaryIndex for a managed system index");
            Strings.requireNonEmpty(versionMetaKey, "Must supply versionMetaKey for a managed system index");
            Strings.requireNonEmpty(origin, "Must supply origin for a managed system index");
            this.mappingVersion = SystemIndexDescriptor.extractVersionFromMappings(mappings, versionMetaKey);
        } else {
            this.mappingVersion = null;
        }
        Objects.requireNonNull(allowedElasticProductOrigins, "allowedProductOrigins must not be null");
        if (type.isInternal() && !allowedElasticProductOrigins.isEmpty()) {
            throw new IllegalArgumentException("Allowed origins are not valid for internal system indices");
        }
        if (type.isExternal() && allowedElasticProductOrigins.isEmpty()) {
            throw new IllegalArgumentException("External system indices without allowed products is not a valid combination");
        }
        Objects.requireNonNull(minimumNodeVersion, "minimumNodeVersion must be provided!");
        Objects.requireNonNull(priorSystemIndexDescriptors, "priorSystemIndexDescriptors must not be null");
        if (!priorSystemIndexDescriptors.isEmpty()) {
            HashSet<Version> versions = new HashSet<Version>(priorSystemIndexDescriptors.size() + 1);
            versions.add(minimumNodeVersion);
            for (SystemIndexDescriptor prior : priorSystemIndexDescriptors) {
                if (!versions.add(prior.minimumNodeVersion)) {
                    throw new IllegalArgumentException(prior + " has the same minimum node version as another descriptor");
                }
                if (prior.minimumNodeVersion.after(minimumNodeVersion)) {
                    throw new IllegalArgumentException(prior + " has minimum node version [" + prior.minimumNodeVersion + "] which is after [" + minimumNodeVersion + "]");
                }
                if (!prior.priorSystemIndexDescriptors.isEmpty()) {
                    throw new IllegalArgumentException(prior + " has its own prior descriptors but only a depth of 1 is allowed");
                }
                if (!prior.indexPattern.equals(indexPattern)) {
                    throw new IllegalArgumentException("index pattern must be the same");
                }
                if (!prior.primaryIndex.equals(primaryIndex)) {
                    throw new IllegalArgumentException("primary index must be the same");
                }
                if (prior.aliasName.equals(aliasName)) continue;
                throw new IllegalArgumentException("alias name must be the same");
            }
        }
        if (Objects.nonNull(executorNames)) {
            if (!ThreadPool.THREAD_POOL_TYPES.containsKey(executorNames.threadPoolForGet())) {
                throw new IllegalArgumentException(executorNames.threadPoolForGet() + " is not a valid thread pool");
            }
            if (!ThreadPool.THREAD_POOL_TYPES.containsKey(executorNames.threadPoolForSearch())) {
                throw new IllegalArgumentException(executorNames.threadPoolForGet() + " is not a valid thread pool");
            }
            if (!ThreadPool.THREAD_POOL_TYPES.containsKey(executorNames.threadPoolForWrite())) {
                throw new IllegalArgumentException(executorNames.threadPoolForGet() + " is not a valid thread pool");
            }
        }
        this.indexPattern = indexPattern;
        this.primaryIndex = primaryIndex;
        this.aliasName = aliasName;
        Automaton automaton = SystemIndexDescriptor.buildAutomaton(indexPattern, aliasName);
        this.indexPatternAutomaton = new CharacterRunAutomaton(automaton);
        if (primaryIndex != null && !this.indexPatternAutomaton.run(primaryIndex)) {
            throw new IllegalArgumentException("primary index does not match the index pattern!");
        }
        this.description = description;
        this.mappings = mappings;
        Settings settings2 = settings = Objects.isNull(settings) ? Settings.EMPTY : settings;
        if (!settings.hasValue("index.hidden")) {
            settings = Settings.builder().put(settings).put(DEFAULT_SETTINGS).build();
        }
        if (!settings.getAsBoolean("index.hidden", false).booleanValue()) {
            throw new IllegalArgumentException("System indices must have index.hidden set to true.");
        }
        this.settings = settings;
        this.indexFormat = indexFormat;
        this.versionMetaKey = versionMetaKey;
        this.origin = origin;
        this.minimumNodeVersion = minimumNodeVersion;
        this.type = type;
        this.allowedElasticProductOrigins = allowedElasticProductOrigins;
        boolean bl = this.hasDynamicMappings = this.mappings != null && SystemIndexDescriptor.findDynamicMapping(XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, mappings, false));
        if (priorSystemIndexDescriptors.isEmpty() || priorSystemIndexDescriptors.size() == 1) {
            sortedPriorSystemIndexDescriptors = List.copyOf(priorSystemIndexDescriptors);
        } else {
            ArrayList<SystemIndexDescriptor> copy = new ArrayList<SystemIndexDescriptor>(priorSystemIndexDescriptors);
            Collections.sort(copy);
            sortedPriorSystemIndexDescriptors = List.copyOf(copy);
        }
        this.priorSystemIndexDescriptors = sortedPriorSystemIndexDescriptors;
        this.executorNames = Objects.nonNull(executorNames) ? executorNames : ExecutorNames.DEFAULT_SYSTEM_INDEX_THREAD_POOLS;
        this.isNetNew = isNetNew;
    }

    @Override
    public String getIndexPattern() {
        return this.indexPattern;
    }

    public String getPrimaryIndex() {
        return this.primaryIndex;
    }

    public boolean matchesIndexPattern(String index) {
        return this.indexPatternAutomaton.run(index);
    }

    @Override
    public List<String> getMatchingIndices(Metadata metadata) {
        return metadata.indices().keySet().stream().filter(this::matchesIndexPattern).collect(Collectors.toUnmodifiableList());
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "SystemIndexDescriptor[pattern=[" + this.indexPattern + "], description=[" + this.description + "], aliasName=[" + this.aliasName + "]]";
    }

    public String getMappings() {
        return this.mappings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public int getIndexFormat() {
        return this.indexFormat;
    }

    public String getVersionMetaKey() {
        return this.versionMetaKey;
    }

    public Version getMinimumNodeVersion() {
        return this.minimumNodeVersion;
    }

    public boolean isAutomaticallyManaged() {
        return this.type.isManaged();
    }

    public String getOrigin() {
        return this.origin;
    }

    public boolean hasDynamicMappings() {
        return this.hasDynamicMappings;
    }

    public boolean isExternal() {
        return this.type.isExternal();
    }

    public boolean isInternal() {
        return this.type.isInternal();
    }

    public List<String> getAllowedElasticProductOrigins() {
        return this.allowedElasticProductOrigins;
    }

    public boolean isNetNew() {
        return this.isNetNew;
    }

    public Version getMappingVersion() {
        if (!this.type.isManaged()) {
            throw new IllegalStateException(this + " is not managed so there are no mappings or version");
        }
        return this.mappingVersion;
    }

    public String getMinimumNodeVersionMessage(String cause) {
        Objects.requireNonNull(cause);
        Version actualMinimumVersion = this.priorSystemIndexDescriptors.isEmpty() ? this.minimumNodeVersion : this.priorSystemIndexDescriptors.get((int)(this.priorSystemIndexDescriptors.size() - 1)).minimumNodeVersion;
        return String.format(Locale.ROOT, "[%s] failed - system index [%s] requires all data and master nodes to be at least version [%s]", cause, this.getPrimaryIndex(), actualMinimumVersion);
    }

    public SystemIndexDescriptor getDescriptorCompatibleWith(Version version) {
        if (this.minimumNodeVersion.onOrBefore(version)) {
            return this;
        }
        for (SystemIndexDescriptor prior : this.priorSystemIndexDescriptors) {
            if (!version.onOrAfter(prior.minimumNodeVersion)) continue;
            return prior;
        }
        return null;
    }

    public ExecutorNames getThreadPoolNames() {
        return this.executorNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int compareTo(SystemIndexDescriptor other) {
        return this.minimumNodeVersion.compareTo(other.minimumNodeVersion) * -1;
    }

    static Automaton buildAutomaton(String pattern, String alias) {
        String patternAsRegex = SystemIndexDescriptor.patternToRegex(pattern);
        String aliasAsRegex = alias == null ? null : SystemIndexDescriptor.patternToRegex(alias);
        Automaton patternAutomaton = new RegExp(patternAsRegex).toAutomaton();
        if (aliasAsRegex == null) {
            return patternAutomaton;
        }
        Automaton aliasAutomaton = new RegExp(aliasAsRegex).toAutomaton();
        return Operations.union((Automaton)patternAutomaton, (Automaton)aliasAutomaton);
    }

    private static String patternToRegex(String input) {
        String output = input;
        output = output.replaceAll("\\.", "\\\\.");
        output = output.replaceAll("\\*", ".*");
        return output;
    }

    static boolean findDynamicMapping(Map<String, Object> map) {
        if (map == null) {
            return false;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.equals("dynamic") && value instanceof Boolean && ((Boolean)value).booleanValue()) {
                return true;
            }
            if (!(value instanceof Map) || !SystemIndexDescriptor.findDynamicMapping((Map)value)) continue;
            return true;
        }
        return false;
    }

    private static Version extractVersionFromMappings(String mappings, String versionMetaKey) {
        Map<String, Object> mappingsMap = XContentHelper.convertToMap(XContentType.JSON.xContent(), mappings, false);
        Map doc = (Map)mappingsMap.get("_doc");
        Map meta = doc == null ? (Map)mappingsMap.get("_meta") : (Map)doc.get("_meta");
        if (meta == null) {
            throw new IllegalStateException("mappings do not have _meta field");
        }
        String value = (String)meta.get(versionMetaKey);
        if (value == null) {
            throw new IllegalArgumentException("mappings do not have a version in _meta." + versionMetaKey);
        }
        return Version.fromString(value);
    }

    public static enum Type {
        INTERNAL_MANAGED(false, true),
        INTERNAL_UNMANAGED(false, false),
        EXTERNAL_MANAGED(true, true),
        EXTERNAL_UNMANAGED(true, false);

        private final boolean external;
        private final boolean managed;

        private Type(boolean external, boolean managed) {
            this.external = external;
            this.managed = managed;
        }

        public boolean isExternal() {
            return this.external;
        }

        public boolean isManaged() {
            return this.managed;
        }

        public boolean isInternal() {
            return !this.external;
        }
    }

    public static class Builder {
        private String indexPattern;
        private String primaryIndex;
        private String description;
        private String mappings = null;
        private Settings settings = null;
        private String aliasName = null;
        private int indexFormat = 0;
        private String versionMetaKey = null;
        private String origin = null;
        private Version minimumNodeVersion = Version.CURRENT.minimumCompatibilityVersion();
        private Type type = Type.INTERNAL_MANAGED;
        private List<String> allowedElasticProductOrigins = List.of();
        private List<SystemIndexDescriptor> priorSystemIndexDescriptors = List.of();
        private ExecutorNames executorNames;
        private boolean isNetNew = false;

        private Builder() {
        }

        public Builder setIndexPattern(String indexPattern) {
            this.indexPattern = indexPattern;
            return this;
        }

        public Builder setPrimaryIndex(String primaryIndex) {
            this.primaryIndex = primaryIndex;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setMappings(XContentBuilder mappingsBuilder) {
            this.mappings = mappingsBuilder == null ? null : Strings.toString(mappingsBuilder);
            return this;
        }

        public Builder setMappings(String mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder setSettings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder setAliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public Builder setIndexFormat(int indexFormat) {
            this.indexFormat = indexFormat;
            return this;
        }

        public Builder setVersionMetaKey(String versionMetaKey) {
            this.versionMetaKey = versionMetaKey;
            return this;
        }

        public Builder setOrigin(String origin) {
            this.origin = origin;
            return this;
        }

        public Builder setMinimumNodeVersion(Version version) {
            this.minimumNodeVersion = version;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setAllowedElasticProductOrigins(List<String> allowedElasticProductOrigins) {
            this.allowedElasticProductOrigins = allowedElasticProductOrigins;
            return this;
        }

        public Builder setPriorSystemIndexDescriptors(List<SystemIndexDescriptor> priorSystemIndexDescriptors) {
            this.priorSystemIndexDescriptors = priorSystemIndexDescriptors;
            return this;
        }

        public Builder setThreadPools(ExecutorNames threadPoolExecutorNames) {
            this.executorNames = threadPoolExecutorNames;
            return this;
        }

        public Builder setNetNew() {
            this.isNetNew = true;
            return this;
        }

        public SystemIndexDescriptor build() {
            return new SystemIndexDescriptor(this.indexPattern, this.primaryIndex, this.description, this.mappings, this.settings, this.aliasName, this.indexFormat, this.versionMetaKey, this.origin, this.minimumNodeVersion, this.type, this.allowedElasticProductOrigins, this.priorSystemIndexDescriptors, this.executorNames, this.isNetNew);
        }
    }
}

