/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BlendedTermQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.QueryBuilder;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.search.MatchQueryParser;

public class MultiMatchQueryParser
extends MatchQueryParser {
    private Float groupTieBreaker = null;

    public MultiMatchQueryParser(SearchExecutionContext context) {
        super(context);
    }

    public void setTieBreaker(float tieBreaker) {
        this.groupTieBreaker = Float.valueOf(tieBreaker);
    }

    public Query parse(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
        boolean hasMappedField = fieldNames.keySet().stream().anyMatch(k -> this.context.getFieldType((String)k) != null);
        if (!hasMappedField) {
            return Queries.newUnmappedFieldsQuery(fieldNames.keySet());
        }
        float tieBreaker = this.groupTieBreaker == null ? type.tieBreaker() : this.groupTieBreaker.floatValue();
        return this.combineGrouped(switch (type) {
            case MultiMatchQueryBuilder.Type.PHRASE, MultiMatchQueryBuilder.Type.PHRASE_PREFIX, MultiMatchQueryBuilder.Type.BEST_FIELDS, MultiMatchQueryBuilder.Type.MOST_FIELDS, MultiMatchQueryBuilder.Type.BOOL_PREFIX -> this.buildFieldQueries(type, fieldNames, value, minimumShouldMatch);
            case MultiMatchQueryBuilder.Type.CROSS_FIELDS -> this.buildCrossFieldQuery(fieldNames, value, minimumShouldMatch, tieBreaker);
            default -> throw new IllegalStateException("No such type: " + type);
        }, tieBreaker);
    }

    private Query combineGrouped(List<Query> groupQuery, float tieBreaker) {
        if (groupQuery.isEmpty()) {
            return this.zeroTermsQuery.asQuery();
        }
        if (groupQuery.size() == 1) {
            return groupQuery.get(0);
        }
        return new DisjunctionMaxQuery(groupQuery, tieBreaker);
    }

    private List<Query> buildFieldQueries(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (String fieldName : fieldNames.keySet()) {
            if (this.context.getFieldType(fieldName) == null) continue;
            float boostValue = fieldNames.getOrDefault(fieldName, Float.valueOf(1.0f)).floatValue();
            Query query = this.parse(type.matchQueryType(), fieldName, value);
            if ((query = Queries.maybeApplyMinimumShouldMatch(query, minimumShouldMatch)) != null && boostValue != 1.0f && !(query instanceof MatchNoDocsQuery)) {
                query = new BoostQuery(query, boostValue);
            }
            if (query == null) continue;
            queries.add(query);
        }
        return queries;
    }

    private List<Query> buildCrossFieldQuery(Map<String, Float> fieldNames, Object value, String minimumShouldMatch, float tieBreaker) {
        float boost;
        HashMap groups = new HashMap();
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Map.Entry<String, Float> entry : fieldNames.entrySet()) {
            String name = entry.getKey();
            MappedFieldType fieldType = this.context.getFieldType(name);
            if (fieldType == null) continue;
            Analyzer actualAnalyzer = this.getAnalyzer(fieldType, false);
            if (!groups.containsKey(actualAnalyzer)) {
                groups.put(actualAnalyzer, new ArrayList());
            }
            boost = entry.getValue() == null ? 1.0f : entry.getValue().floatValue();
            ((List)groups.get(actualAnalyzer)).add(new FieldAndBoost(fieldType, boost));
        }
        for (Map.Entry<String, Float> entry : groups.entrySet()) {
            String representativeField;
            MatchQueryParser.MatchQueryBuilder builder = ((List)((Object)entry.getValue())).size() == 1 ? new MatchQueryParser.MatchQueryBuilder(this, (Analyzer)entry.getKey(), ((FieldAndBoost)((List)((Object)entry.getValue())).get((int)0)).fieldType, this.enablePositionIncrements, this.autoGenerateSynonymsPhraseQuery) : new CrossFieldsQueryBuilder((Analyzer)entry.getKey(), (List)((Object)entry.getValue()), tieBreaker, this.enablePositionIncrements, this.autoGenerateSynonymsPhraseQuery);
            Query query = builder.createBooleanQuery(representativeField = ((FieldAndBoost)((List)((Object)entry.getValue())).get((int)0)).fieldType.name(), value.toString(), this.occur);
            if (query == null) {
                query = this.zeroTermsQuery.asQuery();
            }
            if ((query = Queries.maybeApplyMinimumShouldMatch(query, minimumShouldMatch)) == null) continue;
            if (((List)((Object)entry.getValue())).size() == 1 && (boost = ((FieldAndBoost)((List)((Object)entry.getValue())).get((int)0)).boost) != 1.0f) {
                query = new BoostQuery(query, boost);
            }
            queries.add(query);
        }
        return queries;
    }

    static Query blendTerm(SearchExecutionContext context, BytesRef value, float tieBreaker, boolean lenient, List<FieldAndBoost> blendedFields) {
        return MultiMatchQueryParser.blendTerms(context, new BytesRef[]{value}, tieBreaker, lenient, blendedFields);
    }

    static Query blendTerms(SearchExecutionContext context, BytesRef[] values, float tieBreaker, boolean lenient, List<FieldAndBoost> blendedFields) {
        ArrayList<Query> queries = new ArrayList<Query>();
        Term[] terms = new Term[blendedFields.size() * values.length];
        float[] blendedBoost = new float[blendedFields.size() * values.length];
        int i = 0;
        for (FieldAndBoost ft : blendedFields) {
            for (BytesRef term : values) {
                Query query;
                try {
                    query = ft.fieldType.termQuery(term, context);
                }
                catch (RuntimeException e) {
                    if (lenient) {
                        query = Queries.newLenientFieldQuery(ft.fieldType.name(), e);
                    }
                    throw e;
                }
                float boost = ft.boost;
                while (query instanceof BoostQuery) {
                    BoostQuery bq = (BoostQuery)query;
                    query = bq.getQuery();
                    boost *= bq.getBoost();
                }
                if (query.getClass() == TermQuery.class) {
                    terms[i] = ((TermQuery)query).getTerm();
                    blendedBoost[i] = boost;
                    ++i;
                    continue;
                }
                if (boost != 1.0f && !(query instanceof MatchNoDocsQuery)) {
                    query = new BoostQuery(query, boost);
                }
                queries.add(query);
            }
        }
        if (i > 0) {
            terms = Arrays.copyOf(terms, i);
            blendedBoost = Arrays.copyOf(blendedBoost, i);
            queries.add(BlendedTermQuery.dismaxBlendedQuery(terms, blendedBoost, tieBreaker));
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        return new DisjunctionMaxQuery(queries, tieBreaker);
    }

    static final class FieldAndBoost {
        final MappedFieldType fieldType;
        final float boost;

        FieldAndBoost(MappedFieldType fieldType, float boost) {
            this.fieldType = Objects.requireNonNull(fieldType);
            this.boost = boost;
        }
    }

    private class CrossFieldsQueryBuilder
    extends MatchQueryParser.MatchQueryBuilder {
        private final List<FieldAndBoost> blendedFields;
        private final float tieBreaker;

        CrossFieldsQueryBuilder(Analyzer analyzer, List<FieldAndBoost> blendedFields, float tieBreaker, boolean enablePositionIncrements, boolean autoGenerateSynonymsPhraseQuery) {
            super(MultiMatchQueryParser.this, analyzer, blendedFields.get((int)0).fieldType, enablePositionIncrements, autoGenerateSynonymsPhraseQuery);
            this.blendedFields = blendedFields;
            this.tieBreaker = tieBreaker;
        }

        public Query createPhraseQuery(String field, String queryText, int phraseSlop) {
            throw new IllegalArgumentException("[multi_match] queries in [cross_fields] mode don't support phrases");
        }

        @Override
        protected Query createPhrasePrefixQuery(String field, String queryText, int slop) {
            throw new IllegalArgumentException("[multi_match] queries in [cross_fields] mode don't support phrase prefix");
        }

        @Override
        protected Query createBooleanPrefixQuery(String field, String queryText, BooleanClause.Occur occur) {
            throw new IllegalArgumentException("[multi_match] queries in [cross_fields] mode don't support boolean prefix");
        }

        protected Query newSynonymQuery(QueryBuilder.TermAndBoost[] terms) {
            BytesRef[] values = new BytesRef[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                values[i] = terms[i].term.bytes();
            }
            return MultiMatchQueryParser.blendTerms(MultiMatchQueryParser.this.context, values, this.tieBreaker, MultiMatchQueryParser.this.lenient, this.blendedFields);
        }

        @Override
        protected Query newTermQuery(Term term, float boost) {
            return MultiMatchQueryParser.blendTerm(MultiMatchQueryParser.this.context, term.bytes(), this.tieBreaker, MultiMatchQueryParser.this.lenient, this.blendedFields);
        }

        @Override
        protected Query newPrefixQuery(Term term) {
            throw new IllegalArgumentException("[multi_match] queries in [cross_fields] mode don't support prefix");
        }

        @Override
        protected Query analyzePhrase(String field, TokenStream stream, int slop) throws IOException {
            ArrayList<Query> disjunctions = new ArrayList<Query>();
            for (FieldAndBoost fieldType : this.blendedFields) {
                Query query = fieldType.fieldType.phraseQuery(stream, slop, this.enablePositionIncrements, MultiMatchQueryParser.this.context);
                if (fieldType.boost != 1.0f) {
                    query = new BoostQuery(query, fieldType.boost);
                }
                disjunctions.add(query);
            }
            return new DisjunctionMaxQuery(disjunctions, this.tieBreaker);
        }

        @Override
        protected Query analyzeMultiPhrase(String field, TokenStream stream, int slop) throws IOException {
            ArrayList<Query> disjunctions = new ArrayList<Query>();
            for (FieldAndBoost fieldType : this.blendedFields) {
                Query query = fieldType.fieldType.multiPhraseQuery(stream, slop, this.enablePositionIncrements, MultiMatchQueryParser.this.context);
                if (fieldType.boost != 1.0f) {
                    query = new BoostQuery(query, fieldType.boost);
                }
                disjunctions.add(query);
            }
            return new DisjunctionMaxQuery(disjunctions, this.tieBreaker);
        }
    }
}

