/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.SpanQueryBuilder;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;

public class SpanNearQueryBuilder
extends AbstractQueryBuilder<SpanNearQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_near";
    public static boolean DEFAULT_IN_ORDER = true;
    public static int DEFAULT_SLOP = 0;
    private static final ParseField SLOP_FIELD = new ParseField("slop", new String[0]);
    private static final ParseField CLAUSES_FIELD = new ParseField("clauses", new String[0]);
    private static final ParseField IN_ORDER_FIELD = new ParseField("in_order", new String[0]);
    private final List<SpanQueryBuilder> clauses = new ArrayList<SpanQueryBuilder>();
    private final int slop;
    private boolean inOrder = DEFAULT_IN_ORDER;

    public SpanNearQueryBuilder(SpanQueryBuilder initialClause, int slop) {
        if (initialClause == null) {
            throw new IllegalArgumentException("[span_near] must include at least one clause");
        }
        this.clauses.add(initialClause);
        this.slop = slop;
    }

    public SpanNearQueryBuilder(StreamInput in) throws IOException {
        super(in);
        for (QueryBuilder clause : SpanNearQueryBuilder.readQueries(in)) {
            this.clauses.add((SpanQueryBuilder)clause);
        }
        this.slop = in.readVInt();
        this.inOrder = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        SpanNearQueryBuilder.writeQueries(out, this.clauses);
        out.writeVInt(this.slop);
        out.writeBoolean(this.inOrder);
    }

    public int slop() {
        return this.slop;
    }

    public SpanNearQueryBuilder addClause(SpanQueryBuilder clause) {
        if (clause == null) {
            throw new IllegalArgumentException("[span_near]  clauses cannot be null");
        }
        this.clauses.add(clause);
        return this;
    }

    public List<SpanQueryBuilder> clauses() {
        return Collections.unmodifiableList(this.clauses);
    }

    public SpanNearQueryBuilder inOrder(boolean inOrder) {
        this.inOrder = inOrder;
        return this;
    }

    public boolean inOrder() {
        return this.inOrder;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray(CLAUSES_FIELD.getPreferredName());
        for (SpanQueryBuilder clause : this.clauses) {
            clause.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(SLOP_FIELD.getPreferredName(), this.slop);
        builder.field(IN_ORDER_FIELD.getPreferredName(), this.inOrder);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static SpanNearQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        int slop = DEFAULT_SLOP;
        boolean inOrder = DEFAULT_IN_ORDER;
        String queryName = null;
        ArrayList<SpanQueryBuilder> clauses = new ArrayList<SpanQueryBuilder>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (CLAUSES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        QueryBuilder query = SpanNearQueryBuilder.parseInnerQueryBuilder(parser);
                        if (!(query instanceof SpanQueryBuilder)) {
                            throw new ParsingException(parser.getTokenLocation(), "span_near [clauses] must be of type span query", new Object[0]);
                        }
                        SpanQueryBuilder clause = (SpanQueryBuilder)query;
                        SpanQueryBuilder.SpanQueryBuilderUtil.checkNoBoost(NAME, currentFieldName, parser, clause);
                        clauses.add(clause);
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[span_near] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (IN_ORDER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    inOrder = parser.booleanValue();
                    continue;
                }
                if (SLOP_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    slop = parser.intValue();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[span_near] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[span_near] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (clauses.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "span_near must include [clauses]", new Object[0]);
        }
        SpanNearQueryBuilder queryBuilder = new SpanNearQueryBuilder((SpanQueryBuilder)clauses.get(0), slop);
        for (int i = 1; i < clauses.size(); ++i) {
            queryBuilder.addClause((SpanQueryBuilder)clauses.get(i));
        }
        queryBuilder.inOrder(inOrder);
        queryBuilder.boost(boost);
        queryBuilder.queryName(queryName);
        return queryBuilder;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        SpanQueryBuilder queryBuilder = this.clauses.get(0);
        boolean isGap = queryBuilder instanceof SpanGapQueryBuilder;
        Query query = null;
        if (!isGap) {
            query = queryBuilder.toQuery(context);
            assert (query instanceof SpanQuery);
        }
        if (this.clauses.size() == 1) {
            assert (!isGap);
            return query;
        }
        String spanNearFieldName = null;
        if (isGap) {
            String fieldName = ((SpanGapQueryBuilder)queryBuilder).fieldName();
            spanNearFieldName = this.queryFieldName(context, fieldName);
        } else {
            spanNearFieldName = ((SpanQuery)query).getField();
        }
        SpanNearQuery.Builder builder = new SpanNearQuery.Builder(spanNearFieldName, this.inOrder);
        builder.setSlop(this.slop);
        if (isGap) {
            int gap = ((SpanGapQueryBuilder)queryBuilder).width();
            builder.addGap(gap);
        } else {
            builder.addClause((SpanQuery)query);
        }
        for (int i = 1; i < this.clauses.size(); ++i) {
            queryBuilder = this.clauses.get(i);
            isGap = queryBuilder instanceof SpanGapQueryBuilder;
            if (isGap) {
                String fieldName = ((SpanGapQueryBuilder)queryBuilder).fieldName();
                String spanGapFieldName = this.queryFieldName(context, fieldName);
                if (!spanNearFieldName.equals(spanGapFieldName)) {
                    throw new IllegalArgumentException("[span_near] clauses must have same field");
                }
                int gap = ((SpanGapQueryBuilder)queryBuilder).width();
                builder.addGap(gap);
                continue;
            }
            query = this.clauses.get(i).toQuery(context);
            assert (query instanceof SpanQuery);
            builder.addClause((SpanQuery)query);
        }
        return builder.build();
    }

    private String queryFieldName(SearchExecutionContext context, String fieldName) {
        MappedFieldType fieldType = context.getFieldType(fieldName);
        return fieldType != null ? fieldType.name() : fieldName;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.clauses, this.slop, this.inOrder);
    }

    @Override
    protected boolean doEquals(SpanNearQueryBuilder other) {
        return Objects.equals(this.clauses, other.clauses) && Objects.equals(this.slop, other.slop) && Objects.equals(this.inOrder, other.inOrder);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public static class SpanGapQueryBuilder
    implements SpanQueryBuilder {
        public static final String NAME = "span_gap";
        private final String fieldName;
        private final int width;

        public SpanGapQueryBuilder(String fieldName, int width) {
            if (Strings.isEmpty(fieldName)) {
                throw new IllegalArgumentException("[span_gap] field name is null or empty");
            }
            this.fieldName = fieldName;
            this.width = width;
        }

        public SpanGapQueryBuilder(StreamInput in) throws IOException {
            this.fieldName = in.readString();
            this.width = in.readInt();
        }

        public String fieldName() {
            return this.fieldName;
        }

        public int width() {
            return this.width;
        }

        @Override
        public Query toQuery(SearchExecutionContext context) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String queryName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public QueryBuilder queryName(String queryName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float boost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public QueryBuilder boost(float boost) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public final void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.fieldName);
            out.writeInt(this.width);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject(this.getName());
            builder.field(this.fieldName, this.width);
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public static SpanGapQueryBuilder fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token;
            String fieldName = null;
            int width = 0;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    SpanGapQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                    fieldName = currentFieldName;
                    continue;
                }
                if (!token.isValue()) continue;
                width = parser.intValue();
            }
            SpanGapQueryBuilder result = new SpanGapQueryBuilder(fieldName, width);
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SpanGapQueryBuilder other = (SpanGapQueryBuilder)obj;
            return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.width, other.width);
        }

        public final int hashCode() {
            return Objects.hash(this.getClass(), this.fieldName, this.width);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this, true, true);
        }

        protected static void throwParsingExceptionOnMultipleFields(String queryName, XContentLocation contentLocation, String processedFieldName, String currentFieldName) {
            if (processedFieldName != null) {
                throw new ParsingException(contentLocation, "[" + queryName + "] query doesn't support multiple fields, found [" + processedFieldName + "] and [" + currentFieldName + "]", new Object[0]);
            }
        }
    }
}

