/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;

public class Segment
implements Writeable {
    private String name;
    private long generation;
    public boolean committed;
    public boolean search;
    public long sizeInBytes = -1L;
    public int docCount = -1;
    public int delDocCount = -1;
    public org.apache.lucene.util.Version version = null;
    public Boolean compound = null;
    public String mergeId;
    public Sort segmentSort;
    public Map<String, String> attributes;

    public Segment(StreamInput in) throws IOException {
        this.name = in.readString();
        this.generation = Long.parseLong(this.name.substring(1), 36);
        this.committed = in.readBoolean();
        this.search = in.readBoolean();
        this.docCount = in.readInt();
        this.delDocCount = in.readInt();
        this.sizeInBytes = in.readLong();
        this.version = Lucene.parseVersionLenient(in.readOptionalString(), null);
        this.compound = in.readOptionalBoolean();
        this.mergeId = in.readOptionalString();
        if (in.getVersion().before(Version.V_8_0_0)) {
            in.readLong();
        }
        if (in.readBoolean()) {
            Segment.readRamTree(in);
        }
        this.segmentSort = this.readSegmentSort(in);
        this.attributes = in.readBoolean() ? in.readMap(StreamInput::readString, StreamInput::readString) : null;
    }

    public Segment(String name) {
        this.name = name;
        this.generation = Long.parseLong(name.substring(1), 36);
    }

    public String getName() {
        return this.name;
    }

    public long getGeneration() {
        return this.generation;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isSearch() {
        return this.search;
    }

    public int getNumDocs() {
        return this.docCount;
    }

    public int getDeletedDocs() {
        return this.delDocCount;
    }

    public ByteSizeValue getSize() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public org.apache.lucene.util.Version getVersion() {
        return this.version;
    }

    @Nullable
    public Boolean isCompound() {
        return this.compound;
    }

    @Nullable
    public String getMergeId() {
        return this.mergeId;
    }

    public Sort getSegmentSort() {
        return this.segmentSort;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        return Objects.equals(this.name, segment.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.committed);
        out.writeBoolean(this.search);
        out.writeInt(this.docCount);
        out.writeInt(this.delDocCount);
        out.writeLong(this.sizeInBytes);
        out.writeOptionalString(this.version.toString());
        out.writeOptionalBoolean(this.compound);
        out.writeOptionalString(this.mergeId);
        if (out.getVersion().before(Version.V_8_0_0)) {
            out.writeLong(0L);
        }
        out.writeBoolean(false);
        this.writeSegmentSort(out, this.segmentSort);
        boolean hasAttributes = this.attributes != null;
        out.writeBoolean(hasAttributes);
        if (hasAttributes) {
            out.writeMap(this.attributes, StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    private Sort readSegmentSort(StreamInput in) throws IOException {
        int size = in.readVInt();
        if (size == 0) {
            return null;
        }
        SortField[] fields = new SortField[size];
        for (int i = 0; i < size; ++i) {
            boolean reverse;
            boolean max;
            String field = in.readString();
            byte type = in.readByte();
            if (type == 0) {
                Boolean missingFirst = in.readOptionalBoolean();
                max = in.readBoolean();
                reverse = in.readBoolean();
                fields[i] = new SortedSetSortField(field, reverse, max ? SortedSetSelector.Type.MAX : SortedSetSelector.Type.MIN);
                if (missingFirst == null) continue;
                fields[i].setMissingValue(missingFirst != false ? SortedSetSortField.STRING_FIRST : SortedSetSortField.STRING_LAST);
                continue;
            }
            Object missing = in.readGenericValue();
            max = in.readBoolean();
            reverse = in.readBoolean();
            fields[i] = new SortedNumericSortField(field, switch (type) {
                case 1 -> SortField.Type.INT;
                case 2 -> SortField.Type.FLOAT;
                case 3 -> SortField.Type.DOUBLE;
                case 4 -> SortField.Type.LONG;
                default -> throw new IOException("invalid index sort type:[" + type + "] for numeric field:[" + field + "]");
            }, reverse, max ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN);
            if (missing == null) continue;
            fields[i].setMissingValue(missing);
        }
        return new Sort(fields);
    }

    private void writeSegmentSort(StreamOutput out, Sort sort) throws IOException {
        if (sort == null) {
            out.writeVInt(0);
            return;
        }
        out.writeVInt(sort.getSort().length);
        for (SortField field : sort.getSort()) {
            out.writeString(field.getField());
            if (field instanceof SortedSetSortField) {
                out.writeByte((byte)0);
                out.writeOptionalBoolean(field.getMissingValue() == null ? null : Boolean.valueOf(field.getMissingValue() == SortField.STRING_FIRST));
                out.writeBoolean(((SortedSetSortField)field).getSelector() == SortedSetSelector.Type.MAX);
                out.writeBoolean(field.getReverse());
                continue;
            }
            if (field instanceof SortedNumericSortField) {
                switch (((SortedNumericSortField)field).getNumericType()) {
                    case INT: {
                        out.writeByte((byte)1);
                        break;
                    }
                    case FLOAT: {
                        out.writeByte((byte)2);
                        break;
                    }
                    case DOUBLE: {
                        out.writeByte((byte)3);
                        break;
                    }
                    case LONG: {
                        out.writeByte((byte)4);
                        break;
                    }
                    default: {
                        throw new IOException("invalid index sort field:" + field);
                    }
                }
                out.writeGenericValue(field.getMissingValue());
                out.writeBoolean(((SortedNumericSortField)field).getSelector() == SortedNumericSelector.Type.MAX);
                out.writeBoolean(field.getReverse());
                continue;
            }
            throw new IOException("invalid index sort field:" + field);
        }
    }

    private static void readRamTree(StreamInput in) throws IOException {
        in.readString();
        in.readVLong();
        int numChildren = in.readVInt();
        for (int i = 0; i < numChildren; ++i) {
            Segment.readRamTree(in);
        }
    }

    public String toString() {
        return "Segment{name='" + this.name + "', generation=" + this.generation + ", committed=" + this.committed + ", search=" + this.search + ", sizeInBytes=" + this.sizeInBytes + ", docCount=" + this.docCount + ", delDocCount=" + this.delDocCount + ", version='" + this.version + "', compound=" + this.compound + ", mergeId='" + this.mergeId + "'" + (String)(this.segmentSort != null ? ", sort=" + this.segmentSort : "") + ", attributes=" + this.attributes + "}";
    }
}

