/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum IndexMode {
    STANDARD{

        @Override
        void validateWithOtherSettings(Map<Setting<?>, Object> settings) {
            if (!Objects.equals(IndexMetadata.INDEX_ROUTING_PATH.getDefault(Settings.EMPTY), settings.get(IndexMetadata.INDEX_ROUTING_PATH))) {
                throw new IllegalArgumentException("[" + IndexMetadata.INDEX_ROUTING_PATH.getKey() + "] requires [" + IndexSettings.MODE.getKey() + "=time_series]");
            }
        }

        @Override
        public void validateMapping(MappingLookup lookup) {
        }

        @Override
        public void validateAlias(@Nullable String indexRouting, @Nullable String searchRouting) {
        }

        @Override
        public void completeMappings(MappingParserContext context, Map<String, Object> mapping, RootObjectMapper.Builder builder) {
        }
    }
    ,
    TIME_SERIES{

        @Override
        void validateWithOtherSettings(Map<Setting<?>, Object> settings) {
            if (settings.get(IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING) != Integer.valueOf(1)) {
                throw new IllegalArgumentException(this.error(IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING));
            }
            for (Setting<?> unsupported : TIME_SERIES_UNSUPPORTED) {
                if (Objects.equals(unsupported.getDefault(Settings.EMPTY), settings.get(unsupported))) continue;
                throw new IllegalArgumentException(this.error(unsupported));
            }
            if (IndexMetadata.INDEX_ROUTING_PATH.getDefault(Settings.EMPTY).equals(settings.get(IndexMetadata.INDEX_ROUTING_PATH))) {
                throw new IllegalArgumentException("[" + IndexSettings.MODE.getKey() + "=time_series] requires [" + IndexMetadata.INDEX_ROUTING_PATH.getKey() + "]");
            }
        }

        private String error(Setting<?> unsupported) {
            return this.tsdbMode() + " is incompatible with [" + unsupported.getKey() + "]";
        }

        @Override
        public void validateMapping(MappingLookup lookup) {
            if (((RoutingFieldMapper)lookup.getMapper("_routing")).required()) {
                throw new IllegalArgumentException(this.routingRequiredBad());
            }
        }

        @Override
        public void validateAlias(@Nullable String indexRouting, @Nullable String searchRouting) {
            if (indexRouting != null || searchRouting != null) {
                throw new IllegalArgumentException(this.routingRequiredBad());
            }
        }

        private String routingRequiredBad() {
            return "routing is forbidden on CRUD operations that target indices in " + this.tsdbMode();
        }

        private String tsdbMode() {
            return "[" + IndexSettings.MODE.getKey() + "=time_series]";
        }

        @Override
        public void completeMappings(MappingParserContext context, Map<String, Object> mapping, RootObjectMapper.Builder builder) {
            if (!mapping.containsKey("_data_stream_timestamp")) {
                mapping.put("_data_stream_timestamp", new HashMap<String, Boolean>(Map.of("enabled", true)));
            } else {
                this.validateTimeStampField(mapping.get("_data_stream_timestamp"));
            }
            Optional<Mapper.Builder> timestamp = builder.getBuilder("@timestamp");
            if (timestamp.isEmpty()) {
                builder.add(new DateFieldMapper.Builder("@timestamp", DateFieldMapper.Resolution.MILLISECONDS, DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER, context.scriptCompiler(), (Boolean)DateFieldMapper.IGNORE_MALFORMED_SETTING.get(context.getSettings()), context.getIndexSettings().getIndexVersionCreated()));
            }
        }

        private void validateTimeStampField(Object timestampFieldValue) {
            if (!(timestampFieldValue instanceof Map)) {
                throw new IllegalArgumentException("time series index [_data_stream_timestamp] meta field format error");
            }
            Map timeStampFieldValueMap = (Map)timestampFieldValue;
            if (!Maps.deepEquals(timeStampFieldValueMap, Map.of("enabled", true)) && !Maps.deepEquals(timeStampFieldValueMap, Map.of("enabled", "true"))) {
                throw new IllegalArgumentException("time series index [_data_stream_timestamp] meta field must be enabled");
            }
        }
    };

    private static final List<Setting<?>> TIME_SERIES_UNSUPPORTED;
    static final List<Setting<?>> VALIDATE_WITH_SETTINGS;

    abstract void validateWithOtherSettings(Map<Setting<?>, Object> var1);

    public abstract void validateMapping(MappingLookup var1);

    public abstract void validateAlias(@Nullable String var1, @Nullable String var2);

    public abstract void completeMappings(MappingParserContext var1, Map<String, Object> var2, RootObjectMapper.Builder var3);

    static {
        TIME_SERIES_UNSUPPORTED = List.of(IndexSortConfig.INDEX_SORT_FIELD_SETTING, IndexSortConfig.INDEX_SORT_ORDER_SETTING, IndexSortConfig.INDEX_SORT_MODE_SETTING, IndexSortConfig.INDEX_SORT_MISSING_SETTING);
        VALIDATE_WITH_SETTINGS = List.copyOf(Stream.concat(Stream.of(IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING, IndexMetadata.INDEX_ROUTING_PATH), TIME_SERIES_UNSUPPORTED.stream()).collect(Collectors.toSet()));
    }
}

