/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.set;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class Sets {
    private Sets() {
    }

    public static <T> HashSet<T> newHashSet(Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        HashSet<T> set = new HashSet<T>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        return iterable instanceof Collection ? new HashSet<T>((Collection)iterable) : Sets.newHashSet(iterable.iterator());
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... elements) {
        Objects.requireNonNull(elements);
        return new HashSet<T>(Arrays.asList(elements));
    }

    public static <T> Set<T> newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static <T> boolean haveEmptyIntersection(Set<T> left, Set<T> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        return left.stream().noneMatch(right::contains);
    }

    public static <T> boolean haveNonEmptyIntersection(Set<T> left, Set<T> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        return left.stream().anyMatch(right::contains);
    }

    public static <T> Set<T> difference(Set<T> left, Set<T> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        return left.stream().filter(k -> !right.contains(k)).collect(Collectors.toSet());
    }

    public static <T> SortedSet<T> sortedDifference(Set<T> left, Set<T> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        return left.stream().filter(k -> !right.contains(k)).collect(Sets.toSortedSet());
    }

    public static <T> SortedSet<T> unmodifiableSortedDifference(Set<T> left, Set<T> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        return left.stream().filter(k -> !right.contains(k)).collect(Sets.toUnmodifiableSortedSet());
    }

    public static <T> Collector<T, SortedSet<T>, SortedSet<T>> toSortedSet() {
        return new SortedSetCollector();
    }

    public static <T> Collector<T, SortedSet<T>, SortedSet<T>> toUnmodifiableSortedSet() {
        return new UnmodifiableSortedSetCollector();
    }

    public static <T> Set<T> union(Set<T> left, Set<T> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        HashSet<T> union = new HashSet<T>(left);
        union.addAll(right);
        return union;
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        Set<T> right;
        Set<T> left;
        Objects.requireNonNull(set1);
        Objects.requireNonNull(set2);
        if (set1.size() < set2.size()) {
            left = set1;
            right = set2;
        } else {
            left = set2;
            right = set1;
        }
        return left.stream().filter(right::contains).collect(Collectors.toSet());
    }

    private static class SortedSetCollector<T>
    extends AbstractSortedSetCollector<T> {
        static final Set<Collector.Characteristics> CHARACTERISTICS = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));

        private SortedSetCollector() {
        }

        @Override
        public Function<SortedSet<T>, SortedSet<T>> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return CHARACTERISTICS;
        }
    }

    private static class UnmodifiableSortedSetCollector<T>
    extends AbstractSortedSetCollector<T> {
        private UnmodifiableSortedSetCollector() {
        }

        @Override
        public Function<SortedSet<T>, SortedSet<T>> finisher() {
            return Collections::unmodifiableSortedSet;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    static abstract class AbstractSortedSetCollector<T>
    implements Collector<T, SortedSet<T>, SortedSet<T>> {
        AbstractSortedSetCollector() {
        }

        @Override
        public Supplier<SortedSet<T>> supplier() {
            return TreeSet::new;
        }

        @Override
        public BiConsumer<SortedSet<T>, T> accumulator() {
            return Set::add;
        }

        @Override
        public BinaryOperator<SortedSet<T>> combiner() {
            return (s, t) -> {
                s.addAll(t);
                return s;
            };
        }

        @Override
        public abstract Function<SortedSet<T>, SortedSet<T>> finisher();

        @Override
        public abstract Set<Collector.Characteristics> characteristics();
    }
}

