/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.elasticsearch.common.ExponentiallyWeightedMovingAverage;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.concurrent.TimedRunnable;
import org.elasticsearch.common.util.concurrent.WrappedRunnable;
import org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;
import org.elasticsearch.core.TimeValue;

public final class EWMATrackingEsThreadPoolExecutor
extends EsThreadPoolExecutor {
    public static double EWMA_ALPHA = 0.3;
    private final Function<Runnable, WrappedRunnable> runnableWrapper;
    private final ExponentiallyWeightedMovingAverage executionEWMA;

    EWMATrackingEsThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, Function<Runnable, WrappedRunnable> runnableWrapper, ThreadFactory threadFactory, XRejectedExecutionHandler handler, ThreadContext contextHolder) {
        super(name, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler, contextHolder);
        this.runnableWrapper = runnableWrapper;
        this.executionEWMA = new ExponentiallyWeightedMovingAverage(EWMA_ALPHA, 0.0);
    }

    @Override
    protected Runnable wrapRunnable(Runnable command) {
        return super.wrapRunnable(this.runnableWrapper.apply(command));
    }

    @Override
    protected Runnable unwrap(Runnable runnable) {
        Runnable unwrapped = super.unwrap(runnable);
        if (unwrapped instanceof WrappedRunnable) {
            return ((WrappedRunnable)unwrapped).unwrap();
        }
        return unwrapped;
    }

    public double getTaskExecutionEWMA() {
        return this.executionEWMA.getAverage();
    }

    public int getCurrentQueueSize() {
        return this.getQueue().size();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        assert (super.unwrap(r) instanceof TimedRunnable) : "expected only TimedRunnables in queue";
        TimedRunnable timedRunnable = (TimedRunnable)super.unwrap(r);
        boolean failedOrRejected = timedRunnable.getFailedOrRejected();
        long taskExecutionNanos = timedRunnable.getTotalExecutionNanos();
        assert (taskExecutionNanos >= 0L || failedOrRejected && taskExecutionNanos == -1L) : "expected task to always take longer than 0 nanoseconds or have '-1' failure code, got: " + taskExecutionNanos + ", failedOrRejected: " + failedOrRejected;
        if (taskExecutionNanos != -1L) {
            this.executionEWMA.addValue(taskExecutionNanos);
        }
    }

    @Override
    protected void appendThreadPoolExecutorDetails(StringBuilder sb) {
        sb.append("task execution EWMA = ").append(TimeValue.timeValueNanos((long)((long)this.executionEWMA.getAverage()))).append(", ");
    }
}

