/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Maps {
    private static final Set<Class<?>> IMMUTABLE_MAP_CLASSES = Set.of(Collections.emptyMap().getClass(), Collections.unmodifiableMap(new HashMap()).getClass(), Map.of().getClass(), Map.of("a", "b").getClass());

    public static <K, V> Map<K, V> copyMapWithAddedEntry(Map<K, V> map, K key, V value) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        assert (Maps.checkIsImmutableMap(map, key, value));
        assert (!map.containsKey(key)) : "expected entry [" + key + "] to not already be present in map";
        Map.Entry[] entries = new Map.Entry[map.size() + 1];
        map.entrySet().toArray(entries);
        entries[entries.length - 1] = Map.entry(key, value);
        return Map.ofEntries(entries);
    }

    public static <K, V> Map<K, V> copyMapWithAddedOrReplacedEntry(Map<K, V> map, K key, V value) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        assert (Maps.checkIsImmutableMap(map, key, value));
        return Stream.concat(map.entrySet().stream().filter(k -> !key.equals(k.getKey())), Stream.of(Map.entry(key, value))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V> Map<K, V> copyMapWithRemovedEntry(Map<K, V> map, K key) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(key);
        assert (Maps.checkIsImmutableMap(map, key, map.get(key)));
        return map.entrySet().stream().filter(k -> !key.equals(k.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static <K, V> boolean checkIsImmutableMap(Map<K, V> map, K key, V value) {
        if (IMMUTABLE_MAP_CLASSES.contains(map.getClass())) {
            return true;
        }
        try {
            map.put(key, value);
            return false;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return true;
        }
    }

    public static <K, V> Map<K, V> ofEntries(Collection<Map.Entry<K, V>> entries) {
        Map map = Map.ofEntries((Map.Entry[])entries.toArray(Map.Entry[]::new));
        return map;
    }

    public static <K, V> boolean deepEquals(Map<K, V> left, Map<K, V> right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null || left.size() != right.size()) {
            return false;
        }
        return left.entrySet().stream().allMatch(e -> right.containsKey(e.getKey()) && Objects.deepEquals(e.getValue(), right.get(e.getKey())));
    }

    public static Map<String, Object> flatten(Map<String, Object> map, boolean flattenArrays, boolean ordered) {
        return Maps.flatten(map, flattenArrays, ordered, null);
    }

    private static Map<String, Object> flatten(Map<String, Object> map, boolean flattenArrays, boolean ordered, String parentPath) {
        TreeMap<String, Object> flatMap = ordered ? new TreeMap() : new HashMap();
        Object prefix = parentPath != null ? parentPath + "." : "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                flatMap.putAll(Maps.flatten((Map)entry.getValue(), flattenArrays, ordered, (String)prefix + entry.getKey()));
                continue;
            }
            if (flattenArrays && entry.getValue() instanceof List) {
                flatMap.putAll(Maps.flatten((List)entry.getValue(), ordered, (String)prefix + entry.getKey()));
                continue;
            }
            flatMap.put((String)prefix + entry.getKey(), entry.getValue());
        }
        return flatMap;
    }

    private static Map<String, Object> flatten(List<Object> list, boolean ordered, String parentPath) {
        TreeMap<String, Object> flatMap = ordered ? new TreeMap() : new HashMap();
        Object prefix = parentPath != null ? parentPath + "." : "";
        for (int i = 0; i < list.size(); ++i) {
            Object cur = list.get(i);
            if (cur instanceof Map) {
                flatMap.putAll(Maps.flatten((Map)cur, true, ordered, (String)prefix + i));
            }
            if (cur instanceof List) {
                flatMap.putAll(Maps.flatten((List)cur, ordered, (String)prefix + i));
                continue;
            }
            flatMap.put((String)prefix + i, cur);
        }
        return flatMap;
    }

    public static <T, K, V> Collector<T, ?, NavigableMap<K, V>> toUnmodifiableSortedMap(Function<T, ? extends K> keyMapper, Function<T, ? extends V> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toMap(keyMapper, valueMapper, (v1, v2) -> {
            throw new IllegalStateException("Duplicate key (attempted merging values " + v1 + "  and " + v2 + ")");
        }, () -> new TreeMap()), Collections::unmodifiableNavigableMap);
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toUnmodifiableOrderedMap(Function<T, ? extends K> keyMapper, Function<T, ? extends V> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toMap(keyMapper, valueMapper, (v1, v2) -> {
            throw new IllegalStateException("Duplicate key (attempted merging values " + v1 + "  and " + v2 + ")");
        }, LinkedHashMap::new), Collections::unmodifiableMap);
    }
}

