/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.SystemIndices;

public class SystemIndexMetadataUpgradeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(SystemIndexMetadataUpgradeService.class);
    private final SystemIndices systemIndices;
    private final ClusterService clusterService;
    private boolean master = false;
    private volatile ImmutableOpenMap<String, IndexMetadata> lastIndexMetadataMap = ImmutableOpenMap.of();
    private volatile boolean updateTaskPending = false;

    public SystemIndexMetadataUpgradeService(SystemIndices systemIndices, ClusterService clusterService) {
        this.systemIndices = systemIndices;
        this.clusterService = clusterService;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        ImmutableOpenMap<String, IndexMetadata> indexMetadataMap;
        if (event.localNodeMaster() != this.master) {
            this.master = event.localNodeMaster();
        }
        if (this.master && !this.updateTaskPending && this.lastIndexMetadataMap != (indexMetadataMap = event.state().metadata().indices())) {
            for (Map.Entry<String, IndexMetadata> cursor : indexMetadataMap.entrySet()) {
                boolean isSystem;
                if (cursor.getValue() == this.lastIndexMetadataMap.get(cursor.getKey()) || (isSystem = this.systemIndices.isSystemIndex(cursor.getValue().getIndex()) || this.systemIndices.isSystemIndexBackingDataStream(cursor.getValue().getIndex().getName())) == cursor.getValue().isSystem()) continue;
                this.updateTaskPending = true;
                this.clusterService.submitStateUpdateTask("system_index_metadata_upgrade_service {system metadata change}", new SystemIndexMetadataUpdateTask());
                break;
            }
        }
    }

    SystemIndexMetadataUpdateTask getTask() {
        return new SystemIndexMetadataUpdateTask();
    }

    public class SystemIndexMetadataUpdateTask
    extends ClusterStateUpdateTask {
        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            ImmutableOpenMap<String, IndexMetadata> indexMetadataMap = currentState.metadata().indices();
            ArrayList<IndexMetadata> updatedMetadata = new ArrayList<IndexMetadata>();
            for (Map.Entry<String, IndexMetadata> cursor : indexMetadataMap.entrySet()) {
                IndexMetadata indexMetadata = cursor.getValue();
                if (indexMetadata == SystemIndexMetadataUpgradeService.this.lastIndexMetadataMap.get(cursor.getKey())) continue;
                boolean isSystem = SystemIndexMetadataUpgradeService.this.systemIndices.isSystemIndex(indexMetadata.getIndex()) || SystemIndexMetadataUpgradeService.this.systemIndices.isSystemIndexBackingDataStream(indexMetadata.getIndex().getName());
                IndexMetadata.Builder builder = IndexMetadata.builder(indexMetadata);
                boolean updated = false;
                if (isSystem != indexMetadata.isSystem()) {
                    builder.system(!indexMetadata.isSystem());
                    updated = true;
                }
                boolean isHidden = indexMetadata.getSettings().getAsBoolean("index.hidden", false);
                if (isSystem && !isHidden) {
                    builder.settings(Settings.builder().put(indexMetadata.getSettings()).put("index.hidden", true));
                    updated = true;
                }
                if (isSystem && indexMetadata.getAliases().values().stream().anyMatch(a -> a.isHidden() == false)) {
                    for (AliasMetadata aliasMetadata : indexMetadata.getAliases().values()) {
                        if (aliasMetadata.isHidden().booleanValue()) continue;
                        builder.removeAlias(aliasMetadata.alias());
                        builder.putAlias(AliasMetadata.builder(aliasMetadata.alias()).filter(aliasMetadata.filter()).indexRouting(aliasMetadata.indexRouting()).isHidden(true).searchRouting(aliasMetadata.searchRouting()).writeIndex(aliasMetadata.writeIndex()));
                    }
                }
                if (!updated) continue;
                updatedMetadata.add(builder.build());
            }
            if (!updatedMetadata.isEmpty()) {
                Metadata.Builder builder = Metadata.builder(currentState.metadata());
                updatedMetadata.forEach(idxMeta -> builder.put((IndexMetadata)idxMeta, true));
                return ClusterState.builder(currentState).metadata(builder).build();
            }
            return currentState;
        }

        @Override
        public void onFailure(String source, Exception e) {
            SystemIndexMetadataUpgradeService.this.updateTaskPending = false;
            logger.error("failed to update system index metadata", (Throwable)e);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            SystemIndexMetadataUpgradeService.this.lastIndexMetadataMap = newState.metadata().indices();
            SystemIndexMetadataUpgradeService.this.updateTaskPending = false;
        }
    }
}

