/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.NotifyOnceListener;
import org.elasticsearch.action.admin.indices.close.CloseIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.admin.indices.close.TransportVerifyShardBeforeCloseAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockResponse;
import org.elasticsearch.action.admin.indices.readonly.TransportVerifyShardIndexBlockAction;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.ShardsAcknowledgedResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadataVerifier;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataIndexStateService {
    private static final Logger logger = LogManager.getLogger(MetadataIndexStateService.class);
    public static final int INDEX_CLOSED_BLOCK_ID = 4;
    public static final ClusterBlock INDEX_CLOSED_BLOCK = new ClusterBlock(4, "index closed", false, false, false, RestStatus.FORBIDDEN, ClusterBlockLevel.READ_WRITE);
    public static final Setting<Boolean> VERIFIED_BEFORE_CLOSE_SETTING = Setting.boolSetting("index.verified_before_close", false, Setting.Property.IndexScope, Setting.Property.PrivateIndex);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexMetadataVerifier indexMetadataVerifier;
    private final IndicesService indicesService;
    private final ShardLimitValidator shardLimitValidator;
    private final ThreadPool threadPool;
    private final NodeClient client;
    private final ActiveShardsObserver activeShardsObserver;

    @Inject
    public MetadataIndexStateService(ClusterService clusterService, AllocationService allocationService, IndexMetadataVerifier indexMetadataVerifier, IndicesService indicesService, ShardLimitValidator shardLimitValidator, NodeClient client, ThreadPool threadPool) {
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.threadPool = threadPool;
        this.client = client;
        this.indexMetadataVerifier = indexMetadataVerifier;
        this.shardLimitValidator = shardLimitValidator;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
    }

    public void closeIndices(CloseIndexClusterStateUpdateRequest request, ActionListener<CloseIndexResponse> listener) {
        Object[] concreteIndices = request.indices();
        if (concreteIndices == null || concreteIndices.length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        this.clusterService.submitStateUpdateTask("add-block-index-to-close " + Arrays.toString(concreteIndices), new ClusterStateUpdateTask(Priority.URGENT, request.masterNodeTimeout(), (Index[])concreteIndices, listener, request){
            private final Map<Index, ClusterBlock> blockedIndices;
            final /* synthetic */ Index[] val$concreteIndices;
            final /* synthetic */ ActionListener val$listener;
            final /* synthetic */ CloseIndexClusterStateUpdateRequest val$request;
            {
                this.val$concreteIndices = indexArray;
                this.val$listener = actionListener;
                this.val$request = closeIndexClusterStateUpdateRequest;
                super(priority, timeout);
                this.blockedIndices = new HashMap<Index, ClusterBlock>();
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return MetadataIndexStateService.addIndexClosedBlocks(this.val$concreteIndices, this.blockedIndices, currentState);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (oldState == newState) {
                    assert (this.blockedIndices.isEmpty()) : "List of blocked indices is not empty but cluster state wasn't changed";
                    this.val$listener.onResponse(new CloseIndexResponse(true, false, Collections.emptyList()));
                } else {
                    assert (!this.blockedIndices.isEmpty()) : "List of blocked indices is empty but cluster state was changed";
                    MetadataIndexStateService.this.threadPool.executor("management").execute(new WaitForClosedBlocksApplied(this.blockedIndices, this.val$request, ActionListener.wrap(verifyResults -> MetadataIndexStateService.this.clusterService.submitStateUpdateTask("close-indices", new ClusterStateUpdateTask(Priority.URGENT, (Map)verifyResults, this.val$listener, this.val$request){
                        private final List<CloseIndexResponse.IndexResult> indices;
                        final /* synthetic */ Map val$verifyResults;
                        final /* synthetic */ ActionListener val$listener;
                        final /* synthetic */ CloseIndexClusterStateUpdateRequest val$request;
                        {
                            this.val$verifyResults = map;
                            this.val$listener = actionListener;
                            this.val$request = closeIndexClusterStateUpdateRequest;
                            super(priority);
                            this.indices = new ArrayList<CloseIndexResponse.IndexResult>();
                        }

                        @Override
                        public ClusterState execute(ClusterState currentState) throws Exception {
                            Tuple<ClusterState, Collection<CloseIndexResponse.IndexResult>> closingResult = MetadataIndexStateService.closeRoutingTable(currentState, blockedIndices, this.val$verifyResults);
                            assert (this.val$verifyResults.size() == ((Collection)closingResult.v2()).size());
                            this.indices.addAll((Collection)closingResult.v2());
                            return MetadataIndexStateService.this.allocationService.reroute((ClusterState)closingResult.v1(), "indices closed");
                        }

                        @Override
                        public void onFailure(String source, Exception e) {
                            this.val$listener.onFailure(e);
                        }

                        @Override
                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            boolean acknowledged = this.indices.stream().noneMatch(CloseIndexResponse.IndexResult::hasFailures);
                            String[] waitForIndices = (String[])this.indices.stream().filter(result -> !result.hasFailures()).filter(result -> newState.routingTable().hasIndex(result.getIndex())).map(result -> result.getIndex().getName()).toArray(String[]::new);
                            if (waitForIndices.length > 0) {
                                MetadataIndexStateService.this.activeShardsObserver.waitForActiveShards(waitForIndices, this.val$request.waitForActiveShards(), this.val$request.ackTimeout(), shardsAcknowledged -> {
                                    if (!shardsAcknowledged.booleanValue()) {
                                        logger.debug("[{}] indices closed, but the operation timed out while waiting for enough shards to be started.", (Object)Arrays.toString(waitForIndices));
                                    }
                                    boolean shardsAcked = acknowledged ? shardsAcknowledged : false;
                                    this.val$listener.onResponse(new CloseIndexResponse(acknowledged, shardsAcked, this.indices));
                                }, this.val$listener::onFailure);
                            } else {
                                this.val$listener.onResponse(new CloseIndexResponse(acknowledged, false, this.indices));
                            }
                        }
                    }), this.val$listener::onFailure)));
                }
            }

            @Override
            public void onFailure(String source, Exception e) {
                this.val$listener.onFailure(e);
            }
        });
    }

    static ClusterState addIndexClosedBlocks(Index[] indices, Map<Index, ClusterBlock> blockedIndices, ClusterState currentState) {
        Metadata.Builder metadata = Metadata.builder(currentState.metadata());
        HashSet<Index> indicesToClose = new HashSet<Index>();
        for (Index index : indices) {
            IndexMetadata indexMetadata = metadata.getSafe(index);
            if (indexMetadata.getState() != IndexMetadata.State.CLOSE) {
                indicesToClose.add(index);
                continue;
            }
            logger.debug("index {} is already closed, ignoring", (Object)index);
            assert (currentState.blocks().hasIndexBlock(index.getName(), INDEX_CLOSED_BLOCK));
        }
        if (indicesToClose.isEmpty()) {
            return currentState;
        }
        Set<Index> restoringIndices = RestoreService.restoringIndices(currentState, indicesToClose);
        if (!restoringIndices.isEmpty()) {
            throw new IllegalArgumentException("Cannot close indices that are being restored: " + restoringIndices);
        }
        Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(currentState, indicesToClose);
        if (!snapshottingIndices.isEmpty()) {
            throw new SnapshotInProgressException("Cannot close indices that are being snapshotted: " + snapshottingIndices + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder routingTable = RoutingTable.builder(currentState.routingTable());
        for (Index index : indicesToClose) {
            ClusterBlock indexBlock = null;
            Set<ClusterBlock> clusterBlocks = currentState.blocks().indices().get(index.getName());
            if (clusterBlocks != null) {
                for (ClusterBlock clusterBlock : clusterBlocks) {
                    if (clusterBlock.id() != 4) continue;
                    indexBlock = clusterBlock;
                    break;
                }
            }
            if (indexBlock == null) {
                indexBlock = MetadataIndexStateService.createIndexClosingBlock();
            }
            assert (Strings.hasLength(indexBlock.uuid())) : "Closing block should have a UUID";
            blocks.addIndexBlock(index.getName(), indexBlock);
            blockedIndices.put(index, indexBlock);
        }
        logger.info(() -> new ParameterizedMessage("closing indices {}", (Object)blockedIndices.keySet().stream().map(Object::toString).collect(Collectors.joining(","))));
        return ClusterState.builder(currentState).blocks(blocks).metadata(metadata).routingTable(routingTable.build()).build();
    }

    static Tuple<ClusterState, Map<Index, ClusterBlock>> addIndexBlock(Index[] indices, ClusterState currentState, IndexMetadata.APIBlock block) {
        Metadata.Builder metadata = Metadata.builder(currentState.metadata());
        HashSet<Index> indicesToAddBlock = new HashSet<Index>();
        for (Index index : indices) {
            metadata.getSafe(index);
            if (currentState.blocks().hasIndexBlock(index.getName(), block.block)) {
                logger.debug("index {} already has block {}, ignoring", (Object)index, (Object)block.block);
                continue;
            }
            indicesToAddBlock.add(index);
        }
        if (indicesToAddBlock.isEmpty()) {
            return Tuple.tuple((Object)currentState, Collections.emptyMap());
        }
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder routingTable = RoutingTable.builder(currentState.routingTable());
        HashMap<Index, ClusterBlock> blockedIndices = new HashMap<Index, ClusterBlock>();
        for (Index index : indicesToAddBlock) {
            ClusterBlock indexBlock = null;
            Set<ClusterBlock> clusterBlocks = currentState.blocks().indices().get(index.getName());
            if (clusterBlocks != null) {
                for (ClusterBlock clusterBlock : clusterBlocks) {
                    if (clusterBlock.id() != block.block.id()) continue;
                    indexBlock = clusterBlock;
                    break;
                }
            }
            if (indexBlock == null) {
                indexBlock = MetadataIndexStateService.createUUIDBasedBlock(block.block);
            }
            assert (Strings.hasLength(indexBlock.uuid())) : "Block should have a UUID";
            blocks.addIndexBlock(index.getName(), indexBlock);
            blockedIndices.put(index, indexBlock);
            IndexMetadata indexMetadata = metadata.getSafe(index);
            if (block.setting().get(indexMetadata.getSettings()).booleanValue()) continue;
            Settings updatedSettings = Settings.builder().put(indexMetadata.getSettings()).put(block.settingName(), true).build();
            metadata.put(IndexMetadata.builder(indexMetadata).settings(updatedSettings).settingsVersion(indexMetadata.getSettingsVersion() + 1L));
        }
        logger.info("adding block {} to indices {}", (Object)block.name, blockedIndices.keySet().stream().map(Object::toString).collect(Collectors.toList()));
        return Tuple.tuple((Object)ClusterState.builder(currentState).blocks(blocks).metadata(metadata).routingTable(routingTable.build()).build(), blockedIndices);
    }

    public void addIndexBlock(AddIndexBlockClusterStateUpdateRequest request, ActionListener<AddIndexBlockResponse> listener) {
        Object[] concreteIndices = request.indices();
        if (concreteIndices == null || concreteIndices.length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        Metadata metadata = this.clusterService.state().metadata();
        ArrayList<String> writeIndices = new ArrayList<String>();
        SortedMap<String, IndexAbstraction> lookup = metadata.getIndicesLookup();
        for (Index index : concreteIndices) {
            Index writeIndex;
            IndexAbstraction ia = (IndexAbstraction)lookup.get(index.getName());
            if (ia == null || ia.getParentDataStream() == null || !(writeIndex = metadata.index(ia.getParentDataStream().getWriteIndex()).getIndex()).equals(index)) continue;
            writeIndices.add(index.getName());
        }
        if (writeIndices.size() > 0) {
            throw new IllegalArgumentException("cannot add a block to the following data stream write indices [" + Strings.collectionToCommaDelimitedString(writeIndices) + "]");
        }
        this.clusterService.submitStateUpdateTask("add-index-block-[" + request.getBlock().name + "]-" + Arrays.toString(concreteIndices), new ClusterStateUpdateTask(Priority.URGENT, request.masterNodeTimeout(), (Index[])concreteIndices, request, listener){
            private Map<Index, ClusterBlock> blockedIndices;
            final /* synthetic */ Index[] val$concreteIndices;
            final /* synthetic */ AddIndexBlockClusterStateUpdateRequest val$request;
            final /* synthetic */ ActionListener val$listener;
            {
                this.val$concreteIndices = indexArray;
                this.val$request = addIndexBlockClusterStateUpdateRequest;
                this.val$listener = actionListener;
                super(priority, timeout);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Tuple<ClusterState, Map<Index, ClusterBlock>> tup = MetadataIndexStateService.addIndexBlock(this.val$concreteIndices, currentState, this.val$request.getBlock());
                this.blockedIndices = (Map)tup.v2();
                return (ClusterState)tup.v1();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (oldState == newState) {
                    assert (this.blockedIndices.isEmpty()) : "List of blocked indices is not empty but cluster state wasn't changed";
                    this.val$listener.onResponse(new AddIndexBlockResponse(true, false, Collections.emptyList()));
                } else {
                    assert (!this.blockedIndices.isEmpty()) : "List of blocked indices is empty but cluster state was changed";
                    MetadataIndexStateService.this.threadPool.executor("management").execute(new WaitForBlocksApplied(this.blockedIndices, this.val$request, ActionListener.wrap(verifyResults -> MetadataIndexStateService.this.clusterService.submitStateUpdateTask("finalize-index-block-[" + request.getBlock().name + "]-[" + this.blockedIndices.keySet().stream().map(Index::getName).collect(Collectors.joining(", ")) + "]", new ClusterStateUpdateTask(Priority.URGENT, (Map)verifyResults, this.val$request, this.val$listener){
                        private final List<AddIndexBlockResponse.AddBlockResult> indices;
                        final /* synthetic */ Map val$verifyResults;
                        final /* synthetic */ AddIndexBlockClusterStateUpdateRequest val$request;
                        final /* synthetic */ ActionListener val$listener;
                        {
                            this.val$verifyResults = map;
                            this.val$request = addIndexBlockClusterStateUpdateRequest;
                            this.val$listener = actionListener;
                            super(priority);
                            this.indices = new ArrayList<AddIndexBlockResponse.AddBlockResult>();
                        }

                        @Override
                        public ClusterState execute(ClusterState currentState) throws Exception {
                            Tuple<ClusterState, Collection<AddIndexBlockResponse.AddBlockResult>> addBlockResult = MetadataIndexStateService.finalizeBlock(currentState, blockedIndices, this.val$verifyResults, this.val$request.getBlock());
                            assert (this.val$verifyResults.size() == ((Collection)addBlockResult.v2()).size());
                            this.indices.addAll((Collection)addBlockResult.v2());
                            return (ClusterState)addBlockResult.v1();
                        }

                        @Override
                        public void onFailure(String source, Exception e) {
                            this.val$listener.onFailure(e);
                        }

                        @Override
                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            boolean acknowledged = this.indices.stream().noneMatch(AddIndexBlockResponse.AddBlockResult::hasFailures);
                            this.val$listener.onResponse(new AddIndexBlockResponse(acknowledged, acknowledged, this.indices));
                        }
                    }), this.val$listener::onFailure)));
                }
            }

            @Override
            public void onFailure(String source, Exception e) {
                this.val$listener.onFailure(e);
            }
        });
    }

    static Tuple<ClusterState, Collection<CloseIndexResponse.IndexResult>> closeRoutingTable(ClusterState currentState, Map<Index, ClusterBlock> blockedIndices, Map<Index, CloseIndexResponse.IndexResult> verifyResult) {
        Metadata.Builder metadata = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder routingTable = RoutingTable.builder(currentState.routingTable());
        HashSet<String> closedIndices = new HashSet<String>();
        HashMap<Index, CloseIndexResponse.IndexResult> closingResults = new HashMap<Index, CloseIndexResponse.IndexResult>(verifyResult);
        for (Map.Entry<Index, CloseIndexResponse.IndexResult> result : verifyResult.entrySet()) {
            Index index = result.getKey();
            boolean acknowledged = !result.getValue().hasFailures();
            try {
                if (!acknowledged) {
                    logger.debug("verification of shards before closing {} failed [{}]", (Object)index, result);
                    continue;
                }
                IndexMetadata indexMetadata = metadata.getSafe(index);
                if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                    logger.debug("verification of shards before closing {} succeeded but index is already closed", (Object)index);
                    assert (currentState.blocks().hasIndexBlock(index.getName(), INDEX_CLOSED_BLOCK));
                    continue;
                }
                ClusterBlock closingBlock = blockedIndices.get(index);
                assert (closingBlock != null);
                if (!currentState.blocks().hasIndexBlock(index.getName(), closingBlock)) {
                    closingResults.put(result.getKey(), new CloseIndexResponse.IndexResult(result.getKey(), new IllegalStateException("verification of shards before closing " + index + " succeeded but block has been removed in the meantime")));
                    logger.debug("verification of shards before closing {} succeeded but block has been removed in the meantime", (Object)index);
                    continue;
                }
                Set<Index> restoringIndices = RestoreService.restoringIndices(currentState, Collections.singleton(index));
                if (!restoringIndices.isEmpty()) {
                    closingResults.put(result.getKey(), new CloseIndexResponse.IndexResult(result.getKey(), new IllegalStateException("verification of shards before closing " + index + " succeeded but index is being restored in the meantime")));
                    logger.debug("verification of shards before closing {} succeeded but index is being restored in the meantime", (Object)index);
                    continue;
                }
                Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(currentState, Collections.singleton(index));
                if (!snapshottingIndices.isEmpty()) {
                    closingResults.put(result.getKey(), new CloseIndexResponse.IndexResult(result.getKey(), new IllegalStateException("verification of shards before closing " + index + " succeeded but index is being snapshot in the meantime")));
                    logger.debug("verification of shards before closing {} succeeded but index is being snapshot in the meantime", (Object)index);
                    continue;
                }
                blocks.removeIndexBlockWithId(index.getName(), 4);
                blocks.addIndexBlock(index.getName(), INDEX_CLOSED_BLOCK);
                IndexMetadata.Builder updatedMetadata = IndexMetadata.builder(indexMetadata).state(IndexMetadata.State.CLOSE);
                metadata.put(updatedMetadata.timestampRange(IndexLongFieldRange.NO_SHARDS).settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(Settings.builder().put(indexMetadata.getSettings()).put(VERIFIED_BEFORE_CLOSE_SETTING.getKey(), true)));
                routingTable.addAsFromOpenToClose(metadata.getSafe(index));
                logger.debug("closing index {} succeeded", (Object)index);
                closedIndices.add(index.getName());
            }
            catch (IndexNotFoundException e) {
                logger.debug("index {} has been deleted since it was blocked before closing, ignoring", (Object)index);
            }
        }
        logger.info("completed closing of indices {}", closedIndices);
        return Tuple.tuple((Object)ClusterState.builder(currentState).blocks(blocks).metadata(metadata).routingTable(routingTable.build()).build(), closingResults.values());
    }

    public void openIndex(OpenIndexClusterStateUpdateRequest request, ActionListener<ShardsAcknowledgedResponse> listener) {
        this.onlyOpenIndex(request, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                String[] indexNames = (String[])Arrays.stream(request.indices()).map(Index::getName).toArray(String[]::new);
                this.activeShardsObserver.waitForActiveShards(indexNames, request.waitForActiveShards(), request.ackTimeout(), shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        logger.debug("[{}] indices opened, but the operation timed out while waiting for enough shards to be started.", (Object)Arrays.toString(indexNames));
                    }
                    listener.onResponse(ShardsAcknowledgedResponse.of(true, shardsAcknowledged));
                }, listener::onFailure);
            } else {
                listener.onResponse(ShardsAcknowledgedResponse.NOT_ACKNOWLEDGED);
            }
        }, listener::onFailure));
    }

    private void onlyOpenIndex(final OpenIndexClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) {
        if (request.indices() == null || request.indices().length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        final String indicesAsString = Arrays.toString(request.indices());
        this.clusterService.submitStateUpdateTask("open-indices " + indicesAsString, new AckedClusterStateUpdateTask(Priority.URGENT, request, listener){

            @Override
            public ClusterState execute(ClusterState currentState) {
                ClusterState updatedState = MetadataIndexStateService.this.openIndices(request.indices(), currentState);
                return MetadataIndexStateService.this.allocationService.reroute(updatedState, "indices opened [" + indicesAsString + "]");
            }
        });
    }

    ClusterState openIndices(Index[] indices, ClusterState currentState) {
        ArrayList<IndexMetadata> indicesToOpen = new ArrayList<IndexMetadata>();
        for (Index index : indices) {
            IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
            if (indexMetadata.getState() != IndexMetadata.State.OPEN) {
                indicesToOpen.add(indexMetadata);
                continue;
            }
            if (!currentState.blocks().hasIndexBlockWithId(index.getName(), 4)) continue;
            indicesToOpen.add(indexMetadata);
        }
        this.shardLimitValidator.validateShardLimit(currentState, indices);
        if (indicesToOpen.isEmpty()) {
            return currentState;
        }
        logger.info(() -> new ParameterizedMessage("opening indices [{}]", (Object)String.join((CharSequence)",", indicesToOpen.stream().map(i -> i.getIndex().toString())::iterator)));
        Metadata.Builder metadata = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        Version minIndexCompatibilityVersion = currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
        for (IndexMetadata indexMetadata : indicesToOpen) {
            Index index = indexMetadata.getIndex();
            if (indexMetadata.getState() != IndexMetadata.State.OPEN) {
                Settings.Builder updatedSettings = Settings.builder().put(indexMetadata.getSettings());
                updatedSettings.remove(VERIFIED_BEFORE_CLOSE_SETTING.getKey());
                IndexMetadata newIndexMetadata = IndexMetadata.builder(indexMetadata).state(IndexMetadata.State.OPEN).settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(updatedSettings).timestampRange(IndexLongFieldRange.NO_SHARDS).build();
                newIndexMetadata = this.indexMetadataVerifier.verifyIndexMetadata(newIndexMetadata, minIndexCompatibilityVersion);
                try {
                    this.indicesService.verifyIndexMetadata(newIndexMetadata, newIndexMetadata);
                }
                catch (Exception e) {
                    throw new ElasticsearchException("Failed to verify index " + index, (Throwable)e, new Object[0]);
                }
                metadata.put(newIndexMetadata, true);
            }
            blocks.removeIndexBlockWithId(index.getName(), 4);
        }
        ClusterState updatedState = ClusterState.builder(currentState).metadata(metadata).blocks(blocks).build();
        RoutingTable.Builder routingTable = RoutingTable.builder(updatedState.routingTable());
        for (IndexMetadata previousIndexMetadata : indicesToOpen) {
            if (previousIndexMetadata.getState() == IndexMetadata.State.OPEN) continue;
            routingTable.addAsFromCloseToOpen(updatedState.metadata().getIndexSafe(previousIndexMetadata.getIndex()));
        }
        return ClusterState.builder(updatedState).routingTable(routingTable.build()).build();
    }

    static Tuple<ClusterState, Collection<AddIndexBlockResponse.AddBlockResult>> finalizeBlock(ClusterState currentState, Map<Index, ClusterBlock> blockedIndices, Map<Index, AddIndexBlockResponse.AddBlockResult> verifyResult, IndexMetadata.APIBlock block) {
        Metadata.Builder metadata = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder routingTable = RoutingTable.builder(currentState.routingTable());
        HashSet<String> effectivelyBlockedIndices = new HashSet<String>();
        HashMap<Index, AddIndexBlockResponse.AddBlockResult> blockingResults = new HashMap<Index, AddIndexBlockResponse.AddBlockResult>(verifyResult);
        for (Map.Entry<Index, AddIndexBlockResponse.AddBlockResult> result : verifyResult.entrySet()) {
            Index index = result.getKey();
            boolean acknowledged = !result.getValue().hasFailures();
            try {
                if (!acknowledged) {
                    logger.debug("verification of shards before blocking {} failed [{}]", (Object)index, result);
                    continue;
                }
                ClusterBlock tempBlock = blockedIndices.get(index);
                assert (tempBlock != null);
                assert (tempBlock.uuid() != null);
                ClusterBlock currentBlock = currentState.blocks().getIndexBlockWithId(index.getName(), tempBlock.id());
                if (currentBlock != null && currentBlock.equals(block.block)) {
                    logger.debug("verification of shards for {} succeeded, but block finalization already occurred (possibly for another block) [{}]", (Object)index, result);
                    continue;
                }
                if (currentBlock == null || !currentBlock.equals(tempBlock)) {
                    blockingResults.put(result.getKey(), new AddIndexBlockResponse.AddBlockResult(result.getKey(), new IllegalStateException("verification of shards before blocking " + index + " succeeded but block has been removed in the meantime")));
                    logger.debug("verification of shards before blocking {} succeeded but block has been removed in the meantime", (Object)index);
                    continue;
                }
                assert (currentBlock != null && currentBlock.equals(tempBlock) && currentBlock.id() == block.block.id());
                blocks.removeIndexBlockWithId(index.getName(), tempBlock.id());
                blocks.addIndexBlock(index.getName(), block.block);
                logger.debug("add block {} to index {} succeeded", (Object)block.block, (Object)index);
                effectivelyBlockedIndices.add(index.getName());
            }
            catch (IndexNotFoundException e) {
                logger.debug("index {} has been deleted since blocking it started, ignoring", (Object)index);
            }
        }
        logger.info("completed adding block {} to indices {}", (Object)block.name, effectivelyBlockedIndices);
        return Tuple.tuple((Object)ClusterState.builder(currentState).blocks(blocks).metadata(metadata).routingTable(routingTable.build()).build(), blockingResults.values());
    }

    public static ClusterBlock createIndexClosingBlock() {
        return new ClusterBlock(4, UUIDs.randomBase64UUID(), "index preparing to close. Reopen the index to allow writes again or retry closing the index to fully close the index.", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
    }

    public static boolean isIndexVerifiedBeforeClosed(IndexMetadata indexMetadata) {
        return indexMetadata.getState() == IndexMetadata.State.CLOSE && VERIFIED_BEFORE_CLOSE_SETTING.exists(indexMetadata.getSettings()) && VERIFIED_BEFORE_CLOSE_SETTING.get(indexMetadata.getSettings()) != false;
    }

    public static ClusterBlock createUUIDBasedBlock(ClusterBlock clusterBlock) {
        assert (clusterBlock.uuid() == null) : "no UUID expected on source block";
        return new ClusterBlock(clusterBlock.id(), UUIDs.randomBase64UUID(), "moving to block " + clusterBlock.description(), clusterBlock.retryable(), clusterBlock.disableStatePersistence(), clusterBlock.isAllowReleaseResources(), clusterBlock.status(), clusterBlock.levels());
    }

    class WaitForBlocksApplied
    extends ActionRunnable<Map<Index, AddIndexBlockResponse.AddBlockResult>> {
        private final Map<Index, ClusterBlock> blockedIndices;
        private final AddIndexBlockClusterStateUpdateRequest request;

        private WaitForBlocksApplied(Map<Index, ClusterBlock> blockedIndices, AddIndexBlockClusterStateUpdateRequest request, ActionListener<Map<Index, AddIndexBlockResponse.AddBlockResult>> listener) {
            super(listener);
            if (blockedIndices == null || blockedIndices.isEmpty()) {
                throw new IllegalArgumentException("Cannot wait for blocks to be applied, list of blocked indices is empty or null");
            }
            this.blockedIndices = blockedIndices;
            this.request = request;
        }

        @Override
        protected void doRun() throws Exception {
            ConcurrentMap results = ConcurrentCollections.newConcurrentMap();
            CountDown countDown = new CountDown(this.blockedIndices.size());
            ClusterState state = MetadataIndexStateService.this.clusterService.state();
            this.blockedIndices.forEach((index, block) -> this.waitForShardsReady((Index)index, (ClusterBlock)block, state, response -> {
                results.put(index, response);
                if (countDown.countDown()) {
                    this.listener.onResponse(Collections.unmodifiableMap(results));
                }
            }));
        }

        private void waitForShardsReady(final Index index, ClusterBlock clusterBlock, ClusterState state, final Consumer<AddIndexBlockResponse.AddBlockResult> onResponse) {
            IndexMetadata indexMetadata = state.metadata().index(index);
            if (indexMetadata == null) {
                logger.debug("index {} has since been deleted, ignoring", (Object)index);
                onResponse.accept(new AddIndexBlockResponse.AddBlockResult(index));
                return;
            }
            IndexRoutingTable indexRoutingTable = state.routingTable().index(index);
            if (indexRoutingTable == null || indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                logger.debug("index {} is closed, no need to wait for shards, ignoring", (Object)index);
                onResponse.accept(new AddIndexBlockResponse.AddBlockResult(index));
                return;
            }
            ImmutableOpenIntMap<IndexShardRoutingTable> shards = indexRoutingTable.getShards();
            final AtomicArray results = new AtomicArray(shards.size());
            final CountDown countDown = new CountDown(shards.size());
            for (Map.Entry<Integer, IndexShardRoutingTable> shard : shards.entrySet()) {
                IndexShardRoutingTable shardRoutingTable = shard.getValue();
                final int shardId = shardRoutingTable.shardId().id();
                this.sendVerifyShardBlockRequest(shardRoutingTable, clusterBlock, (ActionListener<ReplicationResponse>)new NotifyOnceListener<ReplicationResponse>(){

                    @Override
                    public void innerOnResponse(ReplicationResponse replicationResponse) {
                        AddIndexBlockResponse.AddBlockShardResult.Failure[] failures = (AddIndexBlockResponse.AddBlockShardResult.Failure[])Arrays.stream(replicationResponse.getShardInfo().getFailures()).map((? super T f) -> new AddIndexBlockResponse.AddBlockShardResult.Failure(f.index(), f.shardId(), f.getCause(), f.nodeId())).toArray(AddIndexBlockResponse.AddBlockShardResult.Failure[]::new);
                        results.setOnce(shardId, new AddIndexBlockResponse.AddBlockShardResult(shardId, failures));
                        this.processIfFinished();
                    }

                    @Override
                    public void innerOnFailure(Exception e) {
                        AddIndexBlockResponse.AddBlockShardResult.Failure failure = new AddIndexBlockResponse.AddBlockShardResult.Failure(index.getName(), shardId, e);
                        results.setOnce(shardId, new AddIndexBlockResponse.AddBlockShardResult(shardId, new AddIndexBlockResponse.AddBlockShardResult.Failure[]{failure}));
                        this.processIfFinished();
                    }

                    private void processIfFinished() {
                        if (countDown.countDown()) {
                            AddIndexBlockResponse.AddBlockResult result = new AddIndexBlockResponse.AddBlockResult(index, results.toArray(new AddIndexBlockResponse.AddBlockShardResult[results.length()]));
                            logger.debug("result of applying block to index {}: {}", (Object)index, (Object)result);
                            onResponse.accept(result);
                        }
                    }
                });
            }
        }

        private void sendVerifyShardBlockRequest(IndexShardRoutingTable shardRoutingTable, ClusterBlock block, ActionListener<ReplicationResponse> listener) {
            ShardId shardId = shardRoutingTable.shardId();
            if (shardRoutingTable.primaryShard().unassigned()) {
                logger.debug("primary shard {} is unassigned, ignoring", (Object)shardId);
                ReplicationResponse response = new ReplicationResponse();
                response.setShardInfo(new ReplicationResponse.ShardInfo(shardRoutingTable.size(), shardRoutingTable.size(), new ReplicationResponse.ShardInfo.Failure[0]));
                listener.onResponse(response);
                return;
            }
            TaskId parentTaskId = new TaskId(MetadataIndexStateService.this.clusterService.localNode().getId(), this.request.taskId());
            TransportVerifyShardIndexBlockAction.ShardRequest shardRequest = new TransportVerifyShardIndexBlockAction.ShardRequest(shardId, block, parentTaskId);
            if (this.request.ackTimeout() != null) {
                shardRequest.timeout(this.request.ackTimeout());
            }
            MetadataIndexStateService.this.client.executeLocally(TransportVerifyShardIndexBlockAction.TYPE, shardRequest, listener);
        }
    }

    class WaitForClosedBlocksApplied
    extends ActionRunnable<Map<Index, CloseIndexResponse.IndexResult>> {
        private final Map<Index, ClusterBlock> blockedIndices;
        private final CloseIndexClusterStateUpdateRequest request;

        private WaitForClosedBlocksApplied(Map<Index, ClusterBlock> blockedIndices, CloseIndexClusterStateUpdateRequest request, ActionListener<Map<Index, CloseIndexResponse.IndexResult>> listener) {
            super(listener);
            if (blockedIndices == null || blockedIndices.isEmpty()) {
                throw new IllegalArgumentException("Cannot wait for closed blocks to be applied, list of blocked indices is empty or null");
            }
            this.blockedIndices = blockedIndices;
            this.request = request;
        }

        @Override
        protected void doRun() throws Exception {
            ConcurrentMap results = ConcurrentCollections.newConcurrentMap();
            CountDown countDown = new CountDown(this.blockedIndices.size());
            ClusterState state = MetadataIndexStateService.this.clusterService.state();
            this.blockedIndices.forEach((index, block) -> this.waitForShardsReadyForClosing((Index)index, (ClusterBlock)block, state, response -> {
                results.put(index, response);
                if (countDown.countDown()) {
                    this.listener.onResponse(Collections.unmodifiableMap(results));
                }
            }));
        }

        private void waitForShardsReadyForClosing(final Index index, ClusterBlock closingBlock, ClusterState state, final Consumer<CloseIndexResponse.IndexResult> onResponse) {
            IndexMetadata indexMetadata = state.metadata().index(index);
            if (indexMetadata == null) {
                logger.debug("index {} has been blocked before closing and is now deleted, ignoring", (Object)index);
                onResponse.accept(new CloseIndexResponse.IndexResult(index));
                return;
            }
            IndexRoutingTable indexRoutingTable = state.routingTable().index(index);
            if (indexRoutingTable == null || indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                assert (state.blocks().hasIndexBlock(index.getName(), INDEX_CLOSED_BLOCK));
                logger.debug("index {} has been blocked before closing and is already closed, ignoring", (Object)index);
                onResponse.accept(new CloseIndexResponse.IndexResult(index));
                return;
            }
            ImmutableOpenIntMap<IndexShardRoutingTable> shards = indexRoutingTable.getShards();
            final AtomicArray results = new AtomicArray(shards.size());
            final CountDown countDown = new CountDown(shards.size());
            for (Map.Entry<Integer, IndexShardRoutingTable> shard : shards.entrySet()) {
                IndexShardRoutingTable shardRoutingTable = shard.getValue();
                final int shardId = shardRoutingTable.shardId().id();
                this.sendVerifyShardBeforeCloseRequest(shardRoutingTable, closingBlock, (ActionListener<ReplicationResponse>)new NotifyOnceListener<ReplicationResponse>(){

                    @Override
                    public void innerOnResponse(ReplicationResponse replicationResponse) {
                        CloseIndexResponse.ShardResult.Failure[] failures = (CloseIndexResponse.ShardResult.Failure[])Arrays.stream(replicationResponse.getShardInfo().getFailures()).map((? super T f) -> new CloseIndexResponse.ShardResult.Failure(f.index(), f.shardId(), f.getCause(), f.nodeId())).toArray(CloseIndexResponse.ShardResult.Failure[]::new);
                        results.setOnce(shardId, new CloseIndexResponse.ShardResult(shardId, failures));
                        this.processIfFinished();
                    }

                    @Override
                    public void innerOnFailure(Exception e) {
                        CloseIndexResponse.ShardResult.Failure failure = new CloseIndexResponse.ShardResult.Failure(index.getName(), shardId, e);
                        results.setOnce(shardId, new CloseIndexResponse.ShardResult(shardId, new CloseIndexResponse.ShardResult.Failure[]{failure}));
                        this.processIfFinished();
                    }

                    private void processIfFinished() {
                        if (countDown.countDown()) {
                            onResponse.accept(new CloseIndexResponse.IndexResult(index, results.toArray(new CloseIndexResponse.ShardResult[results.length()])));
                        }
                    }
                });
            }
        }

        private void sendVerifyShardBeforeCloseRequest(IndexShardRoutingTable shardRoutingTable, ClusterBlock closingBlock, ActionListener<ReplicationResponse> listener) {
            ShardId shardId = shardRoutingTable.shardId();
            if (shardRoutingTable.primaryShard().unassigned()) {
                logger.debug("primary shard {} is unassigned, ignoring", (Object)shardId);
                ReplicationResponse response = new ReplicationResponse();
                response.setShardInfo(new ReplicationResponse.ShardInfo(shardRoutingTable.size(), shardRoutingTable.size(), new ReplicationResponse.ShardInfo.Failure[0]));
                listener.onResponse(response);
                return;
            }
            TaskId parentTaskId = new TaskId(MetadataIndexStateService.this.clusterService.localNode().getId(), this.request.taskId());
            TransportVerifyShardBeforeCloseAction.ShardRequest shardRequest = new TransportVerifyShardBeforeCloseAction.ShardRequest(shardId, closingBlock, true, parentTaskId);
            if (this.request.ackTimeout() != null) {
                shardRequest.timeout(this.request.ackTimeout());
            }
            MetadataIndexStateService.this.client.executeLocally(TransportVerifyShardBeforeCloseAction.TYPE, shardRequest, listener.delegateFailure((delegate, replicationResponse) -> {
                TransportVerifyShardBeforeCloseAction.ShardRequest req = new TransportVerifyShardBeforeCloseAction.ShardRequest(shardId, closingBlock, false, parentTaskId);
                if (this.request.ackTimeout() != null) {
                    req.timeout(this.request.ackTimeout());
                }
                MetadataIndexStateService.this.client.executeLocally(TransportVerifyShardBeforeCloseAction.TYPE, req, delegate);
            }));
        }
    }
}

