/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.Assertions;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.rollover.RolloverInfo;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.AutoExpandReplicas;
import org.elasticsearch.cluster.metadata.DiffableStringMap;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;

public class IndexMetadata
implements Diffable<IndexMetadata>,
ToXContentFragment {
    public static final ClusterBlock INDEX_READ_ONLY_BLOCK = new ClusterBlock(5, "index read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock INDEX_READ_BLOCK = new ClusterBlock(7, "index read (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.READ));
    public static final ClusterBlock INDEX_WRITE_BLOCK = new ClusterBlock(8, "index write (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
    public static final ClusterBlock INDEX_METADATA_BLOCK = new ClusterBlock(9, "index metadata (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.METADATA_WRITE, ClusterBlockLevel.METADATA_READ));
    public static final ClusterBlock INDEX_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(12, "disk usage exceeded flood-stage watermark, index has read-only-allow-delete block", false, false, true, RestStatus.TOO_MANY_REQUESTS, EnumSet.of(ClusterBlockLevel.METADATA_WRITE, ClusterBlockLevel.WRITE));
    public static final String INDEX_SETTING_PREFIX = "index.";
    public static final String SETTING_NUMBER_OF_SHARDS = "index.number_of_shards";
    public static final Setting<Integer> INDEX_NUMBER_OF_SHARDS_SETTING = IndexMetadata.buildNumberOfShardsSetting();
    public static final String SETTING_NUMBER_OF_REPLICAS = "index.number_of_replicas";
    public static final Setting<Integer> INDEX_NUMBER_OF_REPLICAS_SETTING = Setting.intSetting("index.number_of_replicas", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_ROUTING_PARTITION_SIZE = "index.routing_partition_size";
    public static final Setting<Integer> INDEX_ROUTING_PARTITION_SIZE_SETTING = Setting.intSetting("index.routing_partition_size", 1, 1, Setting.Property.Final, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING = Setting.intSetting("index.number_of_routing_shards", INDEX_NUMBER_OF_SHARDS_SETTING, 1, new Setting.Validator<Integer>(){

        @Override
        public void validate(Integer value) {
        }

        @Override
        public void validate(Integer numRoutingShards, Map<Setting<?>, Object> settings) {
            int numShards = (Integer)settings.get(INDEX_NUMBER_OF_SHARDS_SETTING);
            if (numRoutingShards < numShards) {
                throw new IllegalArgumentException("index.number_of_routing_shards [" + numRoutingShards + "] must be >= index.number_of_shards [" + numShards + "]");
            }
            IndexMetadata.getRoutingFactor(numShards, numRoutingShards);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Integer>> settings = List.of(INDEX_NUMBER_OF_SHARDS_SETTING);
            return settings.iterator();
        }
    }, Setting.Property.IndexScope);
    public static final String SETTING_AUTO_EXPAND_REPLICAS = "index.auto_expand_replicas";
    public static final Setting<AutoExpandReplicas> INDEX_AUTO_EXPAND_REPLICAS_SETTING = AutoExpandReplicas.SETTING;
    public static final String SETTING_READ_ONLY = APIBlock.READ_ONLY.settingName();
    public static final Setting<Boolean> INDEX_READ_ONLY_SETTING = APIBlock.READ_ONLY.setting();
    public static final String SETTING_BLOCKS_READ = APIBlock.READ.settingName();
    public static final Setting<Boolean> INDEX_BLOCKS_READ_SETTING = APIBlock.READ.setting();
    public static final String SETTING_BLOCKS_WRITE = APIBlock.WRITE.settingName();
    public static final Setting<Boolean> INDEX_BLOCKS_WRITE_SETTING = APIBlock.WRITE.setting();
    public static final String SETTING_BLOCKS_METADATA = APIBlock.METADATA.settingName();
    public static final Setting<Boolean> INDEX_BLOCKS_METADATA_SETTING = APIBlock.METADATA.setting();
    public static final String SETTING_READ_ONLY_ALLOW_DELETE = APIBlock.READ_ONLY_ALLOW_DELETE.settingName();
    public static final Setting<Boolean> INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING = APIBlock.READ_ONLY_ALLOW_DELETE.setting();
    public static final String SETTING_VERSION_CREATED = "index.version.created";
    public static final Setting<Version> SETTING_INDEX_VERSION_CREATED = Setting.versionSetting("index.version.created", Version.V_EMPTY, Setting.Property.IndexScope, Setting.Property.PrivateIndex);
    public static final String SETTING_VERSION_CREATED_STRING = "index.version.created_string";
    public static final String SETTING_CREATION_DATE = "index.creation_date";
    @Deprecated
    public static final String SETTING_VERSION_UPGRADED = "index.version.upgraded";
    @Deprecated
    public static final String SETTING_VERSION_UPGRADED_STRING = "index.version.upgraded_string";
    public static final String SETTING_INDEX_PROVIDED_NAME = "index.provided_name";
    public static final String SETTING_PRIORITY = "index.priority";
    public static final Setting<Integer> INDEX_PRIORITY_SETTING = Setting.intSetting("index.priority", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_CREATION_DATE_STRING = "index.creation_date_string";
    public static final String SETTING_INDEX_UUID = "index.uuid";
    public static final String SETTING_HISTORY_UUID = "index.history.uuid";
    public static final String SETTING_DATA_PATH = "index.data_path";
    public static final Setting<String> INDEX_DATA_PATH_SETTING = new Setting("index.data_path", "", Function.identity(), Setting.Property.IndexScope, Setting.Property.DeprecatedWarning);
    public static final String INDEX_UUID_NA_VALUE = "_na_";
    public static final String INDEX_ROUTING_REQUIRE_GROUP_PREFIX = "index.routing.allocation.require";
    public static final String INDEX_ROUTING_INCLUDE_GROUP_PREFIX = "index.routing.allocation.include";
    public static final String INDEX_ROUTING_EXCLUDE_GROUP_PREFIX = "index.routing.allocation.exclude";
    public static final Setting.AffixSetting<String> INDEX_ROUTING_REQUIRE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.require.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_INCLUDE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.include.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_EXCLUDE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.exclude.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.initial_recovery.", key -> Setting.simpleString(key, new Setting.Property[0]));
    public static final Setting<ActiveShardCount> SETTING_WAIT_FOR_ACTIVE_SHARDS = new Setting<ActiveShardCount>("index.write.wait_for_active_shards", "1", ActiveShardCount::parseString, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_INDEX_HIDDEN = "index.hidden";
    public static final Setting<Boolean> INDEX_HIDDEN_SETTING = Setting.boolSetting("index.hidden", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static final String INDEX_FORMAT = "index.format";
    public static final Setting<Integer> INDEX_FORMAT_SETTING = Setting.intSetting("index.format", 0, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<List<String>> INDEX_ROUTING_PATH = Setting.listSetting("index.routing_path", List.of(), Function.identity(), Setting.Property.IndexScope, Setting.Property.Final);
    public static final String KEY_IN_SYNC_ALLOCATIONS = "in_sync_allocations";
    static final String KEY_VERSION = "version";
    static final String KEY_MAPPING_VERSION = "mapping_version";
    static final String KEY_SETTINGS_VERSION = "settings_version";
    static final String KEY_ALIASES_VERSION = "aliases_version";
    static final String KEY_ROUTING_NUM_SHARDS = "routing_num_shards";
    static final String KEY_SETTINGS = "settings";
    static final String KEY_STATE = "state";
    static final String KEY_MAPPINGS = "mappings";
    static final String KEY_ALIASES = "aliases";
    static final String KEY_ROLLOVER_INFOS = "rollover_info";
    static final String KEY_SYSTEM = "system";
    static final String KEY_TIMESTAMP_RANGE = "timestamp_range";
    public static final String KEY_PRIMARY_TERMS = "primary_terms";
    public static final String INDEX_STATE_FILE_PREFIX = "state-";
    static final Version SYSTEM_INDEX_FLAG_ADDED = Version.V_7_10_0;
    private final int routingNumShards;
    private final int routingFactor;
    private final int routingPartitionSize;
    private final List<String> routingPaths;
    private final int numberOfShards;
    private final int numberOfReplicas;
    private final Index index;
    private final long version;
    private final long mappingVersion;
    private final long settingsVersion;
    private final long aliasesVersion;
    private final long[] primaryTerms;
    private final State state;
    private final ImmutableOpenMap<String, AliasMetadata> aliases;
    private final Settings settings;
    @Nullable
    private final MappingMetadata mapping;
    private final ImmutableOpenMap<String, DiffableStringMap> customData;
    private final ImmutableOpenIntMap<Set<String>> inSyncAllocationIds;
    private final transient int totalNumberOfShards;
    private final DiscoveryNodeFilters requireFilters;
    private final DiscoveryNodeFilters includeFilters;
    private final DiscoveryNodeFilters excludeFilters;
    private final DiscoveryNodeFilters initialRecoveryFilters;
    private final Version indexCreatedVersion;
    private final ActiveShardCount waitForActiveShards;
    private final ImmutableOpenMap<String, RolloverInfo> rolloverInfos;
    private final boolean isSystem;
    private final boolean isHidden;
    private final IndexLongFieldRange timestampRange;
    private final int priority;
    private final long creationDate;
    private final boolean ignoreDiskWatermarks;
    @Nullable
    private final List<String> tierPreference;
    public static final String INDEX_RESIZE_SOURCE_UUID_KEY = "index.resize.source.uuid";
    public static final String INDEX_RESIZE_SOURCE_NAME_KEY = "index.resize.source.name";
    public static final Setting<String> INDEX_RESIZE_SOURCE_UUID = Setting.simpleString("index.resize.source.uuid", new Setting.Property[0]);
    public static final Setting<String> INDEX_RESIZE_SOURCE_NAME = Setting.simpleString("index.resize.source.name", new Setting.Property[0]);
    public static final String INDEX_ROLLUP_SOURCE_UUID_KEY = "index.rollup.source.uuid";
    public static final String INDEX_ROLLUP_SOURCE_NAME_KEY = "index.rollup.source.name";
    public static final Setting<String> INDEX_ROLLUP_SOURCE_UUID = Setting.simpleString("index.rollup.source.uuid", Setting.Property.IndexScope, Setting.Property.PrivateIndex);
    public static final Setting<String> INDEX_ROLLUP_SOURCE_NAME = Setting.simpleString("index.rollup.source.name", Setting.Property.IndexScope, Setting.Property.PrivateIndex);
    private static final ToXContent.Params FORMAT_PARAMS;
    public static final MetadataStateFormat<IndexMetadata> FORMAT;

    static Setting<Integer> buildNumberOfShardsSetting() {
        int maxNumShards = Integer.parseInt(System.getProperty("es.index.max_number_of_shards", "1024"));
        if (maxNumShards < 1) {
            throw new IllegalArgumentException("es.index.max_number_of_shards must be > 0");
        }
        return Setting.intSetting(SETTING_NUMBER_OF_SHARDS, 1, 1, maxNumShards, Setting.Property.IndexScope, Setting.Property.Final);
    }

    private IndexMetadata(Index index, long version, long mappingVersion, long settingsVersion, long aliasesVersion, long[] primaryTerms, State state, int numberOfShards, int numberOfReplicas, Settings settings, MappingMetadata mapping, ImmutableOpenMap<String, AliasMetadata> aliases, ImmutableOpenMap<String, DiffableStringMap> customData, ImmutableOpenIntMap<Set<String>> inSyncAllocationIds, DiscoveryNodeFilters requireFilters, DiscoveryNodeFilters initialRecoveryFilters, DiscoveryNodeFilters includeFilters, DiscoveryNodeFilters excludeFilters, Version indexCreatedVersion, int routingNumShards, int routingPartitionSize, List<String> routingPaths, ActiveShardCount waitForActiveShards, ImmutableOpenMap<String, RolloverInfo> rolloverInfos, boolean isSystem, boolean isHidden, IndexLongFieldRange timestampRange, int priority, long creationDate, boolean ignoreDiskWatermarks, @Nullable List<String> tierPreference) {
        this.index = index;
        this.version = version;
        assert (mappingVersion >= 0L) : mappingVersion;
        this.mappingVersion = mappingVersion;
        assert (settingsVersion >= 0L) : settingsVersion;
        this.settingsVersion = settingsVersion;
        assert (aliasesVersion >= 0L) : aliasesVersion;
        this.aliasesVersion = aliasesVersion;
        this.primaryTerms = primaryTerms;
        assert (primaryTerms.length == numberOfShards);
        this.state = state;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.totalNumberOfShards = numberOfShards * (numberOfReplicas + 1);
        this.settings = settings;
        this.mapping = mapping;
        this.customData = customData;
        this.aliases = aliases;
        this.inSyncAllocationIds = inSyncAllocationIds;
        this.requireFilters = requireFilters;
        this.includeFilters = includeFilters;
        this.excludeFilters = excludeFilters;
        this.initialRecoveryFilters = initialRecoveryFilters;
        this.indexCreatedVersion = indexCreatedVersion;
        this.routingNumShards = routingNumShards;
        this.routingFactor = routingNumShards / numberOfShards;
        this.routingPartitionSize = routingPartitionSize;
        this.routingPaths = routingPaths;
        this.waitForActiveShards = waitForActiveShards;
        this.rolloverInfos = rolloverInfos;
        this.isSystem = isSystem;
        assert (isHidden == INDEX_HIDDEN_SETTING.get(settings));
        this.isHidden = isHidden;
        this.timestampRange = timestampRange;
        this.priority = priority;
        this.creationDate = creationDate;
        this.ignoreDiskWatermarks = ignoreDiskWatermarks;
        this.tierPreference = tierPreference;
        assert (numberOfShards * this.routingFactor == routingNumShards) : routingNumShards + " must be a multiple of " + numberOfShards;
    }

    IndexMetadata withMappingMetadata(MappingMetadata mapping) {
        if (this.mapping() == mapping) {
            return this;
        }
        return new IndexMetadata(this.index, this.version, this.mappingVersion, this.settingsVersion, this.aliasesVersion, this.primaryTerms, this.state, this.numberOfShards, this.numberOfReplicas, this.settings, mapping, this.aliases, this.customData, this.inSyncAllocationIds, this.requireFilters, this.initialRecoveryFilters, this.includeFilters, this.excludeFilters, this.indexCreatedVersion, this.routingNumShards, this.routingPartitionSize, this.routingPaths, this.waitForActiveShards, this.rolloverInfos, this.isSystem, this.isHidden, this.timestampRange, this.priority, this.creationDate, this.ignoreDiskWatermarks, this.tierPreference);
    }

    public Index getIndex() {
        return this.index;
    }

    public String getIndexUUID() {
        return this.index.getUUID();
    }

    public boolean isSameUUID(String otherUUID) {
        assert (otherUUID != null);
        assert (this.getIndexUUID() != null);
        if (INDEX_UUID_NA_VALUE.equals(otherUUID) || INDEX_UUID_NA_VALUE.equals(this.getIndexUUID())) {
            return true;
        }
        return otherUUID.equals(this.getIndexUUID());
    }

    public long getVersion() {
        return this.version;
    }

    public long getMappingVersion() {
        return this.mappingVersion;
    }

    public long getSettingsVersion() {
        return this.settingsVersion;
    }

    public long getAliasesVersion() {
        return this.aliasesVersion;
    }

    public long primaryTerm(int shardId) {
        return this.primaryTerms[shardId];
    }

    public Version getCreationVersion() {
        return this.indexCreatedVersion;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public State getState() {
        return this.state;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getRoutingPartitionSize() {
        return this.routingPartitionSize;
    }

    public boolean isRoutingPartitionedIndex() {
        return this.routingPartitionSize != 1;
    }

    public List<String> getRoutingPaths() {
        return this.routingPaths;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public ActiveShardCount getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    public boolean ignoreDiskWatermarks() {
        return this.ignoreDiskWatermarks;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ImmutableOpenMap<String, AliasMetadata> getAliases() {
        return this.aliases;
    }

    public List<String> getTierPreference() {
        if (this.tierPreference == null) {
            List<String> parsed = DataTier.parseTierList(DataTier.TIER_PREFERENCE_SETTING.get(this.settings));
            assert (false) : "the setting parsing should always throw if we didn't store a tier preference when building this instance";
            return parsed;
        }
        return this.tierPreference;
    }

    @Nullable
    public MappingMetadata mapping() {
        return this.mapping;
    }

    public Index getResizeSourceIndex() {
        return INDEX_RESIZE_SOURCE_UUID.exists(this.settings) ? new Index(INDEX_RESIZE_SOURCE_NAME.get(this.settings), INDEX_RESIZE_SOURCE_UUID.get(this.settings)) : null;
    }

    ImmutableOpenMap<String, DiffableStringMap> getCustomData() {
        return this.customData;
    }

    public Map<String, String> getCustomData(String key) {
        return this.customData.get(key);
    }

    public ImmutableOpenIntMap<Set<String>> getInSyncAllocationIds() {
        return this.inSyncAllocationIds;
    }

    public ImmutableOpenMap<String, RolloverInfo> getRolloverInfos() {
        return this.rolloverInfos;
    }

    public Set<String> inSyncAllocationIds(int shardId) {
        assert (shardId >= 0 && shardId < this.numberOfShards);
        return this.inSyncAllocationIds.get(shardId);
    }

    @Nullable
    public DiscoveryNodeFilters requireFilters() {
        return this.requireFilters;
    }

    @Nullable
    public DiscoveryNodeFilters getInitialRecoveryFilters() {
        return this.initialRecoveryFilters;
    }

    @Nullable
    public DiscoveryNodeFilters includeFilters() {
        return this.includeFilters;
    }

    @Nullable
    public DiscoveryNodeFilters excludeFilters() {
        return this.excludeFilters;
    }

    public IndexLongFieldRange getTimestampRange() {
        return this.timestampRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMetadata that = (IndexMetadata)o;
        if (this.version != that.version) {
            return false;
        }
        if (!this.aliases.equals(that.aliases)) {
            return false;
        }
        if (!this.index.equals(that.index)) {
            return false;
        }
        if (!Objects.equals(this.mapping, that.mapping)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (!this.customData.equals(that.customData)) {
            return false;
        }
        if (this.routingNumShards != that.routingNumShards) {
            return false;
        }
        if (this.routingFactor != that.routingFactor) {
            return false;
        }
        if (!Arrays.equals(this.primaryTerms, that.primaryTerms)) {
            return false;
        }
        if (!this.inSyncAllocationIds.equals(that.inSyncAllocationIds)) {
            return false;
        }
        if (!this.rolloverInfos.equals(that.rolloverInfos)) {
            return false;
        }
        return this.isSystem == that.isSystem;
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + Long.hashCode(this.version);
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.aliases.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + Objects.hash(this.mapping);
        result = 31 * result + this.customData.hashCode();
        result = 31 * result + Long.hashCode(this.routingFactor);
        result = 31 * result + Long.hashCode(this.routingNumShards);
        result = 31 * result + Arrays.hashCode(this.primaryTerms);
        result = 31 * result + this.inSyncAllocationIds.hashCode();
        result = 31 * result + this.rolloverInfos.hashCode();
        result = 31 * result + Boolean.hashCode(this.isSystem);
        return result;
    }

    @Override
    public Diff<IndexMetadata> diff(IndexMetadata previousState) {
        return new IndexMetadataDiff(previousState, this);
    }

    public static Diff<IndexMetadata> readDiffFrom(StreamInput in) throws IOException {
        return new IndexMetadataDiff(in);
    }

    public static IndexMetadata fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    public static IndexMetadata readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder(in.readString());
        builder.version(in.readLong());
        builder.mappingVersion(in.readVLong());
        builder.settingsVersion(in.readVLong());
        if (in.getVersion().onOrAfter(Version.V_7_2_0)) {
            builder.aliasesVersion(in.readVLong());
        }
        builder.setRoutingNumShards(in.readInt());
        builder.state(State.fromId(in.readByte()));
        builder.settings(Settings.readSettingsFromStream(in));
        builder.primaryTerms(in.readVLongArray());
        int mappingsSize = in.readVInt();
        for (int i = 0; i < mappingsSize; ++i) {
            MappingMetadata mappingMd = new MappingMetadata(in);
            builder.putMapping(mappingMd);
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            AliasMetadata aliasMd = new AliasMetadata(in);
            builder.putAlias(aliasMd);
        }
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            String key = in.readString();
            DiffableStringMap custom = DiffableStringMap.readFrom(in);
            builder.putCustom(key, custom);
        }
        int inSyncAllocationIdsSize = in.readVInt();
        for (int i = 0; i < inSyncAllocationIdsSize; ++i) {
            int key = in.readVInt();
            Object allocationIds = DiffableUtils.StringSetValueSerializer.getInstance().read(in, (Object)key);
            builder.putInSyncAllocationIds(key, (Set<String>)allocationIds);
        }
        int rolloverAliasesSize = in.readVInt();
        for (int i = 0; i < rolloverAliasesSize; ++i) {
            builder.putRolloverInfo(new RolloverInfo(in));
        }
        if (in.getVersion().onOrAfter(SYSTEM_INDEX_FLAG_ADDED)) {
            builder.system(in.readBoolean());
        }
        builder.timestampRange(IndexLongFieldRange.readFrom(in));
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index.getName());
        out.writeLong(this.version);
        out.writeVLong(this.mappingVersion);
        out.writeVLong(this.settingsVersion);
        if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
            out.writeVLong(this.aliasesVersion);
        }
        out.writeInt(this.routingNumShards);
        out.writeByte(this.state.id());
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVLongArray(this.primaryTerms);
        if (this.mapping == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(1);
            this.mapping.writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (AliasMetadata aliasMetadata : this.aliases.values()) {
            aliasMetadata.writeTo(out);
        }
        out.writeVInt(this.customData.size());
        for (Map.Entry entry : this.customData.entrySet()) {
            out.writeString((String)entry.getKey());
            ((DiffableStringMap)entry.getValue()).writeTo(out);
        }
        out.writeVInt(this.inSyncAllocationIds.size());
        for (Map.Entry entry : this.inSyncAllocationIds.entrySet()) {
            out.writeVInt((Integer)entry.getKey());
            DiffableUtils.StringSetValueSerializer.getInstance().write((Set)entry.getValue(), out);
        }
        out.writeVInt(this.rolloverInfos.size());
        for (RolloverInfo rolloverInfo : this.rolloverInfos.values()) {
            rolloverInfo.writeTo(out);
        }
        if (out.getVersion().onOrAfter(SYSTEM_INDEX_FLAG_ADDED)) {
            out.writeBoolean(this.isSystem);
        }
        this.timestampRange.writeTo(out);
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public int priority() {
        return this.priority;
    }

    public static Builder builder(String index) {
        return new Builder(index);
    }

    public static Builder builder(IndexMetadata indexMetadata) {
        return new Builder(indexMetadata);
    }

    private static Version indexCreatedVersion(Settings indexSettings) {
        Version indexVersion = SETTING_INDEX_VERSION_CREATED.get(indexSettings);
        if (indexVersion == Version.V_EMPTY) {
            String message = String.format(Locale.ROOT, "[%s] is not present in the index settings for index with UUID [%s]", SETTING_INDEX_VERSION_CREATED.getKey(), indexSettings.get(SETTING_INDEX_UUID));
            throw new IllegalArgumentException(message);
        }
        return indexVersion;
    }

    public static Settings addHumanReadableSettings(Settings settings) {
        Long creationDate;
        Settings.Builder builder = Settings.builder().put(settings);
        Version version = SETTING_INDEX_VERSION_CREATED.get(settings);
        if (version != Version.V_EMPTY) {
            builder.put(SETTING_VERSION_CREATED_STRING, version.toString());
        }
        if ((creationDate = settings.getAsLong(SETTING_CREATION_DATE, null)) != null) {
            ZonedDateTime creationDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(creationDate), ZoneOffset.UTC);
            builder.put(SETTING_CREATION_DATE_STRING, creationDateTime.toString());
        }
        return builder.build();
    }

    public int getRoutingNumShards() {
        return this.routingNumShards;
    }

    public int getRoutingFactor() {
        return this.routingFactor;
    }

    public static ShardId selectSplitShard(int shardId, IndexMetadata sourceIndexMetadata, int numTargetShards) {
        int numSourceShards = sourceIndexMetadata.getNumberOfShards();
        if (shardId >= numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be greater than the shard id: " + shardId);
        }
        int routingFactor = IndexMetadata.getRoutingFactor(numSourceShards, numTargetShards);
        IndexMetadata.assertSplitMetadata(numSourceShards, numTargetShards, sourceIndexMetadata);
        return new ShardId(sourceIndexMetadata.getIndex(), shardId / routingFactor);
    }

    public static ShardId selectCloneShard(int shardId, IndexMetadata sourceIndexMetadata, int numTargetShards) {
        int numSourceShards = sourceIndexMetadata.getNumberOfShards();
        if (numSourceShards != numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be the same as the number of  source shards ( " + numSourceShards + ")");
        }
        return new ShardId(sourceIndexMetadata.getIndex(), shardId);
    }

    private static void assertSplitMetadata(int numSourceShards, int numTargetShards, IndexMetadata sourceIndexMetadata) {
        int routingNumShards;
        if (numSourceShards > numTargetShards) {
            throw new IllegalArgumentException("the number of source shards [" + numSourceShards + "] must be less that the number of target shards [" + numTargetShards + "]");
        }
        int n = routingNumShards = numSourceShards == 1 ? numTargetShards : sourceIndexMetadata.getRoutingNumShards();
        if (routingNumShards % numTargetShards != 0) {
            throw new IllegalStateException("the number of routing shards [" + routingNumShards + "] must be a multiple of the target shards [" + numTargetShards + "]");
        }
        assert (sourceIndexMetadata.getNumberOfShards() == 1 || IndexMetadata.getRoutingFactor(numTargetShards, routingNumShards) >= 0);
    }

    public static Set<ShardId> selectRecoverFromShards(int shardId, IndexMetadata sourceIndexMetadata, int numTargetShards) {
        if (sourceIndexMetadata.getNumberOfShards() > numTargetShards) {
            return IndexMetadata.selectShrinkShards(shardId, sourceIndexMetadata, numTargetShards);
        }
        if (sourceIndexMetadata.getNumberOfShards() < numTargetShards) {
            return Collections.singleton(IndexMetadata.selectSplitShard(shardId, sourceIndexMetadata, numTargetShards));
        }
        return Collections.singleton(IndexMetadata.selectCloneShard(shardId, sourceIndexMetadata, numTargetShards));
    }

    public static Set<ShardId> selectShrinkShards(int shardId, IndexMetadata sourceIndexMetadata, int numTargetShards) {
        if (shardId >= numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be greater than the shard id: " + shardId);
        }
        if (sourceIndexMetadata.getNumberOfShards() < numTargetShards) {
            throw new IllegalArgumentException("the number of target shards [" + numTargetShards + "] must be less that the number of source shards [" + sourceIndexMetadata.getNumberOfShards() + "]");
        }
        int routingFactor = IndexMetadata.getRoutingFactor(sourceIndexMetadata.getNumberOfShards(), numTargetShards);
        HashSet<ShardId> shards = new HashSet<ShardId>(routingFactor);
        for (int i = shardId * routingFactor; i < routingFactor * shardId + routingFactor; ++i) {
            shards.add(new ShardId(sourceIndexMetadata.getIndex(), i));
        }
        return shards;
    }

    public static int getRoutingFactor(int sourceNumberOfShards, int targetNumberOfShards) {
        int factor;
        if (sourceNumberOfShards < targetNumberOfShards) {
            factor = targetNumberOfShards / sourceNumberOfShards;
            if (factor * sourceNumberOfShards != targetNumberOfShards || factor <= 1) {
                throw new IllegalArgumentException("the number of source shards [" + sourceNumberOfShards + "] must be a factor of [" + targetNumberOfShards + "]");
            }
        } else if (sourceNumberOfShards > targetNumberOfShards) {
            factor = sourceNumberOfShards / targetNumberOfShards;
            if (factor * targetNumberOfShards != sourceNumberOfShards || factor <= 1) {
                throw new IllegalArgumentException("the number of source shards [" + sourceNumberOfShards + "] must be a multiple of [" + targetNumberOfShards + "]");
            }
        } else {
            factor = 1;
        }
        return factor;
    }

    public static int parseIndexNameCounter(String indexName) {
        int numberIndex = indexName.lastIndexOf("-");
        if (numberIndex == -1) {
            throw new IllegalArgumentException("no - separator found in index name [" + indexName + "]");
        }
        try {
            return Integer.parseInt(indexName.substring(numberIndex + 1, indexName.endsWith(">") ? indexName.length() - 1 : indexName.length()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse the index name [" + indexName + "] to extract the counter", e);
        }
    }

    static {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("binary", "true");
        params.put("context_mode", Metadata.CONTEXT_MODE_GATEWAY);
        FORMAT_PARAMS = new ToXContent.MapParams(params);
        FORMAT = new MetadataStateFormat<IndexMetadata>(INDEX_STATE_FILE_PREFIX){

            @Override
            public void toXContent(XContentBuilder builder, IndexMetadata state) throws IOException {
                Builder.toXContent(state, builder, FORMAT_PARAMS);
            }

            @Override
            public IndexMetadata fromXContent(XContentParser parser) throws IOException {
                return Builder.fromXContent(parser);
            }
        };
    }

    public static enum State {
        OPEN(0),
        CLOSE(1);

        private final byte id;

        private State(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static State fromId(byte id) {
            if (id == 0) {
                return OPEN;
            }
            if (id == 1) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for id [" + id + "]");
        }

        public static State fromString(String state) {
            if ("open".equals(state)) {
                return OPEN;
            }
            if ("close".equals(state)) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for [" + state + "]");
        }
    }

    private static class IndexMetadataDiff
    implements Diff<IndexMetadata> {
        private final String index;
        private final int routingNumShards;
        private final long version;
        private final long mappingVersion;
        private final long settingsVersion;
        private final long aliasesVersion;
        private final long[] primaryTerms;
        private final State state;
        private final Settings settings;
        private final Diff<ImmutableOpenMap<String, MappingMetadata>> mappings;
        private final Diff<ImmutableOpenMap<String, AliasMetadata>> aliases;
        private final Diff<ImmutableOpenMap<String, DiffableStringMap>> customData;
        private final Diff<ImmutableOpenIntMap<Set<String>>> inSyncAllocationIds;
        private final Diff<ImmutableOpenMap<String, RolloverInfo>> rolloverInfos;
        private final boolean isSystem;
        private final IndexLongFieldRange timestampRange;
        private static final DiffableUtils.DiffableValueReader<String, AliasMetadata> ALIAS_METADATA_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(AliasMetadata::new, AliasMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, MappingMetadata> MAPPING_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(MappingMetadata::new, MappingMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, DiffableStringMap> CUSTOM_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(DiffableStringMap::readFrom, DiffableStringMap::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, RolloverInfo> ROLLOVER_INFO_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(RolloverInfo::new, RolloverInfo::readDiffFrom);

        IndexMetadataDiff(IndexMetadata before, IndexMetadata after) {
            this.index = after.index.getName();
            this.version = after.version;
            this.mappingVersion = after.mappingVersion;
            this.settingsVersion = after.settingsVersion;
            this.aliasesVersion = after.aliasesVersion;
            this.routingNumShards = after.routingNumShards;
            this.state = after.state;
            this.settings = after.settings;
            this.primaryTerms = after.primaryTerms;
            this.mappings = DiffableUtils.diff(before.mapping == null ? ImmutableOpenMap.of() : ImmutableOpenMap.builder(1).fPut("_doc", before.mapping).build(), after.mapping == null ? ImmutableOpenMap.of() : ImmutableOpenMap.builder(1).fPut("_doc", after.mapping).build(), DiffableUtils.getStringKeySerializer());
            this.aliases = DiffableUtils.diff(before.aliases, after.aliases, DiffableUtils.getStringKeySerializer());
            this.customData = DiffableUtils.diff(before.customData, after.customData, DiffableUtils.getStringKeySerializer());
            this.inSyncAllocationIds = DiffableUtils.diff(before.inSyncAllocationIds, after.inSyncAllocationIds, DiffableUtils.getVIntKeySerializer(), DiffableUtils.StringSetValueSerializer.getInstance());
            this.rolloverInfos = DiffableUtils.diff(before.rolloverInfos, after.rolloverInfos, DiffableUtils.getStringKeySerializer());
            this.isSystem = after.isSystem;
            this.timestampRange = after.timestampRange;
        }

        IndexMetadataDiff(StreamInput in) throws IOException {
            this.index = in.readString();
            this.routingNumShards = in.readInt();
            this.version = in.readLong();
            this.mappingVersion = in.readVLong();
            this.settingsVersion = in.readVLong();
            this.aliasesVersion = in.getVersion().onOrAfter(Version.V_7_2_0) ? in.readVLong() : 1L;
            this.state = State.fromId(in.readByte());
            this.settings = Settings.readSettingsFromStream(in);
            this.primaryTerms = in.readVLongArray();
            this.mappings = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), MAPPING_DIFF_VALUE_READER);
            this.aliases = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), ALIAS_METADATA_DIFF_VALUE_READER);
            this.customData = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), CUSTOM_DIFF_VALUE_READER);
            this.inSyncAllocationIds = DiffableUtils.readImmutableOpenIntMapDiff(in, DiffableUtils.getVIntKeySerializer(), DiffableUtils.StringSetValueSerializer.getInstance());
            this.rolloverInfos = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), ROLLOVER_INFO_DIFF_VALUE_READER);
            this.isSystem = in.getVersion().onOrAfter(SYSTEM_INDEX_FLAG_ADDED) ? in.readBoolean() : false;
            this.timestampRange = IndexLongFieldRange.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeInt(this.routingNumShards);
            out.writeLong(this.version);
            out.writeVLong(this.mappingVersion);
            out.writeVLong(this.settingsVersion);
            if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
                out.writeVLong(this.aliasesVersion);
            }
            out.writeByte(this.state.id);
            Settings.writeSettingsToStream(this.settings, out);
            out.writeVLongArray(this.primaryTerms);
            this.mappings.writeTo(out);
            this.aliases.writeTo(out);
            this.customData.writeTo(out);
            this.inSyncAllocationIds.writeTo(out);
            this.rolloverInfos.writeTo(out);
            if (out.getVersion().onOrAfter(SYSTEM_INDEX_FLAG_ADDED)) {
                out.writeBoolean(this.isSystem);
            }
            this.timestampRange.writeTo(out);
        }

        @Override
        public IndexMetadata apply(IndexMetadata part) {
            Builder builder = IndexMetadata.builder(this.index);
            builder.version(this.version);
            builder.mappingVersion(this.mappingVersion);
            builder.settingsVersion(this.settingsVersion);
            builder.aliasesVersion(this.aliasesVersion);
            builder.setRoutingNumShards(this.routingNumShards);
            builder.state(this.state);
            builder.settings(this.settings);
            builder.primaryTerms(this.primaryTerms);
            builder.mapping = this.mappings.apply(ImmutableOpenMap.builder(1).fPut("_doc", part.mapping).build()).get("_doc");
            builder.aliases.putAll((Iterable<ObjectObjectCursor<String, AliasMetadata>>)this.aliases.apply(part.aliases));
            builder.customMetadata.putAll((Iterable<ObjectObjectCursor<String, DiffableStringMap>>)this.customData.apply(part.customData));
            builder.inSyncAllocationIds.putAll((Iterable<IntObjectCursor<Set<String>>>)this.inSyncAllocationIds.apply(part.inSyncAllocationIds));
            builder.rolloverInfos.putAll((Iterable<ObjectObjectCursor<String, RolloverInfo>>)this.rolloverInfos.apply(part.rolloverInfos));
            builder.system(this.isSystem);
            builder.timestampRange(this.timestampRange);
            return builder.build();
        }
    }

    public static class Builder {
        private String index;
        private State state = State.OPEN;
        private long version = 1L;
        private long mappingVersion = 1L;
        private long settingsVersion = 1L;
        private long aliasesVersion = 1L;
        private long[] primaryTerms = null;
        private Settings settings = Settings.EMPTY;
        private MappingMetadata mapping;
        private final ImmutableOpenMap.Builder<String, AliasMetadata> aliases;
        private final ImmutableOpenMap.Builder<String, DiffableStringMap> customMetadata;
        private final ImmutableOpenIntMap.Builder<Set<String>> inSyncAllocationIds;
        private final ImmutableOpenMap.Builder<String, RolloverInfo> rolloverInfos;
        private Integer routingNumShards;
        private boolean isSystem;
        private IndexLongFieldRange timestampRange = IndexLongFieldRange.NO_SHARDS;

        public Builder(String index) {
            this.index = index;
            this.aliases = ImmutableOpenMap.builder();
            this.customMetadata = ImmutableOpenMap.builder();
            this.inSyncAllocationIds = ImmutableOpenIntMap.builder();
            this.rolloverInfos = ImmutableOpenMap.builder();
            this.isSystem = false;
        }

        public Builder(IndexMetadata indexMetadata) {
            this.index = indexMetadata.getIndex().getName();
            this.state = indexMetadata.state;
            this.version = indexMetadata.version;
            this.mappingVersion = indexMetadata.mappingVersion;
            this.settingsVersion = indexMetadata.settingsVersion;
            this.aliasesVersion = indexMetadata.aliasesVersion;
            this.settings = indexMetadata.getSettings();
            this.primaryTerms = (long[])indexMetadata.primaryTerms.clone();
            this.mapping = indexMetadata.mapping;
            this.aliases = ImmutableOpenMap.builder(indexMetadata.aliases);
            this.customMetadata = ImmutableOpenMap.builder(indexMetadata.customData);
            this.routingNumShards = indexMetadata.routingNumShards;
            this.inSyncAllocationIds = ImmutableOpenIntMap.builder(indexMetadata.inSyncAllocationIds);
            this.rolloverInfos = ImmutableOpenMap.builder(indexMetadata.rolloverInfos);
            this.isSystem = indexMetadata.isSystem;
            this.timestampRange = indexMetadata.timestampRange;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder numberOfShards(int numberOfShards) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_NUMBER_OF_SHARDS, numberOfShards).build();
            return this;
        }

        public Builder setRoutingNumShards(int routingNumShards) {
            this.routingNumShards = routingNumShards;
            return this;
        }

        public int getRoutingNumShards() {
            return this.routingNumShards == null ? this.numberOfShards() : this.routingNumShards.intValue();
        }

        public int numberOfShards() {
            return this.settings.getAsInt(IndexMetadata.SETTING_NUMBER_OF_SHARDS, -1);
        }

        public Builder numberOfReplicas(int numberOfReplicas) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_NUMBER_OF_REPLICAS, numberOfReplicas).build();
            return this;
        }

        public Builder routingPartitionSize(int routingPartitionSize) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_ROUTING_PARTITION_SIZE, routingPartitionSize).build();
            return this;
        }

        public Builder creationDate(long creationDate) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_CREATION_DATE, creationDate).build();
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            return this.settings(settings.build());
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public MappingMetadata mapping() {
            return this.mapping;
        }

        public Builder putMapping(String source) {
            this.putMapping(new MappingMetadata("_doc", XContentHelper.convertToMap(XContentFactory.xContent((CharSequence)source), source, true)));
            return this;
        }

        public Builder putMapping(MappingMetadata mappingMd) {
            this.mapping = mappingMd;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder putAlias(AliasMetadata aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata);
            return this;
        }

        public Builder putAlias(AliasMetadata.Builder aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata.build());
            return this;
        }

        public Builder removeAlias(String alias) {
            this.aliases.remove(alias);
            return this;
        }

        public Builder removeAllAliases() {
            this.aliases.clear();
            return this;
        }

        public Builder putCustom(String type, Map<String, String> customIndexMetadata) {
            this.customMetadata.put(type, new DiffableStringMap(customIndexMetadata));
            return this;
        }

        public Map<String, String> removeCustom(String type) {
            return this.customMetadata.remove(type);
        }

        public Set<String> getInSyncAllocationIds(int shardId) {
            return this.inSyncAllocationIds.get(shardId);
        }

        public Builder putInSyncAllocationIds(int shardId, Set<String> allocationIds) {
            this.inSyncAllocationIds.put(shardId, new HashSet<String>(allocationIds));
            return this;
        }

        public Builder putRolloverInfo(RolloverInfo rolloverInfo) {
            this.rolloverInfos.put(rolloverInfo.getAlias(), rolloverInfo);
            return this;
        }

        public long version() {
            return this.version;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public long mappingVersion() {
            return this.mappingVersion;
        }

        public Builder mappingVersion(long mappingVersion) {
            this.mappingVersion = mappingVersion;
            return this;
        }

        public long settingsVersion() {
            return this.settingsVersion;
        }

        public Builder settingsVersion(long settingsVersion) {
            this.settingsVersion = settingsVersion;
            return this;
        }

        public long aliasesVersion() {
            return this.aliasesVersion;
        }

        public Builder aliasesVersion(long aliasesVersion) {
            this.aliasesVersion = aliasesVersion;
            return this;
        }

        public long primaryTerm(int shardId) {
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            }
            return this.primaryTerms[shardId];
        }

        public Builder primaryTerm(int shardId, long primaryTerm) {
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            }
            this.primaryTerms[shardId] = primaryTerm;
            return this;
        }

        private void primaryTerms(long[] primaryTerms) {
            this.primaryTerms = (long[])primaryTerms.clone();
        }

        private void initializePrimaryTerms() {
            assert (this.primaryTerms == null);
            if (this.numberOfShards() < 0) {
                throw new IllegalStateException("you must set the number of shards before setting/reading primary terms");
            }
            this.primaryTerms = new long[this.numberOfShards()];
            Arrays.fill(this.primaryTerms, 0L);
        }

        public Builder system(boolean system) {
            this.isSystem = system;
            return this;
        }

        public boolean isSystem() {
            return this.isSystem;
        }

        public Builder timestampRange(IndexLongFieldRange timestampRange) {
            this.timestampRange = timestampRange;
            return this;
        }

        public IndexLongFieldRange getTimestampRange() {
            return this.timestampRange;
        }

        public IndexMetadata build() {
            List<String> tierPreference;
            if (!INDEX_NUMBER_OF_SHARDS_SETTING.exists(this.settings)) {
                throw new IllegalArgumentException("must specify number of shards for index [" + this.index + "]");
            }
            int numberOfShards = INDEX_NUMBER_OF_SHARDS_SETTING.get(this.settings);
            if (!INDEX_NUMBER_OF_REPLICAS_SETTING.exists(this.settings)) {
                throw new IllegalArgumentException("must specify number of replicas for index [" + this.index + "]");
            }
            int numberOfReplicas = INDEX_NUMBER_OF_REPLICAS_SETTING.get(this.settings);
            int routingPartitionSize = INDEX_ROUTING_PARTITION_SIZE_SETTING.get(this.settings);
            if (routingPartitionSize != 1 && routingPartitionSize >= this.getRoutingNumShards()) {
                throw new IllegalArgumentException("routing partition size [" + routingPartitionSize + "] should be a positive number less than the number of shards [" + this.getRoutingNumShards() + "] for [" + this.index + "]");
            }
            ImmutableOpenIntMap.Builder filledInSyncAllocationIds = ImmutableOpenIntMap.builder();
            for (int i = 0; i < numberOfShards; ++i) {
                if (this.inSyncAllocationIds.containsKey(i)) {
                    filledInSyncAllocationIds.put(i, Set.copyOf((Collection)this.inSyncAllocationIds.get(i)));
                    continue;
                }
                filledInSyncAllocationIds.put(i, Collections.emptySet());
            }
            Map<String, String> requireMap = INDEX_ROUTING_REQUIRE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters requireFilters = requireMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.AND, requireMap);
            Map<String, String> includeMap = INDEX_ROUTING_INCLUDE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters includeFilters = includeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, includeMap);
            Map<String, String> excludeMap = INDEX_ROUTING_EXCLUDE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters excludeFilters = excludeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, excludeMap);
            Map<String, String> initialRecoveryMap = INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters initialRecoveryFilters = initialRecoveryMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, initialRecoveryMap);
            Version indexCreatedVersion = IndexMetadata.indexCreatedVersion(this.settings);
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            } else if (this.primaryTerms.length != numberOfShards) {
                throw new IllegalStateException("primaryTerms length is [" + this.primaryTerms.length + "] but should be equal to number of shards [" + this.numberOfShards() + "]");
            }
            ActiveShardCount waitForActiveShards = SETTING_WAIT_FOR_ACTIVE_SHARDS.get(this.settings);
            if (!waitForActiveShards.validate(numberOfReplicas)) {
                throw new IllegalArgumentException("invalid " + SETTING_WAIT_FOR_ACTIVE_SHARDS.getKey() + "[" + waitForActiveShards + "]: cannot be greater than number of shard copies [" + (numberOfReplicas + 1) + "]");
            }
            List<String> routingPaths = INDEX_ROUTING_PATH.get(this.settings);
            String uuid = this.settings.get(IndexMetadata.SETTING_INDEX_UUID, IndexMetadata.INDEX_UUID_NA_VALUE);
            try {
                tierPreference = DataTier.parseTierList(DataTier.TIER_PREFERENCE_SETTING.get(this.settings));
            }
            catch (Exception e) {
                assert (e instanceof IllegalArgumentException) : e;
                tierPreference = null;
            }
            return new IndexMetadata(new Index(this.index, uuid), this.version, this.mappingVersion, this.settingsVersion, this.aliasesVersion, this.primaryTerms, this.state, numberOfShards, numberOfReplicas, this.settings, this.mapping, this.aliases.build(), this.customMetadata.build(), filledInSyncAllocationIds.build(), requireFilters, initialRecoveryFilters, includeFilters, excludeFilters, indexCreatedVersion, this.getRoutingNumShards(), routingPartitionSize, routingPaths, waitForActiveShards, this.rolloverInfos.build(), this.isSystem, INDEX_HIDDEN_SETTING.get(this.settings), this.timestampRange, INDEX_PRIORITY_SETTING.get(this.settings), this.settings.getAsLong(IndexMetadata.SETTING_CREATION_DATE, -1L), DiskThresholdDecider.SETTING_IGNORE_DISK_WATERMARKS.get(this.settings), tierPreference);
        }

        /*
         * WARNING - void declaration
         */
        public static void toXContent(IndexMetadata indexMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            Metadata.XContentContext context = Metadata.XContentContext.valueOf(params.param("context_mode", Metadata.CONTEXT_MODE_API));
            builder.startObject(indexMetadata.getIndex().getName());
            builder.field(IndexMetadata.KEY_VERSION, indexMetadata.getVersion());
            builder.field(IndexMetadata.KEY_MAPPING_VERSION, indexMetadata.getMappingVersion());
            builder.field(IndexMetadata.KEY_SETTINGS_VERSION, indexMetadata.getSettingsVersion());
            builder.field(IndexMetadata.KEY_ALIASES_VERSION, indexMetadata.getAliasesVersion());
            builder.field(IndexMetadata.KEY_ROUTING_NUM_SHARDS, indexMetadata.getRoutingNumShards());
            builder.field(IndexMetadata.KEY_STATE, indexMetadata.getState().toString().toLowerCase(Locale.ENGLISH));
            boolean binary = params.paramAsBoolean("binary", false);
            builder.startObject(IndexMetadata.KEY_SETTINGS);
            if (context != Metadata.XContentContext.API) {
                indexMetadata.getSettings().toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
            } else {
                indexMetadata.getSettings().toXContent(builder, params);
            }
            builder.endObject();
            if (context != Metadata.XContentContext.API) {
                builder.startArray(IndexMetadata.KEY_MAPPINGS);
                mmd = indexMetadata.mapping();
                if (mmd != null) {
                    if (binary) {
                        builder.value(((MappingMetadata)((Object)mmd)).source().compressed());
                    } else {
                        builder.map((Map)XContentHelper.convertToMap(((MappingMetadata)((Object)mmd)).source().uncompressed(), true).v2());
                    }
                }
                builder.endArray();
            } else {
                builder.startObject(IndexMetadata.KEY_MAPPINGS);
                mmd = indexMetadata.mapping();
                if (mmd != null) {
                    void var6_10;
                    Map map = (Map)XContentHelper.convertToMap(((MappingMetadata)((Object)mmd)).source().uncompressed(), false).v2();
                    if (map.size() == 1 && map.containsKey(((MappingMetadata)((Object)mmd)).type())) {
                        Map map2 = (Map)map.get(((MappingMetadata)((Object)mmd)).type());
                    }
                    builder.field(((MappingMetadata)((Object)mmd)).type());
                    builder.map((Map)var6_10);
                }
                builder.endObject();
            }
            for (Map.Entry entry : indexMetadata.customData.entrySet()) {
                builder.stringStringMap((String)entry.getKey(), (Map)entry.getValue());
            }
            if (context != Metadata.XContentContext.API) {
                builder.startObject(IndexMetadata.KEY_ALIASES);
                for (AliasMetadata aliasMetadata : indexMetadata.getAliases().values()) {
                    AliasMetadata.Builder.toXContent(aliasMetadata, builder, params);
                }
                builder.endObject();
                builder.startArray(IndexMetadata.KEY_PRIMARY_TERMS);
                for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                    builder.value(indexMetadata.primaryTerm(i));
                }
                builder.endArray();
            } else {
                builder.startArray(IndexMetadata.KEY_ALIASES);
                for (Map.Entry<String, AliasMetadata> entry : indexMetadata.getAliases().entrySet()) {
                    builder.value(entry.getKey());
                }
                builder.endArray();
                builder.startObject(IndexMetadata.KEY_PRIMARY_TERMS);
                for (int shard = 0; shard < indexMetadata.getNumberOfShards(); ++shard) {
                    builder.field(Integer.toString(shard), indexMetadata.primaryTerm(shard));
                }
                builder.endObject();
            }
            builder.startObject(IndexMetadata.KEY_IN_SYNC_ALLOCATIONS);
            for (Map.Entry<Integer, Set<String>> entry : indexMetadata.inSyncAllocationIds.entrySet()) {
                builder.startArray(String.valueOf(entry.getKey()));
                for (String allocationId : entry.getValue()) {
                    builder.value(allocationId);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.startObject(IndexMetadata.KEY_ROLLOVER_INFOS);
            for (RolloverInfo rolloverInfo : indexMetadata.getRolloverInfos().values()) {
                rolloverInfo.toXContent(builder, params);
            }
            builder.endObject();
            builder.field(IndexMetadata.KEY_SYSTEM, indexMetadata.isSystem);
            builder.startObject(IndexMetadata.KEY_TIMESTAMP_RANGE);
            indexMetadata.timestampRange.toXContent(builder, params);
            builder.endObject();
            builder.endObject();
        }

        public static IndexMetadata fromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
            }
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            boolean mappingVersion = false;
            boolean settingsVersion = false;
            boolean aliasesVersion = false;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (IndexMetadata.KEY_SETTINGS.equals(currentFieldName)) {
                        builder.settings(Settings.fromXContent(parser));
                        continue;
                    }
                    if (IndexMetadata.KEY_MAPPINGS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_OBJECT) {
                                String mappingType = currentFieldName;
                                Map<String, Object> mappingSource = MapBuilder.newMapBuilder().put(mappingType, parser.mapOrdered()).map();
                                builder.putMapping(new MappingMetadata(mappingType, mappingSource));
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + token);
                        }
                        continue;
                    }
                    if (IndexMetadata.KEY_ALIASES.equals(currentFieldName)) {
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetadata.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    if (IndexMetadata.KEY_IN_SYNC_ALLOCATIONS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                String shardId = currentFieldName;
                                HashSet<String> allocationIds = new HashSet<String>();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    if (token != XContentParser.Token.VALUE_STRING) continue;
                                    allocationIds.add(parser.text());
                                }
                                builder.putInSyncAllocationIds(Integer.valueOf(shardId), allocationIds);
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + token);
                        }
                        continue;
                    }
                    if (IndexMetadata.KEY_ROLLOVER_INFOS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_OBJECT) {
                                builder.putRolloverInfo(RolloverInfo.parse(parser, currentFieldName));
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + token);
                        }
                        continue;
                    }
                    if ("warmers".equals(currentFieldName)) {
                        assert (Version.CURRENT.major <= 5);
                        parser.skipChildren();
                        continue;
                    }
                    if (IndexMetadata.KEY_TIMESTAMP_RANGE.equals(currentFieldName)) {
                        builder.timestampRange(IndexLongFieldRange.fromXContent(parser));
                        continue;
                    }
                    builder.putCustom(currentFieldName, parser.mapStrings());
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (IndexMetadata.KEY_MAPPINGS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                                builder.putMapping(new MappingMetadata(new CompressedXContent(parser.binaryValue())));
                                continue;
                            }
                            Map mapping = parser.mapOrdered();
                            if (mapping.size() != 1) continue;
                            String mappingType = (String)mapping.keySet().iterator().next();
                            builder.putMapping(new MappingMetadata(mappingType, mapping));
                        }
                        continue;
                    }
                    if (IndexMetadata.KEY_PRIMARY_TERMS.equals(currentFieldName)) {
                        ArrayList<Long> list = new ArrayList<Long>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser);
                            list.add(parser.longValue());
                        }
                        builder.primaryTerms(list.stream().mapToLong(i -> i).toArray());
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field for an array " + currentFieldName);
                }
                if (token.isValue()) {
                    if (IndexMetadata.KEY_STATE.equals(currentFieldName)) {
                        builder.state(State.fromString(parser.text()));
                        continue;
                    }
                    if (IndexMetadata.KEY_VERSION.equals(currentFieldName)) {
                        builder.version(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_MAPPING_VERSION.equals(currentFieldName)) {
                        mappingVersion = true;
                        builder.mappingVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_SETTINGS_VERSION.equals(currentFieldName)) {
                        settingsVersion = true;
                        builder.settingsVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_ALIASES_VERSION.equals(currentFieldName)) {
                        aliasesVersion = true;
                        builder.aliasesVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_ROUTING_NUM_SHARDS.equals(currentFieldName)) {
                        builder.setRoutingNumShards(parser.intValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_SYSTEM.equals(currentFieldName)) {
                        builder.system(parser.booleanValue());
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + token);
            }
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
            if (Assertions.ENABLED) assert (mappingVersion) : "mapping version should be present for indices created on or after 6.5.0";
            if (Assertions.ENABLED) assert (settingsVersion) : "settings version should be present for indices created on or after 6.5.0";
            Version indexVersion = IndexMetadata.indexCreatedVersion(builder.settings);
            if (Assertions.ENABLED && indexVersion.onOrAfter(Version.V_7_2_0)) assert (aliasesVersion) : "aliases version should be present for indices created on or after 7.2.0";
            return builder.build();
        }

        public static IndexMetadata legacyFromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
            }
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (IndexMetadata.KEY_SETTINGS.equals(currentFieldName)) {
                        Settings settings = Settings.fromXContent(parser);
                        if (SETTING_INDEX_VERSION_CREATED.get(settings).onOrAfter(Version.CURRENT.minimumIndexCompatibilityVersion())) {
                            throw new IllegalStateException("this method should only be used to parse older index metadata versions but got " + SETTING_INDEX_VERSION_CREATED.get(settings));
                        }
                        builder.settings(settings);
                        continue;
                    }
                    if (IndexMetadata.KEY_MAPPINGS.equals(currentFieldName)) {
                        parser.skipChildren();
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (IndexMetadata.KEY_MAPPINGS.equals(currentFieldName)) {
                        parser.skipChildren();
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token.isValue()) {
                    if (IndexMetadata.KEY_STATE.equals(currentFieldName)) {
                        builder.state(State.fromString(parser.text()));
                        continue;
                    }
                    if (IndexMetadata.KEY_VERSION.equals(currentFieldName)) {
                        builder.version(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_MAPPING_VERSION.equals(currentFieldName)) {
                        builder.mappingVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_SETTINGS_VERSION.equals(currentFieldName)) {
                        builder.settingsVersion(parser.longValue());
                        continue;
                    }
                    if (!IndexMetadata.KEY_ROUTING_NUM_SHARDS.equals(currentFieldName)) continue;
                    builder.setRoutingNumShards(parser.intValue());
                    continue;
                }
                XContentParserUtils.throwUnknownToken(token, parser.getTokenLocation());
            }
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
            IndexMetadata indexMetadata = builder.build();
            assert (indexMetadata.getCreationVersion().before(Version.CURRENT.minimumIndexCompatibilityVersion()));
            return indexMetadata;
        }
    }

    public static enum APIBlock implements Writeable
    {
        READ_ONLY("read_only", INDEX_READ_ONLY_BLOCK),
        READ("read", INDEX_READ_BLOCK),
        WRITE("write", INDEX_WRITE_BLOCK),
        METADATA("metadata", INDEX_METADATA_BLOCK),
        READ_ONLY_ALLOW_DELETE("read_only_allow_delete", INDEX_READ_ONLY_ALLOW_DELETE_BLOCK);

        final String name;
        final String settingName;
        final Setting<Boolean> setting;
        final ClusterBlock block;

        private APIBlock(String name, ClusterBlock block) {
            this.name = name;
            this.settingName = "index.blocks." + name;
            this.setting = Setting.boolSetting(this.settingName, false, Setting.Property.Dynamic, Setting.Property.IndexScope);
            this.block = block;
        }

        public String settingName() {
            return this.settingName;
        }

        public Setting<Boolean> setting() {
            return this.setting;
        }

        public ClusterBlock getBlock() {
            return this.block;
        }

        public static APIBlock fromName(String name) {
            for (APIBlock block : APIBlock.values()) {
                if (!block.name.equals(name)) continue;
                return block;
            }
            throw new IllegalArgumentException("No block found with name " + name);
        }

        public static APIBlock fromSetting(String settingName) {
            for (APIBlock block : APIBlock.values()) {
                if (!block.settingName.equals(settingName)) continue;
                return block;
            }
            throw new IllegalArgumentException("No block found with setting name " + settingName);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal());
        }

        public static APIBlock readFrom(StreamInput input) throws IOException {
            return APIBlock.values()[input.readVInt()];
        }
    }
}

