/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.coordination.ApplyCommitRequest;
import org.elasticsearch.cluster.coordination.ClusterStateSerializationStats;
import org.elasticsearch.cluster.coordination.PublishClusterStateStats;
import org.elasticsearch.cluster.coordination.PublishRequest;
import org.elasticsearch.cluster.coordination.PublishWithJoinResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.PositionTrackingOutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class PublicationTransportHandler {
    private static final Logger logger = LogManager.getLogger(PublicationTransportHandler.class);
    public static final String PUBLISH_STATE_ACTION_NAME = "internal:cluster/coordination/publish_state";
    public static final String COMMIT_STATE_ACTION_NAME = "internal:cluster/coordination/commit_state";
    private final BigArrays bigArrays;
    private final TransportService transportService;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final Function<PublishRequest, PublishWithJoinResponse> handlePublishRequest;
    private final AtomicReference<ClusterState> lastSeenClusterState = new AtomicReference();
    private final AtomicReference<PublishRequest> currentPublishRequestToSelf = new AtomicReference();
    private final AtomicLong fullClusterStateReceivedCount = new AtomicLong();
    private final AtomicLong incompatibleClusterStateDiffReceivedCount = new AtomicLong();
    private final AtomicLong compatibleClusterStateDiffReceivedCount = new AtomicLong();
    private static final TransportRequestOptions STATE_REQUEST_OPTIONS = TransportRequestOptions.of(null, TransportRequestOptions.Type.STATE);
    private final SerializationStatsTracker serializationStatsTracker = new SerializationStatsTracker();

    public PublicationTransportHandler(BigArrays bigArrays, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, Function<PublishRequest, PublishWithJoinResponse> handlePublishRequest, BiConsumer<ApplyCommitRequest, ActionListener<Void>> handleApplyCommit) {
        this.bigArrays = bigArrays;
        this.transportService = transportService;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.handlePublishRequest = handlePublishRequest;
        transportService.registerRequestHandler(PUBLISH_STATE_ACTION_NAME, "generic", false, false, BytesTransportRequest::new, (request, channel, task) -> channel.sendResponse(this.handleIncomingPublishRequest((BytesTransportRequest)request)));
        transportService.registerRequestHandler(COMMIT_STATE_ACTION_NAME, "generic", false, false, ApplyCommitRequest::new, (request, channel, task) -> handleApplyCommit.accept((ApplyCommitRequest)request, new ChannelActionListener(channel, COMMIT_STATE_ACTION_NAME, (ApplyCommitRequest)request).map(r -> TransportResponse.Empty.INSTANCE)));
    }

    public PublishClusterStateStats stats() {
        return new PublishClusterStateStats(this.fullClusterStateReceivedCount.get(), this.incompatibleClusterStateDiffReceivedCount.get(), this.compatibleClusterStateDiffReceivedCount.get(), this.serializationStatsTracker.getSerializationStats());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublishWithJoinResponse handleIncomingPublishRequest(BytesTransportRequest request) throws IOException {
        Compressor compressor = CompressorFactory.compressor(request.bytes());
        StreamInput in = request.bytes().streamInput();
        try {
            ClusterState incomingState;
            if (compressor != null) {
                in = new InputStreamStreamInput(compressor.threadLocalInputStream(in));
            }
            in = new NamedWriteableAwareStreamInput(in, this.namedWriteableRegistry);
            in.setVersion(request.version());
            if (in.readBoolean()) {
                ClusterState incomingState2;
                try (StreamInput input = in;){
                    incomingState2 = ClusterState.readFrom(input, this.transportService.getLocalNode());
                }
                catch (Exception e) {
                    logger.warn("unexpected error while deserializing an incoming cluster state", (Throwable)e);
                    throw e;
                }
                this.fullClusterStateReceivedCount.incrementAndGet();
                logger.debug("received full cluster state version [{}] with size [{}]", (Object)incomingState2.version(), (Object)request.bytes().length());
                PublishWithJoinResponse response = this.acceptState(incomingState2);
                this.lastSeenClusterState.set(incomingState2);
                PublishWithJoinResponse publishWithJoinResponse = response;
                return publishWithJoinResponse;
            }
            ClusterState lastSeen = this.lastSeenClusterState.get();
            if (lastSeen == null) {
                logger.debug("received diff for but don't have any local cluster state - requesting full state");
                this.incompatibleClusterStateDiffReceivedCount.incrementAndGet();
                throw new IncompatibleClusterStateVersionException("have no local cluster state");
            }
            try {
                Diff<ClusterState> diff;
                try (StreamInput input = in;){
                    diff = ClusterState.readDiffFrom(input, lastSeen.nodes().getLocalNode());
                }
                incomingState = diff.apply(lastSeen);
            }
            catch (IncompatibleClusterStateVersionException e) {
                this.incompatibleClusterStateDiffReceivedCount.incrementAndGet();
                throw e;
            }
            catch (Exception e) {
                logger.warn("unexpected error while deserializing an incoming cluster state", (Throwable)e);
                throw e;
            }
            this.compatibleClusterStateDiffReceivedCount.incrementAndGet();
            logger.debug("received diff cluster state version [{}] with uuid [{}], diff size [{}]", (Object)incomingState.version(), (Object)incomingState.stateUUID(), (Object)request.bytes().length());
            PublishWithJoinResponse response = this.acceptState(incomingState);
            this.lastSeenClusterState.compareAndSet(lastSeen, incomingState);
            PublishWithJoinResponse publishWithJoinResponse = response;
            return publishWithJoinResponse;
        }
        finally {
            IOUtils.close((Closeable)in);
        }
    }

    private PublishWithJoinResponse acceptState(ClusterState incomingState) {
        if (this.transportService.getLocalNode().equals(incomingState.nodes().getMasterNode())) {
            PublishRequest publishRequest = this.currentPublishRequestToSelf.get();
            if (publishRequest == null || !publishRequest.getAcceptedState().stateUUID().equals(incomingState.stateUUID())) {
                throw new IllegalStateException("publication to self failed for " + publishRequest);
            }
            return this.handlePublishRequest.apply(publishRequest);
        }
        return this.handlePublishRequest.apply(new PublishRequest(incomingState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicationContext newPublicationContext(ClusterStatePublicationEvent clusterStatePublicationEvent) {
        PublicationContext publicationContext = new PublicationContext(clusterStatePublicationEvent);
        boolean success = false;
        try {
            publicationContext.buildDiffAndSerializeStates();
            success = true;
            PublicationContext publicationContext2 = publicationContext;
            return publicationContext2;
        }
        finally {
            if (!success) {
                publicationContext.decRef();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleasableBytesReference serializeFullClusterState(ClusterState clusterState, DiscoveryNode node) {
        Version nodeVersion = node.getVersion();
        ReleasableBytesStreamOutput bytesStream = new ReleasableBytesStreamOutput(this.bigArrays);
        boolean success = false;
        try {
            long uncompressedBytes;
            try (PositionTrackingOutputStreamStreamOutput stream = new PositionTrackingOutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(Streams.flushOnCloseStream(bytesStream)));){
                stream.setVersion(nodeVersion);
                stream.writeBoolean(true);
                clusterState.writeTo(stream);
                uncompressedBytes = ((StreamOutput)stream).position();
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to serialize cluster state for publishing to node {}", (Throwable)e, node);
            }
            ReleasableBytesReference result = new ReleasableBytesReference(bytesStream.bytes(), bytesStream::close);
            this.serializationStatsTracker.serializedFullState(uncompressedBytes, result.length());
            logger.trace("serialized full cluster state version [{}] for node version [{}] with size [{}]", (Object)clusterState.version(), (Object)nodeVersion, (Object)result.length());
            success = true;
            ReleasableBytesReference releasableBytesReference = result;
            return releasableBytesReference;
        }
        finally {
            if (!success) {
                ((BytesStreamOutput)bytesStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleasableBytesReference serializeDiffClusterState(long clusterStateVersion, Diff<ClusterState> diff, DiscoveryNode node) {
        Version nodeVersion = node.getVersion();
        ReleasableBytesStreamOutput bytesStream = new ReleasableBytesStreamOutput(this.bigArrays);
        boolean success = false;
        try {
            long uncompressedBytes;
            try (PositionTrackingOutputStreamStreamOutput stream = new PositionTrackingOutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(Streams.flushOnCloseStream(bytesStream)));){
                stream.setVersion(nodeVersion);
                stream.writeBoolean(false);
                diff.writeTo(stream);
                uncompressedBytes = ((StreamOutput)stream).position();
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to serialize cluster state diff for publishing to node {}", (Throwable)e, node);
            }
            ReleasableBytesReference result = new ReleasableBytesReference(bytesStream.bytes(), bytesStream::close);
            this.serializationStatsTracker.serializedDiff(uncompressedBytes, result.length());
            logger.trace("serialized cluster state diff for version [{}] for node version [{}] with size [{}]", (Object)clusterStateVersion, (Object)nodeVersion, (Object)result.length());
            success = true;
            ReleasableBytesReference releasableBytesReference = result;
            return releasableBytesReference;
        }
        finally {
            if (!success) {
                ((BytesStreamOutput)bytesStream).close();
            }
        }
    }

    private static class SerializationStatsTracker {
        private long fullStateCount;
        private long totalUncompressedFullStateBytes;
        private long totalCompressedFullStateBytes;
        private long diffCount;
        private long totalUncompressedDiffBytes;
        private long totalCompressedDiffBytes;

        private SerializationStatsTracker() {
        }

        public synchronized void serializedFullState(long uncompressedBytes, int compressedBytes) {
            ++this.fullStateCount;
            this.totalUncompressedFullStateBytes += uncompressedBytes;
            this.totalCompressedFullStateBytes += (long)compressedBytes;
        }

        public synchronized void serializedDiff(long uncompressedBytes, int compressedBytes) {
            ++this.diffCount;
            this.totalUncompressedDiffBytes += uncompressedBytes;
            this.totalCompressedDiffBytes += (long)compressedBytes;
        }

        public synchronized ClusterStateSerializationStats getSerializationStats() {
            return new ClusterStateSerializationStats(this.fullStateCount, this.totalUncompressedFullStateBytes, this.totalCompressedFullStateBytes, this.diffCount, this.totalUncompressedDiffBytes, this.totalCompressedDiffBytes);
        }
    }

    public class PublicationContext
    extends AbstractRefCounted {
        private final DiscoveryNodes discoveryNodes;
        private final ClusterState newState;
        private final ClusterState previousState;
        private final boolean sendFullVersion;
        private final Map<Version, ReleasableBytesReference> serializedStates = new ConcurrentHashMap<Version, ReleasableBytesReference>();
        private final Map<Version, ReleasableBytesReference> serializedDiffs = new HashMap<Version, ReleasableBytesReference>();

        PublicationContext(ClusterStatePublicationEvent clusterStatePublicationEvent) {
            this.discoveryNodes = clusterStatePublicationEvent.getNewState().nodes();
            this.newState = clusterStatePublicationEvent.getNewState();
            this.previousState = clusterStatePublicationEvent.getOldState();
            this.sendFullVersion = this.previousState.getBlocks().disableStatePersistence();
        }

        void buildDiffAndSerializeStates() {
            assert (this.refCount() > 0);
            LazyInitializable diffSupplier = new LazyInitializable(() -> this.newState.diff(this.previousState));
            for (DiscoveryNode node : this.discoveryNodes) {
                if (this.sendFullVersion || !this.previousState.nodes().nodeExists(node)) {
                    this.serializedStates.computeIfAbsent(node.getVersion(), v -> PublicationTransportHandler.this.serializeFullClusterState(this.newState, node));
                    continue;
                }
                this.serializedDiffs.computeIfAbsent(node.getVersion(), v -> PublicationTransportHandler.this.serializeDiffClusterState(this.newState.version(), (Diff)diffSupplier.getOrCompute(), node));
            }
        }

        public void sendPublishRequest(DiscoveryNode destination, final PublishRequest publishRequest, final ActionListener<PublishWithJoinResponse> listener) {
            ActionListener<PublishWithJoinResponse> responseActionListener;
            assert (this.refCount() > 0);
            assert (publishRequest.getAcceptedState() == this.newState) : "state got switched on us";
            assert (PublicationTransportHandler.this.transportService.getThreadPool().getThreadContext().isSystemContext());
            if (destination.equals(this.discoveryNodes.getLocalNode())) {
                PublishRequest previousRequest = PublicationTransportHandler.this.currentPublishRequestToSelf.getAndSet(publishRequest);
                assert (previousRequest == null || previousRequest.getAcceptedState().term() < publishRequest.getAcceptedState().term());
                responseActionListener = new ActionListener<PublishWithJoinResponse>(){

                    @Override
                    public void onResponse(PublishWithJoinResponse publishWithJoinResponse) {
                        PublicationTransportHandler.this.currentPublishRequestToSelf.compareAndSet(publishRequest, null);
                        listener.onResponse(publishWithJoinResponse);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        PublicationTransportHandler.this.currentPublishRequestToSelf.compareAndSet(publishRequest, null);
                        listener.onFailure(e);
                    }
                };
            } else {
                responseActionListener = listener;
            }
            if (this.sendFullVersion || !this.previousState.nodes().nodeExists(destination)) {
                logger.trace("sending full cluster state version [{}] to [{}]", (Object)this.newState.version(), (Object)destination);
                this.sendFullClusterState(destination, responseActionListener);
            } else {
                logger.trace("sending cluster state diff for version [{}] to [{}]", (Object)this.newState.version(), (Object)destination);
                this.sendClusterStateDiff(destination, responseActionListener);
            }
        }

        public void sendApplyCommit(DiscoveryNode destination, ApplyCommitRequest applyCommitRequest, ActionListener<TransportResponse.Empty> listener) {
            assert (PublicationTransportHandler.this.transportService.getThreadPool().getThreadContext().isSystemContext());
            PublicationTransportHandler.this.transportService.sendRequest(destination, PublicationTransportHandler.COMMIT_STATE_ACTION_NAME, (TransportRequest)applyCommitRequest, STATE_REQUEST_OPTIONS, new ActionListenerResponseHandler<TransportResponse.Empty>(listener, in -> TransportResponse.Empty.INSTANCE, "generic"));
        }

        private void sendFullClusterState(DiscoveryNode destination, ActionListener<PublishWithJoinResponse> listener) {
            assert (this.refCount() > 0);
            ReleasableBytesReference bytes = this.serializedStates.get(destination.getVersion());
            if (bytes == null) {
                try {
                    bytes = this.serializedStates.computeIfAbsent(destination.getVersion(), v -> PublicationTransportHandler.this.serializeFullClusterState(this.newState, destination));
                }
                catch (Exception e) {
                    logger.warn(() -> new ParameterizedMessage("failed to serialize cluster state before publishing it to node {}", (Object)destination), (Throwable)e);
                    listener.onFailure(e);
                    return;
                }
            }
            this.sendClusterState(destination, bytes, listener);
        }

        private void sendClusterStateDiff(DiscoveryNode destination, ActionListener<PublishWithJoinResponse> listener) {
            ReleasableBytesReference bytes = this.serializedDiffs.get(destination.getVersion());
            assert (bytes != null) : "failed to find serialized diff for node " + destination + " of version [" + destination.getVersion() + "]";
            if (!this.tryIncRef()) {
                assert (false);
                listener.onFailure(new IllegalStateException("publication context released before transmission"));
                return;
            }
            this.sendClusterState(destination, bytes, ActionListener.runAfter(listener.delegateResponse((delegate, e) -> {
                TransportException transportException;
                if (e instanceof TransportException && (transportException = (TransportException)e).unwrapCause() instanceof IncompatibleClusterStateVersionException) {
                    logger.debug(() -> new ParameterizedMessage("resending full cluster state to node {} reason {}", (Object)destination, (Object)transportException.getDetailedMessage()));
                    this.sendFullClusterState(destination, (ActionListener<PublishWithJoinResponse>)delegate);
                    return;
                }
                logger.debug((Message)new ParameterizedMessage("failed to send cluster state to {}", (Object)destination), (Throwable)e);
                delegate.onFailure((Exception)e);
            }), () -> ((PublicationContext)this).decRef()));
        }

        private void sendClusterState(DiscoveryNode destination, ReleasableBytesReference bytes, ActionListener<PublishWithJoinResponse> listener) {
            assert (this.refCount() > 0);
            if (!bytes.tryIncRef()) {
                assert (false);
                listener.onFailure(new IllegalStateException("serialized cluster state released before transmission"));
                return;
            }
            try {
                PublicationTransportHandler.this.transportService.sendRequest(destination, PublicationTransportHandler.PUBLISH_STATE_ACTION_NAME, (TransportRequest)new BytesTransportRequest(bytes, destination.getVersion()), STATE_REQUEST_OPTIONS, new ActionListenerResponseHandler<PublishWithJoinResponse>(ActionListener.runAfter(listener, bytes::decRef), PublishWithJoinResponse::new, "generic"));
            }
            catch (Exception e) {
                assert (false) : e;
                logger.warn(() -> new ParameterizedMessage("error sending cluster state to {}", (Object)destination), (Throwable)e);
                listener.onFailure(e);
            }
        }

        protected void closeInternal() {
            this.serializedDiffs.values().forEach(Releasables::closeExpectNoException);
            this.serializedStates.values().forEach(Releasables::closeExpectNoException);
        }
    }
}

