/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterInfo
implements ToXContentFragment,
Writeable {
    public static final Version DATA_SET_SIZE_SIZE_VERSION = Version.V_7_13_0;
    private final ImmutableOpenMap<String, DiskUsage> leastAvailableSpaceUsage;
    private final ImmutableOpenMap<String, DiskUsage> mostAvailableSpaceUsage;
    final ImmutableOpenMap<String, Long> shardSizes;
    final ImmutableOpenMap<ShardId, Long> shardDataSetSizes;
    public static final ClusterInfo EMPTY = new ClusterInfo();
    final ImmutableOpenMap<ShardRouting, String> routingToDataPath;
    final ImmutableOpenMap<NodeAndPath, ReservedSpace> reservedSpace;

    protected ClusterInfo() {
        this(ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of());
    }

    public ClusterInfo(ImmutableOpenMap<String, DiskUsage> leastAvailableSpaceUsage, ImmutableOpenMap<String, DiskUsage> mostAvailableSpaceUsage, ImmutableOpenMap<String, Long> shardSizes, ImmutableOpenMap<ShardId, Long> shardDataSetSizes, ImmutableOpenMap<ShardRouting, String> routingToDataPath, ImmutableOpenMap<NodeAndPath, ReservedSpace> reservedSpace) {
        this.leastAvailableSpaceUsage = leastAvailableSpaceUsage;
        this.shardSizes = shardSizes;
        this.shardDataSetSizes = shardDataSetSizes;
        this.mostAvailableSpaceUsage = mostAvailableSpaceUsage;
        this.routingToDataPath = routingToDataPath;
        this.reservedSpace = reservedSpace;
    }

    public ClusterInfo(StreamInput in) throws IOException {
        Map<String, DiskUsage> leastMap = in.readMap(StreamInput::readString, DiskUsage::new);
        Map<String, DiskUsage> mostMap = in.readMap(StreamInput::readString, DiskUsage::new);
        Map<String, Long> sizeMap = in.readMap(StreamInput::readString, StreamInput::readLong);
        Map<Object, Object> dataSetSizeMap = in.getVersion().onOrAfter(DATA_SET_SIZE_SIZE_VERSION) ? in.readMap(ShardId::new, StreamInput::readLong) : Map.of();
        Map<ShardRouting, String> routingMap = in.readMap(ShardRouting::new, StreamInput::readString);
        Map<Object, Object> reservedSpaceMap = in.getVersion().onOrAfter(StoreStats.RESERVED_BYTES_VERSION) ? in.readMap(NodeAndPath::new, ReservedSpace::new) : Map.of();
        ImmutableOpenMap.Builder<String, DiskUsage> leastBuilder = ImmutableOpenMap.builder();
        this.leastAvailableSpaceUsage = leastBuilder.putAll(leastMap).build();
        ImmutableOpenMap.Builder<String, DiskUsage> mostBuilder = ImmutableOpenMap.builder();
        this.mostAvailableSpaceUsage = mostBuilder.putAll(mostMap).build();
        ImmutableOpenMap.Builder<String, Long> sizeBuilder = ImmutableOpenMap.builder();
        this.shardSizes = sizeBuilder.putAll(sizeMap).build();
        ImmutableOpenMap.Builder dataSetSizeBuilder = ImmutableOpenMap.builder();
        this.shardDataSetSizes = dataSetSizeBuilder.putAll(dataSetSizeMap).build();
        ImmutableOpenMap.Builder<ShardRouting, String> routingBuilder = ImmutableOpenMap.builder();
        this.routingToDataPath = routingBuilder.putAll(routingMap).build();
        ImmutableOpenMap.Builder reservedSpaceBuilder = ImmutableOpenMap.builder();
        this.reservedSpace = reservedSpaceBuilder.putAll(reservedSpaceMap).build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.leastAvailableSpaceUsage.size());
        for (Map.Entry<String, DiskUsage> c : this.leastAvailableSpaceUsage.entrySet()) {
            out.writeString(c.getKey());
            c.getValue().writeTo(out);
        }
        out.writeMap(this.mostAvailableSpaceUsage, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        out.writeMap(this.shardSizes, StreamOutput::writeString, (o, v) -> out.writeLong(v == null ? -1L : v));
        if (out.getVersion().onOrAfter(DATA_SET_SIZE_SIZE_VERSION)) {
            out.writeMap(this.shardDataSetSizes, (o, s) -> s.writeTo(o), (o, v) -> out.writeLong((long)v));
        }
        out.writeMap(this.routingToDataPath, (o, k) -> k.writeTo(o), StreamOutput::writeString);
        if (out.getVersion().onOrAfter(StoreStats.RESERVED_BYTES_VERSION)) {
            out.writeMap(this.reservedSpace);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (Map.Entry<String, DiskUsage> entry : this.leastAvailableSpaceUsage.entrySet()) {
            builder.startObject(entry.getKey());
            builder.field("node_name", entry.getValue().getNodeName());
            builder.startObject("least_available");
            entry.getValue().toShortXContent(builder);
            builder.endObject();
            builder.startObject("most_available");
            DiskUsage most = this.mostAvailableSpaceUsage.get(entry.getKey());
            if (most != null) {
                most.toShortXContent(builder);
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        builder.startObject("shard_sizes");
        for (Map.Entry<String, Object> entry : this.shardSizes.entrySet()) {
            builder.humanReadableField(entry.getKey() + "_bytes", entry.getKey(), (Object)new ByteSizeValue((Long)entry.getValue()));
        }
        builder.endObject();
        builder.startObject("shard_data_set_sizes");
        for (Map.Entry<Object, Object> entry : this.shardDataSetSizes.entrySet()) {
            builder.humanReadableField(entry.getKey() + "_bytes", ((ShardId)entry.getKey()).toString(), (Object)new ByteSizeValue((Long)entry.getValue()));
        }
        builder.endObject();
        builder.startObject("shard_paths");
        for (Map.Entry<Object, Object> entry : this.routingToDataPath.entrySet()) {
            builder.field(((ShardRouting)entry.getKey()).toString(), (String)entry.getValue());
        }
        builder.endObject();
        builder.startArray("reserved_sizes");
        for (Map.Entry<Object, Object> entry : this.reservedSpace.entrySet()) {
            builder.startObject();
            builder.field("node_id", ((NodeAndPath)entry.getKey()).nodeId);
            builder.field("path", ((NodeAndPath)entry.getKey()).path);
            ((ReservedSpace)entry.getValue()).toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public ImmutableOpenMap<String, DiskUsage> getNodeLeastAvailableDiskUsages() {
        return this.leastAvailableSpaceUsage;
    }

    public ImmutableOpenMap<String, DiskUsage> getNodeMostAvailableDiskUsages() {
        return this.mostAvailableSpaceUsage;
    }

    public Long getShardSize(ShardRouting shardRouting) {
        return this.shardSizes.get(ClusterInfo.shardIdentifierFromRouting(shardRouting));
    }

    public String getDataPath(ShardRouting shardRouting) {
        return this.routingToDataPath.get(shardRouting);
    }

    public long getShardSize(ShardRouting shardRouting, long defaultValue) {
        Long shardSize = this.getShardSize(shardRouting);
        return shardSize == null ? defaultValue : shardSize;
    }

    public Optional<Long> getShardDataSetSize(ShardId shardId) {
        return Optional.ofNullable(this.shardDataSetSizes.get(shardId));
    }

    public ReservedSpace getReservedSpace(String nodeId, String dataPath) {
        ReservedSpace result = this.reservedSpace.get(new NodeAndPath(nodeId, dataPath));
        return result == null ? ReservedSpace.EMPTY : result;
    }

    public static String shardIdentifierFromRouting(ShardRouting shardRouting) {
        return shardRouting.shardId().toString() + "[" + (shardRouting.primary() ? "p" : "r") + "]";
    }

    public static class NodeAndPath
    implements Writeable {
        public final String nodeId;
        public final String path;

        public NodeAndPath(String nodeId, String path) {
            this.nodeId = Objects.requireNonNull(nodeId);
            this.path = Objects.requireNonNull(path);
        }

        public NodeAndPath(StreamInput in) throws IOException {
            this.nodeId = in.readString();
            this.path = in.readString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeAndPath that = (NodeAndPath)o;
            return this.nodeId.equals(that.nodeId) && this.path.equals(that.path);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.path);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeString(this.path);
        }
    }

    public static class ReservedSpace
    implements Writeable {
        public static final ReservedSpace EMPTY = new ReservedSpace(0L, new HashSet<ShardId>());
        private final long total;
        private final HashSet<ShardId> shardIds;

        private ReservedSpace(long total, HashSet<ShardId> shardIds) {
            this.total = total;
            this.shardIds = shardIds;
        }

        ReservedSpace(StreamInput in) throws IOException {
            this.total = in.readVLong();
            int shardIdCount = in.readVInt();
            this.shardIds = new HashSet(shardIdCount);
            for (int i = 0; i < shardIdCount; ++i) {
                this.shardIds.add(new ShardId(in));
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.total);
            out.writeVInt(this.shardIds.size());
            for (ShardId shardIdCursor : this.shardIds) {
                shardIdCursor.writeTo(out);
            }
        }

        public long getTotal() {
            return this.total;
        }

        public boolean containsShardId(ShardId shardId) {
            return this.shardIds.contains(shardId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReservedSpace that = (ReservedSpace)o;
            return this.total == that.total && this.shardIds.equals(that.shardIds);
        }

        public int hashCode() {
            return Objects.hash(this.total, this.shardIds);
        }

        void toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("total", this.total);
            builder.startArray("shards");
            for (ShardId shardIdCursor : this.shardIds) {
                shardIdCursor.toXContent(builder, params);
            }
            builder.endArray();
        }

        public static class Builder {
            private long total;
            private HashSet<ShardId> shardIds = new HashSet();

            public ReservedSpace build() {
                assert (this.shardIds != null) : "already built";
                ReservedSpace reservedSpace = new ReservedSpace(this.total, this.shardIds);
                this.shardIds = null;
                return reservedSpace;
            }

            public Builder add(ShardId shardId, long reservedBytes) {
                assert (this.shardIds != null) : "already built";
                assert (reservedBytes >= 0L) : reservedBytes;
                this.shardIds.add(shardId);
                this.total += reservedBytes;
                return this;
            }
        }
    }
}

