/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.node;

import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskListener;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;

public class NodeClient
extends AbstractClient {
    private Map<ActionType<? extends ActionResponse>, TransportAction<? extends ActionRequest, ? extends ActionResponse>> actions;
    private TaskManager taskManager;
    private Supplier<String> localNodeId;
    private Transport.Connection localConnection;
    private RemoteClusterService remoteClusterService;
    private NamedWriteableRegistry namedWriteableRegistry;

    public NodeClient(Settings settings, ThreadPool threadPool) {
        super(settings, threadPool);
    }

    public void initialize(Map<ActionType<? extends ActionResponse>, TransportAction<? extends ActionRequest, ? extends ActionResponse>> actions, TaskManager taskManager, Supplier<String> localNodeId, Transport.Connection localConnection, RemoteClusterService remoteClusterService, NamedWriteableRegistry namedWriteableRegistry) {
        this.actions = actions;
        this.taskManager = taskManager;
        this.localNodeId = localNodeId;
        this.localConnection = localConnection;
        this.remoteClusterService = remoteClusterService;
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    public void close() {
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        try {
            this.executeLocally(action, request, listener);
        }
        catch (IllegalArgumentException | IllegalStateException | TaskCancelledException e) {
            listener.onFailure(e);
        }
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        return this.taskManager.registerAndExecute("transport", this.transportAction(action), request, this.localConnection, (t, r) -> {
            try {
                listener.onResponse(r);
            }
            catch (Exception e) {
                assert (false) : new AssertionError("callback must handle its own exceptions", e);
                throw e;
            }
        }, (t, e) -> {
            try {
                listener.onFailure((Exception)e);
            }
            catch (Exception ex) {
                ex.addSuppressed((Throwable)e);
                assert (false) : new AssertionError("callback must handle its own exceptions", ex);
                throw ex;
            }
        });
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, TaskListener<Response> listener) {
        return this.taskManager.registerAndExecute("transport", this.transportAction(action), request, this.localConnection, listener::onResponse, listener::onFailure);
    }

    public String getLocalNodeId() {
        return this.localNodeId.get();
    }

    private <Request extends ActionRequest, Response extends ActionResponse> TransportAction<Request, Response> transportAction(ActionType<Response> action) {
        if (this.actions == null) {
            throw new IllegalStateException("NodeClient has not been initialized");
        }
        TransportAction<? extends ActionRequest, ? extends ActionResponse> transportAction = this.actions.get(action);
        if (transportAction == null) {
            throw new IllegalStateException("failed to find action [" + action + "] to execute");
        }
        return transportAction;
    }

    @Override
    public Client getRemoteClusterClient(String clusterAlias) {
        return this.remoteClusterService.getRemoteClusterClient(this.threadPool(), clusterAlias, true);
    }

    public NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }
}

