/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.util.Map;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainRequestBuilder;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequestBuilder;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollRequestBuilder;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequestBuilder;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsRequestBuilder;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;

public interface Client
extends ElasticsearchClient,
Releasable {
    public static final Setting<String> CLIENT_TYPE_SETTING_S = new Setting<String>("client.type", "node", s -> {
        switch (s) {
            case "node": 
            case "transport": {
                return s;
            }
        }
        throw new IllegalArgumentException("Can't parse [client.type] must be one of [node, transport]");
    }, Setting.Property.NodeScope);

    public AdminClient admin();

    public ActionFuture<IndexResponse> index(IndexRequest var1);

    public void index(IndexRequest var1, ActionListener<IndexResponse> var2);

    public IndexRequestBuilder prepareIndex();

    public IndexRequestBuilder prepareIndex(String var1);

    public ActionFuture<UpdateResponse> update(UpdateRequest var1);

    public void update(UpdateRequest var1, ActionListener<UpdateResponse> var2);

    public UpdateRequestBuilder prepareUpdate();

    public UpdateRequestBuilder prepareUpdate(String var1, String var2);

    public ActionFuture<DeleteResponse> delete(DeleteRequest var1);

    public void delete(DeleteRequest var1, ActionListener<DeleteResponse> var2);

    public DeleteRequestBuilder prepareDelete();

    public DeleteRequestBuilder prepareDelete(String var1, String var2);

    public ActionFuture<BulkResponse> bulk(BulkRequest var1);

    public void bulk(BulkRequest var1, ActionListener<BulkResponse> var2);

    public BulkRequestBuilder prepareBulk();

    public BulkRequestBuilder prepareBulk(@Nullable String var1);

    public ActionFuture<GetResponse> get(GetRequest var1);

    public void get(GetRequest var1, ActionListener<GetResponse> var2);

    public GetRequestBuilder prepareGet();

    public GetRequestBuilder prepareGet(String var1, String var2);

    public ActionFuture<MultiGetResponse> multiGet(MultiGetRequest var1);

    public void multiGet(MultiGetRequest var1, ActionListener<MultiGetResponse> var2);

    public MultiGetRequestBuilder prepareMultiGet();

    public ActionFuture<SearchResponse> search(SearchRequest var1);

    public void search(SearchRequest var1, ActionListener<SearchResponse> var2);

    public SearchRequestBuilder prepareSearch(String ... var1);

    public ActionFuture<SearchResponse> searchScroll(SearchScrollRequest var1);

    public void searchScroll(SearchScrollRequest var1, ActionListener<SearchResponse> var2);

    public SearchScrollRequestBuilder prepareSearchScroll(String var1);

    public ActionFuture<MultiSearchResponse> multiSearch(MultiSearchRequest var1);

    public void multiSearch(MultiSearchRequest var1, ActionListener<MultiSearchResponse> var2);

    public MultiSearchRequestBuilder prepareMultiSearch();

    public ActionFuture<TermVectorsResponse> termVectors(TermVectorsRequest var1);

    public void termVectors(TermVectorsRequest var1, ActionListener<TermVectorsResponse> var2);

    public TermVectorsRequestBuilder prepareTermVectors();

    public TermVectorsRequestBuilder prepareTermVectors(String var1, String var2);

    public ActionFuture<MultiTermVectorsResponse> multiTermVectors(MultiTermVectorsRequest var1);

    public void multiTermVectors(MultiTermVectorsRequest var1, ActionListener<MultiTermVectorsResponse> var2);

    public MultiTermVectorsRequestBuilder prepareMultiTermVectors();

    public ExplainRequestBuilder prepareExplain(String var1, String var2);

    public ActionFuture<ExplainResponse> explain(ExplainRequest var1);

    public void explain(ExplainRequest var1, ActionListener<ExplainResponse> var2);

    public ClearScrollRequestBuilder prepareClearScroll();

    public ActionFuture<ClearScrollResponse> clearScroll(ClearScrollRequest var1);

    public void clearScroll(ClearScrollRequest var1, ActionListener<ClearScrollResponse> var2);

    public FieldCapabilitiesRequestBuilder prepareFieldCaps(String ... var1);

    public ActionFuture<FieldCapabilitiesResponse> fieldCaps(FieldCapabilitiesRequest var1);

    public void fieldCaps(FieldCapabilitiesRequest var1, ActionListener<FieldCapabilitiesResponse> var2);

    public Settings settings();

    public Client filterWithHeader(Map<String, String> var1);

    default public Client getRemoteClusterClient(String clusterAlias) {
        throw new UnsupportedOperationException("this client doesn't support remote cluster connections");
    }
}

