/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapChecks;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.bootstrap.BootstrapException;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.BootstrapSettings;
import org.elasticsearch.bootstrap.BootstrapUtil;
import org.elasticsearch.bootstrap.ConsoleCtrlHandler;
import org.elasticsearch.bootstrap.ConsoleLoader;
import org.elasticsearch.bootstrap.ElasticsearchUncaughtExceptionHandler;
import org.elasticsearch.bootstrap.JNAKernel32Library;
import org.elasticsearch.bootstrap.Natives;
import org.elasticsearch.bootstrap.Security;
import org.elasticsearch.bootstrap.Spawner;
import org.elasticsearch.bootstrap.StartupException;
import org.elasticsearch.bootstrap.plugins.PluginsManager;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.PidFile;
import org.elasticsearch.common.filesystem.FileSystemNatives;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.IfConfig;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.monitor.jvm.HotThreads;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;

final class Bootstrap {
    private static volatile Bootstrap INSTANCE;
    private volatile Node node;
    private final CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private final Thread keepAliveThread;
    private final Spawner spawner = new Spawner();

    Bootstrap() {
        this.keepAliveThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Bootstrap.this.keepAliveLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "elasticsearch[keepAlive/" + Version.CURRENT + "]");
        this.keepAliveThread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Bootstrap.this.keepAliveLatch.countDown();
            }
        });
    }

    static void initializeNatives(Path tmpFile, boolean mlockAll, boolean systemCallFilter, boolean ctrlHandler) {
        final Logger logger = LogManager.getLogger(Bootstrap.class);
        if (Natives.definitelyRunningAsRoot()) {
            throw new RuntimeException("can not run elasticsearch as root");
        }
        if (systemCallFilter) {
            Natives.tryInstallSystemCallFilter(tmpFile);
        }
        if (mlockAll) {
            if (Constants.WINDOWS) {
                Natives.tryVirtualLock();
            } else {
                Natives.tryMlockall();
            }
        }
        if (ctrlHandler) {
            Natives.addConsoleCtrlHandler(new ConsoleCtrlHandler(){

                @Override
                public boolean handle(int code) {
                    if (2 == code) {
                        logger.info("running graceful exit on windows");
                        try {
                            Bootstrap.stop();
                        }
                        catch (IOException e) {
                            throw new ElasticsearchException("failed to stop node", (Throwable)e, new Object[0]);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        try {
            JNAKernel32Library.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Natives.trySetMaxNumberOfThreads();
        Natives.trySetMaxSizeVirtualMemory();
        Natives.trySetMaxFileSize();
        StringHelper.randomId();
        FileSystemNatives.init();
    }

    static void initializeProbes() {
        ProcessProbe.getInstance();
        OsProbe.getInstance();
        JvmInfo.jvmInfo();
        HotThreads.initializeRuntimeMonitoring();
    }

    private void setup(boolean addShutdownHook, Environment environment) throws BootstrapException {
        Settings settings = environment.settings();
        try {
            this.spawner.spawnNativeControllers(environment, true);
        }
        catch (IOException e) {
            throw new BootstrapException(e);
        }
        try {
            environment.validateNativesConfig();
        }
        catch (IOException e) {
            throw new BootstrapException(e);
        }
        Bootstrap.initializeNatives(environment.tmpFile(), BootstrapSettings.MEMORY_LOCK_SETTING.get(settings), true, BootstrapSettings.CTRLHANDLER_SETTING.get(settings));
        Bootstrap.initializeProbes();
        if (addShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        IOUtils.close((Closeable[])new Closeable[]{Bootstrap.this.node, Bootstrap.this.spawner});
                        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                        Configurator.shutdown((LoggerContext)context);
                        if (Bootstrap.this.node != null && !Bootstrap.this.node.awaitClose(10L, TimeUnit.SECONDS)) {
                            throw new IllegalStateException("Node didn't stop within 10 seconds. Any outstanding requests or tasks might get killed.");
                        }
                    }
                    catch (IOException ex) {
                        throw new ElasticsearchException("failed to stop node", (Throwable)ex, new Object[0]);
                    }
                    catch (InterruptedException e) {
                        LogManager.getLogger(Bootstrap.class).warn("Thread got interrupted while waiting for the node to shutdown.");
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
        try {
            Logger logger = LogManager.getLogger(JarHell.class);
            JarHell.checkJarHell(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        catch (IOException | URISyntaxException e) {
            throw new BootstrapException(e);
        }
        IfConfig.logIfNecessary();
        try {
            Security.configure(environment, BootstrapSettings.SECURITY_FILTER_BAD_DEFAULTS_SETTING.get(settings));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new BootstrapException(e);
        }
        this.node = new Node(environment){

            @Override
            protected void validateNodeBeforeAcceptingRequests(BootstrapContext context, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> checks) throws NodeValidationException {
                BootstrapChecks.check(context, boundTransportAddress, checks);
            }
        };
    }

    private static Environment createEnvironment(Path pidFile, SecureSettings secureSettings, Settings initialSettings, Path configPath) {
        Settings.Builder builder = Settings.builder();
        if (pidFile != null) {
            builder.put(Environment.NODE_PIDFILE_SETTING.getKey(), pidFile);
        }
        builder.put(initialSettings);
        if (secureSettings != null) {
            builder.setSecureSettings(secureSettings);
        }
        return InternalSettingsPreparer.prepareEnvironment(builder.build(), Collections.emptyMap(), configPath, () -> System.getenv("HOSTNAME"));
    }

    private void start() throws NodeValidationException {
        this.node.start();
        this.keepAliveThread.start();
    }

    static void stop() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{Bootstrap.INSTANCE.node, Bootstrap.INSTANCE.spawner});
            if (Bootstrap.INSTANCE.node != null && !Bootstrap.INSTANCE.node.awaitClose(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Node didn't stop within 10 seconds. Any outstanding requests or tasks might get killed.");
            }
        }
        catch (InterruptedException e) {
            LogManager.getLogger(Bootstrap.class).warn("Thread got interrupted while waiting for the node to shutdown.");
            Thread.currentThread().interrupt();
        }
        finally {
            Bootstrap.INSTANCE.keepAliveLatch.countDown();
        }
    }

    static void init(boolean foreground, Path pidFile, boolean quiet, Environment initialEnv) throws BootstrapException, NodeValidationException, UserException {
        BootstrapInfo.init();
        INSTANCE = new Bootstrap();
        SecureSettings keystore = BootstrapUtil.loadSecureSettings(initialEnv);
        Environment environment = Bootstrap.createEnvironment(pidFile, keystore, initialEnv.settings(), initialEnv.configFile());
        BootstrapInfo.setConsoleOutput(Bootstrap.getConsole(environment));
        Runnable sysOutCloser = Bootstrap.getSysOutCloser();
        Runnable sysErrorCloser = Bootstrap.getSysErrorCloser();
        LogConfigurator.setNodeName(Node.NODE_NAME_SETTING.get(environment.settings()));
        try {
            LogConfigurator.configure(environment);
        }
        catch (IOException e) {
            throw new BootstrapException(e);
        }
        if (environment.pidFile() != null) {
            try {
                PidFile.create(environment.pidFile(), true);
            }
            catch (IOException e) {
                throw new BootstrapException(e);
            }
        }
        try {
            boolean closeStandardStreams;
            boolean bl = closeStandardStreams = !foreground || quiet;
            if (closeStandardStreams) {
                Logger rootLogger = LogManager.getRootLogger();
                Appender maybeConsoleAppender = Loggers.findAppender(rootLogger, ConsoleAppender.class);
                if (maybeConsoleAppender != null) {
                    Loggers.removeAppender(rootLogger, maybeConsoleAppender);
                }
                sysOutCloser.run();
            }
            Bootstrap.checkLucene();
            Thread.setDefaultUncaughtExceptionHandler(new ElasticsearchUncaughtExceptionHandler());
            if (PluginsManager.configExists(environment)) {
                if (Build.CURRENT.type() == Build.Type.DOCKER) {
                    try {
                        PluginsManager.syncPlugins(environment);
                    }
                    catch (Exception e) {
                        throw new BootstrapException(e);
                    }
                } else {
                    throw new BootstrapException(new ElasticsearchException("Can only use [elasticsearch-plugins.yml] config file with distribution type [docker]", new Object[0]));
                }
            }
            INSTANCE.setup(true, environment);
            try {
                IOUtils.close((Closeable)keystore);
            }
            catch (IOException e) {
                throw new BootstrapException(e);
            }
            INSTANCE.start();
            if (!foreground) {
                sysErrorCloser.run();
            }
        }
        catch (RuntimeException | NodeValidationException e) {
            Logger rootLogger = LogManager.getRootLogger();
            Appender maybeConsoleAppender = Loggers.findAppender(rootLogger, ConsoleAppender.class);
            if (foreground && maybeConsoleAppender != null) {
                Loggers.removeAppender(rootLogger, maybeConsoleAppender);
            }
            Logger logger = LogManager.getLogger(Bootstrap.class);
            if (e instanceof CreationException) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream ps = null;
                try {
                    ps = new PrintStream((OutputStream)os, false, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    assert (false);
                    e.addSuppressed(uee);
                }
                new StartupException(e).printStackTrace(ps);
                ps.flush();
                try {
                    logger.error("Guice Exception: {}", (Object)os.toString("UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    assert (false);
                    e.addSuppressed(uee);
                }
            } else if (e instanceof NodeValidationException) {
                logger.error("node validation exception\n{}", (Object)e.getMessage());
            } else {
                logger.error("Exception", (Throwable)e);
            }
            if (foreground && maybeConsoleAppender != null) {
                Loggers.addAppender(rootLogger, maybeConsoleAppender);
            }
            throw e;
        }
    }

    private static PrintStream getConsole(Environment environment) {
        return ConsoleLoader.loadConsole(environment);
    }

    @SuppressForbidden(reason="System#out")
    private static Runnable getSysOutCloser() {
        return System.out::close;
    }

    @SuppressForbidden(reason="System#err")
    private static Runnable getSysErrorCloser() {
        return System.err::close;
    }

    private static void checkLucene() {
        if (!Version.CURRENT.luceneVersion.equals((Object)org.apache.lucene.util.Version.LATEST)) {
            throw new AssertionError((Object)("Lucene version mismatch this version of Elasticsearch requires lucene version [" + Version.CURRENT.luceneVersion + "]  but the current lucene version is [" + org.apache.lucene.util.Version.LATEST + "]"));
        }
    }
}

