/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ParserConstructor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class FieldCapabilities
implements Writeable,
ToXContentObject {
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField IS_METADATA_FIELD = new ParseField("metadata_field", new String[0]);
    private static final ParseField SEARCHABLE_FIELD = new ParseField("searchable", new String[0]);
    private static final ParseField AGGREGATABLE_FIELD = new ParseField("aggregatable", new String[0]);
    private static final ParseField TIME_SERIES_DIMENSION_FIELD = new ParseField("time_series_dimension", new String[0]);
    private static final ParseField TIME_SERIES_METRIC_FIELD = new ParseField("time_series_metric", new String[0]);
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ParseField NON_SEARCHABLE_INDICES_FIELD = new ParseField("non_searchable_indices", new String[0]);
    private static final ParseField NON_AGGREGATABLE_INDICES_FIELD = new ParseField("non_aggregatable_indices", new String[0]);
    private static final ParseField NON_DIMENSION_INDICES_FIELD = new ParseField("non_dimension_indices", new String[0]);
    private static final ParseField METRIC_CONFLICTS_INDICES_FIELD = new ParseField("metric_conflicts_indices", new String[0]);
    private static final ParseField META_FIELD = new ParseField("meta", new String[0]);
    private final String name;
    private final String type;
    private final boolean isMetadataField;
    private final boolean isSearchable;
    private final boolean isAggregatable;
    private final boolean isDimension;
    private final TimeSeriesParams.MetricType metricType;
    private final String[] indices;
    private final String[] nonSearchableIndices;
    private final String[] nonAggregatableIndices;
    private final String[] nonDimensionIndices;
    private final String[] metricConflictsIndices;
    private final Map<String, Set<String>> meta;
    private static final InstantiatingObjectParser<FieldCapabilities, String> PARSER;

    public FieldCapabilities(String name, String type, boolean isMetadataField, boolean isSearchable, boolean isAggregatable, boolean isDimension, TimeSeriesParams.MetricType metricType, String[] indices, String[] nonSearchableIndices, String[] nonAggregatableIndices, String[] nonDimensionIndices, String[] metricConflictsIndices, Map<String, Set<String>> meta) {
        this.name = name;
        this.type = type;
        this.isMetadataField = isMetadataField;
        this.isSearchable = isSearchable;
        this.isAggregatable = isAggregatable;
        this.isDimension = isDimension;
        this.metricType = metricType;
        this.indices = indices;
        this.nonSearchableIndices = nonSearchableIndices;
        this.nonAggregatableIndices = nonAggregatableIndices;
        this.nonDimensionIndices = nonDimensionIndices;
        this.metricConflictsIndices = metricConflictsIndices;
        this.meta = Objects.requireNonNull(meta);
    }

    public FieldCapabilities(String name, String type, boolean isMetadataField, boolean isSearchable, boolean isAggregatable, String[] indices, String[] nonSearchableIndices, String[] nonAggregatableIndices, Map<String, Set<String>> meta) {
        this(name, type, isMetadataField, isSearchable, isAggregatable, false, null, indices, nonSearchableIndices, nonAggregatableIndices, null, null, meta);
    }

    @ParserConstructor
    public FieldCapabilities(String name, String type, Boolean isMetadataField, boolean isSearchable, boolean isAggregatable, Boolean isDimension, String metricType, List<String> indices, List<String> nonSearchableIndices, List<String> nonAggregatableIndices, List<String> nonDimensionIndices, List<String> metricConflictsIndices, Map<String, Set<String>> meta) {
        this(name, type, isMetadataField == null ? false : isMetadataField, isSearchable, isAggregatable, isDimension == null ? false : isDimension, metricType != null ? Enum.valueOf(TimeSeriesParams.MetricType.class, metricType) : null, indices != null ? indices.toArray(new String[0]) : null, nonSearchableIndices != null ? nonSearchableIndices.toArray(new String[0]) : null, nonAggregatableIndices != null ? nonAggregatableIndices.toArray(new String[0]) : null, nonDimensionIndices != null ? nonDimensionIndices.toArray(new String[0]) : null, metricConflictsIndices != null ? metricConflictsIndices.toArray(new String[0]) : null, meta != null ? meta : Collections.emptyMap());
    }

    FieldCapabilities(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.isMetadataField = in.readBoolean();
        this.isSearchable = in.readBoolean();
        this.isAggregatable = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_8_0_0)) {
            this.isDimension = in.readBoolean();
            this.metricType = in.readOptionalEnum(TimeSeriesParams.MetricType.class);
        } else {
            this.isDimension = false;
            this.metricType = null;
        }
        this.indices = in.readOptionalStringArray();
        this.nonSearchableIndices = in.readOptionalStringArray();
        this.nonAggregatableIndices = in.readOptionalStringArray();
        if (in.getVersion().onOrAfter(Version.V_8_0_0)) {
            this.nonDimensionIndices = in.readOptionalStringArray();
            this.metricConflictsIndices = in.readOptionalStringArray();
        } else {
            this.nonDimensionIndices = null;
            this.metricConflictsIndices = null;
        }
        this.meta = in.readMap(StreamInput::readString, i -> i.readSet(StreamInput::readString));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeBoolean(this.isMetadataField);
        out.writeBoolean(this.isSearchable);
        out.writeBoolean(this.isAggregatable);
        if (out.getVersion().onOrAfter(Version.V_8_0_0)) {
            out.writeBoolean(this.isDimension);
            out.writeOptionalEnum(this.metricType);
        }
        out.writeOptionalStringArray(this.indices);
        out.writeOptionalStringArray(this.nonSearchableIndices);
        out.writeOptionalStringArray(this.nonAggregatableIndices);
        if (out.getVersion().onOrAfter(Version.V_8_0_0)) {
            out.writeOptionalStringArray(this.nonDimensionIndices);
            out.writeOptionalStringArray(this.metricConflictsIndices);
        }
        out.writeMap(this.meta, StreamOutput::writeString, (o, set) -> o.writeCollection(set, StreamOutput::writeString));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(IS_METADATA_FIELD.getPreferredName(), this.isMetadataField);
        builder.field(SEARCHABLE_FIELD.getPreferredName(), this.isSearchable);
        builder.field(AGGREGATABLE_FIELD.getPreferredName(), this.isAggregatable);
        if (this.isDimension) {
            builder.field(TIME_SERIES_DIMENSION_FIELD.getPreferredName(), this.isDimension);
        }
        if (this.metricType != null) {
            builder.field(TIME_SERIES_METRIC_FIELD.getPreferredName(), (Enum)this.metricType);
        }
        if (this.indices != null) {
            builder.array(INDICES_FIELD.getPreferredName(), this.indices);
        }
        if (this.nonSearchableIndices != null) {
            builder.array(NON_SEARCHABLE_INDICES_FIELD.getPreferredName(), this.nonSearchableIndices);
        }
        if (this.nonAggregatableIndices != null) {
            builder.array(NON_AGGREGATABLE_INDICES_FIELD.getPreferredName(), this.nonAggregatableIndices);
        }
        if (this.nonDimensionIndices != null) {
            builder.field(NON_DIMENSION_INDICES_FIELD.getPreferredName(), (Object)this.nonDimensionIndices);
        }
        if (this.metricConflictsIndices != null) {
            builder.field(METRIC_CONFLICTS_INDICES_FIELD.getPreferredName(), (Object)this.metricConflictsIndices);
        }
        if (!this.meta.isEmpty()) {
            builder.startObject("meta");
            ArrayList<Map.Entry<String, Set<String>>> entries = new ArrayList<Map.Entry<String, Set<String>>>(this.meta.entrySet());
            entries.sort(Comparator.comparing(Map.Entry::getKey));
            for (Map.Entry entry : entries) {
                ArrayList values = new ArrayList((Collection)entry.getValue());
                values.sort(String::compareTo);
                builder.stringListField((String)entry.getKey(), values);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static FieldCapabilities fromXContent(String name, XContentParser parser) throws IOException {
        return (FieldCapabilities)PARSER.parse(parser, (Object)name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isMetadataField() {
        return this.isMetadataField;
    }

    public boolean isAggregatable() {
        return this.isAggregatable;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public boolean isDimension() {
        return this.isDimension;
    }

    public TimeSeriesParams.MetricType getMetricType() {
        return this.metricType;
    }

    public String getType() {
        return this.type;
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] nonSearchableIndices() {
        return this.nonSearchableIndices;
    }

    public String[] nonAggregatableIndices() {
        return this.nonAggregatableIndices;
    }

    public String[] nonDimensionIndices() {
        return this.nonDimensionIndices;
    }

    public String[] metricConflictsIndices() {
        return this.metricConflictsIndices;
    }

    public Map<String, Set<String>> meta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilities that = (FieldCapabilities)o;
        return this.isMetadataField == that.isMetadataField && this.isSearchable == that.isSearchable && this.isAggregatable == that.isAggregatable && this.isDimension == that.isDimension && Objects.equals((Object)this.metricType, (Object)that.metricType) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Arrays.equals(this.indices, that.indices) && Arrays.equals(this.nonSearchableIndices, that.nonSearchableIndices) && Arrays.equals(this.nonAggregatableIndices, that.nonAggregatableIndices) && Arrays.equals(this.nonDimensionIndices, that.nonDimensionIndices) && Arrays.equals(this.metricConflictsIndices, that.metricConflictsIndices) && Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.name, this.type, this.isMetadataField, this.isSearchable, this.isAggregatable, this.isDimension, this.metricType, this.meta});
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.nonSearchableIndices);
        result = 31 * result + Arrays.hashCode(this.nonAggregatableIndices);
        result = 31 * result + Arrays.hashCode(this.nonDimensionIndices);
        result = 31 * result + Arrays.hashCode(this.metricConflictsIndices);
        return result;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"field_capabilities", (boolean)true, FieldCapabilities.class);
        parser.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), IS_METADATA_FIELD);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), SEARCHABLE_FIELD);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), AGGREGATABLE_FIELD);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), TIME_SERIES_DIMENSION_FIELD);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TIME_SERIES_METRIC_FIELD);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), INDICES_FIELD);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), NON_SEARCHABLE_INDICES_FIELD);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), NON_AGGREGATABLE_INDICES_FIELD);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), NON_DIMENSION_INDICES_FIELD);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), METRIC_CONFLICTS_INDICES_FIELD);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, context) -> p.map(HashMap::new, v -> Set.copyOf(v.list())), META_FIELD);
        PARSER = parser.build();
    }

    private static class IndexCaps {
        final String name;
        final boolean isSearchable;
        final boolean isAggregatable;
        final boolean isDimension;
        final TimeSeriesParams.MetricType metricType;

        IndexCaps(String name, boolean isSearchable, boolean isAggregatable, boolean isDimension, TimeSeriesParams.MetricType metricType) {
            this.name = name;
            this.isSearchable = isSearchable;
            this.isAggregatable = isAggregatable;
            this.isDimension = isDimension;
            this.metricType = metricType;
        }
    }

    static class Builder {
        private final String name;
        private final String type;
        private boolean isMetadataField;
        private boolean isSearchable;
        private boolean isAggregatable;
        private boolean isDimension;
        private TimeSeriesParams.MetricType metricType;
        private boolean metricTypeIsSet;
        private List<IndexCaps> indiceList;
        private Map<String, Set<String>> meta;

        Builder(String name, String type) {
            this.name = name;
            this.type = type;
            this.isSearchable = true;
            this.isAggregatable = true;
            this.isDimension = true;
            this.metricType = null;
            this.metricTypeIsSet = false;
            this.indiceList = new ArrayList<IndexCaps>();
            this.meta = new HashMap<String, Set<String>>();
        }

        void add(String index, boolean isMetadataField, boolean search, boolean agg, boolean isDimension, TimeSeriesParams.MetricType metricType, Map<String, String> meta) {
            IndexCaps indexCaps = new IndexCaps(index, search, agg, isDimension, metricType);
            this.indiceList.add(indexCaps);
            this.isSearchable &= search;
            this.isAggregatable &= agg;
            this.isMetadataField |= isMetadataField;
            this.isDimension &= isDimension;
            if (this.metricTypeIsSet) {
                if (this.metricType != metricType) {
                    this.metricType = null;
                }
            } else {
                this.metricTypeIsSet = true;
                this.metricType = metricType;
            }
            for (Map.Entry<String, String> entry : meta.entrySet()) {
                this.meta.computeIfAbsent(entry.getKey(), key -> new HashSet()).add(entry.getValue());
            }
        }

        List<String> getIndices() {
            return this.indiceList.stream().map(c -> c.name).collect(Collectors.toList());
        }

        FieldCapabilities build(boolean withIndices) {
            Collections.sort(this.indiceList, Comparator.comparing(o -> o.name));
            String[] indices = withIndices ? (String[])this.indiceList.stream().map(caps -> caps.name).toArray(String[]::new) : null;
            String[] nonSearchableIndices = !this.isSearchable && this.indiceList.stream().anyMatch(caps -> caps.isSearchable) ? (String[])this.indiceList.stream().filter(caps -> !caps.isSearchable).map(caps -> caps.name).toArray(String[]::new) : null;
            String[] nonAggregatableIndices = !this.isAggregatable && this.indiceList.stream().anyMatch(caps -> caps.isAggregatable) ? (String[])this.indiceList.stream().filter(caps -> !caps.isAggregatable).map(caps -> caps.name).toArray(String[]::new) : null;
            String[] nonDimensionIndices = !this.isDimension && this.indiceList.stream().anyMatch(caps -> caps.isDimension) ? (String[])this.indiceList.stream().filter(caps -> !caps.isDimension).map(caps -> caps.name).toArray(String[]::new) : null;
            String[] metricConflictsIndices = this.indiceList.stream().anyMatch(caps -> caps.metricType != this.metricType) ? (String[])this.indiceList.stream().map(caps -> caps.name).toArray(String[]::new) : null;
            Function<Map.Entry, Set> entryValueFunction = Map.Entry::getValue;
            Map<String, Set<String>> immutableMeta = this.meta.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entryValueFunction.andThen(Set::copyOf)));
            return new FieldCapabilities(this.name, this.type, this.isMetadataField, this.isSearchable, this.isAggregatable, this.isDimension, this.metricType, indices, nonSearchableIndices, nonAggregatableIndices, nonDimensionIndices, metricConflictsIndices, immutableMeta);
        }
    }
}

