/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.stats.FieldScriptStats;
import org.elasticsearch.action.admin.cluster.stats.IndexFeatureStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class FieldStats
extends IndexFeatureStats {
    int scriptCount = 0;
    final Set<String> scriptLangs;
    final FieldScriptStats fieldScriptStats;

    FieldStats(String name) {
        super(name);
        this.scriptLangs = new HashSet<String>();
        this.fieldScriptStats = new FieldScriptStats();
    }

    FieldStats(StreamInput in) throws IOException {
        super(in);
        this.scriptCount = in.readVInt();
        this.scriptLangs = in.readSet(StreamInput::readString);
        this.fieldScriptStats = new FieldScriptStats(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.scriptCount);
        out.writeCollection(this.scriptLangs, StreamOutput::writeString);
        this.fieldScriptStats.writeTo(out);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("script_count", this.scriptCount);
        if (this.scriptCount > 0) {
            builder.array("lang", this.scriptLangs.toArray(new String[0]));
            this.fieldScriptStats.toXContent(builder, params);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FieldStats that = (FieldStats)o;
        return this.scriptCount == that.scriptCount && this.scriptLangs.equals(that.scriptLangs) && this.fieldScriptStats.equals(that.fieldScriptStats);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.scriptCount, this.scriptLangs, this.fieldScriptStats);
    }
}

