/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.migration;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PostFeatureUpgradeResponse
extends ActionResponse
implements ToXContentObject {
    private final boolean accepted;
    private final List<Feature> features;
    @Nullable
    private final String reason;
    @Nullable
    private final ElasticsearchException elasticsearchException;

    public PostFeatureUpgradeResponse(boolean accepted, List<Feature> features, @Nullable String reason, @Nullable ElasticsearchException exception) {
        this.accepted = accepted;
        this.features = Objects.nonNull(features) ? features : Collections.emptyList();
        this.reason = reason;
        this.elasticsearchException = exception;
    }

    public PostFeatureUpgradeResponse(StreamInput in) throws IOException {
        super(in);
        this.accepted = in.readBoolean();
        this.features = in.readList(Feature::new);
        this.reason = in.readOptionalString();
        this.elasticsearchException = in.readOptionalWriteable(ElasticsearchException::new);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("accepted", this.accepted);
        if (this.accepted) {
            builder.startArray("features");
            for (Feature feature : this.features) {
                feature.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (Objects.nonNull(this.reason)) {
            builder.field("reason", this.reason);
        }
        if (Objects.nonNull(this.elasticsearchException)) {
            builder.field("exception");
            builder.startObject();
            this.elasticsearchException.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.accepted);
        out.writeList(this.features);
        out.writeOptionalString(this.reason);
        out.writeOptionalWriteable(this.elasticsearchException);
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public List<Feature> getFeatures() {
        return Objects.isNull(this.features) ? Collections.emptyList() : this.features;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Nullable
    public ElasticsearchException getElasticsearchException() {
        return this.elasticsearchException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostFeatureUpgradeResponse that = (PostFeatureUpgradeResponse)o;
        return this.accepted == that.accepted && Objects.equals(this.features, that.features) && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.accepted, this.features, this.reason);
    }

    public String toString() {
        return "PostFeatureUpgradeResponse{accepted=" + this.accepted + ", features=" + this.features + ", reason='" + this.reason + "', elasticsearchException=" + this.elasticsearchException + "}";
    }

    public static class Feature
    implements Writeable,
    ToXContentObject {
        private final String featureName;

        public Feature(String featureName) {
            this.featureName = featureName;
        }

        public Feature(StreamInput in) throws IOException {
            this.featureName = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.featureName);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("feature_name", this.featureName);
            builder.endObject();
            return builder;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Feature feature = (Feature)o;
            return Objects.equals(this.featureName, feature.featureName);
        }

        public int hashCode() {
            return Objects.hash(this.featureName);
        }

        public String toString() {
            return "Feature{featureName='" + this.featureName + "'}";
        }
    }
}

