/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.Assertions;
import org.elasticsearch.Build;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class Version
implements Comparable<Version>,
ToXContentFragment {
    private static final org.apache.lucene.util.Version LUCENE_8_11_1 = org.apache.lucene.util.Version.fromBits((int)8, (int)11, (int)1);
    public static final int V_EMPTY_ID = 0;
    public static final Version V_EMPTY = new Version(0, org.apache.lucene.util.Version.LATEST);
    public static final Version V_7_0_0 = new Version(7000099, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_0_1 = new Version(7000199, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_1_0 = new Version(7010099, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_1_1 = new Version(7010199, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_2_0 = new Version(7020099, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_2_1 = new Version(7020199, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_7_3_0 = new Version(7030099, org.apache.lucene.util.Version.LUCENE_8_1_0);
    public static final Version V_7_3_1 = new Version(7030199, org.apache.lucene.util.Version.LUCENE_8_1_0);
    public static final Version V_7_3_2 = new Version(7030299, org.apache.lucene.util.Version.LUCENE_8_1_0);
    public static final Version V_7_4_0 = new Version(7040099, org.apache.lucene.util.Version.LUCENE_8_2_0);
    public static final Version V_7_4_1 = new Version(7040199, org.apache.lucene.util.Version.LUCENE_8_2_0);
    public static final Version V_7_4_2 = new Version(7040299, org.apache.lucene.util.Version.LUCENE_8_2_0);
    public static final Version V_7_5_0 = new Version(7050099, org.apache.lucene.util.Version.LUCENE_8_3_0);
    public static final Version V_7_5_1 = new Version(7050199, org.apache.lucene.util.Version.LUCENE_8_3_0);
    public static final Version V_7_5_2 = new Version(7050299, org.apache.lucene.util.Version.LUCENE_8_3_0);
    public static final Version V_7_6_0 = new Version(7060099, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_7_6_1 = new Version(7060199, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_7_6_2 = new Version(0x6BBB4B, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_7_7_0 = new Version(7070099, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_7_7_1 = new Version(7070199, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_7_8_0 = new Version(7080099, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_7_8_1 = new Version(7080199, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_7_9_0 = new Version(7090099, org.apache.lucene.util.Version.LUCENE_8_6_0);
    public static final Version V_7_9_1 = new Version(7090199, org.apache.lucene.util.Version.LUCENE_8_6_2);
    public static final Version V_7_9_2 = new Version(7090299, org.apache.lucene.util.Version.LUCENE_8_6_2);
    public static final Version V_7_9_3 = new Version(7090399, org.apache.lucene.util.Version.LUCENE_8_6_2);
    public static final Version V_7_10_0 = new Version(7100099, org.apache.lucene.util.Version.LUCENE_8_7_0);
    public static final Version V_7_10_1 = new Version(7100199, org.apache.lucene.util.Version.LUCENE_8_7_0);
    public static final Version V_7_10_2 = new Version(7100299, org.apache.lucene.util.Version.LUCENE_8_7_0);
    public static final Version V_7_11_0 = new Version(7110099, org.apache.lucene.util.Version.LUCENE_8_7_0);
    public static final Version V_7_11_1 = new Version(7110199, org.apache.lucene.util.Version.LUCENE_8_7_0);
    public static final Version V_7_11_2 = new Version(7110299, org.apache.lucene.util.Version.LUCENE_8_7_0);
    public static final Version V_7_12_0 = new Version(7120099, org.apache.lucene.util.Version.LUCENE_8_8_0);
    public static final Version V_7_12_1 = new Version(7120199, org.apache.lucene.util.Version.LUCENE_8_8_0);
    public static final Version V_7_13_0 = new Version(7130099, org.apache.lucene.util.Version.LUCENE_8_8_2);
    public static final Version V_7_13_1 = new Version(7130199, org.apache.lucene.util.Version.LUCENE_8_8_2);
    public static final Version V_7_13_2 = new Version(0x6CCCBB, org.apache.lucene.util.Version.LUCENE_8_8_2);
    public static final Version V_7_13_3 = new Version(7130399, org.apache.lucene.util.Version.LUCENE_8_8_2);
    public static final Version V_7_13_4 = new Version(7130499, org.apache.lucene.util.Version.LUCENE_8_8_2);
    public static final Version V_7_14_0 = new Version(7140099, org.apache.lucene.util.Version.LUCENE_8_9_0);
    public static final Version V_7_14_1 = new Version(7140199, org.apache.lucene.util.Version.LUCENE_8_9_0);
    public static final Version V_7_14_2 = new Version(7140299, org.apache.lucene.util.Version.LUCENE_8_9_0);
    public static final Version V_7_15_0 = new Version(7150099, org.apache.lucene.util.Version.LUCENE_8_9_0);
    public static final Version V_7_15_1 = new Version(7150199, org.apache.lucene.util.Version.LUCENE_8_9_0);
    public static final Version V_7_15_2 = new Version(7150299, org.apache.lucene.util.Version.LUCENE_8_9_0);
    public static final Version V_7_16_0 = new Version(7160099, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_7_16_1 = new Version(7160199, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_7_16_2 = new Version(7160299, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_7_16_3 = new Version(7160399, org.apache.lucene.util.Version.LUCENE_8_10_1);
    public static final Version V_7_17_0 = new Version(7170099, LUCENE_8_11_1);
    public static final Version V_8_0_0;
    public static final Version CURRENT;
    private static final ImmutableOpenIntMap<Version> idToVersion;
    private static final ImmutableOpenMap<String, Version> stringToVersion;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final org.apache.lucene.util.Version luceneVersion;
    private final String toString;
    private final int previousMajorId;
    private Version minCompatVersion;
    private Version minIndexCompatVersion;

    public static Version readVersion(StreamInput in) throws IOException {
        return Version.fromId(in.readVInt());
    }

    public static Version fromId(int id) {
        Version known = idToVersion.get(id);
        if (known != null) {
            return known;
        }
        return Version.fromIdSlow(id);
    }

    private static Version fromIdSlow(int id) {
        List<Version> versions = DeclaredVersionsHolder.DECLARED_VERSIONS;
        Version tmp = new Version(id, org.apache.lucene.util.Version.LATEST);
        int index = Collections.binarySearch(versions, tmp);
        if (index < 0) {
            index = -2 - index;
        } else assert (false) : "Version [" + tmp + "] is declared but absent from the switch statement in Version#fromId";
        org.apache.lucene.util.Version luceneVersion = index == -1 ? org.apache.lucene.util.Version.fromBits((int)(versions.get((int)0).luceneVersion.major - 1), (int)0, (int)0) : versions.get((int)index).luceneVersion;
        return new Version(id, luceneVersion);
    }

    public static void writeVersion(Version version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static Version min(Version version1, Version version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static Version max(Version version1, Version version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static Version fromString(String version) {
        if (!Strings.hasLength(version)) {
            return CURRENT;
        }
        Version cached = stringToVersion.get(version);
        if (cached != null) {
            return cached;
        }
        return Version.fromStringSlow(version);
    }

    private static Version fromStringSlow(String version) {
        String[] parts;
        boolean snapshot = version.endsWith("-SNAPSHOT");
        if (snapshot) {
            version = version.substring(0, version.length() - 9);
        }
        if ((parts = version.split("[.-]")).length != 3) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            if (rawMajor >= 5 && snapshot) {
                throw new IllegalArgumentException("illegal version format - snapshots are only supported until version 2.x");
            }
            if (rawMajor >= 7 && parts.length == 4) {
                throw new IllegalArgumentException("illegal version format - qualifiers are only supported until version 6.x");
            }
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            return Version.fromId(major + minor + revision + 99);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version " + version, e);
        }
    }

    Version(int id, org.apache.lucene.util.Version luceneVersion) {
        this.id = id;
        this.major = (byte)(id / 1000000 % 100);
        this.minor = (byte)(id / 10000 % 100);
        this.revision = (byte)(id / 100 % 100);
        this.build = (byte)(id % 100);
        this.luceneVersion = Objects.requireNonNull(luceneVersion);
        this.toString = this.major + "." + this.minor + "." + this.revision;
        this.previousMajorId = this.major > 0 ? (this.major - 1) * 1000000 + 99 : this.major;
    }

    public boolean after(Version version) {
        return version.id < this.id;
    }

    public boolean onOrAfter(Version version) {
        return version.id <= this.id;
    }

    public boolean before(Version version) {
        return version.id > this.id;
    }

    public boolean onOrBefore(Version version) {
        return version.id >= this.id;
    }

    @Override
    public int compareTo(Version other) {
        return Integer.compare(this.id, other.id);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public Version minimumCompatibilityVersion() {
        Version res = this.minCompatVersion;
        if (res == null) {
            this.minCompatVersion = res = this.computeMinCompatVersion();
        }
        return res;
    }

    private Version computeMinCompatVersion() {
        if (this.major == 6) {
            return Version.fromId(5060099);
        }
        if (this.major == 7) {
            return Version.fromId(6080099);
        }
        if (this.major >= 8) {
            Version bwcVersion = null;
            for (int i = DeclaredVersionsHolder.DECLARED_VERSIONS.size() - 1; i >= 0; --i) {
                Version candidateVersion = DeclaredVersionsHolder.DECLARED_VERSIONS.get(i);
                if (candidateVersion.major != this.major - 1 || !this.after(candidateVersion)) continue;
                if (bwcVersion != null && candidateVersion.minor < bwcVersion.minor) break;
                bwcVersion = candidateVersion;
            }
            return bwcVersion == null ? this : bwcVersion;
        }
        return Version.min(this, Version.fromId(this.major * 1000000 + 0 + 99));
    }

    public Version minimumIndexCompatibilityVersion() {
        Version res = this.minIndexCompatVersion;
        if (res == null) {
            this.minIndexCompatVersion = res = this.computeMinIndexCompatVersion();
        }
        return res;
    }

    private Version computeMinIndexCompatVersion() {
        int bwcMajor = this.major == 5 ? 2 : this.major - 1;
        boolean bwcMinor = false;
        return Version.min(this, Version.fromId(bwcMajor * 1000000 + 0 + 99));
    }

    public boolean isCompatible(Version version) {
        boolean compatible;
        boolean bl = compatible = this.onOrAfter(version.minimumCompatibilityVersion()) && version.onOrAfter(this.minimumCompatibilityVersion());
        assert (!compatible || Math.max(this.major, version.major) - Math.min(this.major, version.major) <= 1);
        return compatible;
    }

    public Version previousMajor() {
        return Version.fromId(this.previousMajorId);
    }

    @SuppressForbidden(reason="System.out.*")
    public static void main(String[] args) {
        String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s/%s, JVM: %s", Build.CURRENT.getQualifiedVersion(), Build.CURRENT.flavor().displayName(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), JvmInfo.jvmInfo().version());
        System.out.println(versionOutput);
    }

    public String toString() {
        return this.toString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    public static List<Version> getDeclaredVersions(Class<?> versionClass) {
        Field[] fields = versionClass.getFields();
        ArrayList<Version> versions = new ArrayList<Version>(fields.length);
        block9: for (Field field : fields) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) && Modifier.isFinal(mod) && Modifier.isPublic(mod) || field.getType() != Version.class) continue;
            switch (field.getName()) {
                case "CURRENT": 
                case "V_EMPTY": {
                    continue block9;
                }
                default: {
                    assert (field.getName().matches("V(_\\d+){3}?")) : field.getName();
                    try {
                        versions.add((Version)field.get(null));
                        continue block9;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        Collections.sort(versions);
        return versions;
    }

    static {
        CURRENT = V_8_0_0 = new Version(8000099, org.apache.lucene.util.Version.LUCENE_9_0_0);
        ImmutableOpenIntMap.Builder<Version> builder = ImmutableOpenIntMap.builder();
        ImmutableOpenMap.Builder<String, Version> builderByString = ImmutableOpenMap.builder();
        for (Field declaredField : Version.class.getFields()) {
            String fieldName;
            if (!declaredField.getType().equals(Version.class) || (fieldName = declaredField.getName()).equals("CURRENT") || fieldName.equals("V_EMPTY")) continue;
            assert (fieldName.matches("V_\\d+_\\d+_\\d+")) : "expected Version field [" + fieldName + "] to match V_\\d+_\\d+_\\d+";
            try {
                Version version = (Version)declaredField.get(null);
                if (Assertions.ENABLED) {
                    String[] fields = fieldName.split("_");
                    int major = Integer.valueOf(fields[1]) * 1000000;
                    int minor = Integer.valueOf(fields[2]) * 10000;
                    int revision = Integer.valueOf(fields[3]) * 100;
                    int expectedId = major + minor + revision + 99;
                    assert (version.id == expectedId) : "expected version [" + fieldName + "] to have id [" + expectedId + "] but was [" + version.id + "]";
                }
                Version maybePrevious = builder.put(version.id, version);
                builderByString.put(version.toString(), version);
                if ($assertionsDisabled || maybePrevious == null) continue;
                throw new AssertionError((Object)("expected [" + version.id + "] to be uniquely mapped but saw [" + maybePrevious + "] and [" + version + "]"));
            }
            catch (IllegalAccessException e) {
                assert (false) : "Version field [" + fieldName + "] should be public";
            }
        }
        assert (Version.CURRENT.luceneVersion.equals((Object)org.apache.lucene.util.Version.LATEST)) : "Version must be upgraded to [" + org.apache.lucene.util.Version.LATEST + "] is still set to [" + Version.CURRENT.luceneVersion + "]";
        assert (RestApiVersion.current().major == Version.CURRENT.major) : "RestApiVersion must be upgraded to reflect major from Version.CURRENT [" + Version.CURRENT.major + "] but is still set to [" + RestApiVersion.current().major + "]";
        builder.put(0, V_EMPTY);
        builderByString.put(V_EMPTY.toString(), V_EMPTY);
        idToVersion = builder.build();
        stringToVersion = builderByString.build();
    }

    private static class DeclaredVersionsHolder {
        static final List<Version> DECLARED_VERSIONS = Collections.unmodifiableList(Version.getDeclaredVersions(Version.class));

        private DeclaredVersionsHolder() {
        }
    }
}

