/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.capacity.memory;

import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.autoscaling.AutoscalingMetadata;
import org.elasticsearch.xpack.autoscaling.capacity.memory.AutoscalingMemoryInfo;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicy;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicyMetadata;

public class AutoscalingMemoryInfoService {
    public static final Setting<TimeValue> FETCH_TIMEOUT = Setting.timeSetting((String)"xpack.autoscaling.memory.monitor.timeout", (TimeValue)TimeValue.timeValueSeconds((long)15L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Long FETCHING_SENTINEL = Long.MIN_VALUE;
    private static final Logger logger = LogManager.getLogger(AutoscalingMemoryInfoService.class);
    private volatile ImmutableOpenMap<String, Long> nodeToMemory = ImmutableOpenMap.builder().build();
    private volatile TimeValue fetchTimeout;
    private final Client client;
    private final Object mutex = new Object();

    @Inject
    public AutoscalingMemoryInfoService(ClusterService clusterService, Client client) {
        this.client = client;
        this.fetchTimeout = (TimeValue)FETCH_TIMEOUT.get(clusterService.getSettings());
        if (DiscoveryNode.isMasterNode((Settings)clusterService.getSettings())) {
            clusterService.addListener(this::onClusterChanged);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(FETCH_TIMEOUT, this::setFetchTimeout);
        }
    }

    private void setFetchTimeout(TimeValue fetchTimeout) {
        this.fetchTimeout = fetchTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClusterChanged(ClusterChangedEvent event) {
        boolean master = event.localNodeMaster();
        ClusterState state = event.state();
        Set<DiscoveryNode> currentNodes = master ? this.relevantNodes(state) : Set.of();
        Set<DiscoveryNode> missingNodes = null;
        Object object = this.mutex;
        synchronized (object) {
            this.retainAliveNodes(currentNodes);
            if (master) {
                missingNodes = this.addMissingNodes(currentNodes);
            }
        }
        if (missingNodes != null) {
            this.sendToMissingNodes(arg_0 -> ((DiscoveryNodes)state.nodes()).get(arg_0), missingNodes);
        }
    }

    Set<DiscoveryNode> relevantNodes(ClusterState state) {
        Set<Set<DiscoveryNodeRole>> roleSets = this.calculateAutoscalingRoleSets(state);
        return StreamSupport.stream(state.nodes().spliterator(), false).filter(n -> roleSets.contains(n.getRoles())).collect(Collectors.toSet());
    }

    private Set<DiscoveryNode> addMissingNodes(Set<DiscoveryNode> nodes) {
        Set<DiscoveryNode> missingNodes;
        if (nodes.size() != this.nodeToMemory.size() && (missingNodes = nodes.stream().filter(dn -> !this.nodeToMemory.containsKey((Object)dn.getEphemeralId())).collect(Collectors.toSet())).size() > 0) {
            ImmutableOpenMap.Builder builder = ImmutableOpenMap.builder(this.nodeToMemory);
            missingNodes.stream().map(DiscoveryNode::getEphemeralId).forEach(id -> builder.put(id, (Object)FETCHING_SENTINEL));
            this.nodeToMemory = builder.build();
            return missingNodes;
        }
        return null;
    }

    private void sendToMissingNodes(final Function<String, DiscoveryNode> nodeLookup, final Set<DiscoveryNode> missingNodes) {
        this.client.admin().cluster().nodesStats((NodesStatsRequest)new NodesStatsRequest((String[])missingNodes.stream().map(DiscoveryNode::getId).toArray(String[]::new)).clear().addMetric(NodesStatsRequest.Metric.OS.metricName()).timeout(this.fetchTimeout), (ActionListener)new ActionListener<NodesStatsResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(NodesStatsResponse nodesStatsResponse) {
                Object object = AutoscalingMemoryInfoService.this.mutex;
                synchronized (object) {
                    ImmutableOpenMap.Builder builder = ImmutableOpenMap.builder(AutoscalingMemoryInfoService.this.nodeToMemory);
                    nodesStatsResponse.failures().stream().map(FailedNodeException::nodeId).map(nodeLookup).map(DiscoveryNode::getEphemeralId).forEach(arg_0 -> ((ImmutableOpenMap.Builder)builder).remove(arg_0));
                    nodesStatsResponse.getNodes().forEach(nodeStats -> AutoscalingMemoryInfoService.this.addNodeStats((ImmutableOpenMap.Builder<String, Long>)builder, (NodeStats)nodeStats));
                    AutoscalingMemoryInfoService.this.nodeToMemory = builder.build();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Exception e) {
                Object object = AutoscalingMemoryInfoService.this.mutex;
                synchronized (object) {
                    ImmutableOpenMap.Builder builder = ImmutableOpenMap.builder(AutoscalingMemoryInfoService.this.nodeToMemory);
                    missingNodes.stream().map(DiscoveryNode::getEphemeralId).forEach(arg_0 -> ((ImmutableOpenMap.Builder)builder).remove(arg_0));
                    AutoscalingMemoryInfoService.this.nodeToMemory = builder.build();
                }
                logger.warn("Unable to obtain memory info from [{}]", (Object)missingNodes);
            }
        });
    }

    private Set<Set<DiscoveryNodeRole>> calculateAutoscalingRoleSets(ClusterState state) {
        AutoscalingMetadata autoscalingMetadata = (AutoscalingMetadata)state.metadata().custom("autoscaling");
        if (autoscalingMetadata != null) {
            return autoscalingMetadata.policies().values().stream().map(AutoscalingPolicyMetadata::policy).map(AutoscalingPolicy::roles).map(this::toRoles).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private Set<DiscoveryNodeRole> toRoles(SortedSet<String> roleNames) {
        return roleNames.stream().map(DiscoveryNodeRole::getRoleFromRoleName).collect(Collectors.toSet());
    }

    private void retainAliveNodes(Set<DiscoveryNode> currentNodes) {
        assert (Thread.holdsLock(this.mutex));
        Set ephemeralIds = currentNodes.stream().map(DiscoveryNode::getEphemeralId).collect(Collectors.toSet());
        Set toRemove = StreamSupport.stream(this.nodeToMemory.keys().spliterator(), false).map(c -> (String)c.value).filter(Predicate.not(ephemeralIds::contains)).collect(Collectors.toSet());
        if (!toRemove.isEmpty()) {
            ImmutableOpenMap.Builder builder = ImmutableOpenMap.builder(this.nodeToMemory);
            builder.removeAll(toRemove::contains);
            this.nodeToMemory = builder.build();
        }
    }

    private void addNodeStats(ImmutableOpenMap.Builder<String, Long> builder, NodeStats nodeStats) {
        builder.put((Object)nodeStats.getNode().getEphemeralId(), (Object)nodeStats.getOs().getMem().getAdjustedTotal().getBytes());
    }

    public AutoscalingMemoryInfo snapshot() {
        ImmutableOpenMap<String, Long> nodeToMemoryRef = this.nodeToMemory;
        return node -> {
            Long result = (Long)nodeToMemoryRef.get((Object)node.getEphemeralId());
            if (result == FETCHING_SENTINEL) {
                return null;
            }
            return result;
        };
    }
}

