/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.stats;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.ingest.geoip.DatabaseNodeService;
import org.elasticsearch.ingest.geoip.GeoIpDownloader;
import org.elasticsearch.ingest.geoip.GeoIpDownloaderTaskExecutor;
import org.elasticsearch.ingest.geoip.stats.GeoIpDownloaderStats;
import org.elasticsearch.ingest.geoip.stats.GeoIpDownloaderStatsAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class GeoIpDownloaderStatsTransportAction
extends TransportNodesAction<GeoIpDownloaderStatsAction.Request, GeoIpDownloaderStatsAction.Response, GeoIpDownloaderStatsAction.NodeRequest, GeoIpDownloaderStatsAction.NodeResponse> {
    private final TransportService transportService;
    private final DatabaseNodeService registry;
    private final GeoIpDownloaderTaskExecutor geoIpDownloaderTaskExecutor;

    @Inject
    public GeoIpDownloaderStatsTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, DatabaseNodeService registry, GeoIpDownloaderTaskExecutor geoIpDownloaderTaskExecutor) {
        super("cluster:monitor/ingest/geoip/stats", threadPool, clusterService, transportService, actionFilters, GeoIpDownloaderStatsAction.Request::new, GeoIpDownloaderStatsAction.NodeRequest::new, "management", GeoIpDownloaderStatsAction.NodeResponse.class);
        this.transportService = transportService;
        this.registry = registry;
        this.geoIpDownloaderTaskExecutor = geoIpDownloaderTaskExecutor;
    }

    protected GeoIpDownloaderStatsAction.Response newResponse(GeoIpDownloaderStatsAction.Request request, List<GeoIpDownloaderStatsAction.NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new GeoIpDownloaderStatsAction.Response(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected GeoIpDownloaderStatsAction.NodeRequest newNodeRequest(GeoIpDownloaderStatsAction.Request request) {
        return new GeoIpDownloaderStatsAction.NodeRequest(request);
    }

    protected GeoIpDownloaderStatsAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new GeoIpDownloaderStatsAction.NodeResponse(in);
    }

    protected GeoIpDownloaderStatsAction.NodeResponse nodeOperation(GeoIpDownloaderStatsAction.NodeRequest request, Task task) {
        GeoIpDownloader geoIpTask = this.geoIpDownloaderTaskExecutor.getCurrentTask();
        GeoIpDownloaderStats stats = geoIpTask == null || geoIpTask.getStatus() == null ? null : geoIpTask.getStatus();
        return new GeoIpDownloaderStatsAction.NodeResponse(this.transportService.getLocalNode(), stats, this.registry.getAvailableDatabases(), this.registry.getFilesInTemp(), this.registry.getConfigDatabases());
    }
}

