/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rollup.RollupV2;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.rollup.action.DeleteRollupJobAction;
import org.elasticsearch.xpack.core.rollup.action.GetRollupCapsAction;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;
import org.elasticsearch.xpack.core.rollup.action.GetRollupJobsAction;
import org.elasticsearch.xpack.core.rollup.action.PutRollupJobAction;
import org.elasticsearch.xpack.core.rollup.action.RollupAction;
import org.elasticsearch.xpack.core.rollup.action.RollupIndexerAction;
import org.elasticsearch.xpack.core.rollup.action.RollupSearchAction;
import org.elasticsearch.xpack.core.rollup.action.StartRollupJobAction;
import org.elasticsearch.xpack.core.rollup.action.StopRollupJobAction;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.rollup.RollupInfoTransportAction;
import org.elasticsearch.xpack.rollup.RollupUsageTransportAction;
import org.elasticsearch.xpack.rollup.action.TransportDeleteRollupJobAction;
import org.elasticsearch.xpack.rollup.action.TransportGetRollupCapsAction;
import org.elasticsearch.xpack.rollup.action.TransportGetRollupIndexCapsAction;
import org.elasticsearch.xpack.rollup.action.TransportGetRollupJobAction;
import org.elasticsearch.xpack.rollup.action.TransportPutRollupJobAction;
import org.elasticsearch.xpack.rollup.action.TransportRollupSearchAction;
import org.elasticsearch.xpack.rollup.action.TransportStartRollupAction;
import org.elasticsearch.xpack.rollup.action.TransportStopRollupAction;
import org.elasticsearch.xpack.rollup.job.RollupJobTask;
import org.elasticsearch.xpack.rollup.rest.RestDeleteRollupJobAction;
import org.elasticsearch.xpack.rollup.rest.RestGetRollupCapsAction;
import org.elasticsearch.xpack.rollup.rest.RestGetRollupIndexCapsAction;
import org.elasticsearch.xpack.rollup.rest.RestGetRollupJobsAction;
import org.elasticsearch.xpack.rollup.rest.RestPutRollupJobAction;
import org.elasticsearch.xpack.rollup.rest.RestRollupSearchAction;
import org.elasticsearch.xpack.rollup.rest.RestStartRollupJobAction;
import org.elasticsearch.xpack.rollup.rest.RestStopRollupJobAction;
import org.elasticsearch.xpack.rollup.v2.RestRollupAction;
import org.elasticsearch.xpack.rollup.v2.TransportRollupAction;
import org.elasticsearch.xpack.rollup.v2.TransportRollupIndexerAction;

public class Rollup
extends Plugin
implements ActionPlugin,
PersistentTaskPlugin {
    public static final int ROLLUP_VERSION_V1 = 1;
    public static final int ROLLUP_VERSION_V2 = 2;
    public static final int CURRENT_ROLLUP_VERSION = 2;
    public static final String TASK_THREAD_POOL_NAME = "rollup_indexing";
    public static final String ROLLUP_TEMPLATE_VERSION_FIELD = "rollup-version";
    private final SetOnce<SchedulerEngine> schedulerEngine = new SetOnce();
    private final Settings settings;

    public Rollup(Settings settings) {
        this.settings = settings;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return Collections.emptyList();
    }

    public List<RestHandler> getRestHandlers(Settings unused, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<BaseRestHandler> handlers = new ArrayList<BaseRestHandler>(Arrays.asList(new BaseRestHandler[]{new RestRollupSearchAction(), new RestPutRollupJobAction(), new RestStartRollupJobAction(), new RestStopRollupJobAction(), new RestDeleteRollupJobAction(), new RestGetRollupJobsAction(), new RestGetRollupCapsAction(), new RestGetRollupIndexCapsAction()}));
        if (RollupV2.isEnabled()) {
            handlers.add(new RestRollupAction());
        }
        return handlers;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>(Arrays.asList(new ActionPlugin.ActionHandler((ActionType)RollupSearchAction.INSTANCE, TransportRollupSearchAction.class), new ActionPlugin.ActionHandler((ActionType)PutRollupJobAction.INSTANCE, TransportPutRollupJobAction.class), new ActionPlugin.ActionHandler((ActionType)StartRollupJobAction.INSTANCE, TransportStartRollupAction.class), new ActionPlugin.ActionHandler((ActionType)StopRollupJobAction.INSTANCE, TransportStopRollupAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteRollupJobAction.INSTANCE, TransportDeleteRollupJobAction.class), new ActionPlugin.ActionHandler((ActionType)GetRollupJobsAction.INSTANCE, TransportGetRollupJobAction.class), new ActionPlugin.ActionHandler((ActionType)GetRollupCapsAction.INSTANCE, TransportGetRollupCapsAction.class), new ActionPlugin.ActionHandler((ActionType)GetRollupIndexCapsAction.INSTANCE, TransportGetRollupIndexCapsAction.class), new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.ROLLUP, RollupUsageTransportAction.class), new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.ROLLUP, RollupInfoTransportAction.class)));
        if (RollupV2.isEnabled()) {
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)RollupIndexerAction.INSTANCE, TransportRollupIndexerAction.class));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)RollupAction.INSTANCE, TransportRollupAction.class));
        }
        return actions;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settingsToUse) {
        FixedExecutorBuilder indexing = new FixedExecutorBuilder(settingsToUse, TASK_THREAD_POOL_NAME, 1, -1, "xpack.rollup.task_thread_pool", false);
        return Collections.singletonList(indexing);
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        this.schedulerEngine.set((Object)new SchedulerEngine(this.settings, this.getClock()));
        return Collections.singletonList(new RollupJobTask.RollupJobPersistentTasksExecutor(client, (SchedulerEngine)this.schedulerEngine.get(), threadPool));
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public void close() {
        if (this.schedulerEngine.get() != null) {
            ((SchedulerEngine)this.schedulerEngine.get()).stop();
        }
    }
}

