/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto.xcontent;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.xpack.sql.proto.xcontent.MediaType;
import org.elasticsearch.xpack.sql.proto.xcontent.MediaTypeRegistry;
import org.elasticsearch.xpack.sql.proto.xcontent.ParsedMediaType;
import org.elasticsearch.xpack.sql.proto.xcontent.XContent;
import org.elasticsearch.xpack.sql.proto.xcontent.cbor.CborXContent;
import org.elasticsearch.xpack.sql.proto.xcontent.json.JsonXContent;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum XContentType implements MediaType
{
    JSON(0){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/json";
        }

        @Override
        public String mediaType() {
            return "application/json;charset=utf-8";
        }

        @Override
        public String queryParameter() {
            return "json";
        }

        @Override
        public XContent xContent() {
            return JsonXContent.jsonXContent;
        }

        @Override
        public Set<MediaType.HeaderValue> headerValues() {
            return Collections.unmodifiableSet(new HashSet<MediaType.HeaderValue>(Arrays.asList(new MediaType.HeaderValue("application/json"), new MediaType.HeaderValue("application/x-ndjson"), new MediaType.HeaderValue("application/*"))));
        }
    }
    ,
    CBOR(3){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/cbor";
        }

        @Override
        public String queryParameter() {
            return "cbor";
        }

        @Override
        public XContent xContent() {
            return CborXContent.cborXContent;
        }

        @Override
        public Set<MediaType.HeaderValue> headerValues() {
            return Collections.singleton(new MediaType.HeaderValue("application/cbor"));
        }
    };

    public static final MediaTypeRegistry<XContentType> MEDIA_TYPE_REGISTRY;
    private int index;

    public static XContentType fromMediaType(String mediaTypeHeaderValue) throws IllegalArgumentException {
        ParsedMediaType parsedMediaType = ParsedMediaType.parseMediaType(mediaTypeHeaderValue);
        if (parsedMediaType != null) {
            return parsedMediaType.toMediaType(MEDIA_TYPE_REGISTRY);
        }
        return null;
    }

    private XContentType(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public String mediaType() {
        return this.mediaTypeWithoutParameters();
    }

    public abstract XContent xContent();

    public abstract String mediaTypeWithoutParameters();

    public XContentType canonical() {
        return this;
    }

    static {
        MEDIA_TYPE_REGISTRY = new MediaTypeRegistry().register(XContentType.values());
    }
}

