/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto.xcontent;

import com.fasterxml.jackson.core.JsonParser;
import org.elasticsearch.xpack.sql.proto.core.RestApiVersion;
import org.elasticsearch.xpack.sql.proto.xcontent.DeprecationHandler;
import org.elasticsearch.xpack.sql.proto.xcontent.NamedXContentRegistry;

public class XContentParserConfiguration {
    public static final XContentParserConfiguration EMPTY = new XContentParserConfiguration(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, RestApiVersion.current());
    final NamedXContentRegistry registry;
    final DeprecationHandler deprecationHandler;
    final RestApiVersion restApiVersion;

    private XContentParserConfiguration(NamedXContentRegistry registry, DeprecationHandler deprecationHandler, RestApiVersion restApiVersion) {
        this.registry = registry;
        this.deprecationHandler = deprecationHandler;
        this.restApiVersion = restApiVersion;
    }

    public XContentParserConfiguration withRegistry(NamedXContentRegistry registry) {
        return new XContentParserConfiguration(registry, this.deprecationHandler, this.restApiVersion);
    }

    public NamedXContentRegistry registry() {
        return this.registry;
    }

    public XContentParserConfiguration withDeprecationHandler(DeprecationHandler deprecationHandler) {
        return new XContentParserConfiguration(this.registry, deprecationHandler, this.restApiVersion);
    }

    public DeprecationHandler deprecationHandler() {
        return this.deprecationHandler;
    }

    public XContentParserConfiguration withRestApiVersion(RestApiVersion restApiVersion) {
        return new XContentParserConfiguration(this.registry, this.deprecationHandler, restApiVersion);
    }

    public RestApiVersion restApiVersion() {
        return this.restApiVersion;
    }

    public JsonParser filter(JsonParser parser) {
        return parser;
    }
}

