/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto.core;

import java.util.function.Function;

public enum RestApiVersion {
    V_8(8),
    V_7(7);

    public final byte major;
    private static final RestApiVersion CURRENT;

    private RestApiVersion(int major) {
        this.major = (byte)major;
    }

    public RestApiVersion previous() {
        return RestApiVersion.fromMajorVersion(this.major - 1);
    }

    public boolean matches(Function<RestApiVersion, Boolean> restApiVersionFunctions) {
        return restApiVersionFunctions.apply(this);
    }

    private static RestApiVersion fromMajorVersion(int majorVersion) {
        return RestApiVersion.valueOf("V_" + majorVersion);
    }

    public static RestApiVersion minimumSupported() {
        return RestApiVersion.current().previous();
    }

    public static RestApiVersion current() {
        return CURRENT;
    }

    public static Function<RestApiVersion, Boolean> equalTo(RestApiVersion restApiVersion) {
        return r -> r.major == restApiVersion.major;
    }

    public static Function<RestApiVersion, Boolean> onOrAfter(RestApiVersion restApiVersion) {
        return r -> r.major >= restApiVersion.major;
    }

    static {
        CURRENT = V_8;
    }
}

