/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.xpack.sql.proto.xcontent.ToXContent;
import org.elasticsearch.xpack.sql.proto.xcontent.ToXContentObject;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentBuilder;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentLocation;

public class SqlTypedParamValue
implements ToXContentObject {
    public final Object value;
    public final String type;
    private boolean hasExplicitType;
    private XContentLocation tokenLocation;

    public SqlTypedParamValue(String type, Object value) {
        this(type, value, true);
    }

    public SqlTypedParamValue(String type, Object value, boolean hasExplicitType) {
        this.value = value;
        this.type = type;
        this.hasExplicitType = hasExplicitType;
    }

    public boolean hasExplicitType() {
        return this.hasExplicitType;
    }

    public void hasExplicitType(boolean hasExplicitType) {
        this.hasExplicitType = hasExplicitType;
    }

    public XContentLocation tokenLocation() {
        return this.tokenLocation;
    }

    public void tokenLocation(XContentLocation tokenLocation) {
        this.tokenLocation = tokenLocation;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", this.type);
        builder.field("value", this.value);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTypedParamValue that = (SqlTypedParamValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.type, that.type) && Objects.equals(this.hasExplicitType, that.hasExplicitType);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type, this.hasExplicitType);
    }

    public String toString() {
        return String.valueOf(this.value) + " [" + this.type + "][" + this.hasExplicitType + "][" + this.tokenLocation + "]";
    }
}

