/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.Collections;
import java.util.function.Function;
import org.elasticsearch.xpack.sql.client.CheckedFunction;
import org.elasticsearch.xpack.sql.client.ClientException;
import org.elasticsearch.xpack.sql.client.ClientVersion;
import org.elasticsearch.xpack.sql.client.ConnectionConfiguration;
import org.elasticsearch.xpack.sql.client.JreHttpUrlConnection;
import org.elasticsearch.xpack.sql.proto.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.proto.CoreProtocol;
import org.elasticsearch.xpack.sql.proto.MainResponse;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlClearCursorRequest;
import org.elasticsearch.xpack.sql.proto.SqlClearCursorResponse;
import org.elasticsearch.xpack.sql.proto.SqlQueryRequest;
import org.elasticsearch.xpack.sql.proto.SqlQueryResponse;
import org.elasticsearch.xpack.sql.proto.core.Streams;
import org.elasticsearch.xpack.sql.proto.core.TimeValue;
import org.elasticsearch.xpack.sql.proto.core.Tuple;
import org.elasticsearch.xpack.sql.proto.xcontent.ToXContent;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentBuilder;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentParserConfiguration;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentType;

public class HttpClient {
    private final ConnectionConfiguration cfg;
    private final XContentType requestBodyContentType;

    public HttpClient(ConnectionConfiguration cfg) {
        this.cfg = cfg;
        this.requestBodyContentType = cfg.binaryCommunication() ? XContentType.CBOR : XContentType.JSON;
    }

    public boolean ping(long timeoutInMs) throws SQLException {
        return this.head("/", timeoutInMs);
    }

    public MainResponse serverInfo() throws SQLException {
        return this.get("/", MainResponse::fromXContent);
    }

    public SqlQueryResponse basicQuery(String query, int fetchSize) throws SQLException {
        SqlQueryRequest sqlRequest = new SqlQueryRequest(query, Collections.emptyList(), CoreProtocol.TIME_ZONE, null, fetchSize, TimeValue.timeValueMillis(this.cfg.queryTimeout()), TimeValue.timeValueMillis(this.cfg.pageTimeout()), null, Boolean.FALSE, null, new RequestInfo(Mode.CLI, ClientVersion.CURRENT), false, false, this.cfg.binaryCommunication(), Collections.emptyMap());
        return this.query(sqlRequest);
    }

    public SqlQueryResponse query(SqlQueryRequest sqlRequest) throws SQLException {
        return this.post("/_sql", sqlRequest, SqlQueryResponse::fromXContent);
    }

    public SqlQueryResponse nextPage(String cursor) throws SQLException {
        SqlQueryRequest sqlRequest = new SqlQueryRequest(cursor, TimeValue.timeValueMillis(this.cfg.queryTimeout()), TimeValue.timeValueMillis(this.cfg.pageTimeout()), new RequestInfo(Mode.CLI), this.cfg.binaryCommunication());
        return this.post("/_sql", sqlRequest, SqlQueryResponse::fromXContent);
    }

    public boolean queryClose(String cursor, Mode mode) throws SQLException {
        SqlClearCursorResponse response = this.post("/_sql/close", new SqlClearCursorRequest(cursor, new RequestInfo(mode)), SqlClearCursorResponse::fromXContent);
        return response.isSucceeded();
    }

    private <Request extends AbstractSqlRequest, Response> Response post(String path, Request request, CheckedFunction<XContentParser, Response, IOException> responseParser) throws SQLException {
        byte[] requestBytes = this.toXContent(request);
        String query = "error_trace";
        Tuple response = (Tuple)AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, query, this.cfg, con -> con.request(out -> out.write(requestBytes), this::readFrom, "POST", this.requestBodyContentType.mediaTypeWithoutParameters()))).getResponseOrThrowException();
        return this.fromXContent((XContentType)response.v1(), (byte[])response.v2(), responseParser);
    }

    private boolean head(String path, long timeoutInMs) throws SQLException {
        ConnectionConfiguration pingCfg = new ConnectionConfiguration(this.cfg.baseUri(), this.cfg.connectionString(), this.cfg.validateProperties(), this.cfg.binaryCommunication(), this.cfg.connectTimeout(), timeoutInMs, this.cfg.queryTimeout(), this.cfg.pageTimeout(), this.cfg.pageSize(), this.cfg.authUser(), this.cfg.authPass(), this.cfg.sslConfig(), this.cfg.proxyConfig());
        try {
            return AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, "error_trace", pingCfg, JreHttpUrlConnection::head));
        }
        catch (ClientException ex) {
            throw new SQLException("Cannot ping server", ex);
        }
    }

    private <Response> Response get(String path, CheckedFunction<XContentParser, Response, IOException> responseParser) throws SQLException {
        Tuple response = (Tuple)AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, "error_trace", this.cfg, con -> con.request(null, this::readFrom, "GET"))).getResponseOrThrowException();
        return this.fromXContent((XContentType)response.v1(), (byte[])response.v2(), responseParser);
    }

    private <Request extends ToXContent> byte[] toXContent(Request xContent) {
        byte[] byArray;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            try (XContentBuilder xContentBuilder = new XContentBuilder(this.requestBodyContentType.xContent(), buffer);){
                if (xContent.isFragment()) {
                    xContentBuilder.startObject();
                }
                xContent.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                if (xContent.isFragment()) {
                    xContentBuilder.endObject();
                }
            }
            byArray = buffer.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ClientException("Cannot serialize request", ex);
            }
        }
        buffer.close();
        return byArray;
    }

    private Tuple<XContentType, byte[]> readFrom(InputStream inputStream, Function<String, String> headers) {
        String contentType = headers.apply("Content-Type");
        XContentType xContentType = XContentType.fromMediaType(contentType);
        if (xContentType == null) {
            throw new IllegalStateException("Unsupported Content-Type: " + contentType);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Streams.copy(inputStream, out);
        }
        catch (IOException ex) {
            throw new ClientException("Cannot deserialize response", ex);
        }
        return new Tuple<XContentType, byte[]>(xContentType, out.toByteArray());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <Response> Response fromXContent(XContentType xContentType, byte[] bytesReference, CheckedFunction<XContentParser, Response, IOException> responseParser) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytesReference);){
            Response Response;
            block13: {
                XContentParser parser = xContentType.xContent().createParser(XContentParserConfiguration.EMPTY, stream);
                try {
                    Response = responseParser.apply(parser);
                    if (parser == null) break block13;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return Response;
        }
        catch (IOException ex) {
            throw new ClientException("Cannot parse response", ex);
        }
    }
}

