/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.structurefinder;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.core.textstructure.structurefinder.TextStructure;
import org.elasticsearch.xpack.textstructure.structurefinder.DelimitedTextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinderFactory;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;
import org.elasticsearch.xpack.textstructure.structurefinder.TimeoutChecker;
import org.supercsv.prefs.CsvPreference;

public class DelimitedTextStructureFinderFactory
implements TextStructureFinderFactory {
    static final double DELIMITER_OVERRIDDEN_ALLOWED_FRACTION_OF_BAD_LINES = 0.1;
    static final double FORMAT_OVERRIDDEN_ALLOWED_FRACTION_OF_BAD_LINES = 0.05;
    private final CsvPreference csvPreference;
    private final int minFieldsPerRow;
    private final boolean trimFields;

    DelimitedTextStructureFinderFactory(char delimiter, char quote, int minFieldsPerRow, boolean trimFields) {
        this.csvPreference = new CsvPreference.Builder(quote, (int)delimiter, "\n").build();
        this.minFieldsPerRow = minFieldsPerRow;
        this.trimFields = trimFields;
    }

    DelimitedTextStructureFinderFactory makeSimilar(Character quote, Boolean shouldTrimFields) {
        return new DelimitedTextStructureFinderFactory((char)this.csvPreference.getDelimiterChar(), quote == null ? this.csvPreference.getQuoteChar() : quote.charValue(), this.minFieldsPerRow, shouldTrimFields == null ? this.trimFields : shouldTrimFields);
    }

    @Override
    public boolean canFindFormat(TextStructure.Format format) {
        return format == null || format == TextStructure.Format.DELIMITED;
    }

    @Override
    public boolean canCreateFromSample(List<String> explanation, String sample, double allowedFractionOfBadLines) {
        return DelimitedTextStructureFinder.canCreateFromSample(explanation, sample, this.minFieldsPerRow, this.csvPreference, (String)(switch ((char)this.csvPreference.getDelimiterChar()) {
            case ',' -> "CSV";
            case '\t' -> "TSV";
            default -> Character.getName(this.csvPreference.getDelimiterChar()).toLowerCase(Locale.ROOT) + " delimited values";
        }), allowedFractionOfBadLines);
    }

    @Override
    public TextStructureFinder createFromSample(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, int lineMergeSizeLimit, TextStructureOverrides overrides, TimeoutChecker timeoutChecker) throws IOException {
        CsvPreference adjustedCsvPreference = new CsvPreference.Builder(this.csvPreference).maxLinesPerRow(lineMergeSizeLimit).build();
        return DelimitedTextStructureFinder.makeDelimitedTextStructureFinder(explanation, sample, charsetName, hasByteOrderMarker, adjustedCsvPreference, this.trimFields, overrides, timeoutChecker);
    }
}

