/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.structurefinder;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.core.textstructure.structurefinder.FieldStats;
import org.elasticsearch.xpack.core.textstructure.structurefinder.TextStructure;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureUtils;
import org.elasticsearch.xpack.textstructure.structurefinder.TimeoutChecker;
import org.elasticsearch.xpack.textstructure.structurefinder.TimestampFormatFinder;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.Util;

public class DelimitedTextStructureFinder
implements TextStructureFinder {
    private static final String REGEX_NEEDS_ESCAPE_PATTERN = "([\\\\|()\\[\\]{}^$.+*?])";
    private static final int MAX_LEVENSHTEIN_COMPARISONS = 100;
    private static final int LONG_FIELD_THRESHOLD = 100;
    private final List<String> sampleMessages;
    private final TextStructure structure;

    static DelimitedTextStructureFinder makeDelimitedTextStructureFinder(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, CsvPreference csvPreference, boolean trimFields, TextStructureOverrides overrides, TimeoutChecker timeoutChecker) throws IOException {
        Tuple<String, TimestampFormatFinder> timeField;
        String delimiterPattern;
        int index;
        String[] columnNames;
        Tuple<List<List<String>>, List<Integer>> parsed = DelimitedTextStructureFinder.readRows(sample, csvPreference, timeoutChecker);
        List rows = (List)parsed.v1();
        List lineNumbers = (List)parsed.v2();
        Tuple<Boolean, String[]> headerInfo = DelimitedTextStructureFinder.findHeaderFromSample(explanation, rows, overrides);
        boolean isHeaderInText = (Boolean)headerInfo.v1();
        String[] header = (String[])headerInfo.v2();
        List<String> overriddenColumnNames = overrides.getColumnNames();
        if (overriddenColumnNames != null) {
            if (overriddenColumnNames.size() != header.length) {
                throw new IllegalArgumentException("[" + overriddenColumnNames.size() + "] column names were specified [" + String.join((CharSequence)",", overriddenColumnNames) + "] but there are [" + header.length + "] columns in the sample");
            }
            columnNames = overriddenColumnNames.toArray(new String[0]);
        } else {
            columnNames = new String[header.length];
            for (int i = 0; i < header.length; ++i) {
                assert (header[i] != null);
                String rawHeader = trimFields ? header[i].trim() : header[i];
                columnNames[i] = rawHeader.isEmpty() ? "column" + (i + 1) : rawHeader.replace('.', '_');
            }
        }
        int maxLinesPerMessage = 1;
        List<String> sampleLines = Arrays.asList(sample.split("\n"));
        ArrayList<String> sampleMessages = new ArrayList<String>();
        ArrayList sampleRecords = new ArrayList();
        int prevMessageEndLineNumber = isHeaderInText ? (Integer)lineNumbers.get(0) : 0;
        int n = index = isHeaderInText ? 1 : 0;
        while (index < rows.size()) {
            List row = (List)rows.get(index);
            int lineNumber = (Integer)lineNumbers.get(index);
            if (row.size() != columnNames.length) {
                prevMessageEndLineNumber = lineNumber;
            } else {
                LinkedHashMap sampleRecord = new LinkedHashMap();
                Util.filterListToMap(sampleRecord, (String[])columnNames, (List)(trimFields ? row.stream().map(field -> field == null ? null : field.trim()).collect(Collectors.toList()) : row));
                sampleRecords.add(sampleRecord);
                sampleMessages.add(String.join((CharSequence)"\n", sampleLines.subList(prevMessageEndLineNumber, lineNumber)));
                maxLinesPerMessage = Math.max(maxLinesPerMessage, lineNumber - prevMessageEndLineNumber);
                prevMessageEndLineNumber = lineNumber;
            }
            ++index;
        }
        String preamble = String.join((CharSequence)"\n", sampleLines.subList(0, (Integer)lineNumbers.get(1))) + "\n";
        sampleLines = null;
        Tuple<SortedMap<String, Object>, SortedMap<String, FieldStats>> mappingsAndFieldStats = TextStructureUtils.guessMappingsAndCalculateFieldStats(explanation, sampleRecords, timeoutChecker);
        SortedMap fieldMappings = (SortedMap)mappingsAndFieldStats.v1();
        List<String> columnNamesList = Arrays.asList(columnNames);
        char delimiter = (char)csvPreference.getDelimiterChar();
        char quoteChar = csvPreference.getQuoteChar();
        Map<String, Object> csvProcessorSettings = DelimitedTextStructureFinder.makeCsvProcessorSettings("message", columnNamesList, delimiter, quoteChar, trimFields);
        TextStructure.Builder structureBuilder = new TextStructure.Builder(TextStructure.Format.DELIMITED).setCharset(charsetName).setHasByteOrderMarker(hasByteOrderMarker).setSampleStart(preamble).setNumLinesAnalyzed(((Integer)lineNumbers.get(lineNumbers.size() - 1)).intValue()).setNumMessagesAnalyzed(sampleRecords.size()).setHasHeaderRow(Boolean.valueOf(isHeaderInText)).setDelimiter(Character.valueOf(delimiter)).setQuote(Character.valueOf(quoteChar)).setColumnNames(columnNamesList);
        String quote = String.valueOf(quoteChar);
        String twoQuotes = quote + quote;
        String quotePattern = quote.replaceAll(REGEX_NEEDS_ESCAPE_PATTERN, "\\\\$1");
        String optQuotePattern = quotePattern + "?";
        String string = delimiterPattern = delimiter == '\t' ? "\\t" : String.valueOf(delimiter).replaceAll(REGEX_NEEDS_ESCAPE_PATTERN, "\\\\$1");
        if (isHeaderInText) {
            structureBuilder.setExcludeLinesPattern("^" + Arrays.stream(header).map(column -> optQuotePattern + column.replace(quote, twoQuotes).replaceAll(REGEX_NEEDS_ESCAPE_PATTERN, "\\\\$1") + optQuotePattern).collect(Collectors.joining(delimiterPattern)));
        }
        if (trimFields) {
            structureBuilder.setShouldTrimFields(Boolean.valueOf(true));
        }
        if ((timeField = TextStructureUtils.guessTimestampField(explanation, sampleRecords, overrides, timeoutChecker)) != null) {
            boolean needClientTimeZone = ((TimestampFormatFinder)timeField.v2()).hasTimezoneDependentParsing();
            structureBuilder.setTimestampField((String)timeField.v1()).setJodaTimestampFormats(((TimestampFormatFinder)timeField.v2()).getJodaTimestampFormats()).setJavaTimestampFormats(((TimestampFormatFinder)timeField.v2()).getJavaTimestampFormats()).setNeedClientTimezone(needClientTimeZone).setIngestPipeline(TextStructureUtils.makeIngestPipelineDefinition(null, Collections.emptyMap(), csvProcessorSettings, fieldMappings, (String)timeField.v1(), ((TimestampFormatFinder)timeField.v2()).getJavaTimestampFormats(), needClientTimeZone, ((TimestampFormatFinder)timeField.v2()).needNanosecondPrecision())).setMultilineStartPattern(DelimitedTextStructureFinder.makeMultilineStartPattern(explanation, columnNamesList, maxLinesPerMessage, delimiterPattern, quotePattern, fieldMappings, (String)timeField.v1(), (TimestampFormatFinder)timeField.v2()));
            fieldMappings.put("@timestamp", ((TimestampFormatFinder)timeField.v2()).getEsDateMappingTypeWithoutFormat());
        } else {
            structureBuilder.setIngestPipeline(TextStructureUtils.makeIngestPipelineDefinition(null, Collections.emptyMap(), csvProcessorSettings, fieldMappings, null, null, false, false));
            structureBuilder.setMultilineStartPattern(DelimitedTextStructureFinder.makeMultilineStartPattern(explanation, columnNamesList, maxLinesPerMessage, delimiterPattern, quotePattern, fieldMappings, null, null));
        }
        if (mappingsAndFieldStats.v2() != null) {
            structureBuilder.setFieldStats((Map)mappingsAndFieldStats.v2());
        }
        TextStructure structure = structureBuilder.setMappings(Collections.singletonMap("properties", fieldMappings)).setExplanation(explanation).build();
        return new DelimitedTextStructureFinder(sampleMessages, structure);
    }

    private DelimitedTextStructureFinder(List<String> sampleMessages, TextStructure structure) {
        this.sampleMessages = Collections.unmodifiableList(sampleMessages);
        this.structure = structure;
    }

    @Override
    public List<String> getSampleMessages() {
        return this.sampleMessages;
    }

    @Override
    public TextStructure getStructure() {
        return this.structure;
    }

    static Tuple<List<List<String>>, List<Integer>> readRows(String sample, CsvPreference csvPreference, TimeoutChecker timeoutChecker) throws IOException {
        int fieldsInFirstRow = -1;
        ArrayList<List> rows = new ArrayList<List>();
        ArrayList<Integer> lineNumbers = new ArrayList<Integer>();
        try (CsvListReader csvReader = new CsvListReader((Reader)new StringReader(sample), csvPreference);){
            try {
                List row;
                while ((row = csvReader.read()) != null) {
                    if (fieldsInFirstRow < 0) {
                        fieldsInFirstRow = row.size();
                    } else {
                        while (row.size() > fieldsInFirstRow && row.get(row.size() - 1) == null) {
                            row.remove(row.size() - 1);
                        }
                    }
                    rows.add(row);
                    timeoutChecker.check("delimited record parsing");
                    lineNumbers.add(csvReader.getLineNumber());
                }
            }
            catch (SuperCsvException e) {
                if (DelimitedTextStructureFinder.notUnexpectedEndOfFile(e)) {
                    throw e;
                }
            }
        }
        assert (!rows.isEmpty());
        assert (lineNumbers.size() == rows.size());
        if (((List)rows.get(0)).size() != ((List)rows.get(rows.size() - 1)).size()) {
            rows.remove(rows.size() - 1);
            lineNumbers.remove(lineNumbers.size() - 1);
        }
        assert (rows.size() > 1);
        return new Tuple(rows, lineNumbers);
    }

    static Tuple<Boolean, String[]> findHeaderFromSample(List<String> explanation, List<List<String>> rows, TextStructureOverrides overrides) {
        Object[] header;
        assert (!rows.isEmpty());
        List<String> overriddenColumnNames = overrides.getColumnNames();
        List<String> firstRow = rows.get(0);
        boolean isHeaderInText = true;
        if (overrides.getHasHeaderRow() != null) {
            String duplicateValue;
            isHeaderInText = overrides.getHasHeaderRow();
            if (isHeaderInText && overriddenColumnNames == null && (duplicateValue = DelimitedTextStructureFinder.findDuplicateNonEmptyValues(firstRow)) != null) {
                throw new IllegalArgumentException("Sample specified to contain a header row, but the first row contains duplicate values: [" + duplicateValue + "]");
            }
            explanation.add("Sample specified to " + (isHeaderInText ? "contain" : "not contain") + " a header row");
        } else if (DelimitedTextStructureFinder.findDuplicateNonEmptyValues(firstRow) != null) {
            isHeaderInText = false;
            explanation.add("First row contains duplicate values, so assuming it's not a header");
        } else if (rows.size() < 3) {
            explanation.add("Too little data to accurately assess whether header is in sample - guessing it is");
        } else {
            isHeaderInText = DelimitedTextStructureFinder.isFirstRowUnusual(explanation, rows);
        }
        if (isHeaderInText) {
            header = (String[])firstRow.stream().map(field -> field == null ? "" : field).toArray(String[]::new);
        } else {
            header = new String[firstRow.size()];
            Arrays.fill(header, "");
        }
        return new Tuple((Object)isHeaderInText, (Object)header);
    }

    static String findDuplicateNonEmptyValues(List<String> row) {
        HashSet<String> values = new HashSet<String>();
        for (String value : row) {
            if (value == null || value.isEmpty() || values.add(value)) continue;
            return value;
        }
        return null;
    }

    private static boolean isFirstRowUnusual(List<String> explanation, List<List<String>> rows) {
        assert (rows.size() >= 3);
        List<String> firstRow = rows.get(0);
        String firstRowStr = firstRow.stream().map(field -> field == null ? "" : field).collect(Collectors.joining(""));
        List<List<String>> otherRows = rows.subList(1, rows.size());
        ArrayList<String> otherRowStrs = new ArrayList<String>();
        for (List<String> row : otherRows) {
            otherRowStrs.add(row.stream().map(str -> str == null ? "" : str).collect(Collectors.joining("")));
        }
        double firstRowLength = firstRowStr.length();
        DoubleSummaryStatistics otherRowStats = otherRowStrs.stream().mapToDouble(otherRow -> otherRow.length()).collect(DoubleSummaryStatistics::new, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
        double otherLengthRange = otherRowStats.getMax() - otherRowStats.getMin();
        if (firstRowLength < otherRowStats.getMin() - otherLengthRange / 10.0 || firstRowLength > otherRowStats.getMax() + otherLengthRange / 10.0) {
            explanation.add("First row is unusual based on length test: [" + firstRowLength + "] and [" + DelimitedTextStructureFinder.toNiceString(otherRowStats) + "]");
            return true;
        }
        explanation.add("First row is not unusual based on length test: [" + firstRowLength + "] and [" + DelimitedTextStructureFinder.toNiceString(otherRowStats) + "]");
        BitSet shortFieldMask = DelimitedTextStructureFinder.makeShortFieldMask(rows, 100);
        DoubleSummaryStatistics firstRowStats = otherRows.stream().limit(100L).mapToDouble(otherRow -> DelimitedTextStructureFinder.levenshteinFieldwiseCompareRows(firstRow, otherRow, shortFieldMask)).collect(DoubleSummaryStatistics::new, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
        otherRowStats = new DoubleSummaryStatistics();
        int numComparisons = 0;
        int proportion = otherRowStrs.size() / 100;
        int innerIncrement = 1 + proportion * proportion;
        Random random = new Random(firstRow.hashCode());
        for (int i = 0; numComparisons < 100 && i < otherRowStrs.size(); ++i) {
            for (int j = i + 1 + random.nextInt(innerIncrement); numComparisons < 100 && j < otherRowStrs.size(); ++numComparisons, j += innerIncrement) {
                otherRowStats.accept(DelimitedTextStructureFinder.levenshteinFieldwiseCompareRows(otherRows.get(i), otherRows.get(j), shortFieldMask));
            }
        }
        if (firstRowStats.getAverage() > otherRowStats.getAverage() * 1.2) {
            explanation.add("First row is unusual based on Levenshtein test [" + DelimitedTextStructureFinder.toNiceString(firstRowStats) + "] and [" + DelimitedTextStructureFinder.toNiceString(otherRowStats) + "]");
            return true;
        }
        explanation.add("First row is not unusual based on Levenshtein test [" + DelimitedTextStructureFinder.toNiceString(firstRowStats) + "] and [" + DelimitedTextStructureFinder.toNiceString(otherRowStats) + "]");
        return false;
    }

    private static String toNiceString(DoubleSummaryStatistics stats) {
        return String.format(Locale.ROOT, "count=%d, min=%f, average=%f, max=%f", stats.getCount(), stats.getMin(), stats.getAverage(), stats.getMax());
    }

    static BitSet makeShortFieldMask(List<List<String>> rows, int longFieldThreshold) {
        assert (!rows.isEmpty());
        BitSet shortFieldMask = new BitSet();
        int maxLength = rows.stream().map(List::size).max(Integer::compareTo).get();
        int index = 0;
        while (index < maxLength) {
            int i = index++;
            shortFieldMask.set(i, rows.stream().allMatch(row -> i >= row.size() || row.get(i) == null || ((String)row.get(i)).length() < longFieldThreshold));
        }
        return shortFieldMask;
    }

    static int levenshteinFieldwiseCompareRows(List<String> firstRow, List<String> secondRow) {
        int largestSize = Math.max(firstRow.size(), secondRow.size());
        if (largestSize < 1) {
            return 0;
        }
        BitSet allFields = new BitSet();
        allFields.set(0, largestSize);
        return DelimitedTextStructureFinder.levenshteinFieldwiseCompareRows(firstRow, secondRow, allFields);
    }

    static int levenshteinFieldwiseCompareRows(List<String> firstRow, List<String> secondRow, BitSet fieldMask) {
        int result = 0;
        int index = fieldMask.nextSetBit(0);
        while (index >= 0) {
            result += DelimitedTextStructureFinder.levenshteinDistance(index < firstRow.size() ? firstRow.get(index) : "", index < secondRow.size() ? secondRow.get(index) : "");
            index = fieldMask.nextSetBit(index + 1);
        }
        return result;
    }

    static int levenshteinDistance(String first, String second) {
        int secondLen;
        int firstLen = first == null ? 0 : first.length();
        int n = secondLen = second == null ? 0 : second.length();
        if (firstLen == 0) {
            return secondLen;
        }
        if (secondLen == 0) {
            return firstLen;
        }
        int[] currentCol = new int[secondLen + 1];
        int[] prevCol = new int[secondLen + 1];
        for (int down = 0; down <= secondLen; ++down) {
            currentCol[down] = down;
        }
        for (int across = 1; across <= firstLen; ++across) {
            int[] tmp = prevCol;
            prevCol = currentCol;
            currentCol = tmp;
            currentCol[0] = across;
            for (int down = 1; down <= secondLen; ++down) {
                if (first.charAt(across - 1) == second.charAt(down - 1)) {
                    currentCol[down] = prevCol[down - 1];
                    continue;
                }
                int option1 = prevCol[down];
                int option2 = currentCol[down - 1];
                int option3 = prevCol[down - 1];
                currentCol[down] = Math.min(Math.min(option1, option2), option3) + 1;
            }
        }
        return currentCol[secondLen];
    }

    static boolean lineHasUnescapedQuote(String line, CsvPreference csvPreference) {
        char quote = csvPreference.getQuoteChar();
        String lineWithEscapedQuotesRemoved = line.replace(String.valueOf(quote) + quote, "");
        for (int index = 1; index < lineWithEscapedQuotesRemoved.length() - 1; ++index) {
            if (lineWithEscapedQuotesRemoved.charAt(index) != quote || lineWithEscapedQuotesRemoved.codePointAt(index - 1) == csvPreference.getDelimiterChar() || lineWithEscapedQuotesRemoved.codePointAt(index + 1) == csvPreference.getDelimiterChar()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean canCreateFromSample(List<String> explanation, String sample, int minFieldsPerRow, CsvPreference csvPreference, String formatName, double allowedFractionOfBadLines) {
        for (String sampleLine : sampleLines = sample.split("\n")) {
            if (!DelimitedTextStructureFinder.lineHasUnescapedQuote(sampleLine, csvPreference)) continue;
            explanation.add("Not " + formatName + " because a line has an unescaped quote that is not at the beginning or end of a field: [" + sampleLine + "]");
            return false;
        }
        numberOfLinesInSample = sampleLines.length;
        try {
            block22: {
                csvReader = new CsvListReader((Reader)new StringReader(sample), csvPreference);
                fieldsInFirstRow = -1;
                fieldsInLastRow = -1;
                illFormattedRows = new ArrayList<Integer>();
                numberOfRows = 0;
lbl14:
                // 4 sources

                while (true) {
                    try {
                        row = csvReader.read();
                        if (row == null) ** GOTO lbl56
                        ++numberOfRows;
                        if (fieldsInFirstRow >= 0) ** GOTO lbl42
                        fieldsInFirstRow = fieldsInThisRow;
                        if (fieldsInFirstRow < minFieldsPerRow) {
                            explanation.add("Not " + formatName + " because the first row has fewer than [" + minFieldsPerRow + "] fields: [" + fieldsInFirstRow + "]");
                            var16_25 = false;
                            break;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (SuperCsvException e) {
                        if (DelimitedTextStructureFinder.notUnexpectedEndOfFile(e)) {
                            explanation.add("Not " + formatName + " because there was a parsing exception: [" + e.getMessage() + "]");
                            var15_23 = false;
                            csvReader.close();
                            return var15_23;
                        }
                        break block22;
                    }
                    break;
                }
                csvReader.close();
                return var16_25;
lbl-1000:
                // 1 sources

                {
                    fieldsInLastRow = fieldsInFirstRow;
                    ** GOTO lbl14
lbl42:
                    // 2 sources

                    for (fieldsInThisRow = row.size(); fieldsInThisRow > fieldsInFirstRow && row.get(fieldsInThisRow - 1) == null; --fieldsInThisRow) {
                    }
                    if (fieldsInThisRow == fieldsInFirstRow) ** GOTO lbl-1000
                    illFormattedRows.add(numberOfRows - 1);
                    totalNumberOfRows = numberOfRows + numberOfLinesInSample - csvReader.getLineNumber();
                    if (!((double)illFormattedRows.size() > Math.ceil(allowedFractionOfBadLines * totalNumberOfRows))) ** GOTO lbl14
                    explanation.add(new ParameterizedMessage("Not {} because {} or more rows did not have the same number of fields as the first row ({}). Bad rows {}", new Object[]{formatName, illFormattedRows.size(), fieldsInFirstRow, illFormattedRows}).getFormattedMessage());
                    var18_26 = false;
                }
                csvReader.close();
                return var18_26;
lbl-1000:
                // 1 sources

                {
                    fieldsInLastRow = fieldsInThisRow;
                    ** continue;
lbl56:
                    // 1 sources

                    if (fieldsInLastRow <= fieldsInFirstRow) ** GOTO lbl-1000
                    explanation.add("Not " + formatName + " because last row has more fields than first row: [" + fieldsInFirstRow + "] and [" + fieldsInLastRow + "]");
                    var15_23 = false;
                }
                csvReader.close();
                return var15_23;
lbl-1000:
                // 1 sources

                {
                    if (fieldsInLastRow >= fieldsInFirstRow) break block22;
                    --numberOfRows;
                }
            }
            if (numberOfRows <= 1) {
                explanation.add("Not " + formatName + " because fewer than 2 complete records in sample: [" + numberOfRows + "]");
                return false;
            }
            explanation.add("Deciding sample is " + formatName);
            return true;
        }
        catch (IOException e) {
            explanation.add("Not " + formatName + " because there was a parsing exception: [" + e.getMessage() + "]");
            return false;
        }
    }

    private static boolean notUnexpectedEndOfFile(SuperCsvException e) {
        return !e.getMessage().startsWith("unexpected end of file while reading quoted column");
    }

    static Map<String, Object> makeCsvProcessorSettings(String field, List<String> targetFields, char separator, char quote, boolean trim) {
        LinkedHashMap<String, Object> csvProcessorSettings = new LinkedHashMap<String, Object>();
        csvProcessorSettings.put("field", field);
        csvProcessorSettings.put("target_fields", Collections.unmodifiableList(targetFields));
        if (separator != ',') {
            csvProcessorSettings.put("separator", String.valueOf(separator));
        }
        if (quote != '\"') {
            csvProcessorSettings.put("quote", String.valueOf(quote));
        }
        csvProcessorSettings.put("ignore_missing", false);
        if (trim) {
            csvProcessorSettings.put("trim", true);
        }
        return Collections.unmodifiableMap(csvProcessorSettings);
    }

    static String makeMultilineStartPattern(List<String> explanation, List<String> columnNames, int maxLinesPerMessage, String delimiterPattern, String quotePattern, Map<String, Object> fieldMappings, String timeFieldName, TimestampFormatFinder timeFieldFormat) {
        assert (!columnNames.isEmpty());
        assert (maxLinesPerMessage > 0);
        assert (timeFieldName == null == (timeFieldFormat == null));
        if (maxLinesPerMessage == 1) {
            explanation.add("Not creating a multi-line start pattern as no sampled message spanned multiple lines");
            return null;
        }
        StringBuilder builder = new StringBuilder("^");
        for (String columnName : columnNames.subList(0, columnNames.size() - 1)) {
            String type;
            if (columnName.equals(timeFieldName)) {
                builder.append(quotePattern).append("?");
                String simpleTimePattern = timeFieldFormat.getSimplePattern().pattern();
                builder.append(simpleTimePattern.startsWith("\\b") ? simpleTimePattern.substring(2) : simpleTimePattern);
                explanation.add("Created a multi-line start pattern based on timestamp column [" + columnName + "]");
                return builder.toString();
            }
            Object columnMapping = fieldMappings.get(columnName);
            if (columnMapping instanceof Map && (type = (String)((Map)columnMapping).get("type")) != null) {
                String columnPattern = switch (type) {
                    case "boolean" -> "(?:true|false)";
                    case "byte", "short", "integer", "long" -> "[+-]?\\d+";
                    case "half_float", "float", "double" -> "[+-]?(?:\\d+(?:\\.\\d+)?|\\.\\d+)(?:[eE][+-]?\\d+)?";
                    default -> null;
                };
                if (columnPattern != null) {
                    builder.append("(?:").append(columnPattern).append("|").append(quotePattern).append(columnPattern).append(quotePattern).append(")").append(delimiterPattern);
                    explanation.add("Created a multi-line start pattern based on [" + type + "] column [" + columnName + "]");
                    return builder.toString();
                }
            }
            builder.append(".*?").append(delimiterPattern);
        }
        explanation.add("Failed to create a suitable multi-line start pattern");
        return null;
    }
}

