/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.common.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Base64;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SqlStreamOutput
extends OutputStreamStreamOutput {
    private final ByteArrayOutputStream bytes;

    public SqlStreamOutput(Version version, ZoneId zoneId) throws IOException {
        this(new ByteArrayOutputStream(), version, zoneId);
    }

    private SqlStreamOutput(ByteArrayOutputStream bytes, Version version, ZoneId zoneId) throws IOException {
        super(Base64.getEncoder().wrap((OutputStream)new OutputStreamStreamOutput((OutputStream)bytes)));
        this.bytes = bytes;
        Version.writeVersion((Version)version, (StreamOutput)this);
        this.writeZoneId(zoneId);
    }

    public String streamAsString() {
        return this.bytes.toString(StandardCharsets.ISO_8859_1);
    }
}

