/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.DeprecationChecks;
import org.elasticsearch.xpack.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckAction;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckRequest;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckResponse;

public class TransportNodeDeprecationCheckAction
extends TransportNodesAction<NodesDeprecationCheckRequest, NodesDeprecationCheckResponse, NodesDeprecationCheckAction.NodeRequest, NodesDeprecationCheckAction.NodeResponse> {
    private final Settings settings;
    private final PluginsService pluginsService;
    private volatile List<String> skipTheseDeprecations;

    @Inject
    public TransportNodeDeprecationCheckAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, PluginsService pluginsService, ActionFilters actionFilters) {
        super("cluster:admin/xpack/deprecation/nodes/info", threadPool, clusterService, transportService, actionFilters, NodesDeprecationCheckRequest::new, NodesDeprecationCheckAction.NodeRequest::new, "generic", NodesDeprecationCheckAction.NodeResponse.class);
        this.settings = settings;
        this.pluginsService = pluginsService;
        this.skipTheseDeprecations = (List)DeprecationChecks.SKIP_DEPRECATIONS_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DeprecationChecks.SKIP_DEPRECATIONS_SETTING, this::setSkipDeprecations);
    }

    private <T> void setSkipDeprecations(List<String> skipDeprecations) {
        this.skipTheseDeprecations = Collections.unmodifiableList(skipDeprecations);
    }

    protected NodesDeprecationCheckResponse newResponse(NodesDeprecationCheckRequest request, List<NodesDeprecationCheckAction.NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new NodesDeprecationCheckResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected NodesDeprecationCheckAction.NodeRequest newNodeRequest(NodesDeprecationCheckRequest request) {
        return new NodesDeprecationCheckAction.NodeRequest(request);
    }

    protected NodesDeprecationCheckAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodesDeprecationCheckAction.NodeResponse(in);
    }

    protected NodesDeprecationCheckAction.NodeResponse nodeOperation(NodesDeprecationCheckAction.NodeRequest request, Task task) {
        return this.nodeOperation(request, DeprecationChecks.NODE_SETTINGS_CHECKS);
    }

    NodesDeprecationCheckAction.NodeResponse nodeOperation(NodesDeprecationCheckAction.NodeRequest request, List<BiFunction<Settings, PluginsAndModules, DeprecationIssue>> nodeSettingsChecks) {
        Settings filteredSettings = this.settings.filter(setting -> !Regex.simpleMatch(this.skipTheseDeprecations, (String)setting));
        List<DeprecationIssue> issues = DeprecationInfoAction.filterChecks(nodeSettingsChecks, c -> (DeprecationIssue)c.apply(filteredSettings, this.pluginsService.info()));
        return new NodesDeprecationCheckAction.NodeResponse(this.transportService.getLocalNode(), issues);
    }
}

