/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.RateLimitingFilter;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.deprecation.DeprecationChecks;
import org.elasticsearch.xpack.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckAction;
import org.elasticsearch.xpack.deprecation.RestDeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.TransportDeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.TransportNodeDeprecationCheckAction;
import org.elasticsearch.xpack.deprecation.logging.DeprecationCacheResetAction;
import org.elasticsearch.xpack.deprecation.logging.DeprecationIndexingComponent;
import org.elasticsearch.xpack.deprecation.logging.DeprecationIndexingTemplateRegistry;
import org.elasticsearch.xpack.deprecation.logging.RestDeprecationCacheResetAction;
import org.elasticsearch.xpack.deprecation.logging.TransportDeprecationCacheResetAction;

public class Deprecation
extends Plugin
implements ActionPlugin {
    public static final Setting<Boolean> WRITE_DEPRECATION_LOGS_TO_INDEX = Setting.boolSetting((String)"cluster.deprecation_indexing.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> USE_X_OPAQUE_ID_IN_FILTERING = Setting.boolSetting((String)"cluster.deprecation_indexing.x_opaque_id_used.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)DeprecationInfoAction.INSTANCE, TransportDeprecationInfoAction.class), new ActionPlugin.ActionHandler((ActionType)NodesDeprecationCheckAction.INSTANCE, TransportNodeDeprecationCheckAction.class), new ActionPlugin.ActionHandler((ActionType)DeprecationCacheResetAction.INSTANCE, TransportDeprecationCacheResetAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestDeprecationInfoAction(), new RestDeprecationCacheResetAction());
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        DeprecationIndexingTemplateRegistry templateRegistry = new DeprecationIndexingTemplateRegistry(environment.settings(), clusterService, threadPool, client, xContentRegistry);
        templateRegistry.initialize();
        RateLimitingFilter rateLimitingFilterForIndexing = new RateLimitingFilter();
        rateLimitingFilterForIndexing.setUseXOpaqueId(((Boolean)USE_X_OPAQUE_ID_IN_FILTERING.get(environment.settings())).booleanValue());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(USE_X_OPAQUE_ID_IN_FILTERING, arg_0 -> ((RateLimitingFilter)rateLimitingFilterForIndexing).setUseXOpaqueId(arg_0));
        DeprecationIndexingComponent component = DeprecationIndexingComponent.createDeprecationIndexingComponent(client, environment.settings(), rateLimitingFilterForIndexing, (Boolean)WRITE_DEPRECATION_LOGS_TO_INDEX.get(environment.settings()), clusterService);
        return List.of(component, rateLimitingFilterForIndexing);
    }

    public List<Setting<?>> getSettings() {
        return List.of(USE_X_OPAQUE_ID_IN_FILTERING, WRITE_DEPRECATION_LOGS_TO_INDEX, DeprecationChecks.SKIP_DEPRECATIONS_SETTING);
    }
}

