/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.graph;

import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureTransportAction;
import org.elasticsearch.xpack.graph.Graph;

public class GraphInfoTransportAction
extends XPackInfoFeatureTransportAction {
    private final boolean enabled;
    private final XPackLicenseState licenseState;

    @Inject
    public GraphInfoTransportAction(TransportService transportService, ActionFilters actionFilters, Settings settings, XPackLicenseState licenseState) {
        super(XPackInfoFeatureAction.GRAPH.name(), transportService, actionFilters);
        this.enabled = (Boolean)XPackSettings.GRAPH_ENABLED.get(settings);
        this.licenseState = licenseState;
    }

    public String name() {
        return "graph";
    }

    public boolean available() {
        return this.licenseState != null && Graph.GRAPH_FEATURE.checkWithoutTracking(this.licenseState);
    }

    public boolean enabled() {
        return this.enabled;
    }
}

